#include "ezs_plot.h"
#include "ezs_fb.h"
#include <stdio.h>
#include <math.h>
#include <assert.h>


void ezs_plot(cyg_uint32 data[], size_t length, cyg_fb_colour foreground, cyg_fb_colour background)
{
	ezs_fb_clear(background);
	{
		size_t i = 0;
		for (i = 1; i < length; ++i) {
			assert(data[i] < 1024);
			cyg_ucount16 y = (((int) data[i]) * FB_HEIGHT) / 1024;

			ezs_fb_vline(i, FB_HEIGHT - y, 1, foreground);
		}
	}
}
