#ifndef   SIMPLE_QUEUE_HEADER
#define   SIMPLE_QUEUE_HEADER

namespace lwt {

template<typename T>
class SimpleQueue
{
	private:
	T *head;
	T **tail;

	public:
	void init()
	{
		head = 0;
		tail = &head;
	}

	void enqueue(T *item)
	{
		item->next = 0;
		*tail = item;
		tail = &item->next;
	}

	T* dequeue()
	{
		T *out;
		if((out = head) && !(head = out->next)) tail = &head;
		return out;
	}

	bool isEmpty()
	{
		return head == 0;
	}
};

} // namespace lwt

#endif /* SIMPLE_QUEUE_HEADER */
