#ifndef   LWT_ATOMIC_HEADER
#define   LWT_ATOMIC_HEADER

namespace lwt {

class Atomic
{
	public:
	template<typename T>
	static T swap(volatile T *ref, T newval)
	{
    	T before;
    	asm volatile (
    	    "xchg %0, %2 \n\t"

    	    : "=r"(before)
    	    : "0"(newval), "m"(*ref)
    	    : "memory" /* make this block a compiler barrier */
    	);
    	return before;
	}

	static void busy()
	{
		asm volatile("pause \n\t":::);
	}
};

} // namespace lwt

#endif /* LWT_ATOMIC_HEADER */
