#ifndef   LWT_ALLOCATOR_HEADER
#define   LWT_ALLOCATOR_HEADER

#include <stdint.h>
#include <stdlib.h>

namespace lwt {

class Alloc
{
	public:
	template<typename T>
	static T* alloc()
	{
		void *out = malloc(sizeof(T));
		if(out == NULL) {
			lwt::die("malloc in Alloc::alloc");
		}
		return (T*)out;
	}

	template<typename T>
	static void free(T *ptr)
	{
		::free(ptr);
	}
};

} // namespace lwt

#endif /* LWT_ALLOCATOR_HEADER */
