[global lwt_save_and_switch]
[global lwt_restore_context]

[extern lwt_after_switch]
[extern lwt_restore_cleanup]

%if __BITS__ == 64

; target stack in rdi
align 16
lwt_save_and_switch:
	; save non-volatile registers
	push rbp
	push rbx
	push r12
	push r13
	push r14
	push r15

	xchg rsp, rdi
	jmp lwt_after_switch


; stack base in rdi
; stack to switch to in rsi
align 16
lwt_restore_context:
	mov rsp, rsi

	pop r15
	pop r14
	pop r13
	pop r12
	pop rbx
	pop rbp

	jmp lwt_restore_cleanup
align 16

%elif __BITS__ == 32

align 16
lwt_save_and_switch:
	; save argument in eax
	mov eax, [esp+4]

	; save non-volatile registers
	push ebp
	push ebx
	push edi
	push esi

	xchg esp, eax

	; pass argument on stack
	push eax
	call lwt_after_switch


align 16
lwt_restore_context:
	; stack base in eax
	; stack to switch to in ecx
	mov eax, [esp+4]
	mov ecx, [esp+8]

	mov esp ,ecx
	pop esi
	pop edi
	pop ebx
	pop ebp

	push eax
	call lwt_restore_cleanup
	pop eax
	ret

align 16

%endif
