#include "arch/context.h"
#include "util/die.h"
#include "sched/scheduler.h"
#include "mem/alloc.h"

extern "C" void lwt_restore_cleanup(void *nc)
{
	lwt::Context *newContext = (lwt::Context*)nc;
	lwt::Context::destroy(lwt::Scheduler::currentContext);
	lwt::Scheduler::currentContext = newContext;
}

extern "C" void lwt_after_switch(void *currentStack)
{
	lwt::Scheduler::currentThread->func = lwt_restore_context;
	lwt::Scheduler::currentThread->ptr1 = lwt::Scheduler::oldContext;
	lwt::Scheduler::currentThread->ptr2 = currentStack;

	lwt::Scheduler::postBlockFunc(lwt::Scheduler::postBlockArg);

	lwt::Scheduler::loop();

	lwt::fatal("return from scheduler loop in lwt_after_switch");
}

lwt::Context* lwt::Context::make()
{
	lwt::Context *out = lwt::Alloc::context();
	if(out == 0) {
		return 0;
	}

	#if LWT_USE_VALGRIND == 1
	out->valgrindID = VALGRIND_STACK_REGISTER(out->stack, out->stack + LWT_STACK_SIZE);
	#endif

	return out;
}

void lwt::Context::destroy(lwt::Context *context)
{
	if(context == 0) {
		return;
	}

	#if LWT_USE_VALGRIND == 1
	VALGRIND_STACK_DEREGISTER(context->valgrindID);
	#endif

	lwt::Alloc::freeContext(context);
}
