#ifndef   LWT_CONTEXT_HEADER
#define   LWT_CONTEXT_HEADER

#include "config.h"

#if LWT_USE_VALGRIND == 1
#include <stdint.h>
#include <valgrind/valgrind.h>
#endif

extern "C" void lwt_restore_context(void*, void*);

namespace lwt {

class Context
{
	private:
	char stack[LWT_STACK_SIZE];

	#if LWT_USE_VALGRIND == 1
	uint64_t valgrindID;
	#endif

	public:
	static lwt::Context* make();
	static void destroy(lwt::Context *context);

	void* getTopOfStack()
	{
		return (void*)(stack + LWT_STACK_SIZE);
	}
};

} // namespace lwt

#endif /* LWT_CONTEXT_HEADER */
