#ifndef   LWT_ALLOCATOR_HEADER
#define   LWT_ALLOCATOR_HEADER

#include <stdint.h>
#include <stdlib.h>

#include "util/die.h"
#include "sched/thread.h"
#include "arch/context.h"

namespace lwt {

class Alloc
{
	public:
	static void* alloc(uintptr_t size)
	{
		void *out = malloc(size);
		if(out == NULL) {
			lwt::die("malloc in Alloc::alloc");
		}
		return out;
	}

	template<typename T>
	static T* alloc()
	{
		return (T*)alloc(sizeof(T));
	}

	static void free(void *ptr)
	{
		::free(ptr);
	}

	static lwt::Thread* thread()
	{
		return lwt::Alloc::alloc<lwt::Thread>();
	}

	static void freeThread(lwt::Thread *thread)
	{
		lwt::Alloc::free(thread);
	}

	static lwt::Context* context()
	{
		return lwt::Alloc::alloc<lwt::Context>();
	}

	static void freeContext(lwt::Context *context)
	{
		lwt::Alloc::free(context);
	}

};

} // namespace lwt

#endif /* LWT_ALLOCATOR_HEADER */
