/**
 * \addtogroup COM_EXT Extended Serial Communication
 *
 * \brief Special operations for serial communication with SPiCboards
 *
 * \sa com_ext.h
 *
 * @{
 * \file com_ext.h
 * \version \$Rev: 15477 $
 */

#ifndef COM_EXT_H
#define COM_EXT_H

/**
 * \brief Set the baud rate (transmission frequence)
 *
 * The baud rate is the number of symbols to be transfered within one second.
 * Hence this defines the transmission interval for a single symbol:
 * \f$ T = \frac{1s}{BAUD\_RATE} \f$
 *
 * \warning In case your connection is instable you should propably
 *          consider a lower frequency!
 *
 * \param baud  the desired baud rate
 *
 * \retval 4   using CPU frequency/1024 for timer
 * \retval 3   using CPU frequency/256 for timer
 * \retval 2   using CPU frequency/64 for timer
 * \retval 1   using CPU frequency/8 for timer
 * \retval 0   using CPU frequency for timer
 * \retval -1  baud rate too high
 * \retval -2  baud rate too low
 * \retval -3  setting baud rate not supported (default BAUD_RATE is used)
 */
int8_t sb_com_setBaud(uint32_t baud);

/** @}*/

#endif
