package de.fau.spicsim.gui

import de.fau.spicsim.Main
import java.awt.GridBagLayout
import java.awt.GridBagConstraints
import java.awt.Color
import java.awt.Dimension
import java.awt.Insets
import java.awt.Toolkit
import java.awt.Image
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.RenderingHints
import java.awt.Font
import javax.swing.JSlider
import javax.swing.SwingConstants
import javax.swing.JButton
import javax.swing.JLabel
import javax.swing.ImageIcon
import javax.swing.JToggleButton
import javax.swing.UIManager
import javax.swing.JFrame
import javax.swing.JPanel

class MainWindowBoard extends MainWindow {

    //frame.setTitle("SPiCsim v" + Main.boardVersion + " - board")

    val cp = frame.getContentPane()
    cp.setLayout(new GridBagLayout())

    val c = new GridBagConstraints()
    c.fill = GridBagConstraints.BOTH
    c.insets = new Insets(0, 0, 0, 0)
    c.weightx = 0.25
    c.weighty = 1.0
    c.gridx = 0
    c.gridy = 0
    c.gridheight = 4

    val ledp = new JPanel()
    ledp.setLayout(new GridBagLayout())
    cp.add(ledp, c)

    c.insets = new Insets(2, 2, 2, 2)
    c.gridheight = 1

    //Add leds
    c.weightx = 1.0
    c.weighty = 0.125
    for (i <- 0 to 7) {
        c.gridx = 0
        c.gridy = i

        val led = leds(i)
        ledp.add(led, c)
        led
    }

    c.weightx = 0.2
    c.weighty = 1.0
    c.gridx = 1
    c.gridy = 0
    c.gridheight = 4
    c.insets = new Insets(0, 0, 0, 0)
    val adcp = new JPanel()
    adcp.setLayout(new GridBagLayout())
    cp.add(adcp, c)

    c.gridx = 0
    c.gridheight = 1
    c.insets = new Insets(5, 5, 5, 5)

    for (i <- 0 to 1) yield {
        val adcSlider = adc(i)
        adcSlider.setOrientation(1)
        adcSlider.setMinimum(0)
        adcSlider.setMaximum(1024)
        c.weightx = 0.5
        c.weighty = 0.9
        c.gridy = 0
        c.gridheight = 7
        adcp.add(adcSlider, c)

        val label = new JLabel()
        label.setVerticalAlignment(SwingConstants.TOP)
        label.setHorizontalAlignment(SwingConstants.CENTER)
        //label.setFont(new Font("Arial", Font.BOLD, 12))
        if(i == 0){
            label.setText("<html><center><b>Poti</b></center></html>")
        }else{
            label.setText("<html><center><b>Photo</b></center></html>")
        }
        c.weightx = 0.5
        c.weighty = 0.1
        c.gridy = 7
        c.gridheight = 1
        adcp.add(label, c)
        c.gridx += 1
    }

    c.weightx = 0.30
    c.weighty = 0.25
    c.gridwidth = 2
    c.gridy = 0
    c.gridx = 2

    cp.add(btnLoad, c)

    c.gridy += 1

    cp.add(btnReset, c)

    c.weightx = 0.15
    c.weighty = 0.5
    c.gridy = 2
    c.gridx = 2
    c.gridwidth = 1
    c.gridheight = 2
    for (i <- 0 to 1) {
        val seg = sSeg(i)
        cp.add(seg, c)
        c.gridx += 1
    }

    c.weightx = 0.25
    c.weighty = 0.25
    c.gridy = 3
    c.gridx = 4
    c.gridheight = 1
    c.gridwidth = 1
    for (i <- 0 to 1) {
        val button = btn(i)
        cp.add(button, c)
        c.gridy -= 1
        button
    }

    c.weightx = 0.25
    c.weighty = 0.5
    c.gridwidth = 1
    c.gridheight = 2
    c.gridy = 0
    val info = new JLabel("<html><center>"
        + "<b>"
        + "SPiCboard v" + Main.boardVersion + "<br />Simulator"
        + "</b>"
        + "<br /><br />"
        + "Informatik 4 - FAU"
        + "<br />"
        + "Version " + Main.simVersion
        + "</center></html>")
    info.setHorizontalAlignment(SwingConstants.CENTER)
    cp.add(info, c)

    frame.setVisible(true);
}
