.PHONY: debug dbgstub

LIBSPICBOARDDIR ?= ../libspicboard

CC   := avr-gcc
SIZE := avr-size
GDB  := avr-gdb

AVARICE := $(addprefix $(wildcard /proj/i4spic/pub/tools/bin/),avarice)
AVRDUDE := $(addprefix $(wildcard /proj/i4spic/pub/tools/bin/),avrdude)

# Port for the GDB stub
PORT := 4242

# Warning! -fwhole-program breaks the linkage of additional files
COMMONCFLAGS=-ffreestanding -mmcu=atmega32 -DF_CPU=1000000  -Wall -Werror -pedantic -pedantic-errors -I$(LIBSPICBOARDDIR)

COMMONCFLAGS+=-std=c99

# Use these for debugging...
CFLAGS ?= -g -O0 $(COMMONCFLAGS)

# ...or these for an optimized code image
#CFLAGS ?= -Os $(COMMONCFLAGS)

LDFLAGS ?= -L$(LIBSPICBOARDDIR) -lspicboard


dbgstub:
	@if lsusb -d 03eb:2103 >/dev/null 2>&1; then \
		$(AVARICE) -2 -B '125 kHz' -j usb -P atmega32 localhost:$(PORT) ; \
	elif lsusb -d 03eb:2110 >/dev/null 2>&1; then \
		$(AVARICE) -3 -B '125 kHz' -j usb -P atmega32 localhost:$(PORT) ; \
	else \
		echo '*****************************' ; \
		echo '     Connect JTAG device.' ; \
		echo '*****************************' ; \
		exit 1 ; \
	fi

%.elf.flash: %.hex.flash

%.hex.flash: %.hex
	@if lsusb -d 03eb:2103 >/dev/null 2>&1; then \
		$(AVRDUDE) -p m32 -B 8 -c jtag2 -P usb -U flash:w:$< ; \
	elif lsusb -d 03eb:2110 >/dev/null 2>&1; then \
		$(AVRDUDE) -p m32 -B 8 -c jtag3 -P usb -U flash:w:$< ; \
	elif lsusb -d 03eb:2104 >/dev/null 2>&1; then \
		$(AVRDUDE) -p m32 -B 8 -c avrisp2 -P usb -U flash:w:$< ; \
	elif lsusb -d 16c0:05dc >/dev/null 2>&1; then \
			$(AVRDUDE) -p m32 -B 8 -c usbasp -P usb -U flash:w:$< ; \
	else \
		echo '************************************' ; \
		echo '     Connect ISP or JTAG device.' ; \
		echo '************************************' ; \
		exit 1 ; \
	fi

%.flash: %.hex.flash

%.elf.debug: %.elf
	$(GDB) $< -ex "target remote localhost:$(PORT)"

%.debug: %.elf.debug

# avrdude can't cope with ELF
%.bin: %.elf
	avr-objcopy -O binary -R .eeprom $< $@

%.dis: %.elf
	avr-objdump -d $< > $@

%.elf: %.c
	$(CC) $(CFLAGS) -o $@ $^ $(LDFLAGS)
	$(SIZE) $@

# For LED exercise
test.elf: test.c led.c

# For the "schnelltest"
schnelltest_led.elf: schnelltest_led.c led.c
