package de.fau.spicsim

import java.awt.EventQueue
import java.io.File
import de.fau.spicsim.gui.Gui
import de.fau.spicsim.gui.SkinManager
import de.fau.spicsim.text.TextOutput

case class Config(
	val file: File = null,
	val skin: String = null)

object Main {

	val boardVersion: String = "3"
	val simVersion: String = Main.getClass().getPackage().getImplementationVersion().toString()
	val skinManager = new SkinManager

	var gui: Gui = null;

	val sim = new SpicSim

	def main(args: Array[String]): Unit = {

		val a = new Config

		val parser = new scopt.OptionParser[Config]("spicsim") {
			head("SPiCsim", Main.simVersion)
			arg[File]("<elf-file>")
				.optional()
				.action { (x, c) => c.copy(file = x) }
				.text("ELF file to simulate.")
				.validate { x =>
					if(sim.checkFileExtension(x)){
						if(x.exists() && x.isFile()){
							success
						}else{
							failure("File not found")
						}
					}else{
						failure("Wrong file extension. Only ELF files are supported.")
					}
				}
			opt[String]('s', "skin")
				.valueName("<name>")
				.action{ (x, c) => c.copy(skin = x) }
				.text("Available skins are: "
					+ skinManager.getAvailableSkins +
					" (default is " + skinManager.getDefaultSkin + ")")
				.validate { x =>
					if(skinManager.checkSkin(x)){
						success
					}else{
						failure("Invalid skin parameter. Available skins are: " + skinManager.getAvailableSkins)
					}
				}
			version("version")
				.abbr("v")
				.text("Show version number.")
			help("help")
				.abbr("h")
				.text("Show this help message.")
			/*
			note("\nSPiCboard v" + Main.boardVersion + " Simulator\n" +
				 "Informatik 4 - FAU\n" +
				 "Version " + Main.simVersion)
			*/
		}

		val conf = parser.parse(args, Config()).getOrElse(sys.exit(1))

		initGui(sim, conf.skin)
		new TextOutput(sim, System.out)
		if (conf.file != null) {
			sim.load(conf.file)
			sim.start
		}

	}

	def initGui(ssim: SpicSim, skin: String) {
		EventQueue.invokeLater(new Runnable() {
			def run() {

			}
		});

		gui = new Gui(ssim, skin)

	}

}