package de.fau.spicsim.gui

import de.fau.spicsim.Main
import java.awt.GridBagLayout
import java.awt.GridBagConstraints
import java.awt.Color
import java.awt.Dimension
import java.awt.Insets
import java.awt.Toolkit
import java.awt.Image
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.RenderingHints
import java.awt.Font
import javax.swing.JSlider
import javax.swing.SwingConstants
import javax.swing.JButton
import javax.swing.JLabel
import javax.swing.ImageIcon
import javax.swing.JToggleButton
import javax.swing.UIManager
import javax.swing.JFrame
import javax.swing.JPanel
import javax.swing.event.ChangeEvent
import javax.swing.event.ChangeListener

class MainWindowCoffee extends MainWindow {

    frame.setTitle("SPiCsim v" + Main.boardVersion + " - coffee")
    frame.setBounds(100, 100, 520, 400)
    frame.setMinimumSize(new Dimension(520, 400))

    val colorFull  = new Color(0,101,192)
    val colorEmpty = Color.white
    val textFull   = "<html><center><b>Full</b></center></html>"
    val textEmpty  = "<html><center><b>Empty</b></center></html>"

    val backgroundImage = new ImageIcon(getImage("images/coffee.png"))
    val cp = frame.getContentPane()
    cp.setLayout(new GridBagLayout())
    val c = new GridBagConstraints()
    c.fill = GridBagConstraints.BOTH
    c.insets = new Insets(0,0,0,0)

    /*
    c.ipady = 20;
    c.ipadx = 20;
    */

    c.gridheight = 1
    c.gridwidth = 1
    c.gridx = 0
    c.gridy = 0
    c.weightx = 0.1;
    c.weighty = 0.85;
    val left = new JPanel()
    left.setLayout(new GridBagLayout())
    cp.add(left, c)

    c.gridheight = 1
    c.gridwidth = 1
    c.gridx = 2
    c.gridy = 0
    c.weightx = 0.1;
    c.weighty = 0.85;
    val right = new JPanel()
    right.setLayout(new GridBagLayout())
    cp.add(right, c)

    c.weightx = 0.8
    c.weighty = 0.85
    c.gridheight = 1
    c.gridwidth = 1
    c.gridy = 0
    c.gridx = 1
    val imagePanel = new JPanel() {
      override def paintComponent(g : Graphics) = {
        super.paintComponent(g)
        val g2 = g match {
          case g2: Graphics2D => g2
          case _ => throw new ClassCastException
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
            RenderingHints.VALUE_INTERPOLATION_BILINEAR)
        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
            RenderingHints.VALUE_RENDER_QUALITY)
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON)

        //g2.drawImage(backgroundImage.getImage(), 0, 0, this);
        g2.drawImage(backgroundImage.getImage(), 0, 0, this.getWidth(), this.getHeight(), null)
      }
    }
    imagePanel.setOpaque(true)
    imagePanel.setBackground(colorFull)
    cp.add(imagePanel, c)

    c.insets = new Insets(5, 5, 5, 5)
    c.gridheight = 1
    c.gridwidth = 3
    c.gridx = 0
    c.gridy = 1
    c.weightx = 1.0
    c.weighty = 0.15
    val bottom = new JPanel()
    bottom.setLayout(new GridBagLayout())
    cp.add(bottom, c)

    var a = 0
    c.gridx = 0;
    c.weightx = 1.0
    c.weighty = 1.0 / 6
    for (i <- 0 to 3) {
        val led = leds(i)
        if(i == 1){
            c.gridy = 0
            left.add(led, c)
        }else{
            c.gridy = a
            a = a + 1
            right.add(led, c)
        }
    }

    val labelLeft = new JLabel("<html><center><b>Pump<br>Heater</b></center></html>")
    labelLeft.setVerticalAlignment(SwingConstants.TOP)
    labelLeft.setHorizontalAlignment(SwingConstants.CENTER)
    labelLeft.setFont(new Font("Arial", Font.BOLD, 14))
    c.weightx = 1.0
    c.weighty = 0.85
    c.gridheight = 1
    c.gridwidth = 1
    c.gridx = 0
    c.gridy = 1
    left.add(labelLeft, c)

    val labelRight = new JLabel("<html><center><b>Status</b></center></html>")
    labelRight.setVerticalAlignment(SwingConstants.TOP)
    labelRight.setHorizontalAlignment(SwingConstants.CENTER)
    labelRight.setFont(new Font("Arial", Font.BOLD, 14))
    c.weightx = 1.0
    c.weighty = 0.55
    c.gridheight = 1
    c.gridwidth = 1
    c.gridx = 0
    c.gridy = 3
    right.add(labelRight, c)

    c.weightx = 0.25;
    c.weighty = 1.0;
    c.gridheight = 1
    c.gridwidth = 1
    c.gridy = 0
    c.gridx = 1
    btnLoad.setText("<html><center><b>Load</b></center></html>")
    btnLoad.setFont(new Font("Arial", Font.BOLD, 16))
    bottom.add(btnLoad, c)

    c.gridx = 2
    btnReset.setText("<html><center><b>Reset</b></center></html>")
    btnReset.setFont(new Font("Arial", Font.BOLD, 16))
    bottom.add(btnReset, c)

    override val btn = for (i <- 0 to 1) yield {
        if(i == 0){
            val jbtn = new JButton("<html><center><b>Coffee!</b></center></html>")
            jbtn.setFont(new Font("Arial", Font.BOLD, 16))
            c.gridx = 3
            bottom.add(jbtn, c)
            jbtn
        }else{
            val jbtn = new JToggleButton(textFull)
            jbtn.setFont(new Font("Arial", Font.BOLD, 16))
            val cl = new ChangeListener {
                def stateChanged(cEvt: ChangeEvent) {
                    val bModel = jbtn.getModel
                    if(bModel.isSelected){
                        jbtn.setText(textEmpty);
                        imagePanel.setBackground(colorEmpty)
                    }else{
                        jbtn.setText(textFull);
                        imagePanel.setBackground(colorFull)
                    }
                }
            }
            jbtn.addChangeListener(cl)
            c.gridx = 0
            bottom.add(jbtn, c)
            jbtn
        }
    }

    frame.setVisible(true);
}
