/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.CORBA;

import JavaORB.CORBA.BOAEntry;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.RequestAdapter;
import JavaORB.CORBA.handler.ObjectFactory;
import JavaORB.CORBA.portable.Delegate;
import JavaORB.ObjectAdapter;
import JavaORB.Trace;
import JavaORB.protocol.Listener;
import JavaORB.protocol.ProtocolPlug;
import JavaORB.protocol.ServerConnection;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ImplementationDef;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJECT_NOT_EXISTHelper;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.OBJ_ADAPTERHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ServantObject;
import org.omg.GIOP.LocateStatusType_1_2;

public class BOA
extends org.omg.CORBA.BOA
implements ObjectAdapter {
    private RequestAdapter rqa;
    Hashtable ObjectTable;
    int ObjectCount = 0;
    Listener listener;
    private ProtocolPlug plug;
    private ObjectFactory factory;

    public void connect(ObjectImpl obj, String name) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::connect");
        }
        String[] ids = obj._ids();
        byte[] key = null;
        String id = ids.length > 0 ? ids[0] : new String("IDL:omg.org/CORBA/Object:1.0");
        if (Trace.level != 0) {
            Trace.Step("ID de l'objet a connecter : " + id);
        }
        if (Trace.level != 0) {
            Trace.Step("Object Key de l'objet a connecter : " + name);
        }
        key = new byte[name.length()];
        int count = 0;
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) > '\u00ff') {
                if (Trace.level != 0) {
                    Trace.CoreError("Clef d'objet invalide");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.DATA_CONVERSION");
                }
                throw new DATA_CONVERSION("Incorrect object key", 2, CompletionStatus.COMPLETED_NO);
            }
            ++i;
        }
        i = 0;
        while (i < name.length()) {
            key[count++] = (byte)name.charAt(i);
            ++i;
        }
        try {
            Delegate _d = (Delegate)obj._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            obj._set_delegate(new Delegate());
        }
        ((Delegate)obj._get_delegate())._set_key(key);
        ((Delegate)obj._get_delegate())._set_id(id);
        ((Delegate)obj._get_delegate())._set_port(this.listener._get_port());
        ((Delegate)obj._get_delegate())._set_host(this.listener._get_host());
        ((Delegate)obj._get_delegate()).localObject(true);
        BOAEntry entry = new BOAEntry();
        entry.ObjectRef = obj;
        entry.name = name;
        this.ObjectTable.put(new String(key), entry);
        entry.state = true;
        this.factory.connectObject(obj);
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::connect");
        }
    }

    public void shutdown(boolean wait_for_completion) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::shutdown");
        }
        if (!wait_for_completion) {
            try {
                this.listener.deactivate();
                this.listener.end();
            }
            catch (COMM_FAILURE ex) {
                if (Trace.level != 0) {
                    Trace.Step("Rattrape une exception org.omg.CORBA.COMM_FAILURE");
                }
            }
        } else {
            this.listener.complete_and_deactivate();
            this.listener.end();
        }
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::shutdown");
        }
    }

    public void change_implementation(Object obj, ImplementationDef impl) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::change_implementation");
        }
        ObjectImpl o = (ObjectImpl)obj;
        BOAEntry entry = this.findBOAEntry(o);
        if (!impl.getHostName().equals(((Delegate)o._get_delegate())._get_host())) {
            entry.local = false;
            ((Delegate)o._get_delegate())._set_host(impl.getHostName());
        }
        if (!impl.getObjectName().equals(entry.name)) {
            entry.name = impl.getObjectName();
            byte[] newName = new byte[entry.name.length()];
            int i = 0;
            while (i < entry.name.length()) {
                newName[i] = (byte)entry.name.charAt(i);
                ++i;
            }
            ((Delegate)o._get_delegate())._set_key(newName);
        }
        if (impl.getObjectPort() != ((Delegate)o._get_delegate())._get_port()) {
            entry.local = false;
            ((Delegate)o._get_delegate())._set_port(impl.getObjectPort());
        }
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::change_implementation");
        }
    }

    public void deactivate_impl(ImplementationDef def) {
        this.shutdown(false);
    }

    public void dispatch(ServerConnection srv, int RequestId, boolean ResponseExpected, byte[] ObjectKey, String Operation, InputStream input) {
        BOAEntry entry;
        if (Trace.level != 0) {
            Trace.InFunction("BOA::dispatch");
        }
        BooleanHolder except_flag = new BooleanHolder();
        BooleanHolder user_flag = new BooleanHolder();
        OutputStream output = this.plug.newOutputStream(srv._get_version().minor);
        if (Trace.level != 0) {
            Trace.Step("Clef de l'objet demande : " + new String(ObjectKey));
        }
        if ((entry = this.findBOAEntryByKey(ObjectKey)) == null) {
            if (Trace.level != 0) {
                Trace.CoreError("L'objet demande n'existe pas");
            }
            if (Operation.equals("_non_existent")) {
                if (Trace.level != 0) {
                    Trace.Step("Pas d'erreur car l'operatione est : _non_existent ");
                }
                if (ResponseExpected) {
                    output.write_boolean(true);
                    srv.reply(RequestId, output);
                }
            } else {
                if (Trace.level != 0) {
                    Trace.ThrowException("Renvoi org.omg.CORBA.OBJECT_NOT_EXIST");
                }
                OBJECT_NOT_EXISTHelper.write(output, new OBJECT_NOT_EXIST("Object not exist", 1, CompletionStatus.COMPLETED_NO));
                srv.replySystemException(RequestId, output);
            }
        } else if (!entry.state) {
            if (Trace.level != 0) {
                Trace.CoreError("L'objet " + entry.name + " n'est pas active");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("Renvoie org.omg.CORBA.OBJ_ADAPTER");
            }
            OBJ_ADAPTERHelper.write(output, new OBJ_ADAPTER("Object not ready", 2, CompletionStatus.COMPLETED_NO));
            if (ResponseExpected) {
                srv.replySystemException(RequestId, output);
            }
        } else if (!entry.local) {
            if (Trace.level != 0) {
                Trace.Step("L'objet " + entry.name + " est distant");
            }
            ((Delegate)entry.ObjectRef._get_delegate())._write_Object(output);
            if (ResponseExpected) {
                srv.replyLocationForward(RequestId, output);
            }
        } else {
            if (Trace.level != 0) {
                Trace.Step("Demande a l'objet " + entry.name + " le traitement de " + Operation);
            }
            this.rqa.dispatch(Operation, ResponseExpected, input, output, except_flag, user_flag, entry.ObjectRef, srv, RequestId);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::dispatch");
        }
    }

    public void servant_postinvoke(Object self, ServantObject srvObject) {
        throw new NO_IMPLEMENT();
    }

    public void obj_is_ready(ObjectImpl obj) {
        BOAEntry entry;
        if (Trace.level != 0) {
            Trace.InFunction("BOA::obj_is_ready");
        }
        if ((entry = this.findBOAEntry(obj)) != null) {
            if (Trace.level != 0) {
                Trace.Step("L'objet " + entry.name + " est active");
            }
        } else {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible d'activer l'objet");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.OBJ_ADAPTER");
            }
            throw new OBJ_ADAPTER("Unable to activate this object", 1, CompletionStatus.COMPLETED_NO);
        }
        entry.state = true;
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::obj_is_ready");
        }
    }

    public void connectRemote(ObjectImpl obj) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::connectRemote");
        }
        byte[] key = ((Delegate)obj._get_delegate())._get_key();
        String KeyAsString = new String(key, 0, key.length);
        if (Trace.level != 0) {
            Trace.Step("Object Key de l'objet a connecter : " + KeyAsString);
        }
        BOAEntry entry = new BOAEntry();
        entry.ObjectRef = obj;
        entry.name = KeyAsString;
        entry.local = false;
        this.ObjectTable.put(new String(key), entry);
        entry.state = true;
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::connectRemote");
        }
    }

    public BOA(int port) {
        if (Trace.level != 0) {
            Trace.NewInstance("BOA");
        }
        this.ObjectTable = new Hashtable();
        this.plug = ORBSingleton.plug;
        this.listener = this.plug.newListener();
        this.listener.activate(this, port);
        this.rqa = new RequestAdapter();
        this.listener.begin();
        this.factory = ORBSingleton._orb.get_object_factory();
        this.plug.adapterActivated(this);
    }

    public boolean work_pending() {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::work_pending");
        }
        boolean completed = this.listener.isCompleted();
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::work_pending");
        }
        return completed;
    }

    public ObjectImpl implByName(String name) {
        byte[] object_key = new byte[name.length()];
        object_key = name.getBytes();
        if (object_key == null) {
            return null;
        }
        BOAEntry entry = this.findBOAEntryByKey(object_key);
        if (entry != null) {
            return entry.ObjectRef;
        }
        return null;
    }

    public void deactivate_obj(ObjectImpl obj) {
        BOAEntry entry;
        if (Trace.level != 0) {
            Trace.InFunction("BOA::deactivate_object");
        }
        if ((entry = this.findBOAEntry(obj)) != null) {
            if (Trace.level != 0) {
                Trace.Step("L'objet " + entry.name + " est desactive");
            }
        } else {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible d'activer l'objet");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.OBJ_ADAPTER");
            }
            throw new OBJ_ADAPTER("Unable to activate this object", 1, CompletionStatus.COMPLETED_NO);
        }
        entry.state = false;
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::deactivate_object");
        }
    }

    public void disconnect(ObjectImpl obj) {
        byte[] object_key;
        if (Trace.level != 0) {
            Trace.InFunction("BOA::disconnect");
        }
        if (this.ObjectTable.get(object_key = ((Delegate)obj._get_delegate())._get_key()) != null) {
            this.ObjectTable.remove(new String(object_key));
        }
        this.factory.disconnectObject(obj);
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::disconnect");
        }
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        throw new NO_IMPLEMENT();
    }

    public void locate(ServerConnection srv, int RequestId, byte[] ObjectKey) {
        BOAEntry entry;
        if (Trace.level != 0) {
            Trace.InFunction("BOA::locate");
        }
        if ((entry = this.findBOAEntryByKey(ObjectKey)) == null) {
            if (Trace.level != 0) {
                Trace.Step("L'objet demande est inconnu : " + new String(ObjectKey));
            }
            srv.replyLocationReply(RequestId, LocateStatusType_1_2.UNKNOWN_OBJECT, null);
        } else if (entry.local) {
            if (Trace.level != 0) {
                Trace.Step("L'objet demande est local, il se nomme : " + entry.name);
            }
            srv.replyLocationReply(RequestId, LocateStatusType_1_2.OBJECT_HERE, null);
        } else {
            if (Trace.level != 0) {
                Trace.Step("L'objet demande est distant, il se nomme : " + entry.name);
            }
            OutputStream output = this.plug.newOutputStream(srv._get_version().minor);
            ((Delegate)entry.ObjectRef._get_delegate())._write_Object(output);
            srv.replyLocationReply(RequestId, LocateStatusType_1_2.OBJECT_FORWARD, output);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::locate");
        }
    }

    public void forward(ObjectImpl objOld, ObjectImpl objNew) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::forward");
        }
        BOAEntry entry = this.findBOAEntry(objOld);
        if (Trace.level != 0) {
            Trace.Step("Object Key de l'objet migrateur : " + entry.name);
        }
        String KeyAsString = new String(((Delegate)objNew._get_delegate())._get_key());
        if (Trace.level != 0) {
            Trace.Step("Object Key de l'objet a connecter : " + KeyAsString);
        }
        entry.ObjectRef = objNew;
        entry.name = KeyAsString;
        entry.local = false;
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::forward");
        }
    }

    public ObjectImpl implExists(ObjectImpl obj) {
        int port = ((Delegate)obj._get_delegate())._get_port();
        if (port != this.listener._get_port()) {
            return null;
        }
        String host = ((Delegate)obj._get_delegate())._get_host();
        String myAddr = this.listener._get_addr();
        String myHost = this.listener._get_host();
        if (!host.equalsIgnoreCase(myAddr) && !host.equalsIgnoreCase(myHost)) {
            return null;
        }
        byte[] object_key = ((Delegate)obj._get_delegate())._get_key();
        if (object_key == null) {
            return null;
        }
        BOAEntry entry = this.findBOAEntryByKey(object_key);
        if (entry != null) {
            return entry.ObjectRef;
        }
        return null;
    }

    private BOAEntry findBOAEntryByKey(byte[] object_key) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::findBOAEntryByKey");
        }
        BOAEntry found = null;
        found = (BOAEntry)this.ObjectTable.get(new String(object_key));
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::findBOAEntryByKey");
        }
        return found;
    }

    public Listener get_listener() {
        return this.listener;
    }

    public static org.omg.CORBA.BOA init(ORB orb, String[] args) {
        return ((ORBSingleton)orb).BOA_init(args);
    }

    private BOAEntry findBOAEntry(ObjectImpl obj) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::findBOAEntry");
        }
        BOAEntry found = null;
        byte[] key = ((Delegate)obj._get_delegate())._get_key();
        found = (BOAEntry)this.ObjectTable.get(new String(key));
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::findBOAEntry");
        }
        return found;
    }

    public void impl_is_ready(ImplementationDef def) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::impl_is_ready");
        }
        if (Trace.level != 0) {
            Trace.Step("Lance le thread Listener");
        }
        this.listener.attend();
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::impl_is_ready");
        }
    }

    public void impl_is_ready() {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::impl_is_ready");
        }
        if (Trace.level != 0) {
            Trace.Step("Lance le thread Listener");
        }
        this.listener.attend();
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::impl_is_ready");
        }
    }

    public void perform_work() {
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::perform_work");
        }
        this.listener.complete();
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::perform_work");
        }
    }

    public void connect(ObjectImpl obj) {
        if (Trace.level != 0) {
            Trace.InFunction("BOA::connect");
        }
        String[] ids = obj._ids();
        byte[] key = null;
        String id = ids.length > 0 ? ids[0] : new String("IDL:omg.org/CORBA/Object:1.0");
        if (Trace.level != 0) {
            Trace.Step("ID de l'objet a connecter : " + id);
        }
        String num = String.valueOf(this.ObjectCount++);
        String KeyAsString = id.concat("/" + num);
        if (Trace.level != 0) {
            Trace.Step("Object Key de l'objet a connecter : " + KeyAsString);
        }
        key = new byte[id.length() + num.length() + 1];
        int count = 0;
        int i = 0;
        while (i < KeyAsString.length()) {
            if (KeyAsString.charAt(i) > '\u00ff') {
                if (Trace.level != 0) {
                    Trace.CoreError("Clef d'objet invalide");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.DATA_CONVERSION");
                }
                throw new DATA_CONVERSION("Incorrect object key", 2, CompletionStatus.COMPLETED_NO);
            }
            ++i;
        }
        i = 0;
        while (i < KeyAsString.length()) {
            key[count++] = (byte)KeyAsString.charAt(i);
            ++i;
        }
        try {
            Delegate _d = (Delegate)obj._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            obj._set_delegate(new Delegate());
        }
        ((Delegate)obj._get_delegate())._set_key(key);
        ((Delegate)obj._get_delegate())._set_id(id);
        ((Delegate)obj._get_delegate())._set_port(this.listener._get_port());
        ((Delegate)obj._get_delegate())._set_host(this.listener._get_host());
        ((Delegate)obj._get_delegate()).localObject(true);
        BOAEntry entry = new BOAEntry();
        entry.ObjectRef = obj;
        entry.name = KeyAsString;
        this.ObjectTable.put(new String(key), entry);
        entry.state = true;
        this.factory.connectObject(obj);
        if (Trace.level != 0) {
            Trace.OutFunction("BOA::connect");
        }
    }
}

