/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.INS;

import JavaORB.INS.BindingIteratorImpl;
import JavaORB.INS.Server;
import JavaORB.INS.graphNode;
import java.util.Vector;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class NamingContextExImpl
extends NamingContextExtPOA {
    private NameComponent _name;
    private org.omg.CORBA.ORB _orb;
    private NamingContextExImpl parent;
    private Vector graph = new Vector();

    public NameComponent[] to_name(String sn) throws InvalidName {
        this.verbose("Return a stringified name");
        NameComponent cp = null;
        Vector<NameComponent> list = new Vector<NameComponent>();
        int index = 0;
        int last = 0;
        int last_part = 0;
        String part = null;
        while (true) {
            if ((index = sn.indexOf("/", last)) == -1) {
                part = sn.substring(last_part, sn.length());
            } else if (index > 0) {
                if (sn.charAt(index - 1) != '\\') {
                    part = sn.substring(last_part, index);
                    last_part = last;
                } else {
                    part = null;
                }
            } else {
                part = null;
            }
            if (part != null) {
                cp = new NameComponent();
                int last2 = 0;
                int index2 = 0;
                boolean ok = false;
                while ((index2 = part.indexOf(".", last2)) != -1) {
                    if (index2 > 0 && part.charAt(index2 - 1) == '\\') {
                        last2 = index2 + 1;
                        continue;
                    }
                    ok = true;
                    last2 = index2 + 1;
                    break;
                }
                if (ok) {
                    cp.id = this.removeExtra(part.substring(0, last2 - 1));
                    cp.kind = this.removeExtra(part.substring(last2, part.length()));
                } else {
                    cp.id = this.removeExtra(part);
                    cp.kind = "";
                }
                list.addElement(cp);
                if (index == -1) break;
            }
            last = index + 1;
        }
        NameComponent[] name = new NameComponent[list.size()];
        int i = 0;
        while (i < list.size()) {
            name[i] = (NameComponent)list.elementAt(i);
            ++i;
        }
        return name;
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        this.verbose("Get an URL");
        return "corbaname://" + this.checkFormat(addr) + "/" + this.adaptToURL(sn);
    }

    private NamingContextExImpl addNamingContext(NamingContext nc, NameComponent n) {
        graphNode node = new graphNode();
        node.n = n;
        node.isNc = true;
        node.obj = nc;
        NamingContextExImpl nci = this.getImpl(nc);
        if (nci != null) {
            nci.parent = this;
            nci._name = n;
        }
        this.graph.addElement(node);
        return nci;
    }

    private String adaptToURL(String sn) throws InvalidName {
        return sn;
    }

    private void removeObject(NamingContext nc) {
        graphNode node = null;
        int i = 0;
        while (i < this.graph.size()) {
            node = (graphNode)this.graph.elementAt(i);
            if (node.obj._is_equivalent(nc)) {
                this.graph.removeElementAt(i);
                NamingContextExImpl impl = this.getImpl(nc);
                try {
                    impl._poa().deactivate_object(impl._object_id());
                }
                catch (ObjectNotActive ex) {
                }
                catch (WrongPolicy ex) {
                    // empty catch block
                }
                return;
            }
            ++i;
        }
    }

    private void verbose(String message) {
        if (Server.is_verbose) {
            System.out.println("[ " + message + " ]");
        }
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Unbind ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length - 1);
        if (n.length == 1) {
            this.removeGraphNode(n[0]);
            return;
        }
        if (node == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        if (!node.isNc) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        this.getImpl(node.obj).removeGraphNode(n[n.length - 1]);
        if (Server.persistent) {
            Server.pc.remove_object(this.getObjectPath(n[n.length - 1]));
        }
    }

    private NameComponent[] getObjectPath(NameComponent nc) {
        NameComponent[] up_name = null;
        NameComponent[] name = null;
        up_name = this.getPath();
        name = new NameComponent[up_name.length + 1];
        System.arraycopy(up_name, 0, name, 0, up_name.length);
        name[up_name.length] = nc;
        return name;
    }

    protected NamingContextExImpl(org.omg.CORBA.ORB orb) {
        this.parent = null;
        this._orb = orb;
        ((ORB)orb).set_delegate(this);
    }

    protected NamingContextExImpl(org.omg.CORBA.ORB orb, NamingContextExImpl p) {
        this.parent = p;
        this._orb = orb;
        ((ORB)orb).set_delegate(this);
        try {
            this._default_POA().activate_object(this);
        }
        catch (ServantAlreadyActive ex) {
        }
        catch (WrongPolicy ex) {
            System.out.println("INS, warning n\u00b06");
        }
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Bind an object ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length);
        NamingContextExImpl nc = null;
        if (node != null) {
            throw new AlreadyBound();
        }
        node = this.findGraphNode(n, 0, n.length - 1);
        if (node != null) {
            NameComponent[] np = new NameComponent[n.length - 1];
            System.arraycopy(n, 0, np, 0, n.length - 1);
            if (!node.isNc) {
                throw new NotFound(NotFoundReason.not_context, np);
            }
        }
        nc = node == null ? this : this.getImpl(node.obj);
        nc.addObject(obj, n[n.length - 1]);
        if (Server.persistent) {
            Server.pc.add_object(this.getObjectPath(n[n.length - 1]), obj);
        }
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Rebind an object ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length);
        if (node == null) {
            try {
                this.bind(n, obj);
            }
            catch (AlreadyBound ex) {
                throw new CannotProceed();
            }
            return;
        }
        if (node.isNc) {
            throw new NotFound(NotFoundReason.not_object, n);
        }
        node.obj = obj;
        if (Server.persistent) {
            Server.pc.modify_object(this.getObjectPath(n[n.length - 1]), obj);
        }
    }

    private void removeGraphNode(NameComponent n) {
        graphNode node = null;
        int i = 0;
        while (i < this.graph.size()) {
            node = (graphNode)this.graph.elementAt(i);
            if (node.n.id.equals(n.id)) {
                if (node.isNc) {
                    try {
                        this._poa().deactivate_object(this._poa().reference_to_id(node.obj));
                    }
                    catch (ObjectNotActive ex) {
                        System.out.println("INS Warning n\u00b03");
                    }
                    catch (WrongAdapter ex) {
                        System.out.println("INS Warning n\u00b04");
                    }
                    catch (WrongPolicy ex) {
                        System.out.println("INS Warning n\u00b05");
                    }
                }
                this.graph.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        NamingContext nc = this.new_context();
        this.bind_context(n, nc);
        return nc;
    }

    public void destroy() throws NotEmpty {
        this.verbose("Destroy a NamingContext");
        if (this.graph.size() != 0) {
            throw new NotEmpty();
        }
        this.parent.removeObject(this._this());
        if (Server.persistent) {
            Server.pc.remove_nc(this.getPath());
        }
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        NameComponent[] name = this.to_name(n);
        return this.resolve(name);
    }

    private String adaptName(String n) {
        String str = "";
        int i = 0;
        while (i < n.length()) {
            str = n.charAt(i) == '/' ? str + "\\/" : (n.charAt(i) == '.' ? str + "\\." : str + n.charAt(i));
            ++i;
        }
        return str;
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        this.verbose("List all objects");
        int max = 0;
        int size = this.graph.size();
        graphNode node = null;
        max = size < how_many ? size : how_many;
        bl.value = new Binding[max];
        int i = 0;
        while (i < max) {
            bl.value[i] = new Binding();
            node = (graphNode)this.graph.elementAt(i);
            bl.value[i].binding_name = new NameComponent[1];
            bl.value[i].binding_name[0] = node.n;
            bl.value[i].binding_type = node.isNc ? BindingType.ncontext : BindingType.nobject;
            ++i;
        }
        if (how_many < size) {
            Binding[] next = new Binding[size - how_many];
            int i2 = how_many;
            while (i2 < size) {
                next[i2 - how_many] = new Binding();
                node = (graphNode)this.graph.elementAt(i2);
                next[i2 - how_many].binding_name = new NameComponent[1];
                next[i2 - how_many].binding_name[0] = node.n;
                next[i2 - how_many].binding_type = node.isNc ? BindingType.ncontext : BindingType.nobject;
                ++i2;
            }
            BindingIteratorImpl b = new BindingIteratorImpl(this._orb, next);
            bi.value = b._this();
        } else {
            bi.value = new BindingIteratorImpl(this._orb, new Binding[0])._this();
        }
    }

    private void addObject(Object obj, NameComponent n) {
        graphNode node = new graphNode();
        node.n = n;
        node.isNc = false;
        node.obj = obj;
        this.graph.addElement(node);
    }

    private String removeExtra(String n) {
        String str = "";
        int i = 0;
        while (i < n.length()) {
            if (n.charAt(i) != '\\') {
                str = str + n.charAt(i);
            }
            ++i;
        }
        return str;
    }

    private NameComponent[] getPath() {
        NameComponent[] up_name = null;
        NameComponent[] name = null;
        if (this.parent == null) {
            return new NameComponent[0];
        }
        up_name = this.parent.getPath();
        name = new NameComponent[up_name.length + 1];
        System.arraycopy(up_name, 0, name, 0, up_name.length);
        name[up_name.length] = this._name;
        return name;
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Bind a context ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length);
        NamingContextExImpl ncp = null;
        if (node != null) {
            throw new AlreadyBound();
        }
        node = this.findGraphNode(n, 0, n.length - 1);
        if (node != null) {
            NameComponent[] np = new NameComponent[n.length - 1];
            System.arraycopy(n, 0, np, 0, n.length - 1);
            if (!node.isNc) {
                throw new NotFound(NotFoundReason.not_context, np);
            }
        }
        ncp = node == null ? this : this.getImpl(node.obj);
        NamingContextExImpl new_ctx = ncp.addNamingContext(nc, n[n.length - 1]);
        if (Server.persistent) {
            Server.pc.add_nc(new_ctx.getPath());
        }
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Rebind a context ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length);
        if (node == null) {
            try {
                this.bind_context(n, nc);
            }
            catch (AlreadyBound ex) {
                throw new CannotProceed();
            }
            return;
        }
        if (!node.isNc) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        node.obj = nc;
        if (Server.persistent) {
            Server.pc.modify_nc(this.getImpl(node.obj).getPath());
        }
    }

    public NamingContext new_context() {
        this.verbose("Create a new context");
        NamingContextExImpl nc = new NamingContextExImpl(this._orb, this);
        return nc._this();
    }

    private NamingContextExImpl getImpl(Object obj) {
        NamingContextExImpl nci = null;
        try {
            nci = this.parent == null ? (NamingContextExImpl)this._default_POA().reference_to_servant(obj) : (NamingContextExImpl)this._poa().reference_to_servant(obj);
        }
        catch (ObjectNotActive ex) {
            System.out.println("INS, warning n\u00b07");
        }
        catch (WrongAdapter ex) {
            System.out.println("INS, warning n\u00b08");
        }
        catch (WrongPolicy ex) {
            System.out.println("INS, warning n\u00b09");
        }
        return nci;
    }

    private String checkFormat(String addr) throws InvalidAddress {
        Vector<String> list = new Vector<String>();
        try {
            int index;
            int old = 0;
            while (true) {
                if ((index = addr.indexOf(",", old)) == -1) break;
                list.addElement(addr.substring(old, index));
                old = index + 1;
            }
            list.addElement(addr.substring(old));
            int i = 0;
            while (i < list.size()) {
                String ad = (String)list.elementAt(i);
                index = addr.indexOf("@");
                if (index != -1 && (index = ad.substring(0, index).indexOf(".")) == -1) {
                    throw new InvalidAddress();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new InvalidAddress();
        }
        return addr;
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        String str = "";
        int i = 0;
        while (i < n.length) {
            str = str + this.adaptName(n[i].id);
            if (!n[i].kind.equals("")) {
                str = str + "." + this.adaptName(n[i].kind);
            }
            if (i + 1 < n.length) {
                str = str + "/";
            }
            ++i;
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private graphNode findGraphNode(NameComponent[] n, int begin, int end) throws NotFound, InvalidName {
        graphNode node = null;
        if (begin == end) {
            return null;
        }
        if (n.length == 0) {
            throw new InvalidName();
        }
        int i = 0;
        while (i < this.graph.size()) {
            node = (graphNode)this.graph.elementAt(i);
            if (node.n.id.equals(n[begin].id) && node.n.kind.equals(n[begin].kind)) {
                if (begin + 1 >= end) return node;
                if (n.length <= begin + 1) return node;
                if (node.isNc) {
                    return this.getImpl(node.obj).findGraphNode(n, begin + 1, end);
                }
            }
            ++i;
        }
        return null;
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Resolve an object ( " + n[n.length - 1].id + " )");
        graphNode node = this.findGraphNode(n, 0, n.length);
        if (node == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        return node.obj;
    }
}

