/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.INS;

import JavaORB.CORBA.ORBSingleton;
import JavaORB.INS.NamingContextExImpl;
import JavaORB.INS.persistence.connector;
import JavaORB.INS.persistence.databasePersistence;
import JavaORB.INS.persistence.filePersistence;
import JavaORB.PortableServer.KeyAssignmentPolicyValue;
import JavaORB.PortableServer.KeyAssignmentPolicyValueHelper;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class Server {
    private static Properties ins_properties;
    protected static connector pc;
    protected static boolean is_verbose;
    private static boolean ior_file;
    public static boolean persistent;
    private static boolean database;

    private static void parse_args(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-help")) {
                Server.print_help();
            } else if (args[i].equalsIgnoreCase("-ior")) {
                ior_file = true;
            } else if (args[i].equalsIgnoreCase("-verbose")) {
                is_verbose = true;
            } else if (args[i].equalsIgnoreCase("-persistent")) {
                persistent = true;
            } else if (args[i].equalsIgnoreCase("-database")) {
                database = true;
                persistent = true;
            }
            ++i;
        }
    }

    private static void print_help() {
        System.out.println("Command line : \n");
        System.out.println("\tjava JavaORB.INS.Server [ orb options ] options\n");
        System.out.println("Options : ");
        System.out.println("\t-ior");
        System.out.println("\t\tgenerate a file 'ins.ior' that contains the INS ior.");
        System.out.println("\t-persistent");
        System.out.println("\t\tactivate the persistent mode [ into a file by default ].");
        System.out.println("\t-database");
        System.out.println("\t\tpersistent is activated for a database.");
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("\nJavaORB Interoperable Naming Service, version 1.0");
        System.out.println("(c) 1999, Distributed Object Group");
        System.out.println("Developped by Jerome DANIEL");
        System.out.println("");
        Server.parse_args(args);
        ORB orb = ORB.init(args, null);
        Object objPoa = null;
        POA rootPOA = null;
        try {
            objPoa = orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        rootPOA = POAHelper.narrow(objPoa);
        Policy[] policies = new Policy[7];
        policies[0] = rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
        Any policy_any = orb.create_any();
        KeyAssignmentPolicyValueHelper.insert(policy_any, KeyAssignmentPolicyValue.USER_KEY);
        try {
            ORBSingleton ors = new ORBSingleton();
            policies[1] = ors.create_policy(1000, policy_any);
        }
        catch (PolicyError ex) {
            System.out.println(ex);
        }
        POA subPOA = null;
        try {
            subPOA = rootPOA.create_POA("INSsubPOA", rootPOA.the_POAManager(), policies);
        }
        catch (InvalidPolicy ex) {
            System.out.println("Invalid POA policies !");
            System.exit(0);
        }
        catch (AdapterAlreadyExists ex) {
            System.out.println("Unable to create sub POA !");
            System.exit(0);
        }
        NamingContextExImpl naming = new NamingContextExImpl(orb);
        byte[] rootId = new String("NameService").getBytes();
        try {
            subPOA.activate_object_with_id(rootId, naming);
        }
        catch (ServantAlreadyActive ex) {
            System.out.println("Unable to activate the NameService node !");
            System.exit(0);
        }
        catch (ObjectAlreadyActive ex) {
            System.out.println("Unable to activate the NameService node !");
            System.exit(0);
        }
        catch (WrongPolicy ex) {
            System.out.println("Unable to activate the NameService node !");
            System.exit(0);
        }
        Server.load_properties(orb);
        if (ior_file) {
            String ins_ior = null;
            try {
                ins_ior = orb.object_to_string(subPOA.servant_to_reference(naming));
            }
            catch (ServantNotActive ex) {
            }
            catch (WrongPolicy ex) {
                // empty catch block
            }
            try {
                FileOutputStream file = new FileOutputStream("ins.ior");
                PrintWriter pfile = new PrintWriter(file);
                pfile.println(ins_ior);
                pfile.close();
            }
            catch (IOException ex) {
                System.out.println("INS fatal error : Unable to generate 'ins.ior'");
                System.exit(0);
            }
            System.out.println("IOR file generated ( ins.ior ).\n");
        }
        if (persistent) {
            pc = database ? new databasePersistence(naming) : new filePersistence(naming);
            pc.init(ins_properties, args);
            System.out.println("Persistent mode activated.\n");
        } else {
            System.out.println("Transient mode activated.\n");
        }
        try {
            rootPOA.the_POAManager().activate();
        }
        catch (AdapterInactive ex) {
            System.out.println("Unable to activate the POA manager !");
            System.exit(0);
        }
        try {
            System.out.println("INS server is now ready...");
            orb.run();
        }
        catch (Exception ex) {
            System.out.println("INS server stopped...");
            ex.printStackTrace();
        }
    }

    static {
        is_verbose = false;
        ior_file = false;
        persistent = false;
        database = false;
    }

    private static void load_properties(ORB orb) {
        ORBSingleton cfr_ignored_0 = (ORBSingleton)orb;
        FileInputStream in = ORBSingleton.openFile("INS.cfg");
        if (in == null) {
            return;
        }
        ins_properties = new Properties();
        try {
            ins_properties.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            System.out.println("INS warning : Unable to load INS.cfg properties.");
        }
    }
}

