/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.INS.persistence;

import JavaORB.INS.NamingContextExImpl;
import JavaORB.INS.Server;
import JavaORB.INS.persistence.connector;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class databasePersistence
implements connector {
    private boolean clean;
    private ORB orb;
    private NamingContextExImpl naming;
    private Properties properties = null;
    private Connection db = null;

    public void add_nc(NameComponent[] name) {
        this.store(true, name, null);
    }

    public databasePersistence(NamingContextExImpl root) {
        this.naming = root;
        this.orb = ORB.init();
        this.clean = false;
    }

    private void store(boolean nc, NameComponent[] name, Object obj) {
        String str = "";
        try {
            str = this.naming.to_string(name);
        }
        catch (InvalidName ex) {
            System.out.println("INS warning : Unable to stringified a name.");
        }
        byte[] bin_data_1 = str.getBytes();
        byte[] bin_data_2 = null;
        if (nc) {
            bin_data_2 = new byte[]{};
        } else {
            str = this.orb.object_to_string(obj);
            bin_data_2 = str.getBytes();
        }
        byte b = 0;
        if (nc) {
            b = 1;
        }
        try {
            PreparedStatement pstmt = this.db.prepareStatement("INSERT INTO INSTable VALUES (?,?,?)");
            pstmt.setBytes(1, bin_data_1);
            pstmt.setByte(2, b);
            pstmt.setBytes(3, bin_data_2);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("INS warning : Unable to store an entry into the database.");
        }
    }

    private NameComponent[] restore(ResultSet res, BooleanHolder nc, ObjectHolder obj) throws SQLException {
        byte[] bin_data_1 = res.getBytes(1);
        byte b = res.getByte(2);
        byte[] bin_data_2 = res.getBytes(3);
        String str = new String(bin_data_1);
        NameComponent[] name = null;
        try {
            name = this.naming.to_name(str);
        }
        catch (InvalidName ex) {
            System.out.println("INS warning : Unable to stringified a name.");
        }
        if (b == 0) {
            nc.value = false;
            String ior = new String(bin_data_2);
            obj.value = this.orb.string_to_object(ior);
        } else {
            nc.value = true;
        }
        return name;
    }

    private void createTable() {
        System.out.print("Create INSTable [");
        try {
            Statement stmt = this.db.createStatement();
            stmt.executeUpdate("CREATE TABLE INSTable ( id binary PRIMARY KEY, nc byte, ior binary )");
            stmt.close();
        }
        catch (SQLException ex) {
            System.out.println(" NOT OK ]");
            System.out.println("INS fatal error : " + ex);
            System.exit(0);
        }
        System.out.println(" OK ]");
    }

    private void cleanTable() {
        System.out.print("Remove INSTable [");
        try {
            Statement stmt = this.db.createStatement();
            stmt.executeUpdate("DROP TABLE INSTable");
        }
        catch (SQLException ex) {
            System.out.println(" NOT OK ]");
            System.out.println("INS warning : Unable to remove INSTable from database.");
            return;
        }
        System.out.println(" OK ]");
        this.createTable();
    }

    public void modify_object(NameComponent[] name, Object obj) {
        this.update(false, name, obj);
    }

    public void remove_object(NameComponent[] name) {
        this.remove(name);
    }

    private void restoreObject(NameComponent[] name, Object obj) {
        try {
            this.naming.bind(name, obj);
        }
        catch (NotFound ex) {
            System.out.println("INS warning N\u00b015 : Unable to restore an Object.");
        }
        catch (AlreadyBound ex) {
            System.out.println("INS warning N\u00b016 : Unable to restore an Object.");
        }
        catch (CannotProceed ex) {
            System.out.println("INS warning N\u00b017 : Unable to restore an Object.");
        }
        catch (InvalidName ex) {
            System.out.println("INS warning N\u00b018 : Unable to restore an Object.");
        }
    }

    private void checkDatabase() {
        String urlDB = this.properties.getProperty("INS.urlDB");
        if (urlDB == null) {
            System.out.println("INS fatal error : Unable to get INS.urlDB property.");
            System.exit(0);
        }
        try {
            this.db = DriverManager.getConnection(urlDB);
        }
        catch (SQLException ex) {
            System.out.print("Checking for INS database [ NOT OK ]");
            System.out.println("INS fatal error : " + ex + "\n");
            System.exit(0);
        }
        System.out.println("Checking for INS database [ OK ]");
        if (this.clean) {
            this.cleanTable();
        }
        System.out.print("Looking for INS table [");
        try {
            Statement stmt = this.db.createStatement();
            ResultSet res = stmt.executeQuery("SELECT * from INSTable");
            res.close();
        }
        catch (SQLException ex) {
            System.out.println(" NOT OK ]");
            this.createTable();
            return;
        }
        System.out.println(" OK ]");
    }

    private void update(boolean nc, NameComponent[] name, Object obj) {
        String str = "";
        try {
            str = this.naming.to_string(name);
        }
        catch (InvalidName ex) {
            System.out.println("INS warning : Unable to stringified a name.");
        }
        byte[] bin_data_1 = str.getBytes();
        byte[] bin_data_2 = null;
        if (nc) {
            bin_data_2 = new byte[]{};
        } else {
            str = this.orb.object_to_string(obj);
            bin_data_2 = str.getBytes();
        }
        byte b = 0;
        if (nc) {
            b = 1;
        }
        try {
            PreparedStatement pstmt = this.db.prepareStatement("UPDATE INSTable SET ior=?,nc=? WHERE id=?");
            pstmt.setBytes(1, bin_data_2);
            pstmt.setByte(2, b);
            pstmt.setBytes(3, bin_data_1);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("INS warning : Unable to store an entry into the database.");
        }
    }

    private void load() {
        ResultSet res = null;
        NameComponent[] name = null;
        BooleanHolder nc = new BooleanHolder();
        ObjectHolder obj = new ObjectHolder();
        Server.persistent = false;
        try {
            Statement stmt = this.db.createStatement();
            res = stmt.executeQuery("SELECT * from INSTable");
        }
        catch (SQLException ex) {
            System.out.println("INS fatal error : Unable to load persistent data from database.");
            System.exit(0);
        }
        try {
            while (res.next()) {
                name = this.restore(res, nc, obj);
                if (nc.value) {
                    this.restoreNamingContext(name);
                    continue;
                }
                this.restoreObject(name, obj.value);
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        Server.persistent = true;
    }

    public void add_object(NameComponent[] name, Object obj) {
        this.store(false, name, obj);
    }

    private void initDatabase() {
        String driver = this.properties.getProperty("INS.driver");
        if (driver == null) {
            System.out.println("INS fatal error : Unable to get INS.driver property.");
            System.exit(0);
        }
        System.out.print("Database initialization [");
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            System.out.println(" NOT OK ]\n");
            System.out.println("INS fatal error : " + e);
            System.exit(0);
        }
        System.out.println(" OK ]");
        this.checkDatabase();
        System.out.println("");
    }

    public void modify_nc(NameComponent[] name) {
        this.update(true, name, null);
    }

    public void remove_nc(NameComponent[] name) {
        this.remove(name);
    }

    public void init(Properties ins_properties, String[] args) {
        this.properties = ins_properties;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-clean")) {
                this.clean = true;
            }
            ++i;
        }
        this.initDatabase();
        this.load();
    }

    private void remove(NameComponent[] name) {
        String str = "";
        try {
            str = this.naming.to_string(name);
        }
        catch (InvalidName ex) {
            System.out.println("INS warning : Unable to stringified a name.");
        }
        byte[] bin_data = str.getBytes();
        try {
            PreparedStatement pstmt = this.db.prepareStatement("DELETE FROM INSTable where id=?");
            pstmt.setBytes(1, bin_data);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException ex) {
            System.out.println("INS warning : Unable to remove an entry into the database.");
        }
    }

    private void restoreNamingContext(NameComponent[] name) {
        try {
            this.naming.bind_new_context(name);
        }
        catch (NotFound ex) {
            System.out.println("INS warning N\u00b011 : Unable to restore a NamingContext.");
        }
        catch (AlreadyBound ex) {
            System.out.println("INS warning N\u00b012 : Unable to restore a NamingContext.");
        }
        catch (CannotProceed ex) {
            System.out.println("INS warning N\u00b013 : Unable to restore a NamingContext.");
        }
        catch (InvalidName ex) {
            System.out.println("INS warning N\u00b014 : Unable to restore a NamingContext.");
        }
    }
}

