/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.INS.persistence;

import JavaORB.INS.NamingContextExImpl;
import JavaORB.INS.persistence.connector;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class filePersistence
implements connector {
    private NamingContextExImpl naming;
    private ORB orb = ORB.init();
    private Hashtable entries = new Hashtable();
    private RandomAccessFile file;

    private void restoreNamingContext(NameComponent[] name) {
        try {
            this.naming.bind_new_context(name);
        }
        catch (NotFound ex) {
            System.out.println("INS warning N\u00b011 : Unable to restore a NamingContext.");
        }
        catch (AlreadyBound ex) {
            System.out.println("INS warning N\u00b012 : Unable to restore a NamingContext.");
        }
        catch (CannotProceed ex) {
            System.out.println("INS warning N\u00b013 : Unable to restore a NamingContext.");
        }
        catch (InvalidName ex) {
            System.out.println("INS warning N\u00b014 : Unable to restore a NamingContext.");
        }
    }

    public void add_nc(NameComponent[] name) {
        this.store(true, name, null);
    }

    private void invalidate(NameComponent[] name) {
        String str = "";
        int i = 0;
        while (i < name.length) {
            str = str + "/" + name[i].id + "." + name[i].kind;
            ++i;
        }
        this.invalidate(str);
    }

    private void invalidate(String str) {
        try {
            Long index = (Long)this.entries.get(str);
            if (index == null) {
                System.out.println("INS warning : Unable to invalidate an entry.");
                return;
            }
            long tmp = this.file.getFilePointer();
            this.file.seek(index);
            this.file.writeBoolean(false);
            this.file.seek(tmp);
            this.entries.remove(str);
        }
        catch (IOException ex) {
            System.out.println("INS fatal error : Unable to invalidate an existing entry.");
            System.exit(0);
        }
    }

    public filePersistence(NamingContextExImpl root) {
        this.naming = root;
    }

    private void store(boolean nc, NameComponent[] name, Object obj) {
        String str = "";
        try {
            long index = this.file.getFilePointer();
            this.file.writeBoolean(true);
            this.file.writeBoolean(nc);
            this.file.writeInt(name.length);
            int i = 0;
            while (i < name.length) {
                this.file.writeUTF(name[i].id);
                this.file.writeUTF(name[i].kind);
                str = str + "/" + name[i].id + "." + name[i].kind;
                ++i;
            }
            if (!nc) {
                this.file.writeUTF(this.orb.object_to_string(obj));
            }
            this.entries.put(str, new Long(index));
        }
        catch (IOException ex) {
            System.out.println("INS fatal error : Unable to an entry into the persistent file.");
            System.exit(0);
        }
    }

    public NameComponent[] restore(DataInputStream file, BooleanHolder nc, ObjectHolder obj) throws IOException {
        boolean ncb;
        boolean valid;
        NameComponent[] name = null;
        String ior = null;
        do {
            valid = file.readBoolean();
            ncb = file.readBoolean();
            int length = file.readInt();
            name = new NameComponent[length];
            int i = 0;
            while (i < length) {
                name[i] = new NameComponent();
                name[i].id = file.readUTF();
                name[i].kind = file.readUTF();
                ++i;
            }
            if (ncb) continue;
            ior = file.readUTF();
        } while (!valid);
        nc.value = ncb;
        if (!ncb) {
            obj.value = this.orb.string_to_object(ior);
        }
        return name;
    }

    public void modify_object(NameComponent[] name, Object obj) {
        this.invalidate(name);
        this.store(false, name, obj);
    }

    public void remove_object(NameComponent[] name) {
        this.invalidate(name);
    }

    private void restoreObject(NameComponent[] name, Object obj) {
        try {
            this.naming.bind(name, obj);
        }
        catch (NotFound ex) {
            System.out.println("INS warning N\u00b015 : Unable to restore an Object.");
        }
        catch (AlreadyBound ex) {
            System.out.println("INS warning N\u00b016 : Unable to restore an Object.");
        }
        catch (CannotProceed ex) {
            System.out.println("INS warning N\u00b017 : Unable to restore an Object.");
        }
        catch (InvalidName ex) {
            System.out.println("INS warning N\u00b018 : Unable to restore an Object.");
        }
    }

    private void load() {
        BooleanHolder nc = new BooleanHolder();
        ObjectHolder obj = new ObjectHolder();
        NameComponent[] name = null;
        DataInputStream file = null;
        try {
            FileInputStream input = new FileInputStream("ins.$$$");
            file = new DataInputStream(input);
        }
        catch (IOException ex) {
            return;
        }
        try {
            while (true) {
                name = this.restore(file, nc, obj);
                if (nc.value) {
                    this.restoreNamingContext(name);
                    continue;
                }
                this.restoreObject(name, obj.value);
            }
        }
        catch (IOException ex) {
            try {
                file.close();
                File old = new File("ins.$$$");
                old.delete();
            }
            catch (IOException ex2) {
                System.out.println("INS warning : Unable to close persistent file.");
            }
            return;
        }
    }

    public void add_object(NameComponent[] name, Object obj) {
        this.store(false, name, obj);
    }

    public void modify_nc(NameComponent[] name) {
        this.remove_nc(name);
        this.store(true, name, null);
    }

    public void remove_nc(NameComponent[] name) {
        Enumeration enumeration = this.entries.keys();
        String key = null;
        String str = "";
        int i = 0;
        while (i < name.length) {
            str = str + "/" + name[i].id + "." + name[i].kind;
            ++i;
        }
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (!key.startsWith(str)) continue;
            this.invalidate(key);
        }
    }

    public void init(Properties ins_properties, String[] args) {
        this.rename();
        try {
            this.file = new RandomAccessFile("ins.data", "rw");
        }
        catch (IOException ex) {
            System.out.println("INS fatal error : Unable to create persistent file.");
            System.exit(0);
        }
        this.load();
    }

    private void rename() {
        File src = new File("ins.data");
        File tgt = new File("ins.$$$");
        src.renameTo(tgt);
    }
}

