/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.Interceptor;

import JavaORB.Interceptor.MessageIn;
import JavaORB.Interceptor.MessageInImpl;
import JavaORB.Interceptor.MessageManager;
import JavaORB.Interceptor.MessageOut;
import JavaORB.Interceptor.MessageOutHolder;
import JavaORB.Interceptor.MessageOutImpl;
import JavaORB.Trace;
import JavaORB.protocol.ClientStack;
import java.io.IOException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;

public class MessageManagerImpl
implements MessageManager {
    private ClientStack _stack;
    private MessageIn messageIn;
    private MessageOut messageOut;
    private byte[] remaining;

    public byte[] getMessageIn(IntHolder size) {
        size.value = this.messageIn.size();
        return this.messageIn.content();
    }

    public MessageManagerImpl(ClientStack stack) {
        this._stack = stack;
        this.remaining = new byte[0];
    }

    public MessageOut messageOut() {
        return this.messageOut;
    }

    public byte[] remain() {
        return this.remaining;
    }

    public MessageIn newMessageIn() {
        this.messageIn = new MessageInImpl(new byte[0], 0, 0);
        return this.messageIn;
    }

    public MessageIn messageIn() {
        return this.messageIn;
    }

    public void setMessageOut(byte[] content2, int begin, int size) {
        this.messageOut = new MessageOutImpl(content2, begin, size);
    }

    public void getMessageOut(byte[] content2, int index, int begin, int size) {
        byte[] buffer;
        MessageOutHolder out;
        if (size > this.messageOut.size()) {
            out = new MessageOutHolder();
            this.receive(out, size - this.messageOut.size());
            buffer = out.value.content();
            byte[] tmp = this.messageOut.content();
            byte[] b = new byte[size];
            System.arraycopy(tmp, 0, b, 0, tmp.length);
            System.arraycopy(buffer, 0, b, tmp.length, buffer.length);
            this.messageOut = new MessageOutImpl(b, 0, size);
        }
        if (((MessageOutImpl)this.messageOut).isConsume()) {
            out = new MessageOutHolder();
            this.receive(out, size);
            buffer = out.value.content();
            this.messageOut = new MessageOutImpl(buffer, 0, size);
        } else {
            buffer = this.messageOut.content();
        }
        System.arraycopy(buffer, index, content2, begin, size);
        if (size < buffer.length) {
            this.remaining = new byte[buffer.length - (content2.length + index)];
            System.arraycopy(buffer, content2.length + index, this.remaining, 0, this.remaining.length);
        } else {
            this.remaining = new byte[0];
        }
    }

    public void send(MessageIn msg) {
        byte[] buffer = msg.content();
        try {
            this._stack.send(buffer, 0, buffer.length);
        }
        catch (IOException ex) {
            Trace.CoreError("Unable to send a message via the message interceptor");
            Trace.TraceException(ex);
            throw new COMM_FAILURE("Unable to send a message via the message interceptor");
        }
    }

    public void receive(MessageOutHolder msg, int size) {
        byte[] temp = new byte[size];
        try {
            this._stack.receive(temp, 0, size);
        }
        catch (IOException ex) {
            Trace.CoreError("Unable to receive a message via the message interceptor");
            Trace.TraceException(ex);
            throw new COMM_FAILURE("Unable to receive a message via the message interceptor");
        }
        msg.value = new MessageOutImpl(temp, 0, size);
    }

    public void setMessageIn(byte[] content2, int begin, int size) {
        this.messageIn = new MessageInImpl(content2, begin, size);
    }
}

