/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.PortableServer;

import JavaORB.CORBA.ContextType;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.RequestAdapter;
import JavaORB.CORBA.ServerRequest;
import JavaORB.CORBA.handler.ObjectFactory;
import JavaORB.CORBA.portable.ObjectImpl;
import JavaORB.PortableServer.ActiveObjectMapEntry;
import JavaORB.PortableServer.IdAssignmentPolicyImpl;
import JavaORB.PortableServer.IdUniquenessPolicyImpl;
import JavaORB.PortableServer.ImplicitActivationPolicyImpl;
import JavaORB.PortableServer.Key;
import JavaORB.PortableServer.KeyAssignmentPolicy;
import JavaORB.PortableServer.KeyAssignmentPolicyImpl;
import JavaORB.PortableServer.KeyAssignmentPolicyValue;
import JavaORB.PortableServer.KeyHelper;
import JavaORB.PortableServer.KeyProfileBody;
import JavaORB.PortableServer.KeyProfileBody_1;
import JavaORB.PortableServer.KeyProfileBody_1Helper;
import JavaORB.PortableServer.KeyProfileBody_1Package.type_id;
import JavaORB.PortableServer.LifespanPolicyImpl;
import JavaORB.PortableServer.POAContextEntry;
import JavaORB.PortableServer.POAManagerImpl;
import JavaORB.PortableServer.PersistentKeyBody_1;
import JavaORB.PortableServer.ReferenceEntry;
import JavaORB.PortableServer.RequestBag;
import JavaORB.PortableServer.RequestProcessingPolicyImpl;
import JavaORB.PortableServer.ServantRetentionPolicyImpl;
import JavaORB.PortableServer.ThreadPolicyImpl;
import JavaORB.PortableServer.portable.Delegate;
import JavaORB.Trace;
import JavaORB.iiop.BiDirectionalClientConnectionIIOP;
import JavaORB.policy.BiDirPolicyImpl;
import JavaORB.protocol.Listener;
import JavaORB.protocol.ProtocolPlug;
import JavaORB.protocol.ServerConnection;
import java.io.IOException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.BiDirPolicy.BirectionalPolicy;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_FLAG;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.INV_POLICYHelper;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public class POAImpl
implements POA {
    protected ORBSingleton orb;
    private String _name;
    private POA _parent;
    private Hashtable _child_poa;
    private POAManagerImpl _poa_manager;
    private AdapterActivator _activator;
    protected ServantManager _srv_manager;
    protected Servant _default_servant;
    protected ThreadPolicy _thread;
    protected LifespanPolicy _lifespan;
    protected IdUniquenessPolicy _id_uniqueness;
    protected IdAssignmentPolicy _id_assignment;
    protected ImplicitActivationPolicy _implicit_activation;
    protected ServantRetentionPolicy _servant_retention;
    protected RequestProcessingPolicy _request_processing;
    protected KeyAssignmentPolicy _key_assignment;
    protected BirectionalPolicy _bi_directional;
    protected Listener _oa_entry;
    protected Hashtable _aom;
    private Vector _request_queue;
    private RequestAdapter rqAdapter;
    public ProtocolPlug plug;
    public Hashtable _refList;
    public int instanceCount = 0;
    protected ObjectFactory _factory;
    protected Hashtable _ref_table;

    public POA create_POA(String adapter_name, POAManager a_POAManager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        if (Trace.level != 0) {
            Trace.Step("Create a new POA named : " + adapter_name);
        }
        if (this._child_poa.get(adapter_name) != null) {
            throw new AdapterAlreadyExists();
        }
        POAImpl new_poa = new POAImpl(adapter_name, this, this._oa_entry, a_POAManager, policies);
        this._child_poa.put(adapter_name, new_poa);
        return new_poa;
    }

    protected boolean policy_implicit() {
        return this._implicit_activation.value().value() == 0;
    }

    private String[] getPOAFullName() {
        POA poa = this;
        String[] fullname = null;
        Vector<String> list = new Vector<String>();
        while (poa.the_parent() != null) {
            list.addElement(poa.the_name());
            poa = poa.the_parent();
        }
        fullname = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            fullname[i] = (String)list.elementAt(list.size() - (i + 1));
            ++i;
        }
        return fullname;
    }

    public void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        ActiveObjectMapEntry aom_entry = null;
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        aom_entry = (ActiveObjectMapEntry)this._aom.get(new String(oid));
        if (aom_entry == null) {
            throw new ObjectNotActive();
        }
        try {
            Object ref = this.getReferenceFromServant(aom_entry.serv);
            this.removeRef(oid);
            this._factory.disconnectObject(ref);
        }
        catch (ServantNotActive servantNotActive) {
            // empty catch block
        }
        if (this.policy_use_manager() && this._srv_manager != null && this._srv_manager instanceof ServantActivator) {
            ((ServantActivator)this._srv_manager).etherealize(aom_entry.oid, this, aom_entry.serv, true, false);
        }
        this._aom.remove(new String(oid));
        ((Delegate)aom_entry.serv._get_delegate()).removePOA(aom_entry.serv);
    }

    public void proceed_request() {
        block4: {
            block3: {
                if (!this.policy_single_thread()) break block3;
                POAImpl pOAImpl = this;
                synchronized (pOAImpl) {
                    this.proceed_request_really();
                    java.lang.Object var2_2 = null;
                    break block4;
                }
            }
            this.proceed_request_really();
        }
    }

    private boolean is_into_invocation() {
        try {
            this.orb.getCurrentContext();
        }
        catch (BAD_OPERATION ex) {
            return false;
        }
        return true;
    }

    public Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        ActiveObjectMapEntry aom_entry = null;
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        aom_entry = (ActiveObjectMapEntry)this._aom.get(new String(oid));
        if (aom_entry == null) {
            throw new ObjectNotActive();
        }
        return aom_entry.serv;
    }

    protected boolean policy_non_retain() {
        return !this.policy_retain();
    }

    protected KeyProfileBody_1 extract_key1_body(Key key) {
        int i = 0;
        while (i < key.profile.length) {
            if (this.isVersion(key.profile[i].version, (byte)2, (byte)2, (byte)0)) {
                KeyProfileBody_1 k = null;
                OutputStream out = this.orb.create_output_stream();
                out.write_octet_array(key.profile[i].key_body, 0, key.profile[i].key_body.length);
                InputStream in = out.create_input_stream();
                k = KeyProfileBody_1Helper.read(in);
                return k;
            }
            ++i;
        }
        throw new INV_FLAG("Unable to get a 2.2.0 KeyProfile body...");
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        return new LifespanPolicyImpl(value);
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        return new IdAssignmentPolicyImpl(value);
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        return new ImplicitActivationPolicyImpl(value);
    }

    protected void remove_child(String name) {
        if (this._child_poa.containsKey(name)) {
            this._child_poa.remove(name);
        } else if (Trace.level != 0) {
            Trace.CoreError("Try to remove an unknown child !");
        }
    }

    protected boolean is_system_key(byte[] key) {
        try {
            if (key.length < 8) {
                return false;
            }
            OutputStream out = this.orb.create_output_stream();
            out.write_octet_array(key, 0, key.length);
            InputStream in = out.create_input_stream();
            String magic = in.read_string();
            if (magic.equals("JORB")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected Key extract_system_key(byte[] key) {
        Key k = null;
        OutputStream out = this.orb.create_output_stream();
        out.write_octet_array(key, 0, key.length);
        InputStream in = out.create_input_stream();
        k = KeyHelper.read(in);
        return k;
    }

    public Object create_reference_with_id(byte[] id, String intf) throws WrongPolicy {
        if (this.policy_system_id()) {
            throw new WrongPolicy();
        }
        byte[] key = this.id_to_key(id);
        org.omg.CORBA.portable.ObjectImpl ref = this.convertToImpl(this.create_new_reference(null, key));
        String[] list = new String[]{intf};
        ((ObjectImpl)ref).set_ids(list);
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_key(key);
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_port(this._oa_entry._get_port());
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_host(this._oa_entry._get_host());
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_id(intf);
        this._ref_table.put(new String(key), ref);
        return ref;
    }

    protected byte[] key_to_id(byte[] key) {
        if (this.is_system_key(key)) {
            if (Trace.level != 0) {
                Trace.Step("Get an Object ID from a JavaORB Servant Key");
            }
            Key k = this.extract_system_key(key);
            KeyProfileBody_1 body = this.extract_key1_body(k);
            switch (body.id.discriminator()) {
                case 0: {
                    return body.id.persistent().body;
                }
                case 1: {
                    return body.id.body();
                }
            }
            throw new INTERNAL("Unable to extract a KeyId");
        }
        if (Trace.level != 0) {
            Trace.Step("Get an Object ID from a User Key");
        }
        return key;
    }

    public Servant lookup_id(byte[] oid) throws OBJECT_NOT_EXIST {
        Servant serv = this.get_servant_with_id(oid);
        if (serv != null) {
            return serv;
        }
        Enumeration enumeration = this._child_poa.elements();
        if (enumeration.hasMoreElements()) {
            POAImpl poa = (POAImpl)enumeration.nextElement();
            try {
                try {
                    serv = poa.lookup_id(oid);
                }
                catch (OBJECT_NOT_EXIST ex) {}
            }
            catch (Throwable throwable) {}
            return serv;
        }
        throw new OBJECT_NOT_EXIST();
    }

    public void removeRef(byte[] oid) {
        byte[] key = this.id_to_key(oid);
        this._ref_table.remove(new String(key));
    }

    protected boolean policy_unique_id() {
        return this._id_uniqueness.value().value() == 0;
    }

    protected boolean policy_normal() {
        return this._bi_directional.value() == 0;
    }

    private synchronized String timeStamp() {
        GregorianCalendar c = new GregorianCalendar();
        return "" + c.get(11) + ":" + c.get(12) + ":" + c.get(13) + ":" + c.get(14);
    }

    public void dequeue_requests() {
        while (this._request_queue.size() != 0) {
            this.proceed_request();
        }
    }

    public Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        try {
            return this.servant_to_reference(this.id_to_servant(oid));
        }
        catch (ServantNotActive ex) {
            throw new ObjectNotActive();
        }
    }

    public Object getReference(Servant servant, byte[] oid) {
        Object obj = null;
        try {
            obj = this.getReferenceFromServant(servant);
        }
        catch (ServantNotActive ex) {
            // empty catch block
        }
        if (obj == null) {
            byte[] key = this.id_to_key(oid);
            obj = (Object)this._ref_table.get(new String(key));
        }
        return obj;
    }

    public POA[] the_children() {
        POA[] list = new POA[this._child_poa.size()];
        Enumeration enumeration = this._child_poa.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            list[i++] = (POA)enumeration.nextElement();
        }
        return list;
    }

    private static boolean array_equal(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public AdapterActivator the_activator() {
        return this._activator;
    }

    public void the_activator(AdapterActivator value) {
        this._activator = value;
    }

    public void destroy(boolean etherealize_objects, boolean wait_for_completion) {
        Enumeration enumeration;
        if (Trace.level != 0) {
            Trace.Step("Destroy a POA");
        }
        if (wait_for_completion) {
            if (this.is_into_invocation()) {
                throw new BAD_INV_ORDER();
            }
            if (etherealize_objects && this.policy_retain() && this.policy_use_manager() && this._srv_manager != null) {
                enumeration = this._aom.elements();
                int index = 0;
                while (enumeration.hasMoreElements()) {
                    ActiveObjectMapEntry aom_entry = (ActiveObjectMapEntry)enumeration.nextElement();
                    ((ServantActivator)this._srv_manager).etherealize(aom_entry.oid, this, aom_entry.serv, true, this.is_remaining(aom_entry.serv, index));
                    ((Delegate)aom_entry.serv._get_delegate()).removePOA(aom_entry.serv);
                    ++index;
                }
            }
        }
        enumeration = this._child_poa.elements();
        while (enumeration.hasMoreElements()) {
            ((POA)enumeration.nextElement()).destroy(etherealize_objects, wait_for_completion);
        }
        this._child_poa.clear();
        this._aom.clear();
        ((POAImpl)this._parent).remove_child(this._name);
        System.gc();
    }

    public String the_name() {
        return this._name;
    }

    public void addToReferenceList(Servant servant, Object reference) {
        ReferenceEntry entry = new ReferenceEntry();
        entry.servant = servant;
        entry.reference = reference;
        this._refList.put(servant, entry);
    }

    private void proceed_request_really() {
        block18: {
            RequestBag rqB;
            if (this._request_queue.size() == 0) break block18;
            BooleanHolder except_flag = new BooleanHolder();
            BooleanHolder user_flag = new BooleanHolder();
            POAImpl pOAImpl = this;
            synchronized (pOAImpl) {
                rqB = (RequestBag)this._request_queue.elementAt(0);
                if (Trace.level != 0) {
                    Trace.Step("Get request : " + rqB.op);
                }
                this._request_queue.removeElementAt(0);
                java.lang.Object var9_5 = null;
            }
            OutputStream output = this.plug.newOutputStream(rqB.srv._get_version().minor);
            try {
                this.checkForBiDirPermission();
            }
            catch (INV_POLICY ex) {
                if (Trace.level != 0) {
                    Trace.Step("BiDir IIOP is not allowed");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.INV_POLICY");
                }
                OutputStream out = this.orb.create_output_stream();
                INV_POLICYHelper.write(out, ex);
                rqB.srv.replySystemException(rqB.rqId, out);
                return;
            }
            boolean postToDo = false;
            if (this.policy_non_retain() && this.policy_use_manager() && this._srv_manager != null) {
                try {
                    try {
                        rqB.cookie = new CookieHolder();
                        rqB.serv = ((ServantLocator)this._srv_manager).preinvoke(rqB.oid, this, rqB.op, rqB.cookie);
                        this.orb.set_delegate(rqB.serv);
                        ((Delegate)rqB.serv._get_delegate()).setPOA(this, rqB.serv);
                    }
                    catch (ForwardRequest ex) {
                        ((ServantLocator)this._srv_manager).postinvoke(rqB.oid, this, rqB.op, rqB.cookie.value, null);
                        output.write_Object(ex.forward_reference);
                        if (rqB.response) {
                            rqB.srv.replyLocationForward(rqB.rqId, output);
                        }
                        return;
                    }
                    catch (Exception ex) {
                        ((ServantLocator)this._srv_manager).postinvoke(rqB.oid, this, rqB.op, rqB.cookie.value, null);
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    ServerRequest request = null;
                    request = new ServerRequest(rqB.op);
                    request.input_data(rqB.data);
                    this.rqAdapter.completeExceptionProcess(ex, request);
                    if (rqB.response) {
                        user_flag.value = false;
                        request.output_data(output, except_flag);
                        rqB.srv.replySystemException(rqB.rqId, output);
                    }
                    return;
                }
                postToDo = true;
            }
            ContextType ctx = new ContextType();
            POAContextEntry entry = new POAContextEntry();
            entry.poa = this;
            entry.key = rqB.oid;
            entry.operation = rqB.op;
            entry.servant = rqB.serv;
            entry.cookie = postToDo ? rqB.cookie.value : null;
            ctx.add("POACurrentContext", entry);
            this.orb.pushCurrentContext(ctx);
            this.rqAdapter.dispatch_servant(rqB, output, except_flag, user_flag, this.getReference(rqB.serv, rqB.oid), this, postToDo);
            this.orb.popCurrentContext();
        }
        if (Trace.level != 0) {
            Trace.Step("Nothing to do, no request in the stack...");
        }
    }

    public void setListener(Listener protocol) {
        this._oa_entry = protocol;
    }

    public byte[] activate_object(Servant p_servant) throws ServantAlreadyActive, WrongPolicy {
        if (Trace.level != 0) {
            Trace.Step("Activate an object");
        }
        if (!this.policy_system_id()) {
            throw new WrongPolicy();
        }
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        if (this._id_uniqueness.value().value() == IdUniquenessPolicyValue.UNIQUE_ID.value()) {
            Enumeration enumeration = this._aom.elements();
            ActiveObjectMapEntry aom_entry = null;
            while (enumeration.hasMoreElements()) {
                aom_entry = (ActiveObjectMapEntry)enumeration.nextElement();
                if (!aom_entry.serv.equals(p_servant)) continue;
                throw new ServantAlreadyActive();
            }
        }
        byte[] id = this.create_system_id(p_servant._all_interfaces(null, null)[0]);
        byte[] key = this.id_to_key(id);
        Object ref = this.create_new_reference(p_servant, key);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_id(p_servant._all_interfaces(null, null)[0]);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_key(key);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_port(this._oa_entry._get_port());
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_host(this._oa_entry._get_host());
        this.addToReferenceList(p_servant, ref);
        ActiveObjectMapEntry new_entry = new ActiveObjectMapEntry();
        new_entry.oid = id;
        new_entry.serv = p_servant;
        this.orb.set_delegate(p_servant);
        ((Delegate)p_servant._get_delegate()).setPOA(this, p_servant);
        this._factory.connectObject(ref);
        this._aom.put(new String(id), new_entry);
        return id;
    }

    private boolean isVersion(byte[] version, byte major, byte minor, byte release) {
        return version[0] == major && version[1] == minor && version[2] == release;
    }

    public Object getReferenceFromServant(Servant servant) throws ServantNotActive {
        ReferenceEntry entry = null;
        entry = (ReferenceEntry)this._refList.get(servant);
        if (entry != null) {
            return entry.reference;
        }
        if (this._implicit_activation != null && this._implicit_activation.value().value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION.value()) {
            try {
                this.activate_object(servant);
                return this.getReferenceFromServant(servant);
            }
            catch (ServantAlreadyActive ex) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
        }
        if (this._srv_manager == null) {
            throw new ServantNotActive();
        }
        return null;
    }

    public void updateReferenceForServant(Servant servant, Object reference) {
        ReferenceEntry entry = null;
        entry = (ReferenceEntry)this._refList.get(servant);
        if (entry != null) {
            entry.reference = reference;
            return;
        }
        this.addToReferenceList(servant, reference);
    }

    protected boolean policy_retain() {
        return this._servant_retention.value().value() == 0;
    }

    protected boolean policy_use_default() {
        return this._request_processing.value().value() == 1;
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        return new IdUniquenessPolicyImpl(value);
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        return new RequestProcessingPolicyImpl(value);
    }

    public POA the_parent() {
        return this._parent;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (this.policy_use_default()) {
            if (this._default_servant == null) {
                throw new NoServant();
            }
            return this._default_servant;
        }
        throw new WrongPolicy();
    }

    public void set_servant(Servant p_servant) throws WrongPolicy {
        if (this.policy_use_default()) {
            this._default_servant = p_servant;
            byte[] key = this.id_to_key(new byte[0]);
            Object ref = this.create_new_reference(p_servant, key);
            ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_key(key);
            ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_port(this._oa_entry._get_port());
            ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_host(this._oa_entry._get_host());
            this.addToReferenceList(this._default_servant, ref);
            this.orb.set_delegate(p_servant);
            ((Delegate)p_servant._get_delegate()).setPOA(this, p_servant);
            return;
        }
        throw new WrongPolicy();
    }

    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        ActiveObjectMapEntry aom_entry = null;
        if (this.policy_use_default()) {
            if (this._default_servant != null) {
                return this._default_servant;
            }
            throw new ObjectNotActive();
        }
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        byte[] key = ((JavaORB.CORBA.portable.Delegate)((org.omg.CORBA.portable.ObjectImpl)reference)._get_delegate())._get_key();
        byte[] srv_id = this.key_to_id(key);
        aom_entry = (ActiveObjectMapEntry)this._aom.get(new String(srv_id));
        if (aom_entry == null) {
            throw new ObjectNotActive();
        }
        return aom_entry.serv;
    }

    public POAImpl lookup_poa_with_servant_id(byte[] oid) throws AdapterNonExistent {
        Servant serv;
        if (Trace.level != 0) {
            Trace.InFunction("POA::lookup_poa_with_servant_id");
        }
        if ((serv = this.get_servant_with_id(oid)) != null) {
            if (Trace.level != 0) {
                Trace.Step("Servant trouve, retourne le POA ( ici soit meme )");
            }
            if (Trace.level != 0) {
                Trace.OutFunction("POA::lookup_poa_with_servant_id");
            }
            return this;
        }
        if (Trace.level != 0) {
            Trace.Step("Parcours les POA fils");
        }
        Enumeration enumeration = this._child_poa.elements();
        if (enumeration.hasMoreElements()) {
            POAImpl poa = (POAImpl)enumeration.nextElement();
            try {
                try {
                    poa = poa.lookup_poa_with_servant_id(oid);
                }
                catch (AdapterNonExistent ex) {}
            }
            catch (Throwable throwable) {}
            if (Trace.level != 0) {
                Trace.Step("POA trouve");
            }
            if (Trace.level != 0) {
                Trace.OutFunction("POA::lookup_poa_with_servant_id");
            }
            return poa;
        }
        if (Trace.level != 0) {
            Trace.CoreError("POA non trouve");
        }
        if (Trace.level != 0) {
            Trace.ThrowException("org.omg.PortableServer.POAPackage.AdapterNonExistent");
        }
        throw new AdapterNonExistent();
    }

    protected boolean policy_system_id() {
        return this._id_assignment.value().value() == 1;
    }

    public byte[] servant_to_id(Servant p_servant) throws ServantNotActive, WrongPolicy {
        ActiveObjectMapEntry aom_entry = null;
        if (this.policy_use_default()) {
            if (this.is_into_invocation()) {
                Object ref = this.getReferenceFromServant(this._default_servant);
                byte[] key = ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._get_key();
                byte[] id = this.key_to_id(key);
                return id;
            }
            throw new ServantNotActive();
        }
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        Enumeration enumeration = this._aom.elements();
        while (enumeration.hasMoreElements()) {
            aom_entry = (ActiveObjectMapEntry)enumeration.nextElement();
            if (aom_entry.serv.equals(p_servant)) break;
        }
        if (aom_entry == null) {
            if (this.policy_implicit()) {
                try {
                    return this.activate_object(p_servant);
                }
                catch (ServantAlreadyActive ex) {
                }
            } else {
                throw new ServantNotActive();
            }
        }
        return aom_entry.oid;
    }

    public Servant get_servant_with_id(byte[] oid) {
        if (Trace.level != 0) {
            Trace.InFunction("POA::get_servant_with_id");
        }
        ActiveObjectMapEntry aom_entry = null;
        if (Trace.level != 0) {
            Trace.Step("Recherche le servant = " + new String(oid));
        }
        if ((aom_entry = (ActiveObjectMapEntry)this._aom.get(new String(oid))) != null) {
            return aom_entry.serv;
        }
        if (Trace.level != 0) {
            Trace.Step("Servant non trouve");
        }
        if (Trace.level != 0) {
            Trace.OutFunction("POA::get_servant_with_id");
        }
        return null;
    }

    protected boolean policy_transient() {
        return this._lifespan.value().value() == 0;
    }

    private boolean is_remaining(Servant srv, int index) {
        ActiveObjectMapEntry entry = null;
        Enumeration enumeration = this._aom.elements();
        int i = 0;
        while (i < index) {
            enumeration.nextElement();
            ++i;
        }
        while (enumeration.hasMoreElements()) {
            entry = (ActiveObjectMapEntry)enumeration.nextElement();
            if (!entry.serv.equals(srv)) continue;
            return true;
        }
        return false;
    }

    public void discard_requests() {
        this._request_queue.removeAllElements();
    }

    public Object servant_to_reference(Servant p_servant) throws ServantNotActive, WrongPolicy {
        ActiveObjectMapEntry aom_entry = null;
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        if (this.policy_unique_id()) {
            return this.getReferenceFromServant(p_servant);
        }
        Enumeration enumeration = this._aom.elements();
        while (enumeration.hasMoreElements()) {
            aom_entry = (ActiveObjectMapEntry)enumeration.nextElement();
            if (aom_entry.serv.equals(p_servant)) break;
        }
        if (aom_entry == null) {
            try {
                this.activate_object(p_servant);
                return this.getReferenceFromServant(p_servant);
            }
            catch (ServantAlreadyActive ex) {
                // empty catch block
            }
        }
        return this.getReferenceFromServant(aom_entry.serv);
    }

    public void etherealize_objects() {
        if (this.policy_retain() && this.policy_use_manager() && this._srv_manager != null) {
            Enumeration enumeration = this._aom.elements();
            int index = 0;
            while (enumeration.hasMoreElements()) {
                ActiveObjectMapEntry aom_entry = (ActiveObjectMapEntry)enumeration.nextElement();
                ((ServantActivator)this._srv_manager).etherealize(aom_entry.oid, this, aom_entry.serv, true, this.is_remaining(aom_entry.serv, ++index));
                ((Delegate)aom_entry.serv._get_delegate()).removePOA(aom_entry.serv);
            }
        }
        Enumeration en = this._child_poa.elements();
        while (en.hasMoreElements()) {
            POAImpl p = (POAImpl)en.nextElement();
            try {
                if (p._poa_manager == this._poa_manager) continue;
                p._poa_manager.deactivate(true, true);
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    public POAManager the_POAManager() {
        return this._poa_manager;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.policy_use_manager()) {
            if (this.policy_retain() && !(this._srv_manager instanceof ServantActivator)) {
                throw new OBJ_ADAPTER();
            }
            if (this.policy_non_retain() && !(this._srv_manager instanceof ServantLocator)) {
                throw new OBJ_ADAPTER();
            }
            if (this._srv_manager == null) {
                throw new OBJ_ADAPTER();
            }
            return this._srv_manager;
        }
        throw new WrongPolicy();
    }

    public void set_servant_manager(ServantManager imgr) throws WrongPolicy {
        if (this.policy_use_manager()) {
            this._srv_manager = imgr;
            return;
        }
        throw new WrongPolicy();
    }

    public void inqueue_request(Servant serv, ServerConnection srv, byte[] ObjectKey, int RequestId, boolean ResponseExpected, String Operation, InputStream input) {
        java.lang.Object var10_10;
        RequestBag rqB = new RequestBag();
        POAImpl pOAImpl = this;
        synchronized (pOAImpl) {
            rqB.serv = serv;
            rqB.srv = srv;
            rqB.oid = ObjectKey;
            rqB.rqId = RequestId;
            rqB.response = ResponseExpected;
            rqB.op = Operation;
            rqB.data = input;
            var10_10 = null;
        }
        if (this._poa_manager.get_state() == 3) {
            if (Trace.level != 0) {
                Trace.Step("Ignore une requete");
            }
            return;
        }
        pOAImpl = this;
        synchronized (pOAImpl) {
            this._request_queue.addElement(rqB);
            var10_10 = null;
        }
        if (Trace.level != 0) {
            Trace.Step("Push a request");
        }
        if (this._poa_manager.get_state() == 2) {
            this.proceed_request();
        }
        if (Trace.level != 0) {
            Trace.Step("POA Manager not activate, wait until activation...");
        }
    }

    void scan_policies(Policy[] policies) throws InvalidPolicy {
        if (Trace.level != 0) {
            Trace.Step("Scan policies : checks POA policies");
        }
        if (policies != null) {
            int i = 0;
            while (i < policies.length) {
                if (policies[i] instanceof ThreadPolicyImpl) {
                    this._thread = (ThreadPolicyImpl)policies[i];
                } else if (policies[i] instanceof LifespanPolicyImpl) {
                    this._lifespan = (LifespanPolicyImpl)policies[i];
                } else if (policies[i] instanceof IdUniquenessPolicyImpl) {
                    this._id_uniqueness = (IdUniquenessPolicyImpl)policies[i];
                } else if (policies[i] instanceof IdAssignmentPolicyImpl) {
                    this._id_assignment = (IdAssignmentPolicyImpl)policies[i];
                } else if (policies[i] instanceof ImplicitActivationPolicyImpl) {
                    this._implicit_activation = (ImplicitActivationPolicyImpl)policies[i];
                } else if (policies[i] instanceof ServantRetentionPolicyImpl) {
                    this._servant_retention = (ServantRetentionPolicyImpl)policies[i];
                } else if (policies[i] instanceof RequestProcessingPolicyImpl) {
                    this._request_processing = (RequestProcessingPolicyImpl)policies[i];
                } else if (policies[i] instanceof KeyAssignmentPolicyImpl) {
                    this._key_assignment = (KeyAssignmentPolicyImpl)policies[i];
                } else if (policies[i] instanceof BiDirPolicyImpl) {
                    this._bi_directional = (BiDirPolicyImpl)policies[i];
                }
                ++i;
            }
            if (this._thread == null) {
                this._thread = this.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL);
            }
            if (this._lifespan == null) {
                this._lifespan = this.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
            }
            if (this._id_uniqueness == null) {
                this._id_uniqueness = this.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID);
            }
            if (this._id_assignment == null) {
                this._id_assignment = this.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            }
            if (this._servant_retention == null) {
                this._servant_retention = this.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
            }
            if (this._request_processing == null) {
                this._request_processing = this.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY);
            }
            if (this._implicit_activation == null) {
                this._implicit_activation = this.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION);
            }
            if (this._key_assignment == null) {
                this._key_assignment = this.create_key_assignment_policy(KeyAssignmentPolicyValue.SYSTEM_KEY);
            }
            if (this._bi_directional == null) {
                this._bi_directional = new BiDirPolicyImpl(0);
            }
            if (this._request_processing.value().value() == 0 && this._servant_retention.value().value() != 0) {
                short idx2;
                short idx1 = this.find_index(22, policies);
                if (idx1 < (idx2 = this.find_index(21, policies))) {
                    throw new InvalidPolicy(idx1);
                }
                throw new InvalidPolicy(idx2);
            }
            if (this._request_processing.value().value() == 1 && this._id_uniqueness.value().value() != 1) {
                short idx2;
                short idx1 = this.find_index(22, policies);
                if (idx1 < (idx2 = this.find_index(18, policies))) {
                    throw new InvalidPolicy(idx1);
                }
                throw new InvalidPolicy(idx2);
            }
            if (this._implicit_activation.value().value() == 0) {
                if (this._id_assignment.value().value() != 1) {
                    short idx2;
                    short idx1 = this.find_index(20, policies);
                    if (idx1 < (idx2 = this.find_index(19, policies))) {
                        throw new InvalidPolicy(idx1);
                    }
                    throw new InvalidPolicy(idx2);
                }
                if (this._servant_retention.value().value() != 0) {
                    short idx2;
                    short idx1 = this.find_index(20, policies);
                    if (idx1 < (idx2 = this.find_index(21, policies))) {
                        throw new InvalidPolicy(idx1);
                    }
                    throw new InvalidPolicy(idx2);
                }
            }
            if (this._key_assignment.value().value() == 0 && this._id_assignment.value().value() != 0) {
                short idx2;
                short idx1 = this.find_index(1000, policies);
                if (idx1 < (idx2 = this.find_index(19, policies))) {
                    throw new InvalidPolicy(idx1);
                }
                throw new InvalidPolicy(idx2);
            }
        }
    }

    public POA find_POA(String adapter_name, boolean activate_it) throws AdapterNonExistent {
        if (Trace.level != 0) {
            Trace.Step("Try to find a POA : " + adapter_name);
        }
        POA poa = null;
        poa = (POA)this._child_poa.get(adapter_name);
        if (poa == null) {
            if (activate_it) {
                if (Trace.level != 0) {
                    Trace.Step("Try to activate : " + adapter_name);
                }
                if (this._activator == null) {
                    throw new AdapterNonExistent();
                }
                if (!this._activator.unknown_adapter(this, adapter_name)) {
                    throw new AdapterNonExistent();
                }
                return this.find_POA(adapter_name, activate_it);
            }
            throw new AdapterNonExistent();
        }
        return poa;
    }

    protected boolean policy_single_thread() {
        return this._thread.value().value() == 1;
    }

    private void checkForBiDirPermission() {
        Thread t = Thread.currentThread();
        Thread o = t;
        if (o instanceof BiDirectionalClientConnectionIIOP && this.policy_normal()) {
            throw new INV_POLICY("BiDirectionnal IIOP is not allowed");
        }
    }

    protected byte[] id_to_key(byte[] id) {
        if (this.policy_system_key()) {
            Key key = new Key();
            key.magic = "JORB";
            KeyProfileBody[] profile = new KeyProfileBody[]{new KeyProfileBody()};
            profile[0].version = new byte[3];
            profile[0].version[0] = 2;
            profile[0].version[1] = 2;
            profile[0].version[2] = 0;
            KeyProfileBody_1 body = new KeyProfileBody_1();
            body.id = new type_id();
            if (this.policy_transient()) {
                body.id.body(id);
            } else {
                PersistentKeyBody_1 p_body = new PersistentKeyBody_1();
                p_body.body = id;
                p_body.unique_id = this.getUUID();
                body.id.persistent(p_body);
            }
            body.poa_path = this.getPOAFullName();
            OutputStream out = this.orb.create_output_stream();
            KeyProfileBody_1Helper.write(out, body);
            InputStream in = out.create_input_stream();
            int size = 0;
            try {
                size = in.available();
            }
            catch (IOException ex) {
                // empty catch block
            }
            profile[0].key_body = new byte[size];
            in.read_octet_array(profile[0].key_body, 0, size);
            out = this.orb.create_output_stream();
            key.profile = profile;
            KeyHelper.write(out, key);
            in = out.create_input_stream();
            try {
                size = in.available();
            }
            catch (IOException ex) {
                // empty catch block
            }
            byte[] k = new byte[size];
            in.read_octet_array(k, 0, size);
            return k;
        }
        return id;
    }

    protected boolean policy_system_key() {
        return this._key_assignment.value().value() == 1;
    }

    private byte[] getUUID() {
        return new byte[0];
    }

    public POAImpl(String name, POA parent, Listener protocol, POAManager manager, Policy[] policies) throws InvalidPolicy {
        if (Trace.level != 0) {
            Trace.NewInstance("POA");
        }
        this._parent = parent;
        this.plug = ORBSingleton.plug;
        this._child_poa = new Hashtable();
        this._aom = new Hashtable();
        this._ref_table = new Hashtable();
        this._refList = new Hashtable();
        this._request_queue = new Vector();
        this._name = name;
        if (manager == null) {
            if (Trace.level != 0) {
                Trace.Step("Create a new POA manager");
            }
            this._poa_manager = new POAManagerImpl();
        } else {
            this._poa_manager = (POAManagerImpl)manager;
        }
        this._oa_entry = protocol;
        this.rqAdapter = new RequestAdapter();
        this.scan_policies(policies);
        this.orb = ORBSingleton._orb;
        this._factory = this.orb.get_object_factory();
    }

    public POAImpl(String name, POA parent, POAManager manager) {
        if (Trace.level != 0) {
            Trace.NewInstance("POA, Constructor 2");
        }
        this._parent = parent;
        this.plug = ORBSingleton.plug;
        this._child_poa = new Hashtable();
        this._aom = new Hashtable();
        this._refList = new Hashtable();
        this._ref_table = new Hashtable();
        this._request_queue = new Vector();
        this._name = name;
        this.rqAdapter = new RequestAdapter();
        if (manager == null) {
            if (Trace.level != 0) {
                Trace.Step("Create a new POA manager");
            }
            this._poa_manager = new POAManagerImpl();
        } else {
            this._poa_manager = (POAManagerImpl)manager;
        }
        this.orb = ORBSingleton._orb;
        this._factory = this.orb.get_object_factory();
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        return new ThreadPolicyImpl(value);
    }

    protected org.omg.CORBA.portable.ObjectImpl convertToImpl(Object object) {
        return (org.omg.CORBA.portable.ObjectImpl)object;
    }

    public void activate_object_with_id(byte[] id, Servant p_servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        String id_str;
        if (Trace.level != 0) {
            Trace.Step("Activate an object with a user ID");
        }
        if (this.policy_non_retain()) {
            throw new WrongPolicy();
        }
        if (this.policy_unique_id() && this._aom.get(id_str = new String(id)) != null) {
            throw new ObjectAlreadyActive();
        }
        byte[] key = this.id_to_key(id);
        Object ref = this.create_new_reference(p_servant, key);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_id(p_servant._all_interfaces(null, null)[0]);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_key(key);
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_port(this._oa_entry._get_port());
        ((JavaORB.CORBA.portable.Delegate)this.convertToImpl(ref)._get_delegate())._set_host(this._oa_entry._get_host());
        this.addToReferenceList(p_servant, ref);
        ActiveObjectMapEntry new_entry = new ActiveObjectMapEntry();
        new_entry.oid = id;
        new_entry.serv = p_servant;
        this.orb.set_delegate(p_servant);
        ((Delegate)p_servant._get_delegate()).setPOA(this, p_servant);
        this._factory.connectObject(ref);
        this._aom.put(new String(id), new_entry);
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        byte[] key = ((JavaORB.CORBA.portable.Delegate)((org.omg.CORBA.portable.ObjectImpl)reference)._get_delegate())._get_key();
        return this.key_to_id(key);
    }

    private synchronized byte[] create_system_id(String sid) {
        sid = this.policy_transient() ? sid + ":" + this.timeStamp() : sid + ":" + this.instanceCount;
        byte[] id = sid.getBytes();
        ++this.instanceCount;
        return id;
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        return new ServantRetentionPolicyImpl(value);
    }

    public KeyAssignmentPolicy create_key_assignment_policy(KeyAssignmentPolicyValue value) {
        return new KeyAssignmentPolicyImpl(value);
    }

    private short find_index(int policy_type, Policy[] policies) {
        int i = 0;
        while (i < policies.length) {
            if (policies[i].policy_type() == policy_type) {
                return (short)i;
            }
            ++i;
        }
        return 9999;
    }

    public Object create_new_reference(Servant servant, byte[] key) {
        Object obj = (Object)this._ref_table.get(new String(key));
        if (obj != null) {
            return obj;
        }
        ObjectImpl ref = new ObjectImpl();
        JavaORB.CORBA.portable.Delegate _delegate = new JavaORB.CORBA.portable.Delegate();
        _delegate.localObject(true);
        ref._set_delegate(_delegate);
        if (servant != null) {
            ref.set_ids(servant._all_interfaces(null, null));
        }
        return ref;
    }

    public void applyPostInvoke(RequestBag rqB) {
        ((ServantLocator)this._srv_manager).postinvoke(rqB.oid, this, rqB.op, rqB.cookie.value, rqB.serv);
        ((Delegate)rqB.serv._get_delegate()).removePOA(rqB.serv);
    }

    protected boolean policy_use_manager() {
        return this._request_processing.value().value() == 2;
    }

    public Object create_reference(String intf) throws WrongPolicy {
        if (!this.policy_system_id()) {
            throw new WrongPolicy();
        }
        byte[] id = this.create_system_id(intf);
        byte[] key = this.id_to_key(id);
        org.omg.CORBA.portable.ObjectImpl ref = this.convertToImpl(this.create_new_reference(null, key));
        String[] list = new String[]{intf};
        ((ObjectImpl)ref).set_ids(list);
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_key(key);
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_port(this._oa_entry._get_port());
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_host(this._oa_entry._get_host());
        ((JavaORB.CORBA.portable.Delegate)ref._get_delegate())._set_id(intf);
        this._ref_table.put(new String(key), ref);
        return ref;
    }
}

