/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler;

import JavaORB.ReleaseInfo;
import JavaORB.compiler.JavaORBProperties;
import JavaORB.compiler.generator.IdlToJava2_3;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.parser.IdlParser;
import java.util.Vector;

public class IdlCompiler {
    public static Vector includeList = new Vector();
    public static Vector symboleDefined = new Vector();
    public static Vector importLink = new Vector();
    public static Vector nativeDefinition = new Vector();
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static boolean map_stub;
    public static boolean map_skeleton;
    public static boolean map_all;
    public static boolean map_tie;
    public static boolean map_user;
    public static boolean pidl;
    public static boolean map_poa;
    public static boolean verbose;
    public static String packageName;
    public static boolean use_package;
    public static boolean portable;
    public static boolean rpc;
    public static String outdir;
    public static boolean dynamic;
    public static boolean usePrefix;
    public static boolean silentMode;
    public static boolean displayBadFlag;

    public static void main(String[] args) {
        IdlParser Parser = null;
        IdlToJava2_3 toJava = null;
        String[] arguments = IdlCompiler.getArguments(args);
        if (args.length != 0) {
            IdlCompiler.analyse_arguments(arguments);
        } else {
            IdlCompiler.affiche_aide();
        }
        Parser = new IdlParser();
        if (!silentMode) {
            System.out.println("JavaORB / (c) 1997, 1998, 1999");
            System.out.println("IDL Compiler");
        }
        IdlObject CompilationGraph = null;
        int i = 0;
        while (i < idl_file_name.length) {
            System.out.println("Compile : " + idl_file_name[i]);
            CompilationGraph = Parser.compile_idl(idl_file_name[i]);
            ++i;
        }
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(0);
        }
        if (verbose) {
            System.out.println("Now translate to Java...");
        }
        toJava = new IdlToJava2_3();
        toJava.translateData(CompilationGraph, packageName);
        if (map_stub) {
            toJava.translateStub(CompilationGraph, packageName);
        }
        if (map_skeleton) {
            toJava.translateSkeleton(CompilationGraph, packageName);
        }
        if (map_tie) {
            toJava.translateTIE(CompilationGraph, packageName);
        }
        if (map_user) {
            toJava.translateUser(CompilationGraph, packageName);
        }
    }

    static {
        idl_file_name_list = new Vector();
        map_stub = true;
        map_skeleton = true;
        map_all = false;
        map_tie = false;
        map_user = false;
        pidl = false;
        map_poa = false;
        verbose = false;
        packageName = null;
        use_package = true;
        portable = true;
        rpc = false;
        outdir = null;
        dynamic = false;
        usePrefix = true;
        silentMode = false;
        displayBadFlag = true;
    }

    public static void analyse_arguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') {
                idl_file_name_list.addElement(args[i]);
            } else if (args[i].equals("-release")) {
                System.out.println(ReleaseInfo.release);
                System.exit(0);
            } else if (args[i].equals("-h")) {
                IdlCompiler.affiche_aide();
            } else if (args[i].equals("-silence")) {
                silentMode = true;
            } else if (args[i].equals("-help")) {
                IdlCompiler.affiche_aide();
            } else if (args[i].equals("-verbose")) {
                verbose = true;
            } else if (args[i].equals("-noprefix")) {
                usePrefix = false;
            } else if (args[i].equals("-nostub")) {
                map_stub = false;
            } else if (args[i].equals("-noskeleton")) {
                map_skeleton = false;
            } else if (args[i].equals("-tie")) {
                map_tie = true;
            } else if (args[i].equals("-rpc")) {
                rpc = true;
            } else if (args[i].equals("-nopackage")) {
                use_package = false;
            } else if (args[i].equals("-poa")) {
                map_poa = true;
            } else if (args[i].equals("-dynamic")) {
                dynamic = true;
            } else if (args[i].equals("-user")) {
                map_user = true;
            } else if (args[i].equals("-all")) {
                map_all = true;
            } else if (args[i].equals("-pidl")) {
                pidl = true;
                map_stub = false;
                map_skeleton = false;
            } else if (args[i].startsWith("-package:")) {
                try {
                    packageName = args[i].substring(9, args[i].length());
                    use_package = false;
                }
                catch (StringIndexOutOfBoundsException ex) {
                    // empty catch block
                }
                if (packageName.equals("")) {
                    System.out.println("Package name cannot be empty...");
                    System.exit(0);
                }
            } else if (args[i].startsWith("-importlink:")) {
                try {
                    importLink.addElement(args[i].substring(12, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-outdir:")) {
                try {
                    outdir = args[i].substring(8, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {
                    // empty catch block
                }
                if (packageName == null) {
                    packageName = "";
                    use_package = false;
                }
            } else if (args[i].startsWith("-I")) {
                try {
                    includeList.addElement(args[i].substring(2, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-D")) {
                try {
                    symboleDefined.addElement(args[i].substring(2, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-native:")) {
                try {
                    nativeDefinition.addElement(args[i].substring(8, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (displayBadFlag) {
                System.out.println("Bad parameter");
                System.out.println("Please, use no flag to display all compiler option flags");
                System.exit(0);
            }
            ++i;
        }
        if (packageName == null) {
            packageName = new String("corba_pkg");
        }
        idl_file_name = new String[idl_file_name_list.size()];
        i = 0;
        while (i < idl_file_name_list.size()) {
            IdlCompiler.idl_file_name[i] = (String)idl_file_name_list.elementAt(i);
            ++i;
        }
    }

    public static String[] getArguments(String[] command_line_args) {
        int last_index;
        String sub;
        int index;
        Vector<String> list;
        String[] args = null;
        String[] config_args = new String[]{};
        JavaORBProperties props = new JavaORBProperties();
        String p = props.getORBProperty("COMPILER.ImportList");
        if (p != null) {
            list = new Vector<String>();
            index = -1;
            sub = null;
            while ((index = p.indexOf(",", last_index = index + 1)) != -1) {
                sub = p.substring(last_index, index);
                list.addElement("-importlink:" + sub);
            }
            list.addElement("-importlink:" + p.substring(last_index, p.length()));
            config_args = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                config_args[i] = (String)list.elementAt(i);
                ++i;
            }
        }
        if ((p = props.getORBProperty("COMPILER.DefaultFlags")) != null) {
            list = new Vector();
            index = -1;
            sub = null;
            while ((index = p.indexOf(" ", last_index = index + 1)) != -1) {
                sub = p.substring(last_index, index);
                list.addElement(sub);
            }
            list.addElement(p.substring(last_index, p.length()));
            String[] tmp_args = new String[config_args.length + list.size()];
            System.arraycopy(config_args, 0, tmp_args, 0, config_args.length);
            int i = 0;
            while (i < list.size()) {
                tmp_args[i + config_args.length] = (String)list.elementAt(i);
                ++i;
            }
            config_args = tmp_args;
        }
        args = new String[command_line_args.length + config_args.length];
        System.arraycopy(config_args, 0, args, 0, config_args.length);
        System.arraycopy(command_line_args, 0, args, config_args.length, command_line_args.length);
        return args;
    }

    public static void affiche_aide() {
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################");
        System.out.println("#                     Java ORB                  #");
        System.out.println("#                -----------------              #");
        System.out.println("#              (c) 1997, 1998, 1999             #");
        System.out.println("#################################################");
        System.out.println("# Java IDL Compiler, Release 2.0                #");
        System.out.println("#################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number");
        System.out.println("\t-nopackage");
        System.out.println("\t\tDon't use corba_pkg directory as a package");
        System.out.println("\t-outdir:");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the corba_pkg directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t\tidl demo.idl -outdir:/home/me/");
        System.out.println("\t-package: package_name");
        System.out.println("\t\tGenerate files in package_name");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl demo.idl -package:exemple");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  idl demo.idl -I/home/me/idl -I../autre");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbole. It is equivalent to #define");
        System.out.println("\t-nostub");
        System.out.println("\t\tDon't generate stub.");
        System.out.println("\t-noskeleton");
        System.out.println("\t\tDon't generate skeleton.");
        System.out.println("\t-tie");
        System.out.println("\t\tGenerate TIE files to delegation mode.");
        System.out.println("\t-user");
        System.out.println("\t\tGenerate code for user");
        System.out.println("\t-pidl");
        System.out.println("\t\tConsider the IDL file as PIDL description. It generates");
        System.out.println("\t\tmapping but no stub, no skeleton.");
        System.out.println("\t-native: native name : native mapping ");
        System.out.println("\t\tDefine native type mapping.");
        System.out.println("\t\tFor example : ");
        System.out.println("\t\t\tidl\tdemo.idl -native:cookie:java.lang.Object");
        System.out.println("\t\t\tthis command implies the mapping of");
        System.out.println("\t\t\tcookie in java.lang.Object.");
        System.out.println("\t-poa");
        System.out.println("\t\tGenerate skeleton for POA");
        System.out.println("\t-dynamic");
        System.out.println("\t\tGenerate stub with DII and skeleton with DSI");
        System.out.println("\t\t( portable way before CORBA 2.3 )");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate mapping for included files.");
        System.out.println("\t-noprefix");
        System.out.println("\t\tDon't generate repository for prefixes.");
        System.out.println("");
        System.out.println("");
        System.exit(0);
    }
}

