/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class JavaORBProperties {
    private Properties ORB_props = new Properties();

    public JavaORBProperties() {
        this.loadConfigurationFile();
    }

    private void loadConfigurationFile() {
        FileInputStream input = this.openFile("JavaORB.cfg");
        String pname = null;
        if (input != null) {
            try {
                if (this.ORB_props == null) {
                    this.ORB_props = new Properties();
                    this.ORB_props.load(input);
                } else {
                    Properties tmp = new Properties();
                    tmp.load(input);
                    Enumeration<?> enumeration = tmp.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        pname = (String)enumeration.nextElement();
                        ((Hashtable)this.ORB_props).put(pname, tmp.getProperty(pname));
                    }
                }
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getORBProperty(String property_name) {
        if (this.ORB_props != null) {
            return this.ORB_props.getProperty(property_name);
        }
        return null;
    }

    private FileInputStream openFileFrom(String directory, String file_name) {
        FileInputStream input = null;
        String path = directory;
        if (!path.equals("") && !directory.endsWith(File.separator)) {
            path = directory + File.separator;
        }
        path = path + file_name;
        try {
            input = new FileInputStream(path);
        }
        catch (IOException ex) {
            return null;
        }
        return input;
    }

    public FileInputStream openFile(String file_name) {
        FileInputStream input = null;
        String s = System.getProperty("JAVA_ORB_DIR");
        if (s != null) {
            input = this.openFileFrom(s, file_name);
        }
        if (input != null) {
            return input;
        }
        input = this.openFileFrom("", file_name);
        if (input != null) {
            return input;
        }
        s = System.getProperty("user.home");
        if (s != null) {
            input = this.openFileFrom(s, file_name);
        }
        if (input != null) {
            return input;
        }
        s = System.getProperty("java.home");
        if (s != null) {
            input = this.openFileFrom(s, file_name);
        }
        if (input != null) {
            return input;
        }
        return null;
    }
}

