/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler.doc;

import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.doc.html.IdlToHTML;
import JavaORB.compiler.doc.rtf.IdlToRTF;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.parser.IdlParser;
import java.util.Vector;

public class IdlDoc {
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static final String Release = "JavaORB version 2.0";
    public static String packageName;
    public static boolean use_package;
    public static String outdir;
    public static boolean stylesheet;
    public static boolean htmlDoc;
    public static String title;
    public static String header;
    public static String footer;
    public static String filename;
    public static boolean usePrefix;

    public static void main(String[] args) {
        IdlParser Parser = null;
        idl_file_name_list = new Vector();
        if (args.length != 0) {
            IdlDoc.analyse_arguments(args);
        } else {
            IdlDoc.affiche_aide();
        }
        IdlCompiler.idl_file_name = idl_file_name;
        if (idl_file_name.length == 0) {
            IdlDoc.affiche_aide();
        }
        Parser = new IdlParser();
        IdlCompiler.verbose = true;
        System.out.println("JavaORB, Doc generator");
        System.out.println("(c) 1999, Distributed Object Group");
        System.out.println("Developped by Jerome DANIEL.\n");
        IdlObject CompilationGraph = null;
        int i = 0;
        while (i < idl_file_name.length) {
            CompilationGraph = Parser.compile_idl(idl_file_name[i]);
            ++i;
        }
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(0);
        }
        if (htmlDoc) {
            System.out.println("IDL To HTML");
            IdlToHTML toHTML = new IdlToHTML();
            toHTML.translateToHTML(CompilationGraph, title, packageName);
        } else {
            System.out.println("IDL To RTF");
            IdlToRTF toRTF = new IdlToRTF();
            if (filename == null) {
                System.out.println("IDL to RTF fatal error : you must specify an file name for the RTF documentation with '-docname:' flag.");
                System.exit(0);
            }
            toRTF.translateToRTF(CompilationGraph, filename, title, header, footer);
        }
    }

    static {
        packageName = null;
        use_package = true;
        outdir = null;
        stylesheet = false;
        htmlDoc = false;
        title = "IDL Documentation";
        header = "";
        footer = "";
        filename = "";
        usePrefix = true;
    }

    public static void analyse_arguments(String[] args) {
        IdlCompiler.includeList = new Vector();
        IdlCompiler.symboleDefined = new Vector();
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') {
                idl_file_name_list.addElement(args[i]);
            } else if (args[i].equals("-release")) {
                System.out.println(Release);
                System.exit(0);
            } else if (args[i].equals("-h")) {
                IdlDoc.affiche_aide();
            } else if (args[i].equals("-html")) {
                htmlDoc = true;
            } else if (args[i].equals("-help")) {
                IdlDoc.affiche_aide();
            } else if (args[i].equals("-nopackage")) {
                use_package = false;
            } else if (args[i].equals("-noprefix")) {
                usePrefix = false;
            } else if (args[i].equals("-stylesheet")) {
                stylesheet = true;
            } else if (args[i].equals("-all")) {
                IdlCompiler.map_all = true;
            } else if (args[i].startsWith("-package:")) {
                try {
                    packageName = args[i].substring(9, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {
                    // empty catch block
                }
                if (packageName.equals("")) {
                    System.out.println("Package name cannot be empty...");
                    System.exit(0);
                }
            } else if (args[i].startsWith("-title:")) {
                try {
                    title = args[i].substring(7, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-header:")) {
                try {
                    header = args[i].substring(7, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-footer:")) {
                try {
                    footer = args[i].substring(7, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-docname:")) {
                try {
                    filename = args[i].substring(9, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-outdir:")) {
                try {
                    outdir = args[i].substring(8, args[i].length());
                }
                catch (StringIndexOutOfBoundsException ex) {
                    // empty catch block
                }
                if (packageName == null) {
                    packageName = "";
                    use_package = false;
                }
            } else if (args[i].startsWith("-I")) {
                try {
                    IdlCompiler.includeList.addElement(args[i].substring(2, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException ex) {}
            } else if (args[i].startsWith("-D")) {
                try {
                    IdlCompiler.symboleDefined.addElement(args[i].substring(2, args[i].length()));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else {
                System.out.println("Bad parameter");
                System.out.println("Please, use no flag to display all compiler option flags");
                System.exit(0);
            }
            ++i;
        }
        if (packageName == null) {
            packageName = new String("corba_pkg");
        }
        IdlCompiler.packageName = packageName;
        idl_file_name = new String[idl_file_name_list.size()];
        i = 0;
        while (i < idl_file_name_list.size()) {
            IdlDoc.idl_file_name[i] = (String)idl_file_name_list.elementAt(i);
            ++i;
        }
    }

    public static void affiche_aide() {
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################");
        System.out.println("#                     Java ORB                  #");
        System.out.println("#                -----------------              #");
        System.out.println("#              (c) 1997, 1998, 1999             #");
        System.out.println("#################################################");
        System.out.println("# Java Doc Compiler, Release 1.0                #");
        System.out.println("#################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number");
        System.out.println("\t-outdir:");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the corba_pkg directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t\tidl2doc demo.idl -outdir:/home/me/");
        System.out.println("\t-package: package_name");
        System.out.println("\t\tGenerate files in package_name");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl demo.idl -package:exemple");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  idl demo.idl -I/home/me/idl -I../autre");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbole. It is equivalent to #define");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate documentation for included files.");
        System.out.println("\t-stylesheet ( for HTML documentation only )");
        System.out.println("\t\tGenerate a style sheet for HTML documentation.");
        System.out.println("\t-title:");
        System.out.println("\t\tSet the documentation title.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl2html demo.idl \"-title:My Doc Title\"");
        System.out.println("\t-noprefix");
        System.out.println("\t\t\tDisable usage of prefix for package name.");
        System.out.println("\t-header ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation header.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl2rtf demo.idl \"-header:My Doc header\"");
        System.out.println("\t-footer ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation footer.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl2rtf demo.idl \"-footer:My Doc footer\"");
        System.out.println("\t-docname:");
        System.out.println("\t\tSet the documentation file name for RTF documentation.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t\tidl2rtf demo.idl -docname:mydoc.rtf");
        System.out.println("");
        System.out.println("");
        System.exit(0);
    }
}

