/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler.generator;

import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.object.IdlArray;
import JavaORB.compiler.object.IdlAttribute;
import JavaORB.compiler.object.IdlComment;
import JavaORB.compiler.object.IdlCommentSection;
import JavaORB.compiler.object.IdlConst;
import JavaORB.compiler.object.IdlContext;
import JavaORB.compiler.object.IdlEnumMember;
import JavaORB.compiler.object.IdlFactoryMember;
import JavaORB.compiler.object.IdlFixed;
import JavaORB.compiler.object.IdlIdent;
import JavaORB.compiler.object.IdlInterface;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.object.IdlOp;
import JavaORB.compiler.object.IdlParam;
import JavaORB.compiler.object.IdlRaises;
import JavaORB.compiler.object.IdlSequence;
import JavaORB.compiler.object.IdlSimple;
import JavaORB.compiler.object.IdlStateMember;
import JavaORB.compiler.object.IdlString;
import JavaORB.compiler.object.IdlStructMember;
import JavaORB.compiler.object.IdlUnion;
import JavaORB.compiler.object.IdlUnionMember;
import JavaORB.compiler.object.IdlValue;
import JavaORB.compiler.object.IdlValueBox;
import JavaORB.compiler.object.IdlValueInheritance;
import JavaORB.compiler.object.IdlWString;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class IdlToJava2_3 {
    private String sep;
    public String current_pkg = IdlCompiler.packageName;
    public IdlObject _root = null;
    private File initial = null;

    public boolean isAbstractBaseInterface(IdlObject obj) {
        IdlInterface itf = (IdlInterface)obj;
        Vector base = itf.getInheritance();
        int i = 0;
        while (i < base.size()) {
            if (((IdlInterface)base.elementAt(i)).abstract_interface()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < base.size()) {
            if (this.isAbstractBaseInterface((IdlInterface)base.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEmptyInterface(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    private String initialName(String name) {
        if (name.startsWith("_")) {
            return name.substring(1, name.length());
        }
        return name;
    }

    public void translate_user_module(IdlObject obj, File writeInto) {
        if (obj.getPrefix() != null) {
            writeInto = this.getPrefixDirectories(obj.getPrefix(), writeInto);
        }
        File intoModule = this.getDirectory(obj.name(), writeInto);
        String old_pkg = this.current_pkg;
        if (obj.getPrefix() != null) {
            this.addToPkg(obj, this.inversedPrefix(obj.getPrefix()) + "." + obj.name());
        } else {
            this.addToPkg(obj, obj.name());
        }
        this.translate_user_object(obj, intoModule);
        this.current_pkg = old_pkg;
    }

    public boolean isHexaCar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public void translate_struct(IdlObject obj, File writeInto) {
        IdlStructMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        this.cartouche(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                    break;
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("\t//");
            output.println("\t// Struct member " + member_obj.name());
            output.println("\t//");
            output.print("\tpublic ");
            member_obj.reset();
            this.translate_type(member_obj.current(), output);
            output.println(" " + member_obj.name() + ";");
            output.println("");
            obj.next();
        }
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "()");
        output.println("\t{ }");
        output.println("");
        output.println("\t//");
        output.println("\t// Constructor with fields initialization");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("\t// @param\t" + member_obj.name() + "\t" + member_obj.name() + " struct member");
            obj.next();
        }
        output.println("\t//");
        output.print("\tpublic " + obj.name() + "( ");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            this.translate_type(member_obj.current(), output);
            output.print(" " + member_obj.name());
            obj.next();
            if (obj.end()) continue;
            output.print(", ");
        }
        output.println(" )");
        output.println("\t{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("\t\tthis." + member_obj.name() + " = " + member_obj.name() + ";");
            obj.next();
        }
        output.println("\t}");
        output.println("");
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_exception(IdlObject obj, File writeInto) {
        IdlStructMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        this.cartouche(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                    break;
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " extends org.omg.CORBA.UserException");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("\t//");
            output.println("\t// Exception member " + member_obj.name());
            output.println("\t//");
            output.print("\tpublic ");
            member_obj.reset();
            this.translate_type(member_obj.current(), output);
            output.println(" " + member_obj.name() + ";");
            output.println("");
            obj.next();
        }
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "()");
        output.println("\t{");
        output.println("\t\tsuper( " + obj.name() + "Helper.id() );");
        output.println("\t}");
        output.println("");
        if (obj.length() != 0) {
            output.println("\t//");
            output.println("\t// Constructor with fields initialization");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("\t// @param\t" + member_obj.name() + "\t" + member_obj.name() + " exception member");
                obj.next();
            }
            output.println("\t//");
            output.print("\tpublic " + obj.name() + "( ");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                this.translate_type(member_obj.current(), output);
                output.print(" " + member_obj.name());
                obj.next();
                if (obj.end()) continue;
                output.print(", ");
            }
            output.println(" )");
            output.println("\t{");
            output.println("\t\tsuper( " + obj.name() + "Helper.id() );");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("\t\tthis." + member_obj.name() + " = " + member_obj.name() + ";");
                obj.next();
            }
            output.println("\t}");
            output.println("");
        }
        if (obj.length() != 0) {
            output.println("\t//");
            output.println("\t// Full constructor with fields initialization");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("\t// @param\t" + member_obj.name() + "\t" + member_obj.name() + " exception member");
                obj.next();
            }
            output.println("\t//");
            output.print("\tpublic " + obj.name() + "( String javaorb_reason");
            obj.reset();
            while (!obj.end()) {
                output.print(", ");
                member_obj = (IdlStructMember)obj.current();
                this.translate_type(member_obj.current(), output);
                output.print(" " + member_obj.name());
                obj.next();
            }
            output.println(" )");
            output.println("\t{");
            output.println("\t\tsuper( javaorb_reason );");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("\t\tthis." + member_obj.name() + " = " + member_obj.name() + ";");
                obj.next();
            }
            output.println("\t}");
            output.println("");
        }
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_user_operation(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        output.println("\t//");
        output.println("\t// Operation " + obj.name());
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("\t{");
        output.println("\t\t//TODO: put your code here");
        output.println("\t}");
        output.println("");
    }

    protected Vector getInheritanceOpList(IdlObject obj, Vector opList) {
        Vector list = ((IdlInterface)obj).getInheritance();
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: 
                case 17: {
                    if (this.isInto(opList, obj.current().name())) break;
                    opList.addElement(obj.current());
                    break;
                }
            }
            obj.next();
        }
        int i = 0;
        while (i < list.size()) {
            IdlInterface itf = (IdlInterface)list.elementAt(i);
            if (itf.kind() == 18) {
                itf = itf.getInterface();
            }
            opList = this.getInheritanceOpList(itf, opList);
            ++i;
        }
        return opList;
    }

    public void translate_object(IdlObject obj, File writeInto, int translateType) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                this.translate_object_content(obj, writeInto, translateType);
            }
            obj.next();
        }
    }

    public void translateSkeleton(IdlObject obj, String packageName) {
        this._root = obj;
        File first = null;
        if (IdlCompiler.outdir != null) {
            first = new File(IdlCompiler.outdir);
        }
        File writeInto = this.getDirectory(packageName, first);
        this.translate_object(obj, writeInto, 2);
    }

    public int final_kind(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.final_kind(((IdlIdent)obj).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_kind(obj.current());
            }
        }
        return obj.kind();
    }

    public void translate_interface_stub(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(writeInto, "_" + obj.name() + "Stub");
        Vector list = new Vector();
        list = this.getInheritanceList(obj, list);
        this.cartouche(output, obj);
        output.println("public class _" + obj.name() + "Stub extends org.omg.CORBA.portable.ObjectImpl");
        output.print("\t\timplements " + obj.name());
        if (IdlCompiler.rpc) {
            output.print(", JavaORB.RpcObject");
        }
        output.println("");
        output.println("{");
        Vector intoList = this.getInheritanceOpList(obj, new Vector());
        if (IdlCompiler.rpc) {
            output.println("\tstatic java.util.Hashtable _operations;");
            output.println("");
            output.println("\tstatic");
            output.println("\t{");
            output.println("\t\t_operations = new java.util.Hashtable();");
            if (list.size() != 0) {
                int j = 0;
                String ex = new String("");
                int i = 0;
                while (i < intoList.size()) {
                    IdlObject ob = (IdlObject)intoList.elementAt(i);
                    if (!ex.equals(ob.upper().getId())) {
                        j = 0;
                        ex = ob.upper().getId();
                    }
                    switch (ob.kind()) {
                        case 16: {
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + j + "\", \"" + ob.name() + "\");");
                            break;
                        }
                        case 17: {
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + j + "\", \"_get_" + ob.name() + "\");");
                            if (((IdlAttribute)ob).readOnly()) break;
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + ++j + "\", \"_set_" + ob.name() + "\");");
                            break;
                        }
                    }
                    ++j;
                    ++i;
                }
            }
            output.println("");
            output.println("\t}");
            output.println("");
            output.println("\tpublic java.util.Hashtable _ops()");
            output.println("\t{");
            output.println("\t\treturn _operations;");
            output.println("\t}");
            output.println("");
        }
        output.println("\tstatic final String[] _ids_list =");
        output.println("\t{");
        if (list.size() != 0) {
            int i = 0;
            while (i < list.size()) {
                output.print("\t\t\"" + (String)list.elementAt(i) + "\"");
                if (i + 1 < list.size()) {
                    output.println(", ");
                }
                ++i;
            }
        }
        output.println("");
        output.println("\t};");
        output.println("");
        output.println("\tpublic String[] _ids()");
        output.println("\t{");
        output.println("\t\treturn _ids_list;");
        output.println("\t}");
        output.println("");
        boolean doIt = true;
        if (((IdlInterface)obj).abstract_interface()) {
            doIt = false;
        }
        if (!IdlCompiler.dynamic && IdlCompiler.map_poa && doIt) {
            output.println("\tfinal public static java.lang.Class _opsClass = " + this.fullname(obj) + "Operations.class;");
            output.println("");
        }
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        int i = 0;
        while (i < intoList.size()) {
            switch (((IdlObject)intoList.elementAt(i)).kind()) {
                case 16: {
                    if (IdlCompiler.dynamic) {
                        this.translate_operation_stub((IdlObject)intoList.elementAt(i), output);
                        break;
                    }
                    this.translate_operation_stub_stream((IdlObject)intoList.elementAt(i), output);
                    break;
                }
                case 17: {
                    if (IdlCompiler.dynamic) {
                        this.translate_attribute_stub((IdlObject)intoList.elementAt(i), output);
                        break;
                    }
                    this.translate_attribute_stub_stream((IdlObject)intoList.elementAt(i), output);
                    break;
                }
            }
            ++i;
        }
        output.println("}");
        output.close();
        this.current_pkg = old_pkg;
    }

    public void translate_marshalling_member(IdlObject obj, PrintWriter output, String outname, String tname, String space) {
        IdlSimple simple = null;
        String array_name = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println(space + "org.omg.CORBA.portable.ValueBaseHelper.write(" + outname + ",(org.omg.CORBA.portable.ValueBase)" + tname + ");");
                    return;
                }
                output.print(space + outname + ".write");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float(" + tname + ");");
                        break block0;
                    }
                    case 30: {
                        output.println("_double(" + tname + ");");
                        break block0;
                    }
                    case 47: {
                        output.println("_short(" + tname + ");");
                        break block0;
                    }
                    case 66: {
                        output.println("_ushort(" + tname + ");");
                        break block0;
                    }
                    case 38: {
                        output.println("_long(" + tname + ");");
                        break block0;
                    }
                    case 65: {
                        output.println("_ulong(" + tname + ");");
                        break block0;
                    }
                    case 73: {
                        output.println("_longlong(" + tname + ");");
                        break block0;
                    }
                    case 74: {
                        output.println("_ulonglong(" + tname + ");");
                        break block0;
                    }
                    case 26: {
                        output.println("_char(" + tname + ");");
                        break block0;
                    }
                    case 71: {
                        output.println("_wchar(" + tname + ");");
                        break block0;
                    }
                    case 24: {
                        output.println("_boolean(" + tname + ");");
                        break block0;
                    }
                    case 41: {
                        output.println("_octet(" + tname + ");");
                        break block0;
                    }
                    case 22: {
                        output.println("_any(" + tname + ");");
                        break block0;
                    }
                    case 70: {
                        output.println("_TypeCode(" + tname + ");");
                        break block0;
                    }
                    case 40: {
                        output.println("_Object(" + tname + ");");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.println(space + outname + ".write_fixed(" + tname + ");");
                break;
            }
            case 5: {
                output.println(space + outname + ".write_string(" + tname + ");");
                break;
            }
            case 6: {
                output.println(space + outname + ".write_wstring(" + tname + ");");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(space + this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 13: {
                output.print(space + this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 24: {
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    int val = space.length() - 1;
                    output.println(space + "if ( " + tname + ".length != " + ((IdlArray)obj).getDimension() + " ) ");
                    output.println(space + "   throw new org.omg.CORBA.MARSHAL();");
                    output.println(space + "for ( int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + "{");
                    this.translate_marshalling_member(obj.current(), output, outname, tname + "[i" + val + "]", space + "\t");
                    output.println("");
                    output.println(space + "}");
                    break;
                }
                output.println(space + outname + ".write_" + array_name + "_array(" + tname + ", 0," + tname + ".length);");
                break;
            }
            case 9: {
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    int val = space.length() - 1;
                    output.println(space + outname + ".write_ulong(" + tname + ".length);");
                    output.println(space + "for ( int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + "{");
                    this.translate_marshalling_member(obj.current(), output, outname, tname + "[i" + val + "]", space + "\t");
                    output.println("");
                    output.println(space + "}");
                    break;
                }
                output.println(space + outname + ".write_ulong(" + tname + ".length);");
                output.println(space + outname + ".write_" + array_name + "_array(" + tname + ", 0," + tname + ".length);");
                break;
            }
            case 10: {
                this.translate_marshalling_member(((IdlIdent)obj).internalObject(), output, outname, tname, space);
                break;
            }
        }
    }

    public void write_helper(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(writeInto, obj.name() + "Helper");
        boolean real_corba_object = false;
        boolean abstract_object = false;
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("corba_pkg")) {
                if (IdlCompiler.use_package) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("//");
        output.println("// Helper class for : " + obj.name());
        output.println("//");
        output.println("// @author JavaORB Compiler");
        output.println("//");
        if (obj.kind() == 27) {
            output.println("public class " + obj.name() + "Helper implements org.omg.CORBA.portable.BoxedValueHelper");
        } else {
            output.println("public class " + obj.name() + "Helper");
        }
        output.println("{");
        output.println("\t//");
        output.println("\t// Insert " + obj.name() + " into an any");
        output.println("\t// param\ta an any");
        output.println("\t// param\tt " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic static void insert( org.omg.CORBA.Any a, ");
        this.translate_type(obj, output);
        output.println(" t )");
        output.println("\t{");
        if (obj.kind() == 28) {
            if (((IdlValue)obj).abstract_value() || ((IdlValue)obj).custom_value()) {
                output.println("\t\ta.type( type() );");
            } else {
                output.println("\t\ta.type( ((org.omg.CORBA.portable.StreamableValue)t)._type() );");
            }
        } else {
            output.println("\t\ta.type( type() );");
        }
        output.println("\t\twrite(a.create_output_stream(),t);");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Extract " + obj.name() + " from an any");
        output.println("\t// @param\ta an any");
        output.println("\t// @return the extracted " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic static ");
        this.translate_type(obj, output);
        output.println(" extract( org.omg.CORBA.Any a )");
        output.println("\t{");
        output.println("\t\tif ( !a.type().equal( type() ) )");
        output.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        output.println("\t\treturn read(a.create_input_stream());");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Internal TypeCode value");
        output.println("\t//");
        output.println("\tprivate static org.omg.CORBA.TypeCode _tc = null;");
        output.println("\tprivate static boolean _working = false;");
        output.println("");
        output.println("\t//");
        output.println("\t// Return the " + obj.name() + " TypeCode");
        output.println("\t// @return a TypeCode");
        output.println("\t//");
        output.println("\tpublic static org.omg.CORBA.TypeCode type()");
        output.println("\t{");
        output.println("\t\tif ( _tc != null )");
        output.println("\t\t\treturn _tc;");
        output.println("\t\telse");
        output.println("\t\t{");
        output.println("\t\t  synchronized(org.omg.CORBA.TypeCode.class)");
        output.println("\t\t  {");
        output.println("\t\t\tif ( _working )");
        output.println("\t\t\t\treturn org.omg.CORBA.ORB.init().create_recursive_tc( id() );");
        output.println("\t\t\t_working = true;");
        this.translate_new_typecode(obj, output);
        output.println("\t\t  }");
        output.println("\t\t}");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Return the " + obj.name() + " IDL ID");
        output.println("\t// @return an ID");
        output.println("\t//");
        output.println("\tpublic static String id()");
        output.println("\t{");
        output.println("\t\treturn _id;");
        output.println("\t}");
        output.println("");
        output.println("\tprivate final static String _id = new String(\"" + obj.getId() + "\");");
        output.println("");
        output.println("\t//");
        output.println("\t// Read " + obj.name() + " from a marshalled stream");
        output.println("\t// @param\tistream the input stream");
        output.println("\t// @return the readed " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic static ");
        this.translate_type(obj, output);
        output.println(" read( org.omg.CORBA.portable.InputStream istream )");
        output.println("\t{");
        if (obj.kind() == 27) {
            output.print("\t\treturn ( ");
            this.translate_type(obj, output);
            output.println(" ) ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value( new " + obj.name() + "Helper() );");
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface() || IdlCompiler.pidl) {
                output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_unmarshalling(obj, output, "istream");
            }
        } else {
            this.translate_unmarshalling(obj, output, "istream");
        }
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Write " + obj.name() + " into a marshalled stream");
        output.println("\t// @param\tostream the output stream");
        output.println("\t// @param\tvalue " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic static void write( org.omg.CORBA.portable.OutputStream ostream, ");
        this.translate_type(obj, output);
        output.println(" value )");
        output.println("\t{");
        if (obj.kind() == 27) {
            output.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value( value, new " + obj.name() + "Helper() );");
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface() || IdlCompiler.pidl) {
                output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_marshalling(obj, output, "ostream", "value");
            }
        } else {
            this.translate_marshalling(obj, output, "ostream", "value");
        }
        output.println("\t}");
        output.println("");
        if (obj.kind() == 15) {
            if (((IdlInterface)obj).abstract_interface()) {
                abstract_object = true;
            } else {
                real_corba_object = true;
            }
            if (this.isAbstractBaseInterface(obj)) {
                abstract_object = true;
            }
            if (abstract_object) {
                output.println("\t//");
                output.println("\t// Narrow CORBA::Object to " + obj.name());
                output.println("\t// @param\tobj the abstract Object");
                output.println("\t// @return " + obj.name() + " Object");
                output.println("\t//");
                output.println("\tpublic static " + obj.name() + " narrow( java.lang.Object obj )");
                output.println("\t{");
                output.println("\t\ttry");
                output.println("\t\t{");
                output.println("\t\t\treturn ( " + obj.name() + ")obj;");
                output.println("\t\t}");
                output.println("\t\tcatch ( ClassCastException ex )");
                output.println("\t\t{");
                output.println("\t\t}");
                output.println("");
                output.println("\t\tthrow new org.omg.CORBA.BAD_PARAM();");
                output.println("\t}");
                output.println("");
            }
            if (real_corba_object) {
                output.println("\t//");
                output.println("\t// Narrow CORBA::Object to " + obj.name());
                output.println("\t// @param\tobj the CORBA Object");
                output.println("\t// @return " + obj.name() + " Object");
                output.println("\t//");
                if (!IdlCompiler.pidl) {
                    output.println("\tpublic static " + obj.name() + " narrow( org.omg.CORBA.Object obj )");
                } else {
                    output.println("\tpublic static " + obj.name() + " narrow( java.lang.Object obj )");
                }
                output.println("\t{");
                output.println("\t\tif ( obj == null )");
                output.println("\t\t   return null;");
                output.println("");
                if (IdlCompiler.pidl) {
                    output.println("\t\ttry");
                    output.println("\t\t{");
                    output.println("\t\t\torg.omg.CORBA.portable.ObjectImpl o = ( org.omg.CORBA.portable.ObjectImpl )obj;");
                    output.println("\t\t\treturn ( " + obj.name() + " )((JavaORB.CORBA.portable.Delegate)(o._get_delegate())).getOpaque();");
                    output.println("\t\t}");
                    output.println("\t\tcatch ( ClassCastException ex )");
                    output.println("\t\t{");
                    output.println("\t\t}");
                    output.println("");
                }
                output.println("\t\ttry");
                output.println("\t\t{");
                output.println("\t\t\treturn ( " + obj.name() + ")obj;");
                output.println("\t\t}");
                output.println("\t\tcatch ( ClassCastException ex )");
                output.println("\t\t{");
                output.println("\t\t}");
                output.println("");
                if (!IdlCompiler.pidl && !((IdlInterface)obj).local_interface()) {
                    output.println("\t\tif ( obj._is_a( id() ) )");
                    output.println("\t\t{");
                    output.println("\t\t\t_" + obj.name() + "Stub stub = new _" + obj.name() + "Stub();");
                    output.println("\t\t\tstub._set_delegate( ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate() );");
                    output.println("\t\t\treturn stub;");
                    output.println("\t\t}");
                    output.println("");
                }
                output.println("\t\tthrow new org.omg.CORBA.BAD_PARAM();");
                output.println("\t}");
                output.println("");
            }
        }
        if (obj.kind() == 28 && !((IdlValue)obj).abstract_value()) {
            obj.reset();
            while (!obj.end()) {
                if (obj.current().kind() == 30) {
                    IdlFactoryMember member;
                    output.println("\t//");
                    output.println("\t// Create a value type ( by its factory way )");
                    output.println("\t//");
                    output.print("\tpublic static " + obj.name() + " " + obj.name() + "( ");
                    output.print("org.omg.CORBA.ORB orb");
                    obj.current().reset();
                    while (!obj.current().end()) {
                        output.print(", ");
                        member = (IdlFactoryMember)obj.current().current();
                        member.reset();
                        this.translate_type(member.current(), output);
                        output.print(" " + member.name());
                        obj.current().next();
                    }
                    output.println(" )");
                    output.println("\t{");
                    output.println("\t\torg.omg.CORBA.portable.ValueFactory _factory = ((org.omg.CORBA_2_3.ORB)orb).lookup_value_factory(id());");
                    output.println("\t\tif ( _factory == null )");
                    output.println("\t\t\tthrow new org.omg.CORBA.BAD_INV_ORDER();");
                    output.print("\t\treturn ((" + this.fullname(obj) + "ValueFactory)(_factory))." + obj.current().name() + "(");
                    obj.current().reset();
                    while (!obj.current().end()) {
                        member = (IdlFactoryMember)obj.current().current();
                        member.reset();
                        output.print(" " + member.name());
                        obj.current().next();
                        if (obj.current().end()) continue;
                        output.print(", ");
                    }
                    output.println(" );");
                    output.println("\t}");
                    output.println("");
                }
                obj.next();
            }
        }
        if (obj.kind() == 27) {
            output.println("\t//");
            output.println("\t// Read a value from an input stream");
            output.println("\t//");
            output.println("\tpublic java.io.Serializable read_value( org.omg.CORBA.portable.InputStream is )");
            output.println("\t{");
            this.translate_unmarshalling(obj, output, "is");
            output.println("\t}");
            output.println("");
            output.println("\t//");
            output.println("\t// Write a value into an output stream");
            output.println("\t//");
            output.println("\tpublic void write_value( org.omg.CORBA.portable.OutputStream os, java.io.Serializable value )");
            output.println("\t{");
            this.translate_marshalling(obj, output, "os", "value");
            output.println("\t}");
            output.println("");
            output.println("\t//");
            output.println("\t// Return the value id");
            output.println("\t//");
            output.println("\tpublic java.lang.String get_id()");
            output.println("\t{");
            output.println("\t\treturn id();");
            output.println("\t}");
            output.println("");
        }
        output.println("}");
        output.close();
    }

    public void translate_marshalling_data(IdlObject obj, PrintWriter output, String outname, String tname) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("org.omg.CORBA.portable.ValueBaseHelper.write(" + outname + ",(org.omg.CORBA.portable.ValueBase)" + tname + ");");
                    return;
                }
                output.print(outname + ".write");
                switch (simple.internal()) {
                    case 34: {
                        output.print("_float");
                        break;
                    }
                    case 30: {
                        output.print("_double");
                        break;
                    }
                    case 47: {
                        output.print("_short");
                        break;
                    }
                    case 66: {
                        output.print("_ushort");
                        break;
                    }
                    case 38: {
                        output.print("_long");
                        break;
                    }
                    case 65: {
                        output.print("_ulong");
                        break;
                    }
                    case 73: {
                        output.print("_longlong");
                        break;
                    }
                    case 74: {
                        output.print("_ulonglong");
                        break;
                    }
                    case 26: {
                        output.print("_char");
                        break;
                    }
                    case 71: {
                        output.print("_wchar");
                        break;
                    }
                    case 24: {
                        output.print("_boolean");
                        break;
                    }
                    case 41: {
                        output.print("_octet");
                        break;
                    }
                    case 22: {
                        output.print("_any");
                        break;
                    }
                    case 70: {
                        output.print("_TypeCode");
                        break;
                    }
                    case 40: {
                        output.print("_Object");
                        break;
                    }
                }
                output.println("(" + tname + ");");
                break;
            }
            case 26: {
                output.println(outname + ".write_fixed(" + tname + ");");
                break;
            }
            case 5: {
                output.println(outname + ".write_string(" + tname + ");");
                break;
            }
            case 6: {
                output.println(outname + ".write_wstring(" + tname + ");");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_marshalling_data(((IdlIdent)obj).internalObject(), output, outname, tname);
                break;
            }
        }
    }

    public void translate_user_interface(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(this.initial, obj.name() + "Impl");
        output.println("//");
        output.println("// Interface implementation definition : " + obj.name());
        output.println("//");
        output.println("// !!!! THIS CODE MUST BE COMPLETED TO BE USED !!!");
        output.println("//");
        if (!IdlCompiler.pidl) {
            if (IdlCompiler.map_poa) {
                if (obj.upper().upper() != null) {
                    output.println("public class " + obj.name() + "Impl extends " + this.fullname(obj.upper()) + "." + obj.name() + "POA");
                } else {
                    output.println("public class " + obj.name() + "Impl extends " + obj.name() + "POA");
                }
            } else if (obj.upper().upper() != null) {
                output.println("public class " + obj.name() + "Impl extends " + this.fullname(obj.upper()) + "._" + obj.name() + "ImplBase");
            } else {
                output.println("public class " + obj.name() + "Impl extends _" + obj.name() + "ImplBase");
            }
        } else {
            output.println("public class " + obj.name() + "Impl implements " + this.fullname(obj) + "Operations");
        }
        output.println("{");
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: {
                    this.translate_user_operation(obj.current(), output);
                    break;
                }
                case 17: {
                    this.translate_user_attribute(obj.current(), output);
                    break;
                }
            }
            obj.next();
        }
        output.println("}");
        output.close();
        this.current_pkg = old_pkg;
    }

    public void translate_user_attribute(IdlObject obj, PrintWriter output) {
        output.println("\t//");
        output.println("\t// " + obj.name() + " read attribute");
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("\t{");
        output.println("\t\t//TODO: put your code here");
        output.println("\t}");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("\t//");
            output.println("\t// " + obj.name() + " write attribute");
            output.println("\t//");
            output.print("\tpublic void " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" value )");
            output.println("\t{");
            output.println("\t\t//TODO: put your code here");
            output.println("\t}");
            output.println("");
        }
    }

    public void translate_attribute(IdlObject obj, PrintWriter output) {
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("\t//");
            output.println("\t// Read accessor for " + obj.name() + " attribute");
            output.println("\t// @return\tthe attribute value");
            output.println("\t//");
        }
        output.print("\tpublic ");
        if (obj.upper().kind() == 28) {
            output.print("abstract ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "();");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            if (obj.hasComment()) {
                this.javadoc(output, obj);
            } else {
                output.println("\t//");
                output.println("\t// Write accessor for " + obj.name() + " attribute");
                output.println("\t// @param\tvalue\tthe attribute value");
                output.println("\t//");
            }
            output.print("\tpublic ");
            if (obj.upper().kind() == 28) {
                output.print("abstract ");
            }
            output.print("void " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" value );");
            output.println("");
        }
    }

    public File getDirectory(String name, File writeInto) {
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        return file;
    }

    public void translate_interface_tie(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        output = !IdlCompiler.map_poa ? this.newFile(writeInto, obj.name() + "Tie") : this.newFile(writeInto, obj.name() + "POATie");
        this.cartouche(output, obj);
        if (!IdlCompiler.map_poa) {
            output.println("public class " + obj.name() + "Tie extends _" + obj.name() + "ImplBase");
        } else {
            output.println("public class " + obj.name() + "POATie extends " + obj.name() + "POA");
        }
        output.println("{");
        output.println("");
        output.println("\t//");
        output.println("\t// Private reference to implementation object");
        output.println("\t//");
        output.println("\tprivate " + obj.name() + "Operations _tie;");
        output.println("");
        if (IdlCompiler.map_poa) {
            output.println("\t//");
            output.println("\t// Private reference to POA");
            output.println("\t//");
            output.println("\tprivate org.omg.PortableServer.POA _poa;");
            output.println("");
        }
        output.println("\t//");
        output.println("\t// Constructor");
        output.println("\t//");
        if (!IdlCompiler.map_poa) {
            output.println("\tpublic " + obj.name() + "Tie( " + obj.name() + "Operations tieObject )");
        } else {
            output.println("\tpublic " + obj.name() + "POATie( " + obj.name() + "Operations tieObject )");
        }
        output.println("\t{");
        output.println("\t\t_tie = tieObject;");
        output.println("\t}");
        output.println("");
        if (IdlCompiler.map_poa) {
            output.println("\t//");
            output.println("\t// Constructor");
            output.println("\t//");
            output.println("\tpublic " + obj.name() + "POATie( " + obj.name() + "Operations tieObject, org.omg.PortableServer.POA poa )");
            output.println("\t{");
            output.println("\t\t_tie = tieObject;");
            output.println("\t\t_poa = poa;");
            output.println("\t}");
            output.println("");
        }
        output.println("\t//");
        output.println("\t// Get the delegate");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "Operations _delegate()");
        output.println("\t{");
        output.println("\t\treturn _tie;");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Set the delegate");
        output.println("\t//");
        output.println("\tpublic void _delegate( " + obj.name() + "Operations delegate_)");
        output.println("\t{");
        output.println("\t\t_tie = delegate_;");
        output.println("\t}");
        output.println("");
        if (IdlCompiler.map_poa) {
            output.println("\t//");
            output.println("\t//");
            output.println("\t//");
            output.println("\tpublic org.omg.PortableServer.POA _default_POA()");
            output.println("\t{");
            output.println("\t\tif ( _poa != null )");
            output.println("\t\t    return _poa;");
            output.println("\t\telse");
            output.println("\t\t    return super._default_POA();");
            output.println("\t}");
            output.println("");
        }
        Vector intoList = this.getInheritanceOpList(obj, new Vector());
        int i = 0;
        while (i < intoList.size()) {
            switch (((IdlObject)intoList.elementAt(i)).kind()) {
                case 16: {
                    this.translate_operation_tie((IdlObject)intoList.elementAt(i), output);
                    break;
                }
                case 17: {
                    this.translate_attribute_tie((IdlObject)intoList.elementAt(i), output);
                    break;
                }
            }
            ++i;
        }
        output.println("}");
        output.close();
    }

    public PrintWriter newFile(File writeInto, String name) {
        String path = new String(writeInto.getPath() + this.sep + name + ".java");
        File file = new File(path);
        return this.fileAccess(file);
    }

    public void translate_module(IdlObject obj, File writeInto, int translateType) {
        if (IdlCompiler.usePrefix && obj.getPrefix() != null && obj.upper().kind() == 0) {
            writeInto = translateType == 0 ? this.createPrefixDirectories(obj.getPrefix(), writeInto) : this.getPrefixDirectories(obj.getPrefix(), writeInto);
        }
        File intoModule = translateType == 0 ? this.createDirectory(obj.name(), writeInto) : this.getDirectory(obj.name(), writeInto);
        String old_pkg = this.current_pkg;
        if (obj.getPrefix() != null && obj.upper().kind() == 0) {
            if (IdlCompiler.usePrefix) {
                this.addToPkg(obj, this.inversedPrefix(obj.getPrefix()) + "." + obj.name());
            } else {
                this.addToPkg(obj, obj.name());
            }
        } else {
            this.addToPkg(obj, obj.name());
        }
        this.translate_object(obj, intoModule, translateType);
        this.current_pkg = old_pkg;
    }

    public String get_array_name(IdlObject obj) {
        switch (this.final_kind(obj)) {
            case 8: {
                IdlSimple simple = (IdlSimple)this.final_type(obj);
                switch (simple.internal()) {
                    case 34: {
                        return "float";
                    }
                    case 30: {
                        return "double";
                    }
                    case 47: {
                        return "short";
                    }
                    case 66: {
                        return "ushort";
                    }
                    case 38: {
                        return "long";
                    }
                    case 65: {
                        return "ulong";
                    }
                    case 73: {
                        return "longlong";
                    }
                    case 74: {
                        return "ulonglong";
                    }
                    case 26: {
                        return "char";
                    }
                    case 71: {
                        return "wchar";
                    }
                    case 24: {
                        return "boolean";
                    }
                    case 41: {
                        return "octet";
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void translate_attribute_stub(IdlObject obj, PrintWriter output) {
        output.println("\t//");
        output.println("\t// Read accessor for " + obj.name() + " attribute");
        output.println("\t// @return\tthe attribute value");
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("\t{");
        output.println("\t\torg.omg.CORBA.Request _arg_request = _request(\"_get_" + obj.name() + "\");");
        if (IdlCompiler.portable) {
            output.println("\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        } else {
            output.println("\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
        }
        output.println("");
        output.print("\t\t_arg_request.set_return_type(");
        obj.reset();
        this.translate_typecode(obj.current(), output);
        output.println(");");
        output.println("");
        if (IdlCompiler.rpc) {
            output.println("\t\tjava.lang.Object [] _extra_rpc = new java.lang.Object[1];");
            output.println("\t\t_extra_rpc[0] = this;");
            output.println("\t\t((JavaORB.CORBA.Request)_arg_request).setExtra( _extra_rpc );");
            output.println("");
        }
        output.println("\t\t_arg_request.invoke();");
        output.println("");
        output.println("\t\tException _except = _arg_request.env().exception();");
        output.println("\t\tif ( _except != null )");
        output.println("\t\t\tthrow (org.omg.CORBA.SystemException)_except;");
        output.println("");
        output.println("\t\torg.omg.CORBA.Any _arg_result = _arg_request.return_value();");
        output.print("\t\treturn ");
        this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
        output.println("\t}");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("\t//");
            output.println("\t// Write accessor for " + obj.name() + " attribute");
            output.println("\t// @param\tvalue\tthe attribute value");
            output.println("\t//");
            output.print("\tpublic void " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" value )");
            output.println("\t{");
            output.println("\t\torg.omg.CORBA.Request _arg_request = _request(\"_set_" + obj.name() + "\");");
            if (IdlCompiler.portable) {
                output.println("\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
            } else {
                output.println("\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
            }
            output.println("");
            output.println("\t\torg.omg.CORBA.Any _arg = _arg_request.add_in_arg();");
            output.print("\t\t");
            this.translate_any_insert(obj.current(), output, "_arg", "value");
            output.println(";");
            if (IdlCompiler.rpc) {
                output.println("\t\tjava.lang.Object [] _extra_rpc = new java.lang.Object[1];");
                output.println("\t\t_extra_rpc[0] = this;");
                output.println("\t\t((JavaORB.CORBA.Request)_arg_request).setExtra( _extra_rpc );");
            }
            output.println("\t\t_arg_request.invoke();");
            output.println("");
            output.println("\t\tException _except = _arg_request.env().exception();");
            output.println("\t\tif ( _except != null )");
            output.println("\t\t\tthrow (org.omg.CORBA.SystemException)_except;");
            output.println("");
            output.println("\t}");
            output.println("");
        }
    }

    public void translate_enum(IdlObject obj, File writeInto) {
        IdlEnumMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        this.cartouche(output, obj);
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        output.println("\t//");
        output.println("\t// Internal member value ");
        output.println("\t//");
        output.println("\tprivate int _" + obj.name() + "_value;");
        output.println("");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlEnumMember)obj.current();
            output.println("\t//");
            output.println("\t// Enum member " + member_obj.name() + " value ");
            output.println("\t//");
            output.print("\tpublic static final int _" + member_obj.name());
            output.println(" = " + member_obj.getValue() + ";");
            output.println("");
            output.println("\t//");
            output.println("\t// Enum member " + member_obj.name());
            output.println("\t//");
            output.print("\tpublic static final " + obj.name() + " " + member_obj.name());
            output.println(" = new " + obj.name() + "(_" + member_obj.name() + ");");
            output.println("");
            obj.next();
        }
        output.println("\t//");
        output.println("\t// Return the internal member value");
        output.println("\t// @return\tthe member value");
        output.println("\t//");
        output.println("\tpublic int value()");
        output.println("\t{");
        output.println("\t\treturn _" + obj.name() + "_value;");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Return a enum member from its value");
        output.println("\t// @param\t\tan enum value");
        output.println("\t// @return\tan enum member");
        output.println("\t//");
        output.println("\tpublic static " + obj.name() + " from_int( int value )");
        output.println("\t{");
        output.println("\t\tswitch ( value )");
        output.println("\t\t{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlEnumMember)obj.current();
            output.println("\t\tcase " + member_obj.getValue() + " :");
            output.println("\t\t\treturn " + member_obj.name() + ";");
            obj.next();
        }
        output.println("\t\t}");
        output.println("\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Private constructor");
        output.println("\t// @param\t\tthe enum value for this new member");
        output.println("\t//");
        output.println("\tprivate " + obj.name() + "( int value )");
        output.println("\t{");
        output.println("\t\t_" + obj.name() + "_value = value;");
        output.println("\t}");
        output.println("");
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_read_attribute_skel(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print("\t\t\t");
        this.translate_type(obj.current(), output);
        output.println(" arg = " + obj.name() + "();");
        output.println("");
        output.println("\t\t\torg.omg.CORBA.NVList argList = orb.create_list(0);");
        output.println("\t\t\torg.omg.CORBA.Any result = orb.create_any();");
        output.println("\t\t\trequest.arguments(argList);");
        output.print("\t\t\t");
        this.translate_any_insert(obj.current(), output, "result", "arg");
        output.println(";");
        output.println("\t\t\trequest.set_result( result );");
    }

    public void translate_write_attribute_skel(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.println("\t\t\torg.omg.CORBA.NVList argList = orb.create_list(0);");
        output.println("\t\t\torg.omg.CORBA.Any arg = orb.create_any();");
        output.print("\t\t\targ.type( ");
        this.translate_typecode(obj.current(), output);
        output.println(" );");
        output.println("\t\t\targList.add_value(\"\", arg, org.omg.CORBA.ARG_IN.value);");
        output.println("\t\t\trequest.arguments(argList);");
        output.println("");
        output.print("\t\t\t");
        this.translate_type(obj.current(), output);
        output.print(" result = ");
        this.translate_unmarshalling_data(obj.current(), output, "arg.create_input_stream()");
        output.println("");
        output.println("\t\t\t" + obj.name() + "( result );");
    }

    public void translate_operation_stub(IdlObject obj, PrintWriter output) {
        IdlRaises r;
        IdlContext c;
        boolean someParams = false;
        int i = 0;
        output.println("\t//");
        output.println("\t// Operation " + obj.name());
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("\t{");
        output.println("\t\torg.omg.CORBA.Request request = _request(\"" + obj.name() + "\");");
        if (IdlCompiler.portable) {
            output.println("\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        } else {
            output.println("\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
        }
        output.println("");
        if (c != null) {
            Vector ctx = c.getValues();
            int j = 0;
            while (j < ctx.size()) {
                output.print("\t\trequest.contexts().add(\"");
                output.print((String)ctx.elementAt(j));
                output.println("\");");
                ++j;
            }
            output.println("\t\trequest.ctx(ctx);");
            output.println("");
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("\t\trequest.set_return_type(");
                this.translate_typecode(obj.current(), output);
                output.println(");");
                output.println("");
            }
        } else {
            output.print("\t\trequest.set_return_type(");
            this.translate_typecode(obj.current(), output);
            output.println(");");
            output.println("");
        }
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.println("\t\torg.omg.CORBA.Any arg" + i + " = request.add_in_arg();");
                        output.print("\t\t");
                        obj.current().reset();
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, obj.current().name());
                        output.println(";");
                        break;
                    }
                    case 1: {
                        output.println("\t\torg.omg.CORBA.Any arg" + i + " = request.add_out_arg();");
                        output.print("\t\targ" + i + ".type(");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(");");
                        break;
                    }
                    case 2: {
                        output.println("\t\torg.omg.CORBA.Any arg" + i + " = request.add_inout_arg();");
                        output.print("\t\t");
                        obj.current().reset();
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, obj.current().name() + ".value");
                        output.println(";");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print("\t\trequest.exceptions().add( ");
                output.println(this.fullname(r.current()) + "Helper.type() );");
                r.next();
            }
        }
        if (IdlCompiler.rpc) {
            output.println("\t\tjava.lang.Object [] _extra_rpc = new java.lang.Object[1];");
            output.println("\t\t_extra_rpc[0] = this;");
            output.println("\t\t((JavaORB.CORBA.Request)request).setExtra( _extra_rpc );");
        }
        output.println("");
        if (((IdlOp)obj).oneway()) {
            output.println("\t\trequest.send_oneway();");
        } else {
            output.println("\t\trequest.invoke();");
        }
        output.println("");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("\t\tException except = request.env().exception();");
            output.println("\t\tif ( except != null )");
            output.println("\t\t{");
            output.println("\t\t\torg.omg.CORBA.UnknownUserException unk_except;");
            output.println("\t\t\ttry");
            output.println("\t\t\t{");
            output.println("\t\t\t\tunk_except = (org.omg.CORBA.UnknownUserException)except;");
            output.println("\t\t\t}");
            output.println("\t\t\tcatch ( ClassCastException ex )");
            output.println("\t\t\t{");
            output.println("\t\t\t\tthrow (org.omg.CORBA.SystemException)except;");
            output.println("\t\t\t}");
            output.println("");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.println("\t\t\ttry");
                output.println("\t\t\t{");
                output.println("\t\t\t\tthrow " + this.fullname(r.current()) + "Helper.extract(unk_except.except);");
                output.println("\t\t\t}");
                output.println("\t\t\tcatch ( org.omg.CORBA.MARSHAL ex )");
                output.println("\t\t\t{ }");
                output.println("");
                r.next();
            }
            output.println("\t\tthrow new org.omg.CORBA.UNKNOWN();");
            output.println("\t\t}");
            output.println("");
        }
        obj.reset();
        obj.next();
        i = 0;
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        output.print("\t\t" + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                    case 2: {
                        output.print("\t\t" + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        output.println("");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("\t\torg.omg.CORBA.Any _arg_result = request.return_value();");
                output.print("\t\treturn ");
                this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
            }
        } else {
            output.println("\t\torg.omg.CORBA.Any _arg_result = request.return_value();");
            output.print("\t\treturn ");
            this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
        }
        output.println("\t}");
        output.println("");
    }

    public String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    public void translate_interface_skel(IdlObject obj, File writeInto) {
        boolean bUseHash;
        int i;
        IdlObject ob;
        PrintWriter output = null;
        output = !IdlCompiler.map_poa ? this.newFile(writeInto, "_" + obj.name() + "ImplBase") : this.newFile(writeInto, obj.name() + "POA");
        Vector list = new Vector();
        list = this.getInheritanceList(obj, list);
        this.cartouche(output, obj);
        if (!IdlCompiler.map_poa) {
            if (IdlCompiler.dynamic) {
                output.println("public abstract class _" + obj.name() + "ImplBase extends org.omg.CORBA.DynamicImplementation");
            } else {
                output.println("public abstract class _" + obj.name() + "ImplBase extends org.omg.CORBA.portable.ObjectImpl");
            }
            output.print("\t\timplements " + obj.name());
            if (IdlCompiler.rpc) {
                output.print(", JavaORB.RpcObject");
            }
            if (!IdlCompiler.dynamic) {
                output.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            output.println("");
        } else {
            if (IdlCompiler.dynamic) {
                output.println("public abstract class " + obj.name() + "POA extends org.omg.PortableServer.DynamicImplementation");
            } else {
                output.println("public abstract class " + obj.name() + "POA extends org.omg.PortableServer.Servant");
            }
            output.print("\t\timplements " + obj.name() + "Operations");
            if (IdlCompiler.rpc) {
                output.print(", JavaORB.RpcObject");
            }
            if (!IdlCompiler.dynamic) {
                output.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            output.println("");
        }
        output.println("{");
        Vector intoList = this.getInheritanceOpList(obj, new Vector());
        if (IdlCompiler.rpc) {
            output.println("\tstatic java.util.Hashtable _operations;");
            output.println("");
            output.println("\tstatic");
            output.println("\t{");
            output.println("\t\t_operations = new java.util.Hashtable();");
            if (list.size() != 0) {
                int j = 0;
                String ex = new String("");
                int i2 = 0;
                while (i2 < intoList.size()) {
                    ob = (IdlObject)intoList.elementAt(i2);
                    if (!ex.equals(ob.upper().getId())) {
                        j = 0;
                        ex = ob.upper().getId();
                    }
                    switch (ob.kind()) {
                        case 16: {
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + j + "\", \"" + ob.name() + "\");");
                            break;
                        }
                        case 17: {
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + j + "\", \"_get_" + ob.name() + "\");");
                            if (((IdlAttribute)ob).readOnly()) break;
                            output.println("\t\t_operations.put( \"" + ob.upper().getId() + "|" + ++j + "\", \"_set_" + ob.name() + "\");");
                            break;
                        }
                    }
                    ++j;
                    ++i2;
                }
            }
            output.println("");
            output.println("\t}");
            output.println("");
            output.println("\tpublic java.util.Hashtable _ops()");
            output.println("\t{");
            output.println("\t\treturn _operations;");
            output.println("\t}");
            output.println("");
        }
        if (!IdlCompiler.map_poa) {
            output.println("\tstatic final String[] _ids_list = ");
            output.println("\t{");
            if (list.size() != 0) {
                i = 0;
                while (i < list.size()) {
                    output.print("\t\t\"" + (String)list.elementAt(i) + "\"");
                    if (i + 1 < list.size()) {
                        output.println(", ");
                    }
                    ++i;
                }
            }
            output.println("");
            output.println("\t};");
            output.println("");
            output.println("\tpublic String[] _ids()");
            output.println("\t{");
            output.println("\t\treturn _ids_list;");
            output.println("\t}");
            output.println("");
        } else {
            output.println("\tpublic " + obj.name() + " _this()");
            output.println("\t{");
            output.println("\t\treturn " + obj.name() + "Helper.narrow(_this_object());");
            output.println("\t}");
            output.println("");
            output.println("\tpublic " + obj.name() + " _this( org.omg.CORBA.ORB orb )");
            output.println("\t{");
            output.println("\t\treturn " + obj.name() + "Helper.narrow(_this_object(orb));");
            output.println("\t}");
            output.println("");
            output.println("\tprivate static String [] _ids_list =");
            output.println("\t{");
            if (list.size() != 0) {
                i = 0;
                while (i < list.size()) {
                    output.print("\t\t\"" + (String)list.elementAt(i) + "\"");
                    if (i + 1 < list.size()) {
                        output.println(", ");
                    }
                    ++i;
                }
            }
            output.println("");
            output.println("\t};");
            output.println("");
            output.println("\tpublic String[] _all_interfaces( org.omg.PortableServer.POA poa, byte [] objectId)");
            output.println("\t{");
            output.println("\t\treturn _ids_list;");
            output.println("\t}");
            output.println("");
        }
        boolean bl = bUseHash = intoList.size() > 8;
        if (bUseHash) {
            output.println("\tprivate static java.util.Hashtable _ops_Hash = new java.util.Hashtable();");
            output.println("\tstatic {");
            int i3 = 0;
            while (i3 < intoList.size()) {
                ob = (IdlObject)intoList.elementAt(i3);
                switch (ob.kind()) {
                    case 16: {
                        output.println("\t\t_ops_Hash.put(\"" + this.initialName(ob.name()) + "\", new Integer(" + (i3 << 2) + ") );");
                        break;
                    }
                    case 17: {
                        output.println("\t\t_ops_Hash.put(\"_get_" + this.initialName(ob.name()) + "\", new Integer(" + (i3 << 2) + ") );");
                        if (((IdlAttribute)ob).readOnly()) break;
                        output.println("\t\t_ops_Hash.put(\"_set_" + this.initialName(ob.name()) + "\", new Integer(" + (i3 << 2 | 1) + ") );");
                        break;
                    }
                }
                ++i3;
            }
            output.println("\t};");
            output.println("");
        }
        if (IdlCompiler.dynamic) {
            output.println("\tpublic final void invoke ( org.omg.CORBA.ServerRequest request )");
        } else {
            output.println("\tpublic org.omg.CORBA.portable.OutputStream _invoke ( String opName,");
            output.println("\t                                                     org.omg.CORBA.portable.InputStream _is,");
            output.println("\t                                                     org.omg.CORBA.portable.ResponseHandler handler)");
        }
        output.println("\t{");
        if (IdlCompiler.dynamic) {
            if (IdlCompiler.portable) {
                output.println("\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
            } else {
                output.println("\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
            }
            output.println("\t\tString opName = request.operation();");
        } else {
            output.println("\t\torg.omg.CORBA.portable.OutputStream _output = null;");
        }
        output.println("");
        if (bUseHash) {
            output.println("\t\tInteger opidx = (Integer)_ops_Hash.get(opName);");
            output.println("\t\tif(opidx == null)");
            output.println("\t\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
            output.println("");
            output.println("\t\tswitch(opidx.intValue()) {");
        }
        int i4 = 0;
        while (i4 < intoList.size()) {
            ob = (IdlObject)intoList.elementAt(i4);
            switch (ob.kind()) {
                case 16: {
                    if (bUseHash) {
                        output.println("\t\tcase " + (i4 << 2) + ":");
                    } else {
                        output.println("\t\tif ( opName.equals(\"" + this.initialName(ob.name()) + "\") )");
                    }
                    output.println("\t\t{");
                    if (IdlCompiler.dynamic) {
                        this.translate_operation_skel(ob, output);
                    } else {
                        this.translate_operation_skel_stream(ob, output);
                    }
                    output.println("\t\t}");
                    break;
                }
                case 17: {
                    if (bUseHash) {
                        output.println("\t\tcase " + (i4 << 2) + ":");
                    } else {
                        output.println("\t\tif ( opName.equals(\"_get_" + this.initialName(ob.name()) + "\") )");
                    }
                    output.println("\t\t{");
                    if (IdlCompiler.dynamic) {
                        this.translate_read_attribute_skel(ob, output);
                    } else {
                        this.translate_read_attribute_skel_stream(ob, output);
                    }
                    output.println("\t\t}");
                    if (((IdlAttribute)ob).readOnly()) break;
                    if (bUseHash) {
                        output.println("\t\tcase " + (i4 << 2 | 1) + ":");
                    } else {
                        output.println("\t\telse");
                        output.println("\t\tif ( opName.equals(\"_set_" + this.initialName(ob.name()) + "\") )");
                    }
                    output.println("\t\t{");
                    if (IdlCompiler.dynamic) {
                        this.translate_write_attribute_skel(ob, output);
                    } else {
                        this.translate_write_attribute_skel_stream(ob, output);
                    }
                    output.println("\t\t}");
                    break;
                }
            }
            if (!bUseHash) {
                output.println("\t\telse");
            }
            ++i4;
        }
        if (bUseHash) {
            output.println("\t\t}");
            output.println("");
            output.println("\t\t// never reached");
            output.println("\t\tthrow new org.omg.CORBA.INTERNAL();");
        } else {
            output.println("\t\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
        }
        output.println("\t}");
        output.println("}");
        output.close();
    }

    public void translate_parameter(IdlObject obj, PrintWriter output, int attr) {
        IdlSimple simple = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 34: {
                        if (attr == 0) {
                            output.print("float");
                            break block0;
                        }
                        output.print("org.omg.CORBA.FloatHolder");
                        break block0;
                    }
                    case 30: {
                        if (attr == 0) {
                            output.print("double");
                            break block0;
                        }
                        output.print("org.omg.CORBA.DoubleHolder");
                        break block0;
                    }
                    case 47: 
                    case 66: {
                        if (attr == 0) {
                            output.print("short");
                            break block0;
                        }
                        output.print("org.omg.CORBA.ShortHolder");
                        break block0;
                    }
                    case 38: 
                    case 65: {
                        if (attr == 0) {
                            output.print("int");
                            break block0;
                        }
                        output.print("org.omg.CORBA.IntHolder");
                        break block0;
                    }
                    case 73: 
                    case 74: {
                        if (attr == 0) {
                            output.print("long");
                            break block0;
                        }
                        output.print("org.omg.CORBA.LongHolder");
                        break block0;
                    }
                    case 26: 
                    case 71: {
                        if (attr == 0) {
                            output.print("char");
                            break block0;
                        }
                        output.print("org.omg.CORBA.CharHolder");
                        break block0;
                    }
                    case 24: {
                        if (attr == 0) {
                            output.print("boolean");
                            break block0;
                        }
                        output.print("org.omg.CORBA.BooleanHolder");
                        break block0;
                    }
                    case 41: {
                        if (attr == 0) {
                            output.print("byte");
                            break block0;
                        }
                        output.print("org.omg.CORBA.ByteHolder");
                        break block0;
                    }
                    case 22: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.Any");
                            break block0;
                        }
                        output.print("org.omg.CORBA.AnyHolder");
                        break block0;
                    }
                    case 70: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.TypeCode");
                            break block0;
                        }
                        output.print("org.omg.CORBA.TypeCodeHolder");
                        break block0;
                    }
                    case 40: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.Object");
                            break block0;
                        }
                        output.print("org.omg.CORBA.ObjectHolder");
                        break block0;
                    }
                    case 88: {
                        if (attr == 0) {
                            output.print("java.io.Serializable");
                            break block0;
                        }
                        output.print("org.omg.CORBA.ValueBaseHolder");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                if (attr == 0) {
                    output.print("java.math.BigDecimal");
                    break;
                }
                output.print("org.omg.CORBA.FixedHolder");
                break;
            }
            case 5: 
            case 6: {
                if (attr == 0) {
                    output.print("java.lang.String");
                    break;
                }
                output.print("org.omg.CORBA.StringHolder");
                break;
            }
            case 27: {
                if (attr == 0) {
                    if (((IdlValueBox)obj).simple()) {
                        output.print(this.fullname(obj));
                        break;
                    }
                    obj.reset();
                    this.translate_parameter(obj.current(), output, attr);
                    break;
                }
                output.print(this.fullname(obj) + "Holder");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                if (attr == 0) {
                    output.print(this.fullname(obj));
                    break;
                }
                output.print(this.fullname(obj) + "Holder");
                break;
            }
            case 25: {
                if (attr != 0) {
                    output.print(this.fullname(obj) + "Holder");
                    break;
                }
                if (this.isNativeDefinition(obj)) {
                    this.printNativeDefinition(obj, output);
                    break;
                }
                output.print(this.fullname(obj));
                break;
            }
            case 13: {
                obj.reset();
                if (attr != 0) {
                    if (this.final_type(obj).kind() == 9 || this.final_type(obj).kind() == 24) {
                        output.print(this.fullname(obj) + "Holder");
                        break;
                    }
                    this.translate_parameter(obj.current(), output, attr);
                    break;
                }
                this.translate_parameter(obj.current(), output, attr);
                break;
            }
            case 9: 
            case 24: {
                if (attr == 0) {
                    this.translate_parameter(obj.current(), output, attr);
                    output.print("[]");
                    break;
                }
                output.print(this.fullname(obj.upper()) + "Holder");
                break;
            }
            case 10: {
                this.translate_parameter(((IdlIdent)obj).internalObject(), output, attr);
                break;
            }
        }
    }

    public File getPrefixDirectories(String prefix, File writeInto) {
        char[] tab = new char[prefix.length() + 20];
        String name = new String(this.inversedPrefix(prefix));
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            tab[j++] = name.charAt(i) == '.' ? this.sep.charAt(0) : name.charAt(i);
            ++i;
        }
        name = new String(tab, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        return file;
    }

    public void printNativeDefinition(IdlObject obj, PrintWriter output) {
        int i = 0;
        while (i < IdlCompiler.nativeDefinition.size()) {
            String s = (String)IdlCompiler.nativeDefinition.elementAt(i);
            int index = s.indexOf(58);
            String word = s.substring(0, index);
            if (obj.name().equals(word)) {
                index = s.lastIndexOf(58);
                word = s.substring(index + 1, s.length());
                output.print(word);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void translate_comment_section(PrintWriter output, String description, IdlObject obj) {
        int i = 0;
        while (i < description.length()) {
            if (description.charAt(i) == '\n') {
                if (i == description.length() - 1) {
                    output.println("");
                    return;
                }
                output.println("");
                if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                    output.print("\t");
                }
                output.print(" * ");
            } else {
                output.print(description.charAt(i));
            }
            ++i;
        }
    }

    public void write_holder(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(writeInto, obj.name() + "Holder");
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("corba_pkg")) {
                if (IdlCompiler.use_package) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("//");
        output.println("// Holder class for : " + obj.name());
        output.println("//");
        output.println("// @author JavaORB Compiler");
        output.println("//");
        output.println("public class " + obj.name() + "Holder implements org.omg.CORBA.portable.Streamable");
        output.println("{");
        output.println("\t//");
        output.println("\t// Internal " + obj.name() + " value");
        output.println("\t//");
        output.print("\tpublic ");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                obj.reset();
                this.translate_type(obj.current(), output);
            } else {
                this.translate_type(obj, output);
            }
        } else {
            this.translate_type(obj, output);
        }
        output.println(" value;");
        output.println("");
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "Holder()");
        output.println("\t{ }");
        output.println("");
        output.println("\t//");
        output.println("\t// Constructor with value initialisation");
        output.println("\t// @param\tinitial\tthe initial value");
        output.println("\t//");
        output.print("\tpublic " + obj.name() + "Holder( ");
        this.translate_type(obj, output);
        output.println(" initial )");
        output.println("\t{");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println("\t\tvalue = initial.value;");
            } else {
                output.println("\t\tvalue = initial;");
            }
        } else {
            output.println("\t\tvalue = initial;");
        }
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Read " + obj.name() + " from a marshalled stream");
        output.println("\t// @param\tistream the input stream");
        output.println("\t//");
        output.println("\tpublic void _read( org.omg.CORBA.portable.InputStream istream )");
        output.println("\t{");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println("\t\tvalue = (" + obj.name() + "Helper.read(istream)).value;");
            } else {
                output.println("\t\tvalue = " + obj.name() + "Helper.read(istream);");
            }
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println("\t\tvalue = " + obj.name() + "Helper.read(istream);");
            }
        } else {
            output.println("\t\tvalue = " + obj.name() + "Helper.read(istream);");
        }
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Write " + obj.name() + " into a marshalled stream");
        output.println("\t// @param\tostream the output stream");
        output.println("\t//");
        output.println("\tpublic void _write( org.omg.CORBA.portable.OutputStream ostream )");
        output.println("\t{");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println("\t\t" + obj.name() + "Helper.write(ostream, new " + obj.name() + "(value));");
            } else {
                output.println("\t\t" + obj.name() + "Helper.write(ostream,value);");
            }
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println("\t\t" + obj.name() + "Helper.write(ostream,value);");
            }
        } else {
            output.println("\t\t" + obj.name() + "Helper.write(ostream,value);");
        }
        output.println("\t}");
        output.println("");
        output.println("\t//");
        output.println("\t// Return the " + obj.name() + " TypeCode");
        output.println("\t// @return a TypeCode");
        output.println("\t//");
        output.println("\tpublic org.omg.CORBA.TypeCode _type()");
        output.println("\t{");
        if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("\t\tthrow new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println("\t\treturn " + obj.name() + "Helper.type();");
            }
        } else {
            output.println("\t\treturn " + obj.name() + "Helper.type();");
        }
        output.println("\t}");
        output.println("");
        output.println("}");
        output.close();
    }

    public void translate_operation(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("\t//");
            output.println("\t// Operation " + obj.name());
            output.println("\t//");
        }
        output.print("\tpublic ");
        if (obj.upper().kind() == 28) {
            output.print("abstract ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println(";");
        output.println("");
    }

    private Vector getInheritedStateMember(IdlObject obj) {
        Vector list = new Vector();
        Vector sub = null;
        IdlValue[] inherited = ((IdlValue)obj).getInheritance();
        if (inherited.length != 0) {
            sub = this.getInheritedStateMember(inherited[0]);
        }
        if (sub != null) {
            int i = 0;
            while (i < sub.size()) {
                list.addElement(sub.elementAt(i));
                ++i;
            }
        }
        obj.reset();
        while (!obj.end()) {
            if (obj.current().kind() == 29) {
                list.addElement(obj.current());
            }
            obj.next();
        }
        return list;
    }

    public String IdlScopeToJavaScope(String expr, boolean complete) {
        Vector<Character> s = new Vector<Character>();
        String mot = new String();
        int last = 0;
        boolean isEnum = false;
        int i = 0;
        while (i < expr.length()) {
            block32: {
                boolean stop;
                boolean prev;
                block30: {
                    block31: {
                        if (!Character.isDigit(expr.charAt(i)) && expr.charAt(i) != '-') break block30;
                        if (expr.charAt(i) != '-') break block31;
                        s.addElement(new Character('-'));
                        if (expr.charAt(i++) == ' ') break block32;
                    }
                    boolean hexaValue = false;
                    while (i != expr.length() && expr.charAt(i) != ' ') {
                        if (expr.charAt(i) == 'x') {
                            hexaValue = true;
                        }
                        s.addElement(new Character(expr.charAt(i)));
                        ++i;
                    }
                    if (hexaValue) {
                        s.addElement(new Character('l'));
                    }
                    break block32;
                }
                if (expr.charAt(i) == '\"') {
                    ++i;
                    s.addElement(new Character('\"'));
                    prev = false;
                    stop = false;
                    while (i != expr.length() && !stop) {
                        if (expr.charAt(i) == '\"' && !prev) {
                            stop = true;
                            continue;
                        }
                        prev = false;
                        if (expr.charAt(i) == '\\') {
                            prev = true;
                        }
                        s.addElement(new Character(expr.charAt(i)));
                        ++i;
                    }
                    s.addElement(new Character('\"'));
                } else if (expr.charAt(i) == '\'') {
                    ++i;
                    s.addElement(new Character('\''));
                    prev = false;
                    stop = false;
                    while (i != expr.length() && !stop) {
                        if (expr.charAt(i) == '\'' && !prev) {
                            stop = true;
                            continue;
                        }
                        prev = false;
                        if (expr.charAt(i) == '\\') {
                            prev = true;
                        }
                        s.addElement(new Character(expr.charAt(i)));
                        ++i;
                    }
                    s.addElement(new Character('\''));
                } else if (Character.isLetter(expr.charAt(i))) {
                    mot = "";
                    int deb = i;
                    while (i != expr.length() && expr.charAt(i) != ' ') {
                        if (expr.charAt(i) == ':' && ++i < expr.length()) {
                            if (expr.charAt(i) == ':') {
                                s.addElement(new Character('.'));
                                last = s.size();
                                ++i;
                            } else {
                                s.addElement(new Character(':'));
                            }
                        }
                        if (expr.charAt(i) == '.') {
                            last = s.size() + 1;
                        }
                        s.addElement(new Character(expr.charAt(i)));
                        mot = mot + expr.charAt(i);
                        ++i;
                    }
                    if (!mot.equals("true") && !mot.equals("false")) {
                        isEnum = this.isEnumCase(expr);
                        if (isEnum) {
                            s.removeElementAt(s.size() - 1);
                        }
                        if (!isEnum) {
                            s.addElement(new Character('.'));
                            s.addElement(new Character('v'));
                            s.addElement(new Character('a'));
                            s.addElement(new Character('l'));
                            s.addElement(new Character('u'));
                            s.addElement(new Character('e'));
                        } else if (complete) {
                            s.insertElementAt(new Character('_'), last);
                        }
                    }
                } else if (expr.charAt(i) != ' ') {
                    s.addElement(new Character(expr.charAt(i)));
                }
            }
            ++i;
        }
        String newExpr = new String();
        int i2 = 0;
        while (i2 < s.size()) {
            newExpr = newExpr + ((Character)s.elementAt(i2)).charValue();
            ++i2;
        }
        return newExpr;
    }

    public String IdlEspaceCharToJavaEscapeChar(String expr) {
        Vector<Character> s = new Vector<Character>();
        int i = 0;
        while (i < expr.length()) {
            if (expr.charAt(i) == '\\') {
                s.addElement(new Character('\\'));
                switch (expr.charAt(++i)) {
                    case '\\': {
                        break;
                    }
                    case 'a': {
                        s.addElement(new Character('0'));
                        s.addElement(new Character('0'));
                        s.addElement(new Character('7'));
                        break;
                    }
                    case 'v': {
                        s.addElement(new Character('0'));
                        s.addElement(new Character('1'));
                        s.addElement(new Character('3'));
                        break;
                    }
                    case 'x': {
                        ++i;
                        while (this.isHexaCar(expr.charAt(i))) {
                            ++i;
                        }
                        s.addElement(new Character('3'));
                        s.addElement(new Character('7'));
                        s.addElement(new Character('7'));
                    }
                    default: {
                        s.addElement(new Character(expr.charAt(i)));
                        break;
                    }
                }
            } else {
                s.addElement(new Character(expr.charAt(i)));
            }
            ++i;
        }
        String newExpr = new String();
        int i2 = 0;
        while (i2 < s.size()) {
            newExpr = newExpr + ((Character)s.elementAt(i2)).charValue();
            ++i2;
        }
        return newExpr;
    }

    public void translate_state_member(IdlObject obj, PrintWriter output) {
        IdlStateMember member = (IdlStateMember)obj;
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("\t//");
            if (member.public_member()) {
                output.println("\t// Public member : " + obj.name());
            } else {
                output.println("\t// Private member : " + obj.name());
            }
            output.println("\t//");
        }
        if (member.public_member()) {
            output.print("\tpublic ");
        } else {
            output.print("\tprotected ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + ";");
        output.println("");
    }

    public void addToPkg(IdlObject obj, String name) {
        this.current_pkg = !IdlCompiler.use_package ? (!this.current_pkg.equals("corba_pkg") ? (!this.current_pkg.equals("") ? this.current_pkg + "." + name : name) : name) : (!this.current_pkg.equals("") ? this.current_pkg + "." + name : name);
    }

    public void translate_attribute_stub_stream(IdlObject obj, PrintWriter output) {
        output.println("\t//");
        output.println("\t// Read accessor for " + obj.name() + " attribute");
        output.println("\t// @return\tthe attribute value");
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("\t{");
        output.println("\t\twhile( true )");
        output.println("\t\t{");
        if (IdlCompiler.map_poa) {
            output.println("\t\t\tif (!this._is_local() )");
            output.println("\t\t\t{");
        }
        output.println("\t\t\t\torg.omg.CORBA.portable.InputStream _input = null;");
        output.println("\t\t\t\ttry");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\torg.omg.CORBA.portable.OutputStream _output = this._request(\"_get_" + obj.name() + "\",true);");
        output.println("\t\t\t\t\t_input = this._invoke(_output);");
        output.print("\t\t\t\t\treturn ");
        this.translate_unmarshalling_data(obj.current(), output, "_input");
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _exception )");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tcontinue;");
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _exception )");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tjava.lang.String _exception_id = _exception.getId();");
        output.println("\t\t\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"Unexcepected User Exception: \"+ _exception_id);");
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tfinally");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tthis._releaseReply(_input);");
        output.println("\t\t\t\t}");
        boolean doIt = true;
        if (obj.upper().kind() == 15 && ((IdlInterface)obj.upper()).abstract_interface()) {
            doIt = false;
        }
        if (IdlCompiler.map_poa) {
            output.println("\t\t\t}");
            if (doIt) {
                output.println("\t\t\telse");
                output.println("\t\t\t{");
                output.println("\t\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_get_" + obj.name() + "\",_opsClass);");
                output.println("\t\t\t\tif ( _so == null )");
                output.println("\t\t\t\t   continue;");
                output.println("\t\t\t\t" + this.fullname(obj.upper()) + "Operations _self = ( " + this.fullname(obj.upper()) + "Operations ) _so.servant;");
                output.println("\t\t\t\ttry");
                output.println("\t\t\t\t{");
                output.println("\t\t\t\t\treturn _self." + obj.name() + "();");
                output.println("\t\t\t\t}");
                output.println("\t\t\t\tfinally");
                output.println("\t\t\t\t{");
                output.println("\t\t\t\t\t_servant_postinvoke(_so);");
                output.println("\t\t\t\t}");
                output.println("\t\t\t}");
            }
        }
        output.println("\t\t}");
        output.println("\t}");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("\t//");
            output.println("\t// Write accessor for " + obj.name() + " attribute");
            output.println("\t// @param\tvalue\tthe attribute value");
            output.println("\t//");
            output.print("\tpublic void " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" value )");
            output.println("\t{");
            output.println("\t\twhile( true )");
            output.println("\t\t{");
            if (IdlCompiler.map_poa) {
                output.println("\t\t\tif (!this._is_local() )");
                output.println("\t\t\t{");
            }
            output.println("\t\t\t\t\torg.omg.CORBA.portable.InputStream _input = null;");
            output.println("\t\t\t\ttry");
            output.println("\t\t\t\t{");
            output.println("\t\t\t\t\torg.omg.CORBA.portable.OutputStream _output = this._request(\"_set_" + obj.name() + "\",true);");
            output.print("\t\t\t\t\t");
            this.translate_marshalling_data(obj.current(), output, "_output", "value");
            output.println("\t\t\t\t\t_input = this._invoke(_output);");
            output.println("\t\t\t\t\treturn;");
            output.println("\t\t\t\t}");
            output.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _exception )");
            output.println("\t\t\t\t{");
            output.println("\t\t\t\t\tcontinue;");
            output.println("\t\t\t\t}");
            output.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _exception )");
            output.println("\t\t\t\t{");
            output.println("\t\t\t\t\tjava.lang.String _exception_id = _exception.getId();");
            output.println("\t\t\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"Unexcepected User Exception: \"+ _exception_id);");
            output.println("\t\t\t\t}");
            output.println("\t\t\t\tfinally");
            output.println("\t\t\t\t{");
            output.println("\t\t\t\t\tthis._releaseReply(_input);");
            output.println("\t\t\t\t}");
            if (IdlCompiler.map_poa) {
                output.println("\t\t\t}");
                if (doIt) {
                    output.println("\t\t\telse");
                    output.println("\t\t\t{");
                    output.println("\t\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_set_" + obj.name() + "\",_opsClass);");
                    output.println("\t\t\t\tif ( _so == null )");
                    output.println("\t\t\t\t   continue;");
                    output.println("\t\t\t\t" + this.fullname(obj.upper()) + "Operations _self = ( " + this.fullname(obj.upper()) + "Operations ) _so.servant;");
                    output.println("\t\t\t\ttry");
                    output.println("\t\t\t\t{");
                    output.println("\t\t\t\t\t_self." + obj.name() + "(value);");
                    output.println("\t\t\t\t}");
                    output.println("\t\t\t\tfinally");
                    output.println("\t\t\t\t{");
                    output.println("\t\t\t\t\t_servant_postinvoke(_so);");
                    output.println("\t\t\t\t}");
                    output.println("\t\t\t}");
                }
            }
            output.println("\t\t}");
            output.println("\t}");
            output.println("");
        }
    }

    public void translate_read_attribute_skel_stream(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print("\t\t\t");
        this.translate_type(obj.current(), output);
        output.println(" arg = " + obj.name() + "();");
        output.println("\t\t\t_output = handler.createReply();");
        output.print("\t\t\t");
        this.translate_marshalling_data(obj.current(), output, "_output", "arg");
        output.println("\t\t\treturn _output;");
    }

    public void translate_write_attribute_skel_stream(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print("\t\t\t");
        this.translate_type(obj.current(), output);
        output.print(" result = ");
        this.translate_unmarshalling_data(obj.current(), output, "_is");
        output.println("");
        output.println("\t\t\t" + obj.name() + "( result );");
        output.println("\t\t\t_output = handler.createReply();");
        output.println("\t\t\treturn _output;");
    }

    public void translate_operation_stub_stream(IdlObject obj, PrintWriter output) {
        IdlRaises r;
        IdlContext c;
        boolean someParams = false;
        boolean noReturn = false;
        output.println("\t//");
        output.println("\t// Operation " + obj.name());
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("\t{");
        output.println("\t\twhile( true )");
        output.println("\t\t{");
        if (IdlCompiler.map_poa) {
            output.println("\t\t\tif (!this._is_local() )");
            output.println("\t\t\t{");
        }
        if (c != null) {
            output.println("\t\t\t\torg.omg.CORBA.ContextList ctxList = org.omg.CORBA.ORB.init().create_context_list();");
        }
        output.println("\t\t\t\torg.omg.CORBA.portable.InputStream _input = null;");
        output.println("\t\t\t\ttry");
        output.println("\t\t\t\t{");
        if (((IdlOp)obj).oneway()) {
            output.println("\t\t\t\t\torg.omg.CORBA.portable.OutputStream _output = this._request(\"" + obj.name() + "\",false);");
        } else {
            output.println("\t\t\t\t\torg.omg.CORBA.portable.OutputStream _output = this._request(\"" + obj.name() + "\",true);");
        }
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("\t\t\t\t\t");
                        obj.current().reset();
                        this.translate_marshalling_data(obj.current().current(), output, "_output", obj.current().name());
                        break;
                    }
                    case 2: {
                        output.print("\t\t\t\t\t");
                        obj.current().reset();
                        this.translate_marshalling_data(obj.current().current(), output, "_output", obj.current().name() + ".value");
                        break;
                    }
                }
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (c != null) {
            Vector ctx = c.getValues();
            int j = 0;
            while (j < ctx.size()) {
                output.println("\t\t\t\t\tctxList.add(\"" + (String)ctx.elementAt(j) + "\");");
                ++j;
            }
            output.println("\t\t\t\t\t_output.write_Context(ctx,ctxList);");
            output.println("");
        }
        output.println("\t\t\t\t\t_input = this._invoke(_output);");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("\t\t\t\t\t");
                this.translate_type(obj.current(), output);
                output.print(" _arg_ret = ");
                this.translate_unmarshalling_data(obj.current(), output, "_input");
            }
        } else {
            output.print("\t\t\t\t\t");
            this.translate_type(obj.current(), output);
            output.print(" _arg_ret = ");
            this.translate_unmarshalling_data(obj.current(), output, "_input");
        }
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 1: 
                    case 2: {
                        output.print("\t\t\t\t\t" + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "_input");
                        break;
                    }
                }
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        int p = obj.pos();
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("\t\t\t\t\treturn _arg_ret;");
            } else {
                output.println("\t\t\t\t\treturn;");
                noReturn = true;
            }
        } else {
            output.println("\t\t\t\t\treturn _arg_ret;");
        }
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _exception )");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tcontinue;");
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _exception )");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tjava.lang.String _exception_id = _exception.getId();");
        obj.pos(p);
        if (!obj.end() && obj.current().kind() == 20) {
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.println("\t\t\t\t\tif ( _exception_id.equals(" + this.fullname(r.current()) + "Helper.id()) )");
                output.println("\t\t\t\t\t{");
                output.println("\t\t\t\t\t\tthrow " + this.fullname(r.current()) + "Helper.read(_exception.getInputStream());");
                output.println("\t\t\t\t\t}");
                output.println("");
                r.next();
            }
        }
        output.println("\t\t\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"Unexcepected User Exception: \"+ _exception_id);");
        output.println("\t\t\t\t}");
        output.println("\t\t\t\tfinally");
        output.println("\t\t\t\t{");
        output.println("\t\t\t\t\tthis._releaseReply(_input);");
        output.println("\t\t\t\t}");
        boolean doIt = true;
        if (obj.upper().kind() == 15 && ((IdlInterface)obj.upper()).abstract_interface()) {
            doIt = false;
        }
        if (IdlCompiler.map_poa) {
            output.println("\t\t\t}");
            if (doIt) {
                output.println("\t\t\telse");
                output.println("\t\t\t{");
                output.println("\t\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"" + obj.name() + "\",_opsClass);");
                output.println("\t\t\t\tif ( _so == null )");
                output.println("\t\t\t\t   continue;");
                output.println("\t\t\t\t" + this.fullname(obj.upper()) + "Operations _self = ( " + this.fullname(obj.upper()) + "Operations ) _so.servant;");
                output.println("\t\t\t\ttry");
                output.println("\t\t\t\t{");
                if (noReturn) {
                    output.print("\t\t\t\t\t_self." + obj.name() + "(");
                } else {
                    output.print("\t\t\t\t\treturn _self." + obj.name() + "(");
                }
                obj.reset();
                obj.next();
                if (!obj.end() && obj.current().kind() == 19) {
                    someParams = true;
                    while (!obj.end()) {
                        obj.current().reset();
                        output.print(" " + obj.current().name());
                        obj.next();
                        if (obj.end()) continue;
                        if (obj.current().kind() != 19) break;
                        output.print(", ");
                    }
                }
                if ((c = this.getContext(obj)) != null) {
                    if (someParams) {
                        output.print(", ");
                    }
                    output.print("ctx");
                }
                output.println(");");
                if (noReturn) {
                    output.println("\t\t\t\t\treturn;");
                }
                output.println("\t\t\t\t}");
                output.println("\t\t\t\tfinally");
                output.println("\t\t\t\t{");
                output.println("\t\t\t\t\t_servant_postinvoke(_so);");
                output.println("\t\t\t\t}");
                output.println("\t\t\t}");
            }
        }
        output.println("\t\t}");
        output.println("\t}");
        output.println("");
    }

    public void translate_unmarshalling(IdlObject obj, PrintWriter output, String inname) {
        block0 : switch (obj.kind()) {
            case 8: {
                if (((IdlSimple)obj).internal() != 70) break;
                output.println("\t\treturn " + inname + ".read_TypeCode();");
                break;
            }
            case 2: {
                output.println("\t\treturn " + obj.name() + ".from_int(" + inname + ".read_long());");
                break;
            }
            case 3: {
                obj.reset();
                output.println("\t\t" + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one." + obj.current().name(), "\t\t");
                    obj.next();
                }
                output.println("");
                output.println("\t\treturn new_one;");
                break;
            }
            case 4: {
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                output.println("\t\t" + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                obj.current().reset();
                boolean enumeration = false;
                if (this.final_kind(obj.current().current()) == 2) {
                    enumeration = true;
                }
                this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one._" + obj.current().name(), "\t\t");
                obj.next();
                if (((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                    output.println("\t\tswitch ( new_one.toInt() ) ");
                } else if (enumeration) {
                    output.println("\t\tswitch ( new_one.discriminator().value() )");
                } else {
                    output.println("\t\tswitch ( new_one.discriminator() )");
                }
                output.println("\t\t{");
                int i = 0;
                while (!obj.end()) {
                    if (i != idx) {
                        if (((IdlUnionMember)obj.current()).getExpression().equals("true ")) {
                            output.println("\t\tcase 1 :");
                        } else if (((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                            output.println("\t\tcase 0 :");
                        } else {
                            output.println("\t\tcase " + this.translate_to_java_expression(((IdlUnionMember)obj.current()).getExpression()) + ":");
                        }
                    } else {
                        output.println("\t\tdefault :");
                    }
                    if (!((IdlUnionMember)obj.current()).isAsNext()) {
                        obj.current().reset();
                        this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one._" + obj.current().name(), "\t\t\t");
                        output.println("\t\t\tbreak;");
                    }
                    obj.next();
                    ++i;
                }
                output.println("\t\t}");
                output.println("");
                output.println("\t\treturn new_one;");
                break;
            }
            case 13: {
                obj.reset();
                switch (obj.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: {
                        output.print("\t\t");
                        this.translate_type(obj.current(), output);
                        output.println(" new_one;");
                        this.translate_unmarshalling_member(obj.current(), output, inname, "new_one", "\t\t");
                        output.println("");
                        output.println("\t\treturn new_one;");
                        break block0;
                    }
                }
                this.translate_unmarshalling(obj.current(), output, inname);
                break;
            }
            case 10: {
                this.translate_unmarshalling(((IdlIdent)obj).internalObject(), output, inname);
                break;
            }
            case 14: {
                obj.reset();
                output.println("\t\t" + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                output.println("\t\tif ( !" + inname + ".read_string().equals( id() ) )");
                output.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one." + obj.current().name(), "\t\t");
                    obj.next();
                }
                output.println("");
                output.println("\t\treturn new_one;");
                break;
            }
            case 25: {
                output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)obj).local_interface()) {
                    output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("\t\tjava.lang.Object new_one = ((org.omg.CORBA_2_3.portable.InputStream)" + inname + ").read_abstract_interface();");
                    output.println("\t\treturn (" + this.fullname(obj) + ") new_one;");
                    break;
                }
                output.println("\t\torg.omg.CORBA.Object new_one = " + inname + ".read_Object();");
                output.println("\t\tif ( new_one != null )");
                output.println("\t\t{");
                output.println("\t\t\tif ( ((org.omg.CORBA.portable.ObjectImpl)new_one)._is_local() )");
                output.println("\t\t\t\treturn " + this.fullname(obj) + "Helper.narrow(new_one);");
                String stubname = this.fullname(obj);
                stubname = stubname.lastIndexOf(".") != -1 ? stubname.substring(0, stubname.lastIndexOf(".") + 1) : "";
                stubname = stubname + "_" + obj.name() + "Stub";
                output.println("\t\t\t" + stubname + " stub = new " + stubname + "();");
                output.println("\t\t\tstub._set_delegate( ((org.omg.CORBA.portable.ObjectImpl)new_one)._get_delegate() );");
                output.println("\t\t\treturn stub;");
                output.println("\t\t}");
                output.println("\t\treturn null;");
                break;
            }
            case 28: {
                if (((IdlValue)obj).abstract_value()) {
                    output.println("\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
                    break;
                }
                output.println("\t\treturn ( " + obj.name() + " ) ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value();");
                break;
            }
            case 27: {
                obj.reset();
                if (((IdlValueBox)obj).simple()) {
                    output.println("\t\t" + this.fullname(obj) + " _box = new " + this.fullname(obj) + "(0);");
                    this.translate_unmarshalling_member(obj.current(), output, inname, "_box.value", "\t\t");
                } else {
                    output.print("\t\t");
                    this.translate_type(obj.current(), output);
                    output.println(" _box = null;");
                    this.translate_unmarshalling_member(obj.current(), output, inname, "_box", "\t\t");
                }
                output.println("\t\treturn _box;");
                break;
            }
        }
    }

    public PrintWriter fileAccess(File writeInto) {
        PrintWriter printout = null;
        try {
            FileOutputStream output = new FileOutputStream(writeInto);
            DataOutputStream dataout = new DataOutputStream(output);
            printout = new PrintWriter(dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printout;
    }

    public void translate_interface_operations(IdlObject obj, File writeInto) {
        PrintWriter output = !((IdlInterface)obj).abstract_interface() ? this.newFile(writeInto, obj.name() + "Operations") : this.newFile(writeInto, obj.name());
        Vector list = ((IdlInterface)obj).getInheritance();
        this.cartouche(output, obj);
        if (!((IdlInterface)obj).abstract_interface()) {
            output.print("public interface " + obj.name() + "Operations");
        } else {
            output.print("public interface " + obj.name() + " extends org.omg.CORBA.portable.IDLEntity");
        }
        if (list.size() != 0) {
            output.print(" extends ");
            int i = 0;
            while (i < list.size()) {
                if (!((IdlInterface)list.elementAt(i)).abstract_interface()) {
                    output.print(this.fullname((IdlObject)list.elementAt(i)) + "Operations");
                } else {
                    output.print(this.fullname((IdlObject)list.elementAt(i)));
                }
                if (i != list.size() - 1) {
                    output.print(", ");
                }
                ++i;
            }
            output.println("");
        } else {
            output.println("");
        }
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: {
                    this.translate_operation(obj.current(), output);
                    break;
                }
                case 17: {
                    this.translate_attribute(obj.current(), output);
                    break;
                }
                case 7: {
                    if (!((IdlInterface)obj).abstract_interface()) break;
                    this.translate_constant(obj.current(), null, output);
                    break;
                }
            }
            obj.next();
        }
        output.println("}");
        output.close();
    }

    public void cartouche(PrintWriter output, IdlObject obj) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("corba_pkg")) {
                if (IdlCompiler.use_package) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        switch (obj.kind()) {
            case 7: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Constant definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 2: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Enum definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 3: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Struct definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 4: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Union definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 14: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Exception definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 15: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Interface definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 27: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Value box definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 28: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Value Type definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
            case 30: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("//");
                output.println("// Factory definition : " + obj.name());
                output.println("//");
                output.println("// @author JavaORB Compiler");
                output.println("//");
                break;
            }
        }
    }

    public IdlObject final_type(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.final_type(((IdlIdent)obj).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_type(obj.current());
            }
        }
        return obj;
    }

    public void translate_interface(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        if (!((IdlInterface)obj).abstract_interface()) {
            output = this.newFile(writeInto, obj.name());
            this.cartouche(output, obj);
        }
        Vector list = ((IdlInterface)obj).getInheritance();
        this.translate_interface_operations(obj, writeInto);
        File intoMe = null;
        intoMe = !this.isEmptyInterface(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
        if (!((IdlInterface)obj).abstract_interface()) {
            output.print("public interface " + obj.name());
            if (list.size() != 0) {
                output.print(" extends " + obj.name() + "Operations, ");
                int i = 0;
                while (i < list.size()) {
                    output.print(this.fullname((IdlObject)list.elementAt(i)));
                    if (i != list.size() - 1) {
                        output.print(", ");
                    }
                    ++i;
                }
            } else {
                output.print(" extends " + obj.name() + "Operations");
                if (!IdlCompiler.pidl) {
                    output.print(" , org.omg.CORBA.Object");
                }
            }
            output.println(", org.omg.CORBA.portable.IDLEntity");
            output.println("{");
        }
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    this.translate_enum(obj.current(), intoMe);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current(), intoMe);
                    break;
                }
                case 4: {
                    this.translate_union(obj.current(), intoMe);
                    break;
                }
                case 13: {
                    this.translate_typedef(obj.current(), intoMe);
                    break;
                }
                case 14: {
                    this.translate_exception(obj.current(), intoMe);
                    break;
                }
                case 25: {
                    this.translate_native(obj.current(), intoMe);
                    break;
                }
                case 7: {
                    if (((IdlInterface)obj).abstract_interface()) break;
                    this.translate_constant(obj.current(), null, output);
                    break;
                }
            }
            obj.next();
        }
        if (!((IdlInterface)obj).abstract_interface()) {
            output.println("}");
            output.close();
        }
        this.current_pkg = old_pkg;
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_value_type(IdlObject obj, File writeInto) {
        IdlValue value = (IdlValue)obj;
        boolean base_custom = false;
        PrintWriter output = this.newFile(writeInto, obj.name());
        this.cartouche(output, obj);
        if (value.abstract_value()) {
            output.println("public interface " + obj.name() + " extends org.omg.CORBA.portable.ValueBase");
            IdlValue[] abs_inheritance = value.getInheritance();
            if (abs_inheritance.length != 0) {
                output.print("\t\timplements ");
            }
            int i = 0;
            while (i < abs_inheritance.length) {
                output.print(this.fullname(abs_inheritance[i]));
                if (i + 1 < abs_inheritance.length) {
                    output.print(", ");
                }
                ++i;
            }
            if (value.supports().size() != 0) {
                if (abs_inheritance.length != 0) {
                    output.print(", ");
                } else {
                    output.print("\t\timplements ");
                }
                Vector list = value.supports();
                int i2 = 0;
                while (i2 < list.size()) {
                    IdlInterface itf = (IdlInterface)list.elementAt(i2);
                    output.print(itf.name());
                    if (!itf.abstract_interface()) {
                        output.print("Operations");
                    }
                    if (i2 + 1 < list.size()) {
                        output.print(", ");
                    }
                    ++i2;
                }
            }
            output.println("{");
            File intoMe = null;
            intoMe = !this.isEmptyValue(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
            String old_pkg = this.current_pkg;
            this.addToPkg(obj, obj.name() + "Package");
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 2: {
                        this.translate_enum(obj.current(), intoMe);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), intoMe);
                        break;
                    }
                    case 4: {
                        this.translate_union(obj.current(), intoMe);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(obj.current(), intoMe);
                        break;
                    }
                    case 14: {
                        this.translate_exception(obj.current(), intoMe);
                        break;
                    }
                    case 25: {
                        this.translate_native(obj.current(), intoMe);
                        break;
                    }
                    case 7: {
                        this.translate_constant(obj.current(), null, output);
                        break;
                    }
                    case 16: {
                        this.translate_operation(obj.current(), output);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(obj.current(), output);
                        break;
                    }
                }
                obj.next();
            }
            this.current_pkg = old_pkg;
            output.println("}");
            output.println("");
            output.close();
        } else {
            int i;
            output.print("public abstract class " + obj.name());
            if (value.supports().size() == 0 && value.getInheritance().length == 0) {
                if (value.custom_value()) {
                    output.println(" implements org.omg.CORBA.portable.CustomValue");
                } else {
                    output.println(" implements org.omg.CORBA.portable.StreamableValue");
                }
            } else {
                IdlValue[] inheritance = value.getInheritance();
                boolean extends_value = false;
                boolean streamNeed = false;
                if (inheritance.length == 0) {
                    streamNeed = true;
                }
                i = 0;
                while (i < inheritance.length) {
                    if (!inheritance[i].abstract_value()) {
                        extends_value = true;
                    }
                    if (inheritance[i].custom_value()) {
                        base_custom = true;
                    }
                    ++i;
                }
                if (!extends_value && value.supports().size() == 0 && value.getInheritance().length != 0) {
                    output.print(" implements org.omg.CORBA.portable.StreamableValue");
                }
                if (extends_value) {
                    output.print(" extends ");
                    int j = 0;
                    int i3 = 0;
                    while (i3 < inheritance.length) {
                        if (!inheritance[i3].abstract_value()) {
                            if (++j > 1) {
                                output.print(", ");
                            }
                            output.print(this.fullname(inheritance[i3]));
                        }
                        ++i3;
                    }
                }
                output.println("");
                boolean implement_map = false;
                if (value.custom_value() && !base_custom) {
                    output.print("\t\timplements org.omg.CORBA.portable.CustomValue");
                    implement_map = true;
                }
                if (value.supports().size() != 0) {
                    if (implement_map) {
                        output.print(", ");
                    } else {
                        output.print("\t\timplements ");
                        if (streamNeed) {
                            output.print("org.omg.CORBA.portable.StreamableValue, ");
                        }
                    }
                    Vector list = value.supports();
                    int i4 = 0;
                    while (i4 < list.size()) {
                        IdlInterface itf = (IdlInterface)list.elementAt(i4);
                        output.print(itf.name());
                        if (!itf.abstract_interface()) {
                            output.print("Operations");
                        }
                        if (i4 + 1 < list.size()) {
                            output.print(", ");
                        }
                        ++i4;
                    }
                }
                output.println("");
            }
            output.println("{");
            File intoMe = null;
            intoMe = !this.isEmptyValue(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
            String old_pkg = this.current_pkg;
            this.addToPkg(obj, obj.name() + "Package");
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 2: {
                        this.translate_enum(obj.current(), intoMe);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), intoMe);
                        break;
                    }
                    case 4: {
                        this.translate_union(obj.current(), intoMe);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(obj.current(), intoMe);
                        break;
                    }
                    case 14: {
                        this.translate_exception(obj.current(), intoMe);
                        break;
                    }
                    case 25: {
                        this.translate_native(obj.current(), intoMe);
                        break;
                    }
                    case 7: {
                        this.translate_constant(obj.current(), null, output);
                        break;
                    }
                    case 16: {
                        this.translate_operation(obj.current(), output);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(obj.current(), output);
                        break;
                    }
                    case 29: {
                        this.translate_state_member(obj.current(), output);
                        break;
                    }
                }
                obj.next();
            }
            this.current_pkg = old_pkg;
            output.println("\t//");
            output.println("\t// Return the truncatable ids");
            output.println("\t//");
            output.println("\tstatic final String[] _ids_list =");
            output.println("\t{");
            String[] list = value.truncatableList();
            int i5 = 0;
            while (i5 < list.length) {
                output.print("\t\t\"" + list[i5] + "\"");
                if (i5 + 1 < list.length) {
                    output.print(",");
                }
                output.println("");
                ++i5;
            }
            output.println("\t};");
            output.println("");
            output.println("\tpublic String [] _truncatable_ids()");
            output.println("\t{");
            output.println("\t\treturn _ids_list;");
            output.println("\t}");
            output.println("");
            if (!value.custom_value() && !base_custom) {
                output.println("\t//");
                output.println("\t// Unmarshal the value into an InputStream");
                output.println("\t//");
                output.println("\tpublic void _read( org.omg.CORBA.portable.InputStream is )");
                output.println("\t{");
                Vector stateList = this.getInheritedStateMember(obj);
                i = 0;
                while (i < stateList.size()) {
                    IdlStateMember state = (IdlStateMember)stateList.elementAt(i);
                    state.reset();
                    this.translate_unmarshalling_member(state.current(), output, "is", state.name(), "\t\t");
                    ++i;
                }
                output.println("\t}");
                output.println("");
                output.println("\t//");
                output.println("\t// Marshal the value into an OutputStream");
                output.println("\t//");
                output.println("\tpublic void _write( org.omg.CORBA.portable.OutputStream os )");
                output.println("\t{");
                i = 0;
                while (i < stateList.size()) {
                    IdlStateMember state = (IdlStateMember)stateList.elementAt(i);
                    state.reset();
                    this.translate_marshalling_member(state.current(), output, "os", state.name(), "\t\t");
                    ++i;
                }
                output.println("\t}");
                output.println("");
                output.println("\t//");
                output.println("\t// Return the value TypeCode");
                output.println("\t//");
                output.println("\tpublic org.omg.CORBA.TypeCode _type()");
                output.println("\t{");
                output.println("\t\treturn " + this.fullname(obj) + "Helper.type();");
                output.println("\t}");
                output.println("");
            }
            output.println("}");
            output.println("");
            output.close();
            boolean factory = false;
            obj.reset();
            while (!obj.end()) {
                if (obj.current().kind() == 30) {
                    factory = true;
                    break;
                }
                obj.next();
            }
            if (factory) {
                output = this.newFile(writeInto, obj.name() + "ValueFactory");
                this.cartouche(output, obj.current());
                output.println("public interface " + obj.name() + "ValueFactory extends org.omg.CORBA.portable.ValueFactory");
                output.println("{");
                obj.reset();
                while (!obj.end()) {
                    if (obj.current().kind() == 30) {
                        output.println("\t//");
                        output.println("\t// Return the value type");
                        output.println("\t//");
                        output.print("\tpublic abstract " + this.fullname(obj) + " " + obj.current().name() + "(");
                        obj.current().reset();
                        while (!obj.current().end()) {
                            IdlFactoryMember member = (IdlFactoryMember)obj.current().current();
                            member.reset();
                            this.translate_type(member.current(), output);
                            output.print(" " + member.name());
                            obj.current().next();
                            if (obj.current().end()) continue;
                            output.print(", ");
                        }
                        output.println(");");
                        output.println("");
                    }
                    obj.next();
                }
                output.println("}");
                output.println("");
                output.close();
            }
        }
        this.write_holder(obj, writeInto);
        this.write_helper(obj, writeInto);
    }

    public String find_default_value(IdlObject obj) {
        int idx = ((IdlUnion)obj).index();
        int p = obj.pos();
        obj.reset();
        IdlUnionMember disc = (IdlUnionMember)obj.current();
        disc.reset();
        switch (this.final_kind(disc.current())) {
            case 2: {
                IdlObject en = this.final_type(disc.current());
                obj.next();
                int l = 0;
                int i = 0;
                en.reset();
                String s = this.fullname(en.current());
                String ts = s + "@ ";
                while (!obj.end()) {
                    IdlUnionMember member_obj;
                    if (i != idx && ts.equals((member_obj = (IdlUnionMember)obj.current()).getExpression())) {
                        ++l;
                        i = -1;
                        en.next();
                        s = this.fullname(en.current());
                        ts = s + "@ ";
                        obj.reset();
                    }
                    ++i;
                    obj.next();
                }
                obj.pos(p);
                return s;
            }
        }
        int l = 0;
        int i = 0;
        obj.next();
        while (!obj.end()) {
            IdlUnionMember member_obj;
            String s;
            if (i != idx && l == new Integer(s = new String((member_obj = (IdlUnionMember)obj.current()).getExpression().substring(0, member_obj.getExpression().length() - 1)))) {
                ++l;
                i = -1;
                obj.reset();
            }
            ++i;
            obj.next();
        }
        obj.pos(p);
        return "" + l;
    }

    public void translate_attribute_tie(IdlObject obj, PrintWriter output) {
        output.println("\t//");
        output.println("\t// Read accessor for " + obj.name() + " attribute");
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("\t{");
        output.println("\t\treturn _tie." + obj.name() + "();");
        output.println("\t}");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("\t//");
            output.println("\t// Write accessor for " + obj.name() + " attribute");
            output.println("\t//");
            output.print("\tpublic void " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" value )");
            output.println("\t{");
            output.println("\t\t_tie." + obj.name() + "(value);");
            output.println("\t}");
            output.println("");
        }
    }

    public void translate_operation_tie(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        output.println("\t//");
        output.println("\t// Operation " + obj.name());
        output.println("\t//");
        output.print("\tpublic ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("\t\tthrows ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("\t{");
        obj.reset();
        output.print("\t\t");
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("return ");
            }
        } else {
            output.print("return ");
        }
        obj.next();
        output.print("_tie." + obj.name() + "(");
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        output.println(");");
        output.println("\t}");
        output.println("");
    }

    public File createDirectory(String name, File writeInto) {
        boolean init = false;
        char[] tab = new char[name.length() + 20];
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '.') {
                tab[j++] = this.sep.charAt(0);
                init = true;
            } else {
                tab[j++] = name.charAt(i);
            }
            ++i;
        }
        String fname = new String(tab, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + fname) : fname;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (init) {
            IdlCompiler.packageName = fname;
        }
        return file;
    }

    public void translate_any_insert(IdlObject obj, PrintWriter output, String aname, String tname) {
        IdlSimple simple = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.print("org.omg.CORBA.portable.ValueBaseHelper.insert(" + aname + ",(org.omg.CORBA.portable.ValueBase)" + tname + ")");
                    return;
                }
                output.print(aname + ".insert_");
                switch (simple.internal()) {
                    case 34: {
                        output.print("float((float)" + tname + ")");
                        break block0;
                    }
                    case 30: {
                        output.print("double((double)" + tname + ")");
                        break block0;
                    }
                    case 47: {
                        output.print("short((short)" + tname + ")");
                        break block0;
                    }
                    case 66: {
                        output.print("ushort((short)" + tname + ")");
                        break block0;
                    }
                    case 38: {
                        output.print("long((int)" + tname + ")");
                        break block0;
                    }
                    case 65: {
                        output.print("ulong((int)" + tname + ")");
                        break block0;
                    }
                    case 73: {
                        output.print("longlong((long)" + tname + ")");
                        break block0;
                    }
                    case 74: {
                        output.print("ulonglong((long)" + tname + ")");
                        break block0;
                    }
                    case 26: {
                        output.print("char(" + tname + ")");
                        break block0;
                    }
                    case 71: {
                        output.print("wchar(" + tname + ")");
                        break block0;
                    }
                    case 24: {
                        output.print("boolean(" + tname + ")");
                        break block0;
                    }
                    case 41: {
                        output.print("octet((byte)" + tname + ")");
                        break block0;
                    }
                    case 22: {
                        output.print("any(" + tname + ")");
                        break block0;
                    }
                    case 70: {
                        output.print("TypeCode(" + tname + ")");
                        break block0;
                    }
                    case 40: {
                        output.print("Object(" + tname + ")");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.print(aname + ".insert_fixed(" + tname + ")");
                break;
            }
            case 5: {
                output.print(aname + ".insert_string(" + tname + ")");
                break;
            }
            case 6: {
                output.print(aname + ".insert_wstring(" + tname + ")");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: {
                output.print(this.fullname(obj));
                output.print("Helper.insert(" + aname + "," + tname + ")");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.print("Helper.insert(" + aname + "," + tname + ")");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_any_insert(((IdlIdent)obj).internalObject(), output, aname, tname);
                break;
            }
        }
    }

    public void translate_native(IdlObject obj, File writeInto) {
        this.write_holder(obj, writeInto);
        this.write_helper(obj, writeInto);
    }

    public void translateUser(IdlObject obj, String packageName) {
        File writeInto;
        this._root = obj;
        File first = null;
        if (IdlCompiler.outdir != null) {
            first = new File(IdlCompiler.outdir);
        }
        this.initial = writeInto = this.getDirectory(packageName, first);
        this.translate_user_object(obj, writeInto);
    }

    public String fullname(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                if (obj2.kind() == 15 || obj2.kind() == 28 || obj2.kind() == 3 || obj2.kind() == 4 || obj2.kind() == 14) {
                    v.addElement(obj2.name() + "Package");
                } else {
                    v.addElement(obj2.name());
                }
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (!(IdlCompiler.packageName == null || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("corba_pkg") && !IdlCompiler.use_package)) {
            name = this.adaptToDot(IdlCompiler.packageName);
        }
        if (IdlCompiler.usePrefix && obj.getPrefix() != null) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + this.inversedPrefix(obj.getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String removePackageName(String expr) {
        int last = 0;
        int index = 0;
        String tmp = "";
        while (true) {
            if ((index = expr.indexOf("Package", last)) == -1) break;
            tmp = tmp + expr.substring(last, index);
            last = index + 7;
        }
        tmp = tmp + expr.substring(last, expr.length());
        return tmp;
    }

    protected Vector getInheritanceList(IdlObject obj, Vector inList) {
        IdlInterface itf = (IdlInterface)obj;
        if (itf.isForward()) {
            itf = itf.getInterface();
        }
        Vector list = itf.getInheritance();
        boolean found = false;
        int i = 0;
        while (i < inList.size()) {
            if (((String)inList.elementAt(i)).equals(obj.getId())) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            inList.addElement(obj.getId());
        }
        i = 0;
        while (i < list.size()) {
            inList = this.getInheritanceList((IdlObject)list.elementAt(i), inList);
            ++i;
        }
        return inList;
    }

    public File createPrefixDirectories(String prefix, File writeInto) {
        char[] tab = new char[prefix.length() + 20];
        String name = new String(this.inversedPrefix(prefix));
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            tab[j++] = name.charAt(i) == '.' ? this.sep.charAt(0) : name.charAt(i);
            ++i;
        }
        name = new String(tab, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public boolean isEmpty(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    public void translate_operation_skel(IdlObject obj, PrintWriter output) {
        int i = 0;
        boolean raises = false;
        boolean someParams = false;
        output.println("\t\t\torg.omg.CORBA.NVList argList = orb.create_list(0);");
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                output.println("\t\t\torg.omg.CORBA.Any arg" + i + " = orb.create_any();");
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("\t\t\targ" + i + ".type( ");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(" );");
                        output.println("\t\t\targList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_IN.value);");
                        break;
                    }
                    case 1: {
                        output.println("\t\t\targList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_OUT.value);");
                        break;
                    }
                    case 2: {
                        output.print("\t\t\targ" + i + ".type( ");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(" );");
                        output.println("\t\t\targList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_INOUT.value);");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        output.println("\t\t\trequest.arguments(argList);");
        output.println("");
        IdlContext c = this.getContext(obj);
        if (c != null) {
            output.println("\t\t\torg.omg.CORBA.Context arg_ctx = request.ctx();");
            output.println("");
        }
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("\t\t\t");
                        this.translate_type(obj.current().current(), output);
                        output.print(" arg" + i + "_in = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                    case 1: {
                        output.print("\t\t\t");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_out = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        break;
                    }
                    case 2: {
                        output.print("\t\t\t");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_inout = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        output.print("\t\t\targ" + i + "_inout.value = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("\t\t\ttry");
            output.println("\t\t\t{");
            raises = true;
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
                this.translate_type(obj.current(), output);
                output.print(" _arg_result = ");
            } else {
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
            }
        } else {
            if (raises) {
                output.print("\t");
            }
            output.print("\t\t\t");
            this.translate_type(obj.current(), output);
            output.print(" _arg_result = ");
        }
        output.print(obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("arg" + i + "_in");
                        break;
                    }
                    case 1: {
                        output.print("arg" + i + "_out");
                        break;
                    }
                    case 2: {
                        output.print("arg" + i + "_inout");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        i = 0;
        if (c != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("arg_ctx");
        }
        output.println(");");
        output.println("");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("\t");
                }
                output.println("\t\t\torg.omg.CORBA.Any any_result = orb.create_any();");
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
                this.translate_any_insert(obj.current(), output, "any_result", "_arg_result");
                output.println(";");
                if (raises) {
                    output.print("\t");
                }
                output.println("\t\t\trequest.set_result( any_result );");
            }
        } else {
            if (raises) {
                output.print("\t");
            }
            output.println("\t\t\torg.omg.CORBA.Any any_result = orb.create_any();");
            if (raises) {
                output.print("\t");
            }
            output.print("\t\t\t");
            this.translate_any_insert(obj.current(), output, "any_result", "_arg_result");
            output.println(";");
            if (raises) {
                output.print("\t");
            }
            output.println("\t\t\trequest.set_result( any_result );");
        }
        output.println("");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (raises) {
                            output.print("\t");
                        }
                        output.print("\t\t\t");
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, "arg" + i + "_out.value");
                        output.println(";");
                        break;
                    }
                    case 2: {
                        if (raises) {
                            output.print("\t");
                        }
                        output.print("\t\t\t");
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, "arg" + i + "_inout.value");
                        output.println(";");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            output.println("\t\t\t}");
            while (!r.end()) {
                output.println("\t\t\tcatch ( " + this.fullname(r.current()) + " ex )");
                output.println("\t\t\t{");
                output.println("\t\t\t\torg.omg.CORBA.Any any_ex = orb.create_any();");
                output.println("\t\t\t\t" + this.fullname(r.current()) + "Helper.insert(any_ex,ex);");
                output.println("\t\t\t\trequest.set_exception(any_ex);");
                output.println("\t\t\t}");
                r.next();
            }
        }
    }

    public void translateStub(IdlObject obj, String packageName) {
        this._root = obj;
        File first = null;
        if (IdlCompiler.outdir != null) {
            first = new File(IdlCompiler.outdir);
        }
        File writeInto = this.getDirectory(packageName, first);
        this.translate_object(obj, writeInto, 1);
    }

    public boolean isTruncatable(IdlObject obj) {
        IdlValue value = (IdlValue)obj;
        Vector inheritance = value.getInheritanceList();
        int i = 0;
        while (i < inheritance.size()) {
            if (((IdlValueInheritance)inheritance.elementAt(i)).truncatable_member()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String adaptToDot(String path) {
        char[] tmp = new char[path.length()];
        int i = 0;
        while (i < path.length()) {
            tmp[i] = path.charAt(i) == '/' || path.charAt(i) == '\\' ? 46 : path.charAt(i);
            ++i;
        }
        return new String(tmp);
    }

    public void javadoc(PrintWriter output, IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null) {
            description = comment.get_description();
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("\t");
            }
            output.println("/**");
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("\t");
            }
            output.print(" * ");
            this.translate_comment_section(output, description, obj);
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                switch (sections[i].kind().value()) {
                    case 0: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("\t");
                        }
                        output.print(" * @" + sections[i].get_title() + " ");
                        break;
                    }
                }
                description = sections[i].get_description();
                this.translate_comment_section(output, description, obj);
                ++i;
            }
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("\t");
            }
            output.println(" */");
        }
    }

    public boolean isNativeDefinition(IdlObject obj) {
        int i = 0;
        while (i < IdlCompiler.nativeDefinition.size()) {
            String s = (String)IdlCompiler.nativeDefinition.elementAt(i);
            int index = s.indexOf(58);
            String word = s.substring(0, index);
            if (obj.name().equals(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String translate_to_java_expression(String expr) {
        String newExpr = this.IdlScopeToJavaScope(expr, true);
        newExpr = this.IdlEspaceCharToJavaEscapeChar(newExpr);
        return newExpr;
    }

    public String translate_to_union_case_expression(IdlUnionMember disc, String expr) {
        String header = "";
        String newExpr = this.IdlScopeToJavaScope(expr, false);
        newExpr = this.IdlEspaceCharToJavaEscapeChar(newExpr);
        disc.reset();
        block0 : switch (this.final_type(disc.current()).kind()) {
            case 8: {
                IdlSimple simple = (IdlSimple)this.final_type(disc.current());
                switch (simple.internal()) {
                    case 47: 
                    case 66: {
                        header = "short)";
                        break block0;
                    }
                    case 38: 
                    case 65: {
                        header = "int)";
                        break block0;
                    }
                    case 73: 
                    case 74: {
                        header = "long)";
                        break block0;
                    }
                    case 26: 
                    case 71: {
                        header = "char)";
                        break block0;
                    }
                    case 24: {
                        header = "boolean)";
                        break block0;
                    }
                    case 41: {
                        header = "byte)";
                        break block0;
                    }
                }
                break;
            }
        }
        if (header.equals("")) {
            return newExpr;
        }
        return "(" + header + "(" + newExpr + ")";
    }

    public int recursion(IdlObject obj) {
        String name = this.final_type(obj.current()).name();
        int i = 0;
        if (this.final_type(obj.current()) instanceof IdlSimple) {
            return 0;
        }
        obj = obj.upper();
        while (obj != null) {
            if (this.final_type(obj).name() != null && this.final_type(obj).name().equals(name)) {
                return i;
            }
            ++i;
            if ((obj = obj.upper()) == null) {
                return i;
            }
            if (obj.kind() == 15 || obj.kind() == 1 || obj.kind() == 0) break;
        }
        return 0;
    }

    public void translate_union(IdlObject obj, File writeInto) {
        IdlUnionMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        int idx = ((IdlUnion)obj).index();
        boolean doMap = false;
        this.cartouche(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                    break;
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlUnionMember)obj.current();
            if (!member_obj.isAsNext()) {
                output.println("\t//");
                output.println("\t// Union member " + member_obj.name());
                output.println("\t//");
                output.print("\tprotected ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" _" + member_obj.name() + ";");
                output.println("");
            }
            obj.next();
        }
        output.println("\t//");
        output.println("\t// Default constructor");
        output.println("\t//");
        output.println("\tpublic " + obj.name() + "()");
        output.println("\t{");
        if (idx != -1) {
            output.println("\t\t__d = " + this.find_default_value(obj) + ";");
        }
        output.println("\t}");
        output.println("");
        obj.reset();
        output.println("\t//");
        output.println("\t// Get discriminator value");
        output.println("\t//");
        output.print("\tpublic ");
        IdlUnionMember discri = member_obj = (IdlUnionMember)obj.current();
        member_obj.reset();
        IdlObject disc = member_obj.current();
        this.translate_type(member_obj.current(), output);
        output.println(" discriminator()");
        output.println("\t{");
        output.println("\t\treturn __d;");
        output.println("\t}");
        output.println("");
        obj.next();
        int i = 0;
        while (!obj.end()) {
            member_obj = (IdlUnionMember)obj.current();
            if (!member_obj.isAsNext()) {
                doMap = false;
                output.println("\t//");
                output.println("\t// Set " + member_obj.name() + " value");
                output.println("\t//");
                output.print("\tpublic void " + member_obj.name() + "( ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" value )");
                output.println("\t{");
                if (i != idx) {
                    output.println("\t\t__d = " + this.translate_to_union_case_expression(discri, member_obj.getExpression()) + ";");
                } else {
                    output.println("\t\t__d = " + this.find_default_value(obj) + ";");
                }
                output.println("\t\t_" + member_obj.name() + " = value;");
                output.println("\t}");
                output.println("");
                if (i == idx) {
                    output.println("\t//");
                    output.println("\t// Set " + member_obj.name() + " value");
                    output.println("\t//");
                    output.print("\tpublic void " + member_obj.name() + "( ");
                    this.translate_type(disc, output);
                    output.print(" dvalue, ");
                    member_obj.reset();
                    this.translate_type(member_obj.current(), output);
                    output.println(" value )");
                    output.println("\t{");
                    output.println("\t\t__d = dvalue;");
                    output.println("\t\t_" + member_obj.name() + " = value;");
                    output.println("\t}");
                    output.println("");
                }
                output.println("\t//");
                output.println("\t// Get " + member_obj.name() + " value");
                output.println("\t//");
                output.print("\tpublic ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" " + member_obj.name() + "()");
                output.println("\t{");
                output.println("\t\treturn _" + member_obj.name() + ";");
                output.println("\t}");
                output.println("");
            } else if (!doMap) {
                output.println("\t//");
                output.println("\t// Set " + member_obj.name() + " value");
                output.println("\t//");
                output.print("\tpublic void " + member_obj.name() + "( ");
                this.translate_type(disc, output);
                output.print(" dvalue, ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" value )");
                output.println("\t{");
                output.println("\t\t__d = dvalue;");
                output.println("\t\t_" + member_obj.name() + " = value;");
                output.println("\t}");
                output.println("");
                doMap = true;
            }
            obj.next();
            ++i;
        }
        if (idx == -1) {
            output.println("\t//");
            output.println("\t// default access");
            output.println("\t//");
            output.println("\tpublic void __default()");
            output.println("\t{");
            output.println("\t}");
        }
        obj.reset();
        obj.next();
        if (((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
            output.println("\t//");
            output.println("\t// Return an int value for discriminator");
            output.println("\t//");
            output.println("\tpublic int toInt()");
            output.println("\t{");
            output.println("\tif ( __d == true )");
            output.println("\t\treturn 1;");
            output.println("\treturn 0;");
            output.println("\t}");
        }
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_user_object(IdlObject obj, File writeInto) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translate_user_module(obj.current(), writeInto);
                        break;
                    }
                    case 15: {
                        this.translate_user_interface(obj.current(), writeInto);
                        break;
                    }
                }
            }
            obj.next();
        }
    }

    public void translateTIE(IdlObject obj, String packageName) {
        this._root = obj;
        if (IdlCompiler.pidl) {
            return;
        }
        File first = null;
        if (IdlCompiler.outdir != null) {
            first = new File(IdlCompiler.outdir);
        }
        File writeInto = this.getDirectory(packageName, first);
        this.translate_object(obj, writeInto, 3);
    }

    public boolean isInto(Vector opList, String op) {
        int i = 0;
        while (i < opList.size()) {
            if (op.equals(((IdlObject)opList.elementAt(i)).name())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IdlToJava2_3() {
        this.sep = System.getProperty("file.separator");
    }

    public void translate_new_typecode(IdlObject obj, PrintWriter output) {
        switch (obj.kind()) {
            case 2: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.println("\t\t\tString []_members = new String[" + obj.length() + "];");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("\t\t\t_members[" + i + "] = new String(\"" + obj.current().name() + "\");");
                    ++i;
                    obj.next();
                }
                output.println("\t\t\t_tc = orb.create_enum_tc(id(),\"" + obj.name() + "\",_members);");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 3: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.println("\t\t\torg.omg.CORBA.StructMember []_members = new org.omg.CORBA.StructMember[" + obj.length() + "];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("\t\t\t_members[" + i + "] = new org.omg.CORBA.StructMember();");
                    output.println("\t\t\t_members[" + i + "].name = \"" + obj.current().name() + "\";");
                    output.print("\t\t\t_members[" + i + "].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                output.println("\t\t\t_tc = orb.create_struct_tc(id(),\"" + obj.name() + "\",_members);");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 4: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.println("\t\t\torg.omg.CORBA.UnionMember []_members = new org.omg.CORBA.UnionMember[" + (obj.length() - 1) + "];");
                output.println("\t\t\torg.omg.CORBA.Any any;");
                output.println("");
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                IdlUnionMember disc = (IdlUnionMember)obj.current();
                disc.reset();
                obj.next();
                int i = 0;
                while (!obj.end()) {
                    output.println("\t\t\tany = orb.create_any();");
                    if (i != idx) {
                        output.print("\t\t\t");
                        this.translate_any_insert(disc.current(), output, "any", this.translate_to_union_case_expression(disc, ((IdlUnionMember)obj.current()).getExpression()));
                        output.println(";");
                    } else {
                        output.println("\t\t\tany.insert_octet((byte)0);");
                    }
                    output.println("\t\t\t_members[" + i + "] = new org.omg.CORBA.UnionMember();");
                    output.println("\t\t\t_members[" + i + "].name = \"" + obj.current().name() + "\";");
                    output.println("\t\t\t_members[" + i + "].label = any;");
                    output.print("\t\t\t_members[" + i + "].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                obj.reset();
                output.print("\t\t\t_tc = orb.create_union_tc(id(),\"" + obj.name() + "\",");
                this.translate_typecode(obj.current().current(), output);
                output.println(",_members);");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 13: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.print("\t\t\t_tc = orb.create_alias_tc(id(),\"" + obj.name() + "\",");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.println(");");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 14: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.println("\t\t\torg.omg.CORBA.StructMember []_members = new org.omg.CORBA.StructMember[" + obj.length() + "];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("\t\t\t_members[" + i + "] = new org.omg.CORBA.StructMember();");
                    output.println("\t\t\t_members[" + i + "].name = \"" + obj.current().name() + "\";");
                    output.print("\t\t\t_members[" + i + "].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                output.println("\t\t\t_tc = orb.create_exception_tc(id(),\"" + obj.name() + "\",_members);");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 15: 
            case 18: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("\t\t\t_tc = orb.create_abstract_interface_tc(id(),\"" + obj.name() + "\");");
                } else {
                    output.println("\t\t\t_tc = orb.create_interface_tc(id(),\"" + obj.name() + "\");");
                }
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 25: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.println("\t\t\t_tc = orb.create_native_tc(id(),\"" + obj.name() + "\");");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 27: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                output.print("\t\t\t_tc = orb.create_value_box_tc(id(),\"" + obj.name() + "\",");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.println(");");
                output.println("\t\t\treturn _tc;");
                break;
            }
            case 28: {
                if (IdlCompiler.portable) {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                } else {
                    output.println("\t\t\torg.omg.CORBA.ORB orb = new JavaORB.CORBA.ORBSingleton();");
                }
                int nbvalue = 0;
                obj.reset();
                while (!obj.end()) {
                    if (obj.current().kind() == 29) {
                        ++nbvalue;
                    }
                    obj.next();
                }
                output.println("\t\t\torg.omg.CORBA.ValueMember []_members = new org.omg.CORBA.ValueMember[" + nbvalue + "];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    if (obj.current().kind() == 29) {
                        output.println("\t\t\t_members[" + i + "] = new org.omg.CORBA.ValueMember();");
                        output.println("\t\t\t_members[" + i + "].name = \"" + obj.current().name() + "\";");
                        output.print("\t\t\t_members[" + i + "].type = ");
                        obj.current().reset();
                        this.translate_typecode(obj.current().current(), output);
                        output.println(";");
                        output.print("\t\t\t_members[" + i + "].access = ");
                        if (((IdlStateMember)obj.current()).public_member()) {
                            output.println("org.omg.CORBA.PUBLIC_MEMBER.value;");
                        } else {
                            output.println("org.omg.CORBA.PRIVATE_MEMBER.value;");
                        }
                        ++i;
                    }
                    obj.next();
                }
                output.println("");
                output.print("\t\t\torg.omg.CORBA.TypeCode _concrete_tc = ");
                this.printConcreteTypeCode(obj, output);
                output.println(";");
                output.println("");
                output.print("\t\t\t_tc = orb.create_value_tc(id(),\"" + obj.name() + "\",");
                if (((IdlValue)obj).abstract_value()) {
                    output.print("org.omg.CORBA.VM_ABSTRACT.value");
                } else if (((IdlValue)obj).custom_value()) {
                    output.print("org.omg.CORBA.VM_CUSTOM.value");
                } else if (this.isTruncatable(obj)) {
                    output.print("org.omg.CORBA.VM_TRUNCATABLE.value");
                } else {
                    output.print("org.omg.CORBA.VM_NONE.value");
                }
                output.println(",_concrete_tc,_members);");
                output.println("\t\t\treturn _tc;");
                break;
            }
        }
    }

    public void translate_constant(IdlObject obj, File writeInto, PrintWriter print) {
        IdlConst const_obj = (IdlConst)obj;
        PrintWriter output = null;
        if (const_obj.into(15) || const_obj.into(28)) {
            print.println("\t//");
            print.println("\t// Constant value");
            print.println("\t//");
            print.print("\tpublic static final ");
            this.translate_type(obj.current(), print);
            print.print(" " + obj.name() + " = (");
            obj.reset();
            this.translate_type(obj.current(), print);
            print.println(") ( " + this.translate_to_java_expression(const_obj.expression()) + " );");
            print.println("");
        } else {
            output = this.newFile(writeInto, obj.name());
            this.cartouche(output, obj);
            output.println("public interface " + obj.name());
            output.println("{");
            output.println("\t//");
            output.println("\t// Constant value");
            output.println("\t//");
            output.print("\tpublic static final ");
            this.translate_type(obj.current(), output);
            output.print(" value = (");
            obj.reset();
            this.translate_type(obj.current(), output);
            output.println(") ( " + this.translate_to_java_expression(const_obj.expression()) + " );");
            output.println("}");
            output.close();
        }
    }

    public void translate_operation_skel_stream(IdlObject obj, PrintWriter output) {
        int i = 0;
        boolean raises = false;
        boolean someParams = false;
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("\t\t\t");
                        this.translate_type(obj.current().current(), output);
                        output.print(" arg" + i + "_in = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "_is");
                        break;
                    }
                    case 1: {
                        output.print("\t\t\t");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_out = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        break;
                    }
                    case 2: {
                        output.print("\t\t\t");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_inout = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        output.print("\t\t\targ" + i + "_inout.value = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "_is");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        IdlContext c = this.getContext(obj);
        if (c != null) {
            output.println("\t\t\torg.omg.CORBA.Context arg_ctx = _is.read_Context();");
            output.println("");
        }
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("\t\t\ttry");
            output.println("\t\t\t{");
            raises = true;
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
                this.translate_type(obj.current(), output);
                output.print(" _arg_result = ");
            } else {
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
            }
        } else {
            if (raises) {
                output.print("\t");
            }
            output.print("\t\t\t");
            this.translate_type(obj.current(), output);
            output.print(" _arg_result = ");
        }
        output.print(obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("arg" + i + "_in");
                        break;
                    }
                    case 1: {
                        output.print("arg" + i + "_out");
                        break;
                    }
                    case 2: {
                        output.print("arg" + i + "_inout");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        i = 0;
        if (c != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("arg_ctx");
        }
        output.println(");");
        output.println("");
        if (raises) {
            output.print("\t");
        }
        output.println("\t\t\t_output = handler.createReply();");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("\t");
                }
                output.print("\t\t\t");
                this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
            }
        } else {
            if (raises) {
                output.print("\t");
            }
            output.print("\t\t\t");
            this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
        }
        output.println("");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (raises) {
                            output.print("\t");
                        }
                        output.print("\t\t\t");
                        this.translate_marshalling_data(obj.current().current(), output, "_output", "arg" + i + "_out.value");
                        break;
                    }
                    case 2: {
                        if (raises) {
                            output.print("\t");
                        }
                        output.print("\t\t\t");
                        this.translate_marshalling_data(obj.current().current(), output, "_output", "arg" + i + "_inout.value");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            output.println("\t\t\t}");
            while (!r.end()) {
                output.println("\t\t\tcatch ( " + this.fullname(r.current()) + " _exception )");
                output.println("\t\t\t{");
                output.println("\t\t\t\t_output = handler.createExceptionReply();");
                output.println("\t\t\t\t" + this.fullname(r.current()) + "Helper.write(_output,_exception);");
                output.println("\t\t\t}");
                r.next();
            }
        }
        output.println("\t\t\treturn _output;");
    }

    public void translate_object_content(IdlObject obj, File writeInto, int translateType) {
        switch (obj.current().kind()) {
            case 1: {
                this.translate_module(obj.current(), writeInto, translateType);
                break;
            }
            case 7: {
                if (translateType != 0) break;
                this.translate_constant(obj.current(), writeInto, null);
                break;
            }
            case 2: {
                if (translateType != 0) break;
                this.translate_enum(obj.current(), writeInto);
                break;
            }
            case 3: {
                if (translateType != 0) break;
                this.translate_struct(obj.current(), writeInto);
                break;
            }
            case 4: {
                if (translateType != 0) break;
                this.translate_union(obj.current(), writeInto);
                break;
            }
            case 13: {
                if (translateType != 0) break;
                this.translate_typedef(obj.current(), writeInto);
                break;
            }
            case 14: {
                if (translateType != 0) break;
                this.translate_exception(obj.current(), writeInto);
                break;
            }
            case 25: {
                if (translateType != 0) break;
                this.translate_native(obj.current(), writeInto);
                break;
            }
            case 27: {
                if (translateType != 0) break;
                this.translate_value_box(obj.current(), writeInto);
                break;
            }
            case 28: {
                if (translateType != 0) break;
                this.translate_value_type(obj.current(), writeInto);
                break;
            }
            case 15: {
                if (translateType == 0) {
                    this.translate_interface(obj.current(), writeInto);
                    break;
                }
                if (translateType == 1) {
                    if (((IdlInterface)obj.current()).local_interface()) break;
                    this.translate_interface_stub(obj.current(), writeInto);
                    break;
                }
                if (translateType == 2) {
                    if (((IdlInterface)obj.current()).abstract_interface() || ((IdlInterface)obj.current()).local_interface()) break;
                    this.translate_interface_skel(obj.current(), writeInto);
                    break;
                }
                if (translateType != 3 || ((IdlInterface)obj.current()).abstract_interface() || ((IdlInterface)obj.current()).local_interface()) break;
                this.translate_interface_tie(obj.current(), writeInto);
                break;
            }
        }
    }

    public void translate_unmarshalling_member(IdlObject obj, PrintWriter output, String inname, String tname, String space) {
        IdlSimple simple = null;
        String array_name = null;
        IdlObject o = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println(space + tname + " = org.omg.CORBA.portable.ValueBaseHelper.read(" + inname + ");");
                    return;
                }
                output.print(space + tname + " = " + inname + ".read");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float();");
                        break block0;
                    }
                    case 30: {
                        output.println("_double();");
                        break block0;
                    }
                    case 47: {
                        output.println("_short();");
                        break block0;
                    }
                    case 66: {
                        output.println("_ushort();");
                        break block0;
                    }
                    case 38: {
                        output.println("_long();");
                        break block0;
                    }
                    case 65: {
                        output.println("_ulong();");
                        break block0;
                    }
                    case 73: {
                        output.println("_longlong();");
                        break block0;
                    }
                    case 74: {
                        output.println("_ulonglong();");
                        break block0;
                    }
                    case 26: {
                        output.println("_char();");
                        break block0;
                    }
                    case 71: {
                        output.println("_wchar();");
                        break block0;
                    }
                    case 24: {
                        output.println("_boolean();");
                        break block0;
                    }
                    case 41: {
                        output.println("_octet();");
                        break block0;
                    }
                    case 22: {
                        output.println("_any();");
                        break block0;
                    }
                    case 70: {
                        output.println("_TypeCode();");
                        break block0;
                    }
                    case 40: {
                        output.println("_Object();");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.println(space + tname + " =" + inname + ".read_fixed();");
                break;
            }
            case 5: {
                output.println(space + tname + " = " + inname + ".read_string();");
                break;
            }
            case 6: {
                output.println(space + tname + " = " + inname + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(space + tname + " = " + this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 13: {
                output.print(space + tname + " = " + this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 24: {
                int val = space.length() - 1;
                output.println(space + "{");
                output.println(space + "int size" + val + " = " + ((IdlArray)obj).getDimension() + ";");
                output.print(space + tname + " = new ");
                obj.reset();
                o = this.final_type(obj.current());
                int next = 0;
                while (o.kind() == 24 || o.kind() == 9) {
                    o.reset();
                    ++next;
                    o = this.final_type(o.current());
                }
                this.translate_type(o, output);
                output.print("[size" + val + "]");
                int i = 0;
                while (i < next) {
                    output.print("[]");
                    ++i;
                }
                output.println(";");
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    output.println(space + "for ( int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + " {");
                    this.translate_unmarshalling_member(obj.current(), output, inname, tname + "[i" + val + "]", space + "\t");
                    output.println("");
                    output.println(space + " }");
                } else {
                    output.println(space + inname + ".read_" + array_name + "_array(" + tname + ", 0, " + tname + ".length);");
                }
                output.println(space + "}");
                break;
            }
            case 9: {
                int val = space.length() - 1;
                output.println(space + "{");
                output.println(space + "int size" + val + " = " + inname + ".read_ulong();");
                output.print(space + tname + " = new ");
                obj.reset();
                o = this.final_type(obj.current());
                int next = 0;
                while (o.kind() == 24 || o.kind() == 9) {
                    o.reset();
                    ++next;
                    o = this.final_type(o.current());
                }
                this.translate_type(o, output);
                output.print("[size" + val + "]");
                int i = 0;
                while (i < next) {
                    output.print("[]");
                    ++i;
                }
                output.println(";");
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    output.println(space + "for ( int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + " {");
                    this.translate_unmarshalling_member(obj.current(), output, inname, tname + "[i" + val + "]", space + "\t");
                    output.println("");
                    output.println(space + " }");
                } else {
                    output.println(space + inname + ".read_" + array_name + "_array(" + tname + ", 0, " + tname + ".length);");
                }
                output.println(space + "}");
                break;
            }
            case 10: {
                this.translate_unmarshalling_member(((IdlIdent)obj).internalObject(), output, inname, tname, space);
                break;
            }
        }
    }

    public boolean isEnumCase(String expr) {
        boolean isEnum = false;
        if (expr.indexOf("@") != -1) {
            isEnum = true;
        }
        return isEnum;
    }

    public void translate_typedef(IdlObject obj, File writeInto) {
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 4: {
                    this.translate_union(obj.current(), writeInto);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current(), writeInto);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current(), writeInto);
                    break;
                }
            }
            obj.next();
        }
        obj.reset();
        switch (obj.current().kind()) {
            case 5: 
            case 6: 
            case 8: {
                this.write_helper(obj, writeInto);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.write_helper(obj, writeInto);
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                this.write_helper(obj, writeInto);
                this.write_holder(obj, writeInto);
                break;
            }
            case 10: {
                this.write_helper(obj, writeInto);
                if (this.final_type(obj.current()).kind() != 9 && this.final_type(obj.current()).kind() != 24) break;
                this.write_holder(obj, writeInto);
                break;
            }
            case 13: {
                this.write_helper(obj, writeInto);
                break;
            }
        }
    }

    public void translate_marshalling(IdlObject obj, PrintWriter output, String outname, String tname) {
        block0 : switch (obj.kind()) {
            case 8: {
                if (((IdlSimple)obj).internal() != 70) break;
                output.println("\t\t" + outname + ".write_TypeCode(" + tname + ");");
                break;
            }
            case 2: {
                output.println("\t\t" + outname + ".write_long(" + tname + ".value());");
                break;
            }
            case 3: {
                obj.reset();
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_marshalling_member(obj.current().current(), output, outname, tname + "." + obj.current().name(), "\t\t");
                    obj.next();
                }
                break;
            }
            case 4: {
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                obj.current().reset();
                boolean enumeration = false;
                if (this.final_kind(obj.current().current()) == 2) {
                    enumeration = true;
                }
                this.translate_marshalling_member(obj.current().current(), output, outname, tname + "._" + obj.current().name(), "\t\t");
                obj.next();
                if (((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                    output.println("\t\tswitch ( " + tname + ".toInt() ) ");
                } else if (enumeration) {
                    output.println("\t\tswitch ( " + tname + ".discriminator().value() )");
                } else {
                    output.println("\t\tswitch ( " + tname + ".discriminator() )");
                }
                output.println("\t\t{");
                int i = 0;
                while (!obj.end()) {
                    if (i != idx) {
                        if (((IdlUnionMember)obj.current()).getExpression().equals("true ")) {
                            output.println("\t\tcase 1 :");
                        } else if (((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                            output.println("\t\tcase 0 :");
                        } else {
                            output.println("\t\tcase " + this.translate_to_java_expression(((IdlUnionMember)obj.current()).getExpression()) + ":");
                        }
                    } else {
                        output.println("\t\tdefault :");
                    }
                    if (!((IdlUnionMember)obj.current()).isAsNext()) {
                        obj.current().reset();
                        this.translate_marshalling_member(obj.current().current(), output, outname, tname + "._" + obj.current().name(), "\t\t\t");
                        output.println("\t\t\tbreak;");
                    }
                    obj.next();
                    ++i;
                }
                output.println("\t\t}");
                break;
            }
            case 13: {
                obj.reset();
                switch (obj.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: {
                        this.translate_marshalling_member(obj.current(), output, outname, tname, "\t\t");
                        break block0;
                    }
                }
                this.translate_marshalling(obj.current(), output, outname, tname);
                break;
            }
            case 10: {
                this.translate_marshalling(((IdlIdent)obj).internalObject(), output, outname, tname);
                break;
            }
            case 14: {
                output.println("\t\t" + outname + ".write_string( id() );");
                obj.reset();
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_marshalling_member(obj.current().current(), output, outname, tname + "." + obj.current().name(), "\t\t");
                    obj.next();
                }
                break;
            }
            case 25: {
                output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)obj).local_interface()) {
                    output.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_abstract_interface(" + tname + ");");
                    break;
                }
                output.println("\t\t" + outname + ".write_Object((org.omg.CORBA.portable.ObjectImpl)" + tname + ");");
                break;
            }
            case 27: {
                obj.reset();
                if (((IdlValueBox)obj).simple()) {
                    output.println("\t\t" + obj.name() + " _box = (" + obj.name() + ")" + tname + ";");
                    this.translate_marshalling_member(obj.current(), output, outname, "_box.value", "\t\t");
                    break;
                }
                output.print("\t\t");
                this.translate_type(obj.current(), output);
                output.print(" _box = (");
                this.translate_type(obj.current(), output);
                output.println(")" + tname + ";");
                this.translate_marshalling_member(obj.current(), output, outname, "_box", "\t\t");
                break;
            }
            case 28: {
                if (((IdlValue)obj).abstract_value()) {
                    output.println("\t\tthrow new org.omg.CORBA.BAD_OPERATION();");
                    break;
                }
                output.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_value(" + tname + ");");
                break;
            }
        }
    }

    public void translate_typecode(IdlObject obj, PrintWriter output) {
        IdlSimple simple = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                output.print("orb.get_primitive_tc(org.omg.CORBA.TCKind.");
                switch (simple.internal()) {
                    case 34: {
                        output.print("tk_float)");
                        break block0;
                    }
                    case 30: {
                        output.print("tk_double)");
                        break block0;
                    }
                    case 47: {
                        output.print("tk_short)");
                        break block0;
                    }
                    case 66: {
                        output.print("tk_ushort)");
                        break block0;
                    }
                    case 38: {
                        output.print("tk_long)");
                        break block0;
                    }
                    case 65: {
                        output.print("tk_ulong)");
                        break block0;
                    }
                    case 73: {
                        output.print("tk_longlong)");
                        break block0;
                    }
                    case 74: {
                        output.print("tk_ulonglong)");
                        break block0;
                    }
                    case 26: {
                        output.print("tk_char)");
                        break block0;
                    }
                    case 71: {
                        output.print("tk_wchar)");
                        break block0;
                    }
                    case 24: {
                        output.print("tk_boolean)");
                        break block0;
                    }
                    case 41: {
                        output.print("tk_octet)");
                        break block0;
                    }
                    case 22: {
                        output.print("tk_any)");
                        break block0;
                    }
                    case 70: {
                        output.print("tk_TypeCode)");
                        break block0;
                    }
                    case 40: {
                        output.print("tk_objref)");
                        break block0;
                    }
                    case 88: {
                        output.print("tk_value)");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.print("orb.create_fixed_tc(" + ((IdlFixed)obj).digits() + "," + ((IdlFixed)obj).scale() + ")");
                break;
            }
            case 5: {
                if (((IdlString)obj).maxSize() == 0) {
                    output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_string )");
                    break;
                }
                output.print("orb.create_string_tc(" + ((IdlString)obj).maxSize() + ")");
                break;
            }
            case 6: {
                if (((IdlWString)obj).maxSize() == 0) {
                    output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_wstring )");
                    break;
                }
                output.print("orb.create_wstring_tc(" + ((IdlWString)obj).maxSize() + ")");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.print("Helper.type()");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.print("Helper.type()");
                break;
            }
            case 9: {
                output.print("orb.create_sequence_tc(");
                output.print(((IdlSequence)obj).getSize() + ",");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.print(")");
                break;
            }
            case 24: {
                output.print("orb.create_array_tc(");
                output.print(((IdlArray)obj).getDimension() + ",");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.print(")");
                break;
            }
            case 10: {
                this.translate_typecode(((IdlIdent)obj).internalObject(), output);
                break;
            }
            default: {
                System.out.println("Unexpected... : " + obj.kind());
                break;
            }
        }
    }

    public void printConcreteTypeCode(IdlObject obj, PrintWriter output) {
        IdlValue value = (IdlValue)obj;
        IdlValue[] inheritance = value.getInheritance();
        int i = 0;
        while (i < inheritance.length) {
            if (!inheritance[i].abstract_value()) {
                this.translate_typecode(inheritance[i], output);
                return;
            }
            ++i;
        }
        output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_null )");
    }

    public void translate_unmarshalling_data(IdlObject obj, PrintWriter output, String inname) {
        IdlSimple simple = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("org.omg.CORBA.portable.ValueBaseHelper.read(" + inname + ");");
                    return;
                }
                output.print(inname + ".read");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float();");
                        break block0;
                    }
                    case 30: {
                        output.println("_double();");
                        break block0;
                    }
                    case 47: {
                        output.println("_short();");
                        break block0;
                    }
                    case 66: {
                        output.println("_ushort();");
                        break block0;
                    }
                    case 38: {
                        output.println("_long();");
                        break block0;
                    }
                    case 65: {
                        output.println("_ulong();");
                        break block0;
                    }
                    case 73: {
                        output.println("_longlong();");
                        break block0;
                    }
                    case 74: {
                        output.println("_ulonglong();");
                        break block0;
                    }
                    case 26: {
                        output.println("_char();");
                        break block0;
                    }
                    case 71: {
                        output.println("_wchar();");
                        break block0;
                    }
                    case 24: {
                        output.println("_boolean();");
                        break block0;
                    }
                    case 41: {
                        output.println("_octet();");
                        break block0;
                    }
                    case 22: {
                        output.println("_any();");
                        break block0;
                    }
                    case 70: {
                        output.println("_TypeCode();");
                        break block0;
                    }
                    case 40: {
                        output.println("_Object();");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.println(inname + ".read_fixed();");
                break;
            }
            case 5: {
                output.println(inname + ".read_string();");
                break;
            }
            case 6: {
                output.println(inname + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_unmarshalling_data(((IdlIdent)obj).internalObject(), output, inname);
                break;
            }
        }
    }

    public void translateData(IdlObject obj, String packageName) {
        this._root = obj;
        File first = null;
        if (IdlCompiler.outdir != null) {
            first = new File(IdlCompiler.outdir);
        }
        File writeInto = this.createDirectory(packageName, first);
        this.translate_object(obj, writeInto, 0);
    }

    public boolean isEmptyValue(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    public void translate_value_box(IdlObject obj, File writeInto) {
        IdlValueBox value = (IdlValueBox)obj;
        if (value.simple()) {
            PrintWriter output = this.newFile(writeInto, obj.name());
            this.cartouche(output, obj);
            output.println("public class " + obj.name() + " implements org.omg.CORBA.portable.ValueBase");
            output.println("{");
            output.println("\t//");
            output.println("\t// Reference to the boxed value");
            output.println("\t//");
            output.print("\tpublic ");
            obj.reset();
            this.translate_type(obj.current(), output);
            output.println(" value;");
            output.println("");
            output.println("\t//");
            output.println("\t// Constructor");
            output.println("\t//");
            output.println("\t// @param initial the initial boxed value");
            output.println("\t//");
            output.print("\tpublic " + obj.name() + "( ");
            this.translate_type(obj.current(), output);
            output.println(" initial )");
            output.println("\t{");
            output.println("\t\tvalue = initial;");
            output.println("\t}");
            output.println("");
            output.println("\t//");
            output.println("\t// Return value box id");
            output.println("\t//");
            output.println("\tprivate static String[] _ids = { " + obj.name() + "Helper.id() };");
            output.println("");
            output.println("\t//");
            output.println("\t// Return truncatable ids");
            output.println("\t//");
            output.println("\tpublic String[] _truncatable_ids()");
            output.println("\t{");
            output.println("\t\treturn _ids;");
            output.println("\t}");
            output.println("");
            output.println("}");
            output.close();
            this.write_holder(obj, writeInto);
            this.write_helper(obj, writeInto);
        } else {
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 4: {
                        this.translate_union(obj.current(), writeInto);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), writeInto);
                        break;
                    }
                    case 2: {
                        this.translate_enum(obj.current(), writeInto);
                        break;
                    }
                }
                obj.next();
            }
            obj.reset();
            switch (obj.current().kind()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 24: 
                case 26: {
                    this.write_helper(obj, writeInto);
                    this.write_holder(obj, writeInto);
                    break;
                }
            }
        }
    }

    public IdlContext getContext(IdlObject obj) {
        int p = obj.pos();
        IdlObject find = null;
        obj.reset();
        while (!obj.end()) {
            if (obj.current().kind() == 21) {
                find = obj.current();
                break;
            }
            obj.next();
        }
        obj.pos(p);
        return (IdlContext)find;
    }

    public void translate_type(IdlObject obj, PrintWriter output) {
        IdlSimple simple = null;
        block0 : switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        output.print("void");
                        break block0;
                    }
                    case 34: {
                        output.print("float");
                        break block0;
                    }
                    case 30: {
                        output.print("double");
                        break block0;
                    }
                    case 47: 
                    case 66: {
                        output.print("short");
                        break block0;
                    }
                    case 38: 
                    case 65: {
                        output.print("int");
                        break block0;
                    }
                    case 73: 
                    case 74: {
                        output.print("long");
                        break block0;
                    }
                    case 26: 
                    case 71: {
                        output.print("char");
                        break block0;
                    }
                    case 24: {
                        output.print("boolean");
                        break block0;
                    }
                    case 41: {
                        output.print("byte");
                        break block0;
                    }
                    case 22: {
                        output.print("org.omg.CORBA.Any");
                        break block0;
                    }
                    case 70: {
                        output.print("org.omg.CORBA.TypeCode");
                        break block0;
                    }
                    case 40: {
                        output.print("org.omg.CORBA.Object");
                        break block0;
                    }
                    case 88: {
                        output.print("java.io.Serializable");
                        break block0;
                    }
                }
                break;
            }
            case 26: {
                output.print("java.math.BigDecimal");
                break;
            }
            case 5: 
            case 6: {
                output.print("java.lang.String");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                break;
            }
            case 25: {
                if (this.isNativeDefinition(obj)) {
                    this.printNativeDefinition(obj, output);
                    break;
                }
                output.print(this.fullname(obj));
                break;
            }
            case 13: {
                obj.reset();
                this.translate_type(obj.current(), output);
                break;
            }
            case 9: 
            case 24: {
                this.translate_type(obj.current(), output);
                output.print("[]");
                break;
            }
            case 10: {
                this.translate_type(((IdlIdent)obj).internalObject(), output);
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    output.print(this.fullname(obj));
                    break;
                }
                obj.reset();
                this.translate_type(obj.current(), output);
                break;
            }
        }
    }
}

