/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler.parser;

import JavaORB.CORBA.TypeCode;
import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.object.IdlArray;
import JavaORB.compiler.object.IdlAttribute;
import JavaORB.compiler.object.IdlConst;
import JavaORB.compiler.object.IdlContext;
import JavaORB.compiler.object.IdlEnum;
import JavaORB.compiler.object.IdlEnumMember;
import JavaORB.compiler.object.IdlExcept;
import JavaORB.compiler.object.IdlFactory;
import JavaORB.compiler.object.IdlFactoryMember;
import JavaORB.compiler.object.IdlIdent;
import JavaORB.compiler.object.IdlInterface;
import JavaORB.compiler.object.IdlModule;
import JavaORB.compiler.object.IdlNative;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.object.IdlOp;
import JavaORB.compiler.object.IdlParam;
import JavaORB.compiler.object.IdlRaises;
import JavaORB.compiler.object.IdlSequence;
import JavaORB.compiler.object.IdlSimple;
import JavaORB.compiler.object.IdlStateMember;
import JavaORB.compiler.object.IdlString;
import JavaORB.compiler.object.IdlStruct;
import JavaORB.compiler.object.IdlStructMember;
import JavaORB.compiler.object.IdlTypeDef;
import JavaORB.compiler.object.IdlUnion;
import JavaORB.compiler.object.IdlUnionMember;
import JavaORB.compiler.object.IdlValue;
import JavaORB.compiler.object.IdlValueBox;
import JavaORB.compiler.object.IdlValueInheritance;
import JavaORB.compiler.object.IdlWString;
import JavaORB.compiler.parser.IdlParser;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ArrayDefHelper;
import org.omg.CORBA.AttributeDef;
import org.omg.CORBA.AttributeDefHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ConstantDefHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.Container;
import org.omg.CORBA.ContainerHelper;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.IDLTypeHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.NativeDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.SequenceDefHelper;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StringDefHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueBoxDefHelper;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;
import org.omg.CORBA.ValueMemberDef;
import org.omg.CORBA.ValueMemberDefHelper;
import org.omg.CORBA.WstringDef;
import org.omg.CORBA.WstringDefHelper;

public class IdlFromIR {
    private static Hashtable _imported = new Hashtable();
    private boolean _initialized = false;
    private Repository _ir = null;
    private IdlParser _parser;

    private IdlObject irOperation(IRObject type, IdlObject scope) {
        String[] ctx;
        IdlParam param = null;
        IdlRaises idl_raises = null;
        IdlContext idl_ctx = null;
        OperationDef ir_op = OperationDefHelper.narrow(type);
        IdlOp idl_op = new IdlOp(scope);
        idl_op.name(ir_op.name());
        if (ir_op.mode().value() == 0) {
            idl_op.oneway(false);
        } else {
            idl_op.oneway(true);
        }
        idl_op.addIdlObject(this.getType(ir_op.result_def(), idl_op));
        ParameterDescription[] params = ir_op.params();
        int i = 0;
        while (i < params.length) {
            param = new IdlParam(idl_op);
            param.name(params[i].name);
            switch (params[i].mode.value()) {
                case 0: {
                    param.param_attr(0);
                    break;
                }
                case 1: {
                    param.param_attr(1);
                    break;
                }
                case 2: {
                    param.param_attr(2);
                    break;
                }
            }
            param.type(this.getType(params[i].type_def, idl_op));
            idl_op.addIdlObject(param);
            ++i;
        }
        ExceptionDef[] exs = ir_op.exceptions();
        if (exs.length != 0) {
            idl_raises = new IdlRaises(idl_op);
            int i2 = 0;
            while (i2 < exs.length) {
                idl_raises.addIdlObject(this.getType(exs[i2], idl_op));
                ++i2;
            }
            idl_op.addIdlObject(idl_raises);
        }
        if ((ctx = ir_op.contexts()).length != 0) {
            idl_ctx = new IdlContext(idl_op);
            int i3 = 0;
            while (i3 < ctx.length) {
                idl_ctx.addValue(ctx[i3]);
                ++i3;
            }
            idl_op.addIdlObject(idl_ctx);
        }
        scope.addIdlObject(idl_op);
        return idl_op;
    }

    public IdlObject createOrFindScope(String scope_name, IdlObject current_scope, Container ir_scope) {
        String name = null;
        Contained contained = null;
        Container container = null;
        IdlObject parent = null;
        parent = scope_name.startsWith("::") ? this._parser.root : current_scope;
        StringTokenizer token = new StringTokenizer(scope_name, "::");
        container = ir_scope;
        while (token.hasMoreTokens()) {
            name = token.nextToken();
            if (!token.hasMoreTokens()) {
                return parent;
            }
            contained = container.lookup(name);
            if (contained == null) {
                IdlParser.fatal_erreur("Unable to find information into IR !");
                return null;
            }
            try {
                container = ContainerHelper.narrow(contained);
            }
            catch (BAD_PARAM ex) {
                IdlParser.fatal_erreur("Incorrect scope !");
                return null;
            }
            parent = parent.isDefined(name, true) ? parent.returnObject(name, true) : this.createContainer(container, parent);
        }
        return parent;
    }

    public IdlObject irDescription(IRObject type, IdlObject scope, boolean visible) {
        switch (type.def_kind().value()) {
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                Contained contained = ContainedHelper.narrow(type);
                return this.irContained(contained, scope, visible);
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 20: {
                Container container = ContainerHelper.narrow(type);
                return this.irContainer(container, scope, visible);
            }
            case 13: {
                return this.irPrimitive(type, scope);
            }
            case 14: {
                return this.irString(type, scope);
            }
            case 15: {
                return this.irSequence(type, scope);
            }
            case 16: {
                return this.irArray(type, scope);
            }
            case 18: {
                return this.irWstring(type, scope);
            }
        }
        return null;
    }

    private String irScopeName(IRObject type) {
        Contained contained = null;
        switch (type.def_kind().value()) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                this._parser.warning("Unexpected state during import...");
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                contained = ContainedHelper.narrow(type);
                return "::" + contained.absolute_name();
            }
        }
        return null;
    }

    public IdlObject irAlias(Contained contained, IdlObject scope, boolean visible) {
        AliasDef ir_alias = AliasDefHelper.narrow(contained);
        IdlTypeDef idl_alias = null;
        IdlObject exist = scope.returnObject(ir_alias.name(), true);
        if (exist == null) {
            idl_alias = new IdlTypeDef(scope);
            if (!IdlCompiler.map_all) {
                idl_alias._map = true;
            }
            idl_alias._import = visible;
        } else {
            idl_alias = (IdlTypeDef)exist;
            if (idl_alias._import) {
                return idl_alias;
            }
        }
        idl_alias.name(ir_alias.name());
        idl_alias._import = true;
        idl_alias.type(this.getType(ir_alias.original_type_def(), idl_alias));
        scope.addIdlObject(idl_alias);
        return idl_alias;
    }

    public IdlObject irValueBox(Contained contained, IdlObject scope, boolean visible) {
        ValueBoxDef ir_valuebox = ValueBoxDefHelper.narrow(contained);
        IdlValueBox idl_valuebox = null;
        IdlObject exist = scope.returnObject(ir_valuebox.name(), true);
        if (exist == null) {
            idl_valuebox = new IdlValueBox(scope);
            if (!IdlCompiler.map_all) {
                idl_valuebox._map = true;
            }
            idl_valuebox._import = visible;
        } else {
            idl_valuebox = (IdlValueBox)exist;
            if (idl_valuebox._import) {
                return idl_valuebox;
            }
        }
        idl_valuebox.name(ir_valuebox.name());
        idl_valuebox._import = true;
        idl_valuebox.type(this.getType(ir_valuebox.original_type_def(), idl_valuebox));
        scope.addIdlObject(idl_valuebox);
        return idl_valuebox;
    }

    public IdlObject irConstant(Contained contained, IdlObject scope, boolean visible) {
        ConstantDef ir_const = ConstantDefHelper.narrow(contained);
        IdlConst idl_const = null;
        IdlObject exist = scope.returnObject(ir_const.name(), true);
        if (exist == null) {
            idl_const = new IdlConst(scope);
            if (!IdlCompiler.map_all) {
                idl_const._map = true;
            }
            idl_const._import = visible;
        } else {
            idl_const = (IdlConst)exist;
            if (idl_const._import) {
                return idl_const;
            }
        }
        idl_const.name(ir_const.name());
        idl_const._import = true;
        idl_const.type(this.getType(ir_const.type_def(), idl_const));
        idl_const.expression(this.getConstExpression(ir_const.value(), ir_const.type()));
        this.setConstValue(ir_const.value(), idl_const);
        scope.addIdlObject(idl_const);
        return idl_const;
    }

    private void setConstValue(Any any, IdlConst idl_const) {
        switch (any.type().kind().value()) {
            case 8: {
                boolean b = any.extract_boolean();
                if (b) {
                    idl_const.intValue(1L);
                    idl_const.floatValue(1.0);
                    break;
                }
                idl_const.intValue(0L);
                idl_const.floatValue(0.0);
                break;
            }
            case 2: {
                short s = any.extract_short();
                idl_const.intValue(s);
                idl_const.floatValue(s);
                break;
            }
            case 4: {
                short us = any.extract_ushort();
                idl_const.intValue(us);
                idl_const.floatValue(us);
                break;
            }
            case 3: {
                int l = any.extract_long();
                idl_const.intValue(l);
                idl_const.floatValue(l);
                break;
            }
            case 5: {
                int ul = any.extract_ulong();
                idl_const.intValue(ul);
                idl_const.floatValue(ul);
                break;
            }
            case 23: {
                long ll = any.extract_longlong();
                idl_const.intValue(ll);
                idl_const.floatValue(ll);
                break;
            }
            case 24: {
                long ull = any.extract_ulonglong();
                idl_const.intValue(ull);
                idl_const.floatValue(ull);
                break;
            }
            case 9: {
                char c = any.extract_char();
                idl_const.intValue(c);
                idl_const.floatValue(c);
                break;
            }
            case 10: {
                byte o = any.extract_octet();
                idl_const.intValue(o);
                idl_const.floatValue(o);
                break;
            }
            case 6: {
                float f = any.extract_float();
                idl_const.intValue(0L);
                idl_const.floatValue(f);
                break;
            }
            case 7: {
                double d = any.extract_double();
                idl_const.intValue(0L);
                idl_const.floatValue(d);
                break;
            }
            case 26: {
                char wc = any.extract_wchar();
                idl_const.intValue(wc);
                idl_const.floatValue(0.0);
                break;
            }
            case 18: {
                idl_const.intValue(0L);
                idl_const.floatValue(0.0);
                break;
            }
            case 27: {
                idl_const.intValue(0L);
                idl_const.floatValue(0.0);
                break;
            }
        }
    }

    private boolean isAlreadyImported(String scope_name) {
        if (!scope_name.startsWith("::")) {
            scope_name = "::" + scope_name;
        }
        return _imported.get(scope_name) != null;
    }

    private void addAsImported(String scope_name) {
        if (!scope_name.startsWith("::")) {
            scope_name = "::" + scope_name;
        }
        _imported.put(scope_name, scope_name);
    }

    public IdlObject irNative(Contained contained, IdlObject scope, boolean visible) {
        NativeDef ir_native = NativeDefHelper.narrow(contained);
        IdlNative idl_native = null;
        IdlObject exist = scope.returnObject(ir_native.name(), true);
        if (exist == null) {
            idl_native = new IdlNative(scope);
            if (!IdlCompiler.map_all) {
                idl_native._map = true;
            }
            idl_native._import = visible;
        } else {
            idl_native = (IdlNative)exist;
            if (idl_native._import) {
                return idl_native;
            }
        }
        idl_native.name(ir_native.name());
        idl_native._import = true;
        scope.addIdlObject(idl_native);
        return idl_native;
    }

    public IdlObject getType(IRObject type, IdlObject parent) {
        try {
            switch (type.def_kind().value()) {
                case 4: {
                    ExceptionDef exc = ExceptionDefHelper.narrow(type);
                    return new IdlIdent(exc.name(), parent, this.getDescription(type));
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 21: 
                case 23: {
                    IDLType idl_type = IDLTypeHelper.narrow(type);
                    return new IdlIdent(idl_type.type().name(), parent, this.getDescription(type));
                }
                case 13: {
                    return this.irPrimitive(type, parent);
                }
                case 14: {
                    return this.irString(type, parent);
                }
                case 15: {
                    return this.irSequence(type, parent);
                }
                case 16: {
                    return this.irArray(type, parent);
                }
                case 18: {
                    return this.irWstring(type, parent);
                }
            }
        }
        catch (Exception ex) {
            IdlParser.fatal_erreur("Unexpected error during type import");
        }
        return null;
    }

    private String getLinkFileName(String link) {
        return link.substring(link.indexOf(":") + 1, link.length());
    }

    public IdlObject irContainer(Container container, IdlObject scope, boolean visible) {
        switch (container.def_kind().value()) {
            case 6: {
                return this.irModule(container, scope, visible);
            }
            case 10: {
                return this.irStruct(container, scope, visible);
            }
            case 4: {
                return this.irException(container, scope, visible);
            }
            case 11: {
                return this.irUnion(container, scope, visible);
            }
            case 5: {
                return this.irInterface(container, scope, visible);
            }
            case 20: {
                return this.irValue(container, scope, visible);
            }
        }
        return null;
    }

    public void getDescriptionFromIR(String scope_name, IdlObject current_scope) {
        if (this.isAlreadyImported(scope_name)) {
            return;
        }
        if (this.checkFromImportFromFile(scope_name)) {
            return;
        }
        Container _scope = null;
        this.init();
        if (scope_name.startsWith("::")) {
            _scope = ContainerHelper.narrow(this._ir);
        } else {
            String repId = current_scope.getId();
            if (repId.equals("IDL:")) {
                _scope = ContainerHelper.narrow(this._ir);
            } else {
                Contained c = this._ir.lookup_id(repId);
                if (c == null) {
                    this._parser.erreur("Unable to find the IR description for container : " + current_scope.name());
                    return;
                }
                try {
                    _scope = ContainerHelper.narrow(c);
                }
                catch (BAD_PARAM ex) {
                    this._parser.erreur("Bad current scope : " + current_scope.name());
                    return;
                }
            }
        }
        Contained contained = _scope.lookup(scope_name);
        if (contained == null) {
            this._parser.erreur("Unable to find into IR : " + scope_name);
            return;
        }
        Container container = null;
        try {
            container = ContainerHelper.narrow(contained);
        }
        catch (BAD_PARAM ex) {
            this._parser.erreur("Bad imported scope : " + current_scope.name());
            return;
        }
        IdlObject begin_scope = this.createOrFindScope(scope_name, current_scope, _scope);
        this.irContainer(container, begin_scope, true);
        this.addAsImported(scope_name);
    }

    public IdlObject irEnum(Contained contained, IdlObject scope, boolean visible) {
        EnumDef ir_enum = EnumDefHelper.narrow(contained);
        IdlEnum idl_enum = null;
        IdlObject exist = scope.returnObject(ir_enum.name(), true);
        if (exist == null) {
            idl_enum = new IdlEnum(scope);
            if (!IdlCompiler.map_all) {
                idl_enum._map = true;
            }
            idl_enum._import = visible;
        } else {
            idl_enum = (IdlEnum)exist;
            if (idl_enum._import) {
                return idl_enum;
            }
        }
        idl_enum.name(ir_enum.name());
        idl_enum._import = true;
        IdlEnumMember member = null;
        String[] members = ir_enum.members();
        int i = 0;
        while (i < members.length) {
            member = new IdlEnumMember(idl_enum);
            member.name(members[i]);
            member.setValue(i);
            idl_enum.addIdlObject(member);
            ++i;
        }
        scope.addIdlObject(idl_enum);
        return idl_enum;
    }

    private IdlObject irPrimitive(IRObject type, IdlObject scope) {
        PrimitiveDef primitive = PrimitiveDefHelper.narrow(type);
        switch (primitive.kind().value()) {
            case 1: {
                return IdlSimple.void_type;
            }
            case 2: {
                return IdlSimple.short_type;
            }
            case 3: {
                return IdlSimple.long_type;
            }
            case 4: {
                return IdlSimple.ushort_type;
            }
            case 5: {
                return IdlSimple.ulong_type;
            }
            case 6: {
                return IdlSimple.float_type;
            }
            case 7: {
                return IdlSimple.double_type;
            }
            case 8: {
                return IdlSimple.boolean_type;
            }
            case 9: {
                return IdlSimple.char_type;
            }
            case 10: {
                return IdlSimple.octet_type;
            }
            case 11: {
                return IdlSimple.any_type;
            }
            case 12: {
                return IdlSimple.typecode_type;
            }
            case 14: {
                return new IdlString(0, scope);
            }
            case 15: {
                return IdlSimple.object_type;
            }
            case 16: {
                return IdlSimple.longlong_type;
            }
            case 17: {
                return IdlSimple.ulonglong_type;
            }
            case 19: {
                return IdlSimple.wchar_type;
            }
            case 20: {
                return new IdlWString(0, scope);
            }
            case 21: {
                return IdlSimple.valuebase_type;
            }
        }
        return null;
    }

    public boolean checkFromImportFromFile(String container_name) {
        if (!container_name.startsWith("::")) {
            return false;
        }
        if ((container_name = container_name.substring(2)).indexOf("::") != -1) {
            return false;
        }
        if (this.importFromIDLFile(container_name)) {
            this.addAsImported(container_name);
            return true;
        }
        return false;
    }

    private boolean importFromIDLFile(String container_name) {
        String idl_file = this.getIDLFileName(container_name);
        if (idl_file != null) {
            this._parser.include_idl_file(idl_file);
            return true;
        }
        return false;
    }

    public IdlObject irStruct(Container container, IdlObject scope, boolean content2) {
        IdlStructMember member = null;
        StructDef ir_struct = StructDefHelper.narrow(container);
        IdlStruct idl_struct = null;
        IdlObject exist = scope.returnObject(ir_struct.name(), true);
        if (exist == null) {
            idl_struct = new IdlStruct(scope);
            if (!IdlCompiler.map_all) {
                idl_struct._map = true;
            }
        } else {
            idl_struct = (IdlStruct)exist;
            if (idl_struct._import) {
                return idl_struct;
            }
        }
        idl_struct.name(ir_struct.name());
        if (content2) {
            StructMember[] members = ir_struct.members();
            int i = 0;
            while (i < members.length) {
                member = new IdlStructMember(idl_struct);
                member.name(members[i].name);
                member.type(this.getType(members[i].type_def, idl_struct));
                idl_struct.addIdlObject(member);
                ++i;
            }
        } else {
            idl_struct._import = false;
        }
        scope.addIdlObject(idl_struct);
        if (!IdlCompiler.map_all) {
            idl_struct._map = true;
        }
        return idl_struct;
    }

    public IdlObject irUnion(Container container, IdlObject scope, boolean content2) {
        IdlUnionMember member = null;
        UnionDef ir_union = UnionDefHelper.narrow(container);
        IdlUnion idl_union = null;
        IdlObject exist = scope.returnObject(ir_union.name(), true);
        if (exist == null) {
            idl_union = new IdlUnion(scope);
            if (!IdlCompiler.map_all) {
                idl_union._map = true;
            }
        } else {
            idl_union = (IdlUnion)exist;
            if (idl_union._import) {
                return idl_union;
            }
        }
        idl_union.name(ir_union.name());
        if (content2) {
            UnionMember[] members = ir_union.members();
            member = new IdlUnionMember(idl_union);
            member.name("__d");
            member.addIdlObject(this.getType(ir_union.discriminator_type_def(), idl_union));
            idl_union.addIdlObject(member);
            int i = 0;
            while (i < members.length) {
                member = new IdlUnionMember(idl_union);
                member.name(members[i].name);
                member.type(this.getType(members[i].type_def, idl_union));
                member.setValue(this.getValue(members[i].label));
                member.setExpression(this.getExpression(members[i].label, ir_union.discriminator_type()));
                idl_union.addIdlObject(member);
                ++i;
            }
        } else {
            idl_union._import = false;
        }
        scope.addIdlObject(idl_union);
        if (!IdlCompiler.map_all) {
            idl_union._map = true;
        }
        return idl_union;
    }

    private IdlObject irArray(IRObject type, IdlObject scope) {
        ArrayDef ir_array = ArrayDefHelper.narrow(type);
        IdlArray array = new IdlArray(scope);
        array.addIdlObject(this.getType(ir_array.element_type_def(), array));
        array.setDimension(ir_array.length());
        return array;
    }

    private IdlObject getDescription(IRObject type) {
        String scope_name = this.irScopeName(type);
        IdlObject parent = this.createOrFindScope(scope_name, null, this._ir);
        return this.irDescription(type, parent, false);
    }

    private String getConstExpression(Any any, org.omg.CORBA.TypeCode switch_tc) {
        try {
            switch (any.type().kind().value()) {
                case 8: {
                    boolean b = any.extract_boolean();
                    if (b) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                case 2: {
                    short s = any.extract_short();
                    return "" + s;
                }
                case 4: {
                    short us = any.extract_ushort();
                    return "" + us;
                }
                case 3: {
                    int l = any.extract_long();
                    return "" + l;
                }
                case 5: {
                    int ul = any.extract_ulong();
                    if (((TypeCode)switch_tc).final_type().kind().value() == 17) {
                        return ((TypeCode)switch_tc).final_type().member_name(ul);
                    }
                    return "" + ul;
                }
                case 23: {
                    long ll = any.extract_longlong();
                    return "" + ll;
                }
                case 24: {
                    long ull = any.extract_ulonglong();
                    return "" + ull;
                }
                case 9: {
                    char c = any.extract_char();
                    return "" + c;
                }
                case 10: {
                    byte o = any.extract_octet();
                    return "" + o;
                }
                case 6: {
                    float f = any.extract_float();
                    return "" + f;
                }
                case 7: {
                    double d = any.extract_double();
                    return "" + d;
                }
                case 26: {
                    char wc = any.extract_wchar();
                    return "" + wc;
                }
                case 18: {
                    return any.extract_string();
                }
                case 27: {
                    return any.extract_wstring();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private long getValue(Any any) {
        switch (any.type().kind().value()) {
            case 8: {
                boolean b = any.extract_boolean();
                if (b) {
                    return 1L;
                }
                return 0L;
            }
            case 2: {
                short s = any.extract_short();
                return s;
            }
            case 4: {
                short us = any.extract_ushort();
                return us;
            }
            case 3: {
                int l = any.extract_long();
                return l;
            }
            case 5: {
                int ul = any.extract_ulong();
                return ul;
            }
            case 23: {
                long ll = any.extract_longlong();
                return ll;
            }
            case 24: {
                long ull = any.extract_ulonglong();
                return ull;
            }
            case 9: {
                char c = any.extract_char();
                return c;
            }
        }
        return 0L;
    }

    private IdlObject irString(IRObject type, IdlObject scope) {
        StringDef ir_string = StringDefHelper.narrow(type);
        return new IdlString(ir_string.bound(), scope);
    }

    public IdlFromIR(IdlParser parser) {
        this._parser = parser;
    }

    public IdlObject irContained(Contained contained, IdlObject scope, boolean visible) {
        switch (contained.def_kind().value()) {
            case 12: {
                return this.irEnum(contained, scope, visible);
            }
            case 23: {
                return this.irNative(contained, scope, visible);
            }
            case 9: {
                return this.irAlias(contained, scope, visible);
            }
            case 21: {
                return this.irValueBox(contained, scope, visible);
            }
            case 3: {
                return this.irConstant(contained, scope, visible);
            }
            case 2: {
                return this.irAttribute(contained, scope);
            }
            case 7: {
                return this.irOperation(contained, scope);
            }
            case 22: {
                return this.irValueMember(contained, scope);
            }
        }
        return null;
    }

    private IdlObject irWstring(IRObject type, IdlObject scope) {
        WstringDef ir_wstring = WstringDefHelper.narrow(type);
        return new IdlWString(ir_wstring.bound(), scope);
    }

    public IdlObject createContainer(Container container, IdlObject parent) {
        switch (container.def_kind().value()) {
            case 6: {
                return this.irModule(container, parent, false);
            }
            case 5: {
                return this.irInterface(container, parent, false);
            }
            case 20: {
                return this.irValue(container, parent, false);
            }
            case 10: {
                return this.irStruct(container, parent, false);
            }
            case 11: {
                return this.irUnion(container, parent, false);
            }
            case 4: {
                return this.irException(container, parent, false);
            }
        }
        IdlParser.fatal_erreur("Incorrect IR Container type");
        return null;
    }

    private String getIDLFileName(String container_name) {
        int i = 0;
        while (i < IdlCompiler.importLink.size()) {
            if (this.getLinkContainerName((String)IdlCompiler.importLink.elementAt(i)).equalsIgnoreCase(container_name)) {
                return this.getLinkFileName((String)IdlCompiler.importLink.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    private String getLinkContainerName(String link) {
        return link.substring(0, link.indexOf(":"));
    }

    public IdlObject irException(Container container, IdlObject scope, boolean content2) {
        IdlStructMember member = null;
        ExceptionDef ir_exception = ExceptionDefHelper.narrow(container);
        IdlExcept idl_exception = null;
        IdlObject exist = scope.returnObject(ir_exception.name(), true);
        if (exist == null) {
            idl_exception = new IdlExcept(scope);
            if (!IdlCompiler.map_all) {
                idl_exception._map = true;
            }
        } else {
            idl_exception = (IdlExcept)exist;
            if (idl_exception._import) {
                return idl_exception;
            }
        }
        idl_exception.name(ir_exception.name());
        if (content2) {
            StructMember[] members = ir_exception.members();
            int i = 0;
            while (i < members.length) {
                member = new IdlStructMember(idl_exception);
                member.name(members[i].name);
                member.type(this.getType(members[i].type_def, idl_exception));
                idl_exception.addIdlObject(member);
                ++i;
            }
        } else {
            idl_exception._import = false;
        }
        scope.addIdlObject(idl_exception);
        if (!IdlCompiler.map_all) {
            idl_exception._map = true;
        }
        return idl_exception;
    }

    private IdlObject irSequence(IRObject type, IdlObject scope) {
        SequenceDef ir_seq = SequenceDefHelper.narrow(type);
        IdlSequence seq = new IdlSequence(scope);
        seq.addIdlObject(this.getType(ir_seq.element_type_def(), seq));
        seq.setSize(ir_seq.bound());
        return seq;
    }

    private IdlObject irValueMember(IRObject type, IdlObject scope) {
        ValueMemberDef ir_vmember = ValueMemberDefHelper.narrow(type);
        IdlStateMember idl_vmember = new IdlStateMember(scope);
        idl_vmember.name(ir_vmember.name());
        if (ir_vmember.access() == 0) {
            idl_vmember.public_member(false);
        } else {
            idl_vmember.public_member(true);
        }
        scope.type(this.getType(ir_vmember.type_def(), idl_vmember));
        scope.addIdlObject(idl_vmember);
        return idl_vmember;
    }

    private String getExpression(Any any, org.omg.CORBA.TypeCode switch_tc) {
        try {
            switch (any.type().kind().value()) {
                case 8: {
                    boolean b = any.extract_boolean();
                    if (b) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                case 2: {
                    short s = any.extract_short();
                    return "" + s;
                }
                case 4: {
                    short us = any.extract_ushort();
                    return "" + us;
                }
                case 3: {
                    int l = any.extract_long();
                    return "" + l;
                }
                case 5: {
                    int ul = any.extract_ulong();
                    if (((TypeCode)switch_tc).final_type().kind().value() == 17) {
                        return ((TypeCode)switch_tc).final_type().member_name(ul);
                    }
                    return "" + ul;
                }
                case 23: {
                    long ll = any.extract_longlong();
                    return "" + ll;
                }
                case 24: {
                    long ull = any.extract_ulonglong();
                    return "" + ull;
                }
                case 9: {
                    char c = any.extract_char();
                    return "" + c;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void init() {
        if (!this._initialized) {
            ORB orb = ORB.init();
            try {
                Object obj = orb.resolve_initial_references("InterfaceRepository");
                this._ir = RepositoryHelper.narrow(obj);
            }
            catch (InvalidName ex) {
                IdlParser.fatal_erreur("Unable to get access to the 'Interface Repository'");
            }
            if (this._ir == null) {
                IdlParser.fatal_erreur("Unable to get access to the 'Interface Repository'");
            }
        }
    }

    public IdlObject irValue(Container container, IdlObject scope, boolean content2) {
        ValueDef ir_value = ValueDefHelper.narrow(container);
        IdlValue idl_value = null;
        IdlValueInheritance inheritance = null;
        IdlObject exist = scope.returnObject(ir_value.name(), true);
        if (exist == null) {
            idl_value = new IdlValue(scope);
            if (!IdlCompiler.map_all) {
                idl_value._map = true;
            }
        } else {
            idl_value = (IdlValue)exist;
            if (idl_value._import) {
                return idl_value;
            }
        }
        idl_value.name(ir_value.name());
        if (content2) {
            idl_value._import = true;
            idl_value.abstract_value(ir_value.is_abstract());
            idl_value.custom_value(ir_value.is_custom());
            ValueDef concrete = ir_value.base_value();
            if (concrete != null) {
                inheritance = new IdlValueInheritance(idl_value);
                inheritance.truncatable_member(ir_value.is_truncatable());
                inheritance.addIdlObject(this.getDescription(concrete));
                idl_value.addInheritance(inheritance);
            }
            ValueDef[] bases = ir_value.abstract_base_values();
            int i = 0;
            while (i < bases.length) {
                inheritance = new IdlValueInheritance(idl_value);
                inheritance.addIdlObject(this.getDescription(bases[i]));
                idl_value.addInheritance(inheritance);
                ++i;
            }
            Vector<IdlObject> supports_list = new Vector<IdlObject>();
            InterfaceDef[] supported = ir_value.supported_interface();
            int i2 = 0;
            while (i2 < supported.length) {
                supports_list.addElement(this.getDescription(supported[i2]));
                ++i2;
            }
            idl_value.supports(supports_list);
            Initializer[] factories = ir_value.initializers();
            this.irFactory(factories, idl_value);
            Contained[] contenu = ir_value.contents(DefinitionKind.dk_all, true);
            int i3 = 0;
            while (i3 < contenu.length) {
                this.irDescription(contenu[i3], idl_value, content2);
                ++i3;
            }
        } else {
            idl_value._import = false;
        }
        scope.addIdlObject(idl_value);
        if (!IdlCompiler.map_all) {
            idl_value._map = true;
        }
        return idl_value;
    }

    private void irFactory(Initializer[] factories, IdlValue idl_value) {
        IdlFactory factory = null;
        IdlFactoryMember member = null;
        int i = 0;
        while (i < factories.length) {
            factory = new IdlFactory(idl_value);
            factory.name(factories[i].name);
            int j = 0;
            while (j < factories[i].members.length) {
                member = new IdlFactoryMember(factory);
                member.name(factories[i].members[j].name);
                member.type(this.getType(factories[i].members[j].type_def, factory));
                factory.addIdlObject(member);
                ++j;
            }
            idl_value.addIdlObject(factory);
            ++i;
        }
    }

    private IdlObject irAttribute(IRObject type, IdlObject scope) {
        AttributeDef ir_attr = AttributeDefHelper.narrow(type);
        IdlAttribute idl_attr = new IdlAttribute(scope);
        idl_attr.name(ir_attr.name());
        if (ir_attr.mode().value() == 0) {
            idl_attr.readOnly(false);
        } else {
            idl_attr.readOnly(true);
        }
        idl_attr.type(this.getType(ir_attr.type_def(), idl_attr));
        scope.addIdlObject(scope);
        return scope;
    }

    public IdlObject irModule(Container container, IdlObject scope, boolean content2) {
        IdlModule idl_module = null;
        ModuleDef ir_module = ModuleDefHelper.narrow(container);
        IdlObject exist = scope.returnObject(ir_module.name(), true);
        if (exist == null) {
            idl_module = new IdlModule(scope);
            scope.addIdlObject(idl_module);
            if (!IdlCompiler.map_all) {
                idl_module._map = true;
            }
            idl_module.name(ir_module.name());
        } else {
            idl_module = (IdlModule)exist;
            if (!content2) {
                return idl_module;
            }
        }
        if (content2) {
            idl_module._import = true;
            Contained[] contenu = ir_module.contents(DefinitionKind.dk_all, true);
            int i = 0;
            while (i < contenu.length) {
                this.irDescription(contenu[i], idl_module, content2);
                ++i;
            }
        } else {
            idl_module._import = false;
        }
        return idl_module;
    }

    public IdlObject irInterface(Container container, IdlObject scope, boolean content2) {
        InterfaceDef ir_interface = InterfaceDefHelper.narrow(container);
        IdlInterface idl_interface = null;
        IdlObject exist = scope.returnObject(ir_interface.name(), true);
        if (exist == null) {
            idl_interface = new IdlInterface(scope);
            if (!IdlCompiler.map_all) {
                idl_interface._map = true;
            }
        } else {
            idl_interface = (IdlInterface)exist;
            if (idl_interface._import) {
                return idl_interface;
            }
        }
        idl_interface.name(ir_interface.name());
        if (content2) {
            idl_interface._import = true;
            idl_interface.abstract_interface(ir_interface.is_abstract());
            InterfaceDef[] bases = ir_interface.base_interfaces();
            int i = 0;
            while (i < bases.length) {
                idl_interface.addInheritance(this.getDescription(bases[i]));
                ++i;
            }
            Contained[] contenu = ir_interface.contents(DefinitionKind.dk_all, true);
            int i2 = 0;
            while (i2 < contenu.length) {
                this.irDescription(contenu[i2], idl_interface, content2);
                ++i2;
            }
        } else {
            idl_interface._import = false;
        }
        scope.addIdlObject(idl_interface);
        if (!IdlCompiler.map_all) {
            idl_interface._map = true;
        }
        return idl_interface;
    }
}

