/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler.parser;

import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.object.IdlArray;
import JavaORB.compiler.object.IdlAttribute;
import JavaORB.compiler.object.IdlConst;
import JavaORB.compiler.object.IdlContext;
import JavaORB.compiler.object.IdlEnum;
import JavaORB.compiler.object.IdlEnumMember;
import JavaORB.compiler.object.IdlExcept;
import JavaORB.compiler.object.IdlFactory;
import JavaORB.compiler.object.IdlFactoryMember;
import JavaORB.compiler.object.IdlFixed;
import JavaORB.compiler.object.IdlIdent;
import JavaORB.compiler.object.IdlImport;
import JavaORB.compiler.object.IdlInterface;
import JavaORB.compiler.object.IdlModule;
import JavaORB.compiler.object.IdlNative;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.object.IdlOp;
import JavaORB.compiler.object.IdlParam;
import JavaORB.compiler.object.IdlRaises;
import JavaORB.compiler.object.IdlSequence;
import JavaORB.compiler.object.IdlSimple;
import JavaORB.compiler.object.IdlStateMember;
import JavaORB.compiler.object.IdlString;
import JavaORB.compiler.object.IdlStruct;
import JavaORB.compiler.object.IdlStructMember;
import JavaORB.compiler.object.IdlTypeDef;
import JavaORB.compiler.object.IdlUnion;
import JavaORB.compiler.object.IdlUnionMember;
import JavaORB.compiler.object.IdlValue;
import JavaORB.compiler.object.IdlValueBox;
import JavaORB.compiler.object.IdlValueInheritance;
import JavaORB.compiler.object.IdlWString;
import JavaORB.compiler.parser.BooleanContainer;
import JavaORB.compiler.parser.DoubleContainer;
import JavaORB.compiler.parser.IdlFromIR;
import JavaORB.compiler.parser.IdlParser;
import JavaORB.compiler.parser.StringContainer;
import java.util.Vector;

public class IdlGrammar {
    public IdlParser parser = null;
    public IdlFromIR irImport = null;

    public void changeId(IdlObject current) {
        IdlInterface itf;
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected after #pragma ID ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (!current.isVisible(this.parser.ctx.value, false)) {
            this.parser.erreur("Undefined Identifier : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject obj = current.returnVisibleObject(this.parser.ctx.value, false);
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.erreur("ID definition expected after #pragma " + obj.name());
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (obj.kind() == 18 && (itf = (IdlInterface)obj).isForward() && (itf = itf.getInterface()) != null) {
            obj = itf;
        }
        obj.setId(this.parser.ctx.value);
    }

    public void changePackage() {
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.erreur("String expected after #pragma javaPackage ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlCompiler.use_package = true;
        IdlCompiler.packageName = new String(this.parser.ctx.value);
    }

    public long unary_exp(StringContainer str, IdlObject obj, DoubleContainer fv) {
        switch (this.parser.ctx.symb) {
            case 1: {
                this.parser.symbole();
                str.value = str.value + "- ";
                return this.primary_exp(str, obj, fv);
            }
            case 0: {
                this.parser.symbole();
                str.value = str.value + "+ ";
                return this.primary_exp(str, obj, fv);
            }
            case 3: {
                this.parser.symbole();
                str.value = str.value + "/ ";
                return this.primary_exp(str, obj, fv);
            }
            case 60: {
                this.parser.symbole();
                str.value = str.value + "% ";
                return this.primary_exp(str, obj, fv);
            }
            case 2: {
                this.parser.symbole();
                str.value = str.value + "* ";
                return this.primary_exp(str, obj, fv);
            }
            case 58: {
                this.parser.symbole();
                str.value = str.value + "~ ";
                return this.primary_exp(str, obj, fv);
            }
            case 19: {
                this.parser.symbole();
                str.value = str.value + "& ";
                return this.primary_exp(str, obj, fv);
            }
            case 85: {
                this.parser.symbole();
                str.value = str.value + "| ";
                return this.primary_exp(str, obj, fv);
            }
        }
        return this.primary_exp(str, obj, fv);
    }

    public void member_list(IdlObject obj) {
        do {
            this.member(obj);
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.block_symbole(obj);
        } while (this.parser.ctx.symb != 5);
    }

    public void changeVersion(IdlObject current) {
        IdlInterface itf;
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected after #pragma VERSION ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (!current.isVisible(this.parser.ctx.value, false)) {
            this.parser.erreur("Undefined identifier : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject obj = current.returnVisibleObject(this.parser.ctx.value, false);
        this.parser.symbole();
        if (this.parser.ctx.symb != 62) {
            this.parser.erreur("Bad version number for  : #pragma " + obj.name());
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        String id = obj.getId();
        int index = id.lastIndexOf(58);
        id = index != -1 ? new String(id.substring(0, index + 1)) : id + ":";
        String newId = new String(id + this.parser.ctx.value);
        if (obj.kind() == 18 && (itf = (IdlInterface)obj).isForward() && (itf = itf.getInterface()) != null) {
            obj.setId(newId);
            obj = itf;
        }
        obj.setId(newId);
    }

    public void union_dcl(IdlObject obj) {
        IdlUnion union_obj = new IdlUnion(obj);
        union_obj.attach_comment();
        if (this.parser.ctx.symb != 54) {
            this.parser.erreur("'union' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            }
            union_obj.name(this.parser.ctx.value);
            obj.addIdlObject(union_obj);
            this.parser.symbole();
            if (this.parser.ctx.symb != 50) {
                this.parser.erreur("'switch' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                this.parser.symbole();
                if (this.parser.ctx.symb != 8) {
                    this.parser.erreur("'(' expected");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                } else {
                    this.parser.symbole();
                    IdlUnionMember d = new IdlUnionMember(obj);
                    d.name("__d");
                    this.switch_type_spec(d);
                    union_obj.addIdlObject(d);
                    if (this.parser.ctx.symb != 9) {
                        this.parser.erreur("')' expected");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                    } else {
                        this.parser.symbole();
                        if (this.parser.ctx.symb != 4) {
                            this.parser.erreur("'{' expected");
                            this.parser.StopList.removeAllElements();
                            this.parser.StopList.addElement(new Integer(13));
                            this.parser.stopAt(this.parser.StopList);
                        } else {
                            this.block_symbole(obj);
                            this.switch_body(union_obj);
                            if (this.parser.ctx.symb != 5) {
                                this.parser.erreur("'}' expected");
                                this.parser.StopList.removeAllElements();
                                this.parser.StopList.addElement(new Integer(13));
                                this.parser.stopAt(this.parser.StopList);
                            }
                        }
                    }
                }
            }
        }
    }

    public void module_dcl(IdlObject obj) {
        IdlModule module_obj = new IdlModule(obj);
        module_obj.attach_comment();
        if (this.parser.ctx.symb != 39) {
            this.parser.erreur("'module' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                module_obj = (IdlModule)obj.returnVisibleObject(this.parser.ctx.value, true);
                module_obj.refreshIncluded();
                if (!module_obj._import) {
                    this.parser.erreur("This module ( " + this.parser.ctx.value + " ) is exposed but not imported, you cannot re-open it !");
                    return;
                }
            } else {
                module_obj.name(this.parser.ctx.value);
                obj.addIdlObject(module_obj);
            }
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.erreur("'{' expected");
        } else {
            this.parser.symbole();
        }
        do {
            this.idl_definition(module_obj);
        } while (this.parser.ctx.symb != 5);
    }

    public void attr_dcl(IdlObject obj) {
        boolean rd = false;
        IdlAttribute first_attr_obj = new IdlAttribute(obj);
        first_attr_obj.attach_comment();
        if (this.parser.ctx.symb == 46) {
            this.parser.symbole();
            rd = true;
        }
        if (this.parser.ctx.symb != 23) {
            this.parser.erreur("'attribute' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        this.param_type_spec(first_attr_obj);
        while (true) {
            if (this.parser.ctx.symb != 21) {
                this.parser.erreur("Identifier expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            IdlAttribute attr_obj = new IdlAttribute(obj);
            attr_obj.name(this.parser.ctx.value);
            attr_obj.readOnly(rd);
            attr_obj.type(first_attr_obj.type());
            attr_obj.attach_comment(first_attr_obj.getComment());
            obj.addIdlObject(attr_obj);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void export_dcl(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 27: {
                this.const_dcl(obj);
                break;
            }
            case 32: {
                this.except_dcl(obj);
                break;
            }
            case 49: {
                this.struct_dcl(obj);
                break;
            }
            case 54: {
                this.union_dcl(obj);
                break;
            }
            case 31: {
                this.enum_dcl(obj);
                break;
            }
            case 52: {
                this.type_dcl(obj);
                break;
            }
            case 76: {
                this.native_dcl(obj);
                break;
            }
            case 68: {
                this.pragma_dcl(obj);
                break;
            }
            case 99: {
                this.type_id_dcl(obj);
                break;
            }
            case 100: {
                this.type_prefix_dcl(obj);
                break;
            }
            case 23: 
            case 46: {
                this.attr_dcl(obj);
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 55: 
            case 56: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 86: 
            case 88: {
                this.op_dcl(obj);
                break;
            }
            default: {
                this.parser.erreur("Unexpected or undefined key word in the interface or value body of " + obj.name());
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
        }
        this.parser.symbole();
    }

    public void forward_dcl(IdlInterface obj) {
        obj.forward();
    }

    public void value_dcl(IdlObject obj, String name, boolean custom) {
        IdlValue value = new IdlValue(obj);
        value.attach_comment();
        if (obj.isVisible(name, false)) {
            IdlObject target = obj.returnVisibleObject(name, false);
            if (target.kind() == 28) {
                this.parser.erreur("This valuetype is already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (target.kind() != 33) {
                this.parser.erreur("This identifier is not a forward valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)target).abstract_value()) {
                this.parser.erreur("The previous definition of this identifier was for an abstract valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)target).definedValue() != null) {
                this.parser.erreur("Valuetype already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                ((IdlValue)target).definedValue(value);
            }
        }
        value.name(name);
        value.custom_value(custom);
        this.value_inheritance_spec(value, custom, true);
        obj.addIdlObject(value);
        this.parser.symbole();
        while (this.parser.ctx.symb != 5) {
            switch (this.parser.ctx.symb) {
                case 93: 
                case 94: {
                    this.state_member_dcl(value);
                    break;
                }
                case 95: {
                    this.init_dcl(value);
                    break;
                }
                default: {
                    this.export_dcl(value);
                    break;
                }
            }
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
    }

    public void pragma_dcl(IdlObject obj) {
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Undefined pragma option : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
        } else if (this.parser.ctx.value.toUpperCase().equals("ID")) {
            this.changeId(obj);
        } else if (this.parser.ctx.value.toUpperCase().equals("VERSION")) {
            this.changeVersion(obj);
        } else if (this.parser.ctx.value.toUpperCase().equals("PREFIX")) {
            this.changePrefix();
        } else if (this.parser.ctx.value.toUpperCase().equals("JAVAPACKAGE")) {
            this.changePackage();
        } else {
            this.parser.erreur("Undefined option  : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.ctx.one = 13;
    }

    public void value_inheritance(IdlObject obj, boolean custom, boolean statefull) {
        String vname = null;
        boolean first = true;
        IdlObject inh = null;
        do {
            boolean trunc;
            this.parser.symbole();
            IdlValueInheritance inheritance = new IdlValueInheritance(obj);
            if (this.parser.ctx.symb == 92) {
                if (!statefull) {
                    this.parser.erreur("'truncatable' cannot be used for an abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (custom) {
                    this.parser.erreur("'truncatable' cannot be used if a valuetype is specified with 'custom'");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                trunc = true;
                this.parser.symbole();
            } else {
                trunc = false;
            }
            vname = this.scoped_name();
            if (obj.isVisible(vname, false)) {
                IdlObject target = obj.returnVisibleObject(vname, false);
                inheritance.truncatable_member(trunc);
                if (target.final_kind() == 33) {
                    if (((IdlValue)target).definedValue() == null) {
                        this.parser.erreur("Unable to inherit from a forward valuetype which has not been yet defined");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(4));
                        this.parser.stopAt(this.parser.StopList);
                        return;
                    }
                    inh = ((IdlValue)target.final_object()).definedValue();
                } else {
                    inh = target.final_object();
                }
                if (inh.kind() != 28) {
                    this.parser.erreur("Unable to inherit from a non-valuetype : " + vname);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!custom && ((IdlValue)inh).custom_value()) {
                    this.parser.erreur("A non-custom valuetype cannot inherit from a custom value type");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (first && trunc && ((IdlValue)inh).abstract_value()) {
                    this.parser.erreur("An abstract valuetype cannot be specified with 'truncatable'");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!statefull && !((IdlValue)inh).abstract_value()) {
                    this.parser.erreur("An abstract valuetype may only inherit from abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (!first && !((IdlValue)inh).abstract_value()) {
                    this.parser.erreur("The second and others inheritances must be abstract valuetype");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                inheritance.addIdlObject(inh);
                ((IdlValue)obj).addInheritance(inheritance);
                if (!first) continue;
                first = false;
                continue;
            }
            this.parser.erreur("Undefined identifier : " + vname);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } while (this.parser.ctx.symb == 11);
    }

    public void simple_type_spec(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 34: {
                obj.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                obj.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                obj.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                obj.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                obj.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                obj.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                obj.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                obj.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                obj.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                obj.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                obj.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 86: {
                this.fixed_dcl(obj);
                return;
            }
            case 72: {
                this.wstring_dcl(obj);
                return;
            }
            case 48: {
                this.string_dcl(obj);
                return;
            }
            case 21: 
            case 56: {
                String name = this.scoped_name();
                if (!obj.isVisible(name, false)) {
                    this.parser.erreur("Undefined identifier : " + name);
                } else {
                    obj.addIdlObject(new IdlIdent(name, obj, obj.returnVisibleObject(name, false)));
                }
                return;
            }
            case 24: {
                obj.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 41: {
                obj.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 22: {
                obj.addIdlObject(IdlSimple.any_type);
                break;
            }
            case 40: {
                obj.addIdlObject(IdlSimple.object_type);
                break;
            }
            case 46: {
                this.sequence_dcl(obj);
                break;
            }
            case 88: {
                obj.addIdlObject(IdlSimple.valuebase_type);
                break;
            }
        }
        this.parser.symbole();
    }

    public void inheritance_spec(IdlInterface obj) {
        if (this.parser.ctx.symb != 14) {
            this.parser.erreur("':' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(4));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            String name;
            if (!obj.isVisible(name = this.scoped_name(), false)) {
                this.parser.erreur("Undeclared interface : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            IdlObject anObj = obj.returnVisibleObject(name, false);
            if (anObj.final_kind() != 18 && anObj.final_kind() != 15) {
                this.parser.erreur("This identifier is not an interface : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            if (anObj.final_kind() == 18 && ((IdlInterface)anObj.final_object()).getInterface() == null) {
                this.parser.erreur("It is not legal to inherit from a forward interface which is not defined : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            if (obj.abstract_interface() && !((IdlInterface)anObj.final_object()).abstract_interface()) {
                this.parser.erreur("An abstract interface can only inherit from an abstract interface : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(4));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            obj.addInheritance(anObj.final_object());
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void parameter_dcls(IdlOp obj) {
        if (this.parser.ctx.symb != 8) {
            this.parser.erreur("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (this.parser.ctx.symb != 9) {
            this.param_dcl(obj);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
            if (this.parser.ctx.symb != 9) continue;
            this.parser.erreur("Parameter definition expected");
            break;
        }
        if (this.parser.ctx.symb != 9) {
            this.parser.erreur("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public long primary_exp(StringContainer str, IdlObject obj, DoubleContainer fv) {
        long value = 0L;
        switch (this.parser.ctx.symb) {
            case 21: 
            case 56: {
                String name = this.scoped_name();
                if (!obj.isVisible(name, false)) {
                    this.parser.erreur("Undefined identifier : " + name);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    break;
                }
                IdlObject found = obj.returnVisibleObject(name, false);
                if (found.kind() == 7) {
                    value = ((IdlConst)found).intValue();
                    fv.value = value;
                    str.value = str.value + this.fullname(found) + " ";
                    break;
                }
                if (found.kind() == 22) {
                    value = ((IdlEnumMember)found).getValue();
                    fv.value = value;
                    str.value = str.value + this.fullname(found) + "@ ";
                    break;
                }
                this.parser.erreur("This identifier " + name + " doesn't correspond to a constant");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
            case 8: {
                this.parser.symbole();
                str.value = str.value + "( ";
                value = this.const_exp(str, obj, fv);
                if (this.parser.ctx.symb != 9) {
                    this.parser.erreur("')' expected");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                }
                str.value = str.value + ") ";
                this.parser.symbole();
                break;
            }
            case 63: {
                str.value = str.value + "\"" + this.parser.ctx.value + "\" ";
                this.parser.symbole();
                break;
            }
            case 64: {
                str.value = str.value + "'" + this.parser.ctx.value + "' ";
                this.parser.symbole();
                break;
            }
            case 61: {
                str.value = str.value + this.parser.ctx.value;
                if (this.parser.ctx.base == 1) {
                    this.convertToDecimal();
                }
                Integer i = new Integer(this.parser.ctx.value);
                value = i.intValue();
                fv.value = value;
                this.parser.symbole();
                break;
            }
            case 62: {
                str.value = str.value + this.parser.ctx.value + " ";
                Double d = new Double(this.parser.ctx.value);
                fv.value = d;
                this.parser.symbole();
                break;
            }
            case 51: {
                str.value = str.value + "true ";
                value = 1L;
                this.parser.symbole();
                break;
            }
            case 33: {
                str.value = str.value + "false ";
                this.parser.symbole();
                value = 0L;
                break;
            }
            default: {
                this.parser.erreur("Incorrect expression");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
        }
        return value;
    }

    public void const_type(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 41: {
                obj.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 24: {
                obj.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 34: {
                obj.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                obj.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                obj.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                obj.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                obj.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                obj.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                obj.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                obj.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                obj.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                obj.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                obj.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 72: {
                this.wstring_dcl(obj);
                return;
            }
            case 48: {
                this.string_dcl(obj);
                return;
            }
            case 86: {
                this.fixed_const_dcl(obj);
                return;
            }
            case 21: 
            case 56: {
                String name = this.scoped_name();
                if (!obj.isVisible(name, false)) {
                    this.parser.erreur("Undefined idenfitier : " + name);
                } else {
                    obj.addIdlObject(new IdlIdent(name, obj, obj.returnVisibleObject(name, false)));
                }
                return;
            }
        }
        this.parser.symbole();
    }

    public void interface_type(IdlObject obj) {
        IdlInterface anItf = null;
        int allready = 0;
        IdlInterface interface_obj = new IdlInterface(obj);
        interface_obj.attach_comment();
        if (this.parser.ctx.symb == 87) {
            interface_obj.abstract_interface(true);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb == 98) {
            if (interface_obj.abstract_interface()) {
                this.parser.erreur("An abstract interface cannot be mark as 'local'");
            }
            interface_obj.local_interface(true);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 37) {
            this.parser.erreur("'interface' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected for interface");
        } else {
            interface_obj.name(this.parser.ctx.value);
            if (obj.isVisible(this.parser.ctx.value, true)) {
                IdlObject anObj = obj.returnVisibleObject(this.parser.ctx.value, true);
                if (anObj.kind() != 15 && anObj.kind() != 18) {
                    this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(14));
                    this.parser.StopList.addElement(new Integer(4));
                    this.parser.stopAt(this.parser.StopList);
                } else {
                    anItf = (IdlInterface)anObj;
                    allready = anItf.isForward() ? 1 : 2;
                }
            }
        }
        obj.addIdlObject(interface_obj);
        this.parser.symbole();
        switch (this.parser.ctx.symb) {
            case 13: {
                if (allready == 1) {
                    this.parser.erreur("This interface is already declared : " + interface_obj.name());
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                this.forward_dcl(interface_obj);
                this.parser.ctx.one = this.parser.ctx.symb;
                break;
            }
            case 4: 
            case 14: {
                if (allready == 1) {
                    if (anItf.abstract_interface() != interface_obj.abstract_interface()) {
                        this.parser.erreur("This interface is not defined as specified in forward declaraton : " + interface_obj.name());
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(5));
                        this.parser.stopAt(this.parser.StopList);
                        return;
                    }
                    interface_obj.defined(anItf);
                }
                if (allready == 2) {
                    this.parser.erreur("This interface is already declared : " + interface_obj.name());
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                this.interface_dcl(interface_obj);
                break;
            }
            default: {
                this.parser.erreur("':' or  '{' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.stopAt(this.parser.StopList);
                break;
            }
        }
    }

    public String scoped_name() {
        String name = new String();
        boolean stop = false;
        while (!stop) {
            if (this.parser.ctx.symb == 56) {
                name = name + "::";
                this.parser.symbole();
            }
            if (this.parser.ctx.symb != 21) {
                this.parser.erreur("Bad identifier");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return name;
            }
            name = name + this.removePrefix(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb == 56) continue;
            stop = true;
        }
        return name;
    }

    public int positive_int_const(IdlObject obj) {
        StringContainer s = new StringContainer();
        DoubleContainer f = new DoubleContainer();
        int value = (int)this.const_exp(s, obj, f);
        if (value < 0) {
            this.parser.erreur("Positive interger constant expected");
        }
        return value;
    }

    public String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    public void const_dcl(IdlObject obj) {
        StringContainer exp = new StringContainer("");
        IdlConst const_obj = new IdlConst(obj);
        const_obj.attach_comment();
        if (this.parser.ctx.symb != 27) {
            this.parser.erreur("'const' expected");
        }
        this.parser.symbole();
        this.const_type(const_obj);
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
        } else {
            const_obj.name(this.parser.ctx.value);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 10) {
            this.parser.erreur("'=' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            DoubleContainer fvalue = new DoubleContainer(0.0);
            long value = this.const_exp(exp, obj, fvalue);
            const_obj.expression(exp.value);
            const_obj.intValue(value);
            const_obj.floatValue(fvalue.value);
            obj.addIdlObject(const_obj);
            this.parser.ctx.one = this.parser.ctx.symb;
        }
    }

    public void struct_dcl(IdlObject obj) {
        IdlStruct struct_obj = new IdlStruct(obj);
        struct_obj.attach_comment();
        if (this.parser.ctx.symb != 49) {
            this.parser.erreur("'struct' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            }
            struct_obj.name(this.parser.ctx.value);
            obj.addIdlObject(struct_obj);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.erreur("'{' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.block_symbole(obj);
            this.member_list(struct_obj);
            if (this.parser.ctx.symb != 5) {
                this.parser.erreur("'}' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
        }
    }

    public void param_dcl(IdlOp obj) {
        IdlParam param_obj = new IdlParam(obj);
        this.param_attribute(param_obj);
        this.param_type_spec(param_obj);
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expecter for paramater");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(9));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        param_obj.name(this.parser.ctx.value);
        obj.addIdlObject(param_obj);
        this.parser.symbole();
    }

    public void op_dcl(IdlObject obj) {
        boolean one = false;
        IdlOp op_obj = new IdlOp(obj);
        op_obj.attach_comment();
        if (this.parser.ctx.symb == 42) {
            this.parser.symbole();
            one = true;
        }
        op_obj.oneway(one);
        this.op_type_spec(op_obj);
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected for operation");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (obj.isVisible(this.parser.ctx.value, false)) {
            this.parser.erreur("Indentifier already used : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        op_obj.name(this.parser.ctx.value);
        this.parser.symbole();
        this.parameter_dcls(op_obj);
        if (this.parser.ctx.symb == 44) {
            this.raises_expr(op_obj);
        }
        if (this.parser.ctx.symb == 28) {
            this.context_expr(op_obj);
        }
        obj.addIdlObject(op_obj);
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void member(IdlObject obj) {
        IdlStructMember first_member_obj = new IdlStructMember(obj);
        first_member_obj.attach_comment();
        this.type_spec(first_member_obj);
        first_member_obj.reset();
        while (true) {
            IdlStructMember member_obj = new IdlStructMember(obj);
            member_obj.type(first_member_obj.type());
            member_obj.attach_comment(first_member_obj.getComment());
            this.declarators(member_obj);
            obj.addIdlObject(member_obj);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void init_dcl(IdlObject obj) {
        IdlFactory init = new IdlFactory(obj);
        init.attach_comment();
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected after 'factory'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (obj.isVisible(this.parser.ctx.value, false)) {
            this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        init.name(this.parser.ctx.value);
        this.parser.symbole();
        this.init_param_decls(init);
        if (this.parser.ctx.symb != 9) {
            this.parser.erreur("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 13) {
            this.parser.erreur("';' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        obj.addIdlObject(init);
    }

    public void fixed_const_dcl(IdlObject obj) {
        if (this.parser.ctx.symb != 86) {
            this.parser.erreur("'fixed' expected");
        }
        this.parser.symbole();
        obj.addIdlObject(new IdlFixed(0, 0, obj));
    }

    public void string_dcl(IdlObject obj) {
        int size = 0;
        if (this.parser.ctx.symb != 48) {
            this.parser.erreur("'string' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            size = this.positive_int_const(obj);
            if (this.parser.ctx.symb != 16) {
                this.parser.erreur("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.StopList.addElement(new Integer(16));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
        obj.addIdlObject(new IdlString(size, obj));
    }

    public void declarators(IdlObject obj) {
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            }
            obj.name(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb == 6) {
                Vector<Integer> dims = new Vector<Integer>();
                do {
                    this.parser.symbole();
                    int dim = this.positive_int_const(obj);
                    dims.addElement(new Integer(dim));
                    if (this.parser.ctx.symb != 7) {
                        this.parser.erreur("']' expected");
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                    }
                    this.parser.symbole();
                } while (this.parser.ctx.symb == 6);
                IdlArray top_level = new IdlArray(obj);
                top_level.setDimension((Integer)dims.elementAt(0));
                IdlArray array_obj = top_level;
                if (dims.size() > 1) {
                    int i = 1;
                    while (i < dims.size()) {
                        IdlArray array_new = new IdlArray(array_obj);
                        array_new.setDimension((Integer)dims.elementAt(i));
                        array_obj.addIdlObject(array_new);
                        array_obj = array_new;
                        ++i;
                    }
                }
                array_obj.addIdlObject(obj.type());
                obj.type(top_level);
            }
        }
    }

    public void enum_dcl(IdlObject obj) {
        IdlEnum enum_obj = new IdlEnum(obj);
        enum_obj.attach_comment();
        if (this.parser.ctx.symb != 31) {
            this.parser.erreur("'enum' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            }
            enum_obj.name(this.parser.ctx.value);
            this.parser.symbole();
        }
        obj.addIdlObject(enum_obj);
        if (this.parser.ctx.symb != 4) {
            this.parser.erreur("'{ expected");
        } else {
            this.block_symbole(obj);
        }
        int index = 0;
        while (true) {
            if (this.parser.ctx.symb != 21) {
                this.parser.erreur("Identifier expected");
                break;
            }
            IdlEnumMember member_obj = new IdlEnumMember(enum_obj);
            member_obj.name(this.parser.ctx.value);
            member_obj.setValue(index++);
            enum_obj.addIdlObject(member_obj);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 5) {
            this.parser.erreur("'}' expected");
        }
    }

    public void except_dcl(IdlObject obj) {
        IdlExcept except_obj = new IdlExcept(obj);
        except_obj.attach_comment();
        if (this.parser.ctx.symb != 32) {
            this.parser.erreur("'exception' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected");
        } else {
            if (obj.isVisible(this.parser.ctx.value, true)) {
                this.parser.erreur("Identifier already used : " + this.parser.ctx.value);
            }
            except_obj.name(this.parser.ctx.value);
            this.parser.symbole();
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.erreur("'{' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            if (this.parser.ctx.symb != 5) {
                this.member_list(except_obj);
            }
            if (this.parser.ctx.symb != 5) {
                this.parser.erreur("'}' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
        }
        obj.addIdlObject(except_obj);
    }

    public void raises_expr(IdlObject obj) {
        IdlRaises raises_obj = new IdlRaises(obj);
        if (this.parser.ctx.symb != 44) {
            this.parser.erreur("'raises' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 8) {
            this.parser.erreur("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            String name;
            if (!obj.isVisible(name = this.scoped_name(), false)) {
                this.parser.erreur("Undefined identifier : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(28));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            if (obj.returnVisibleObject(name, false).kind() != 14) {
                this.parser.erreur("This identifier doesn't correspond to an exception : " + name);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(28));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            raises_obj.addIdlObject(obj.returnVisibleObject(name, false));
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        obj.addIdlObject(raises_obj);
        if (this.parser.ctx.symb != 9) {
            this.parser.erreur("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public void interface_dcl(IdlInterface obj) {
        if (this.parser.ctx.symb == 14) {
            this.inheritance_spec(obj);
        }
        if (this.parser.ctx.symb != 4) {
            this.parser.erreur("'{' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.stopAt(this.parser.StopList);
        } else {
            this.parser.symbole();
            this.interface_body(obj);
        }
        if (this.parser.ctx.symb != 5) {
            this.parser.erreur("'}' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
    }

    public void native_dcl(IdlObject obj) {
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected after 'native'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (obj.isVisible(this.parser.ctx.value, false)) {
            this.parser.erreur("Identifier is already used : " + this.parser.ctx.value);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlNative native_obj = new IdlNative(obj);
        native_obj.attach_comment();
        native_obj.name(this.parser.ctx.value);
        obj.addIdlObject(native_obj);
    }

    public void value_forward_dcl(IdlObject obj, String name, boolean abstract_value) {
        IdlValue value = new IdlValue(obj);
        if (obj.isVisible(name, false)) {
            this.parser.erreur("Identifier already used");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        value.abstract_value(abstract_value);
        value.name(name);
        value.forward(true);
        obj.addIdlObject(value);
        this.parser.ctx.one = this.parser.ctx.symb;
        this.parser.ctx.symb = 13;
    }

    public void value_box_dcl(IdlObject obj, String name) {
        if (obj.isVisible(name, false)) {
            this.parser.erreur("Identifier already used");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(5));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        }
        IdlValueBox value = new IdlValueBox(obj);
        value.attach_comment();
        value.name(name);
        this.type_spec(value);
        obj.addIdlObject(value);
        this.parser.ctx.one = this.parser.ctx.symb;
        this.parser.ctx.symb = 13;
    }

    public void state_member_dcl(IdlObject obj) {
        IdlStateMember member = new IdlStateMember(obj);
        member.attach_comment();
        switch (this.parser.ctx.symb) {
            case 94: {
                member.public_member(true);
                break;
            }
            case 93: {
                member.public_member(false);
                break;
            }
        }
        this.parser.symbole();
        this.type_spec(member);
        while (true) {
            IdlStateMember member_obj = new IdlStateMember(obj);
            member_obj.public_member(member.public_member());
            member_obj.type(member.type());
            member_obj.attach_comment(member.getComment());
            this.declarators(member_obj);
            obj.addIdlObject(member_obj);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
    }

    public void type_id_dcl(IdlObject obj) {
        IdlInterface itf;
        this.parser.symbole();
        String ident = this.scoped_name();
        if (!obj.isVisible(ident, false)) {
            this.parser.erreur("Unknown identifier : " + ident);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject target = obj.returnVisibleObject(ident, false);
        if (this.parser.ctx.symb != 63) {
            this.parser.erreur("ID definition expected after typeId " + ident);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (target.kind() == 18 && (itf = (IdlInterface)target).isForward() && (itf = itf.getInterface()) != null) {
            target = itf;
        }
        target.setId(this.parser.ctx.value);
    }

    public void import_dcl(IdlObject obj) {
        String name = null;
        while (this.parser.ctx.symb == 97) {
            this.parser.symbole();
            name = this.scoped_name();
            obj.addIdlObject(new IdlImport(obj, name));
            this.irImport.getDescriptionFromIR(name, obj);
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
            }
            this.parser.symbole();
        }
    }

    public void idl_specification(IdlObject obj) {
        try {
            this.parser.symbole();
            do {
                if (this.parser.ctx.symb == 97) {
                    this.import_dcl(obj);
                }
                this.idl_definition(obj);
            } while (this.parser.ctx.symb != 254);
        }
        catch (Exception ex) {
            if (IdlCompiler.verbose) {
                System.out.println("--------------------");
                ex.printStackTrace();
                System.out.println("--------------------");
                System.out.println("");
            }
            this.parser.internal_erreur();
        }
    }

    private void block_symbole(IdlObject obj) {
        this.parser.symbole();
        if (this.parser.ctx.symb == 68) {
            this.pragma_dcl(obj);
            this.parser.symbole();
            this.block_symbole(obj);
        }
    }

    public int switch_case(IdlObject obj, BooleanContainer asNext) {
        int index = -1;
        StringContainer str = new StringContainer("");
        int size = 0;
        DoubleContainer fv = new DoubleContainer(0.0);
        asNext.value = false;
        switch (this.parser.ctx.symb) {
            case 25: {
                this.parser.symbole();
                size = (int)this.const_exp(str, obj, fv);
                break;
            }
            case 29: {
                this.parser.symbole();
                index = 0;
                break;
            }
            default: {
                this.parser.erreur("Reserved words 'case' or 'default' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return index;
            }
        }
        if (this.parser.ctx.symb != 14) {
            this.parser.erreur("':' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
        } else {
            IdlUnionMember member_obj = new IdlUnionMember(obj);
            this.parser.symbole();
            if (this.parser.ctx.symb != 25) {
                this.type_spec(member_obj);
                member_obj.reset();
                this.declarators(member_obj);
            } else {
                member_obj.setAsNext();
                asNext.value = true;
            }
            if (index == 0) {
                member_obj.setAsDefault();
            }
            member_obj.setExpression(str.value);
            member_obj.setValue(size);
            obj.addIdlObject(member_obj);
        }
        return index;
    }

    public void param_attribute(IdlParam obj) {
        switch (this.parser.ctx.symb) {
            case 35: {
                obj.param_attr(0);
                break;
            }
            case 43: {
                obj.param_attr(1);
                break;
            }
            case 36: {
                obj.param_attr(2);
                break;
            }
            default: {
                this.parser.erreur("Attribute ( in, out, inout ) expected");
                return;
            }
        }
        this.parser.symbole();
    }

    public void init_param_decls(IdlObject obj) {
        do {
            this.parser.symbole();
            IdlFactoryMember member = new IdlFactoryMember(obj);
            if (this.parser.ctx.symb != 35) {
                this.parser.erreur("'in' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
            this.param_type_spec(member);
            if (this.parser.ctx.symb != 21) {
                this.parser.erreur("Identifier expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            member.name(this.parser.ctx.value);
            obj.addIdlObject(member);
            this.parser.symbole();
        } while (this.parser.ctx.symb == 11);
    }

    public void changePrefix() {
        this.parser.symbole();
        if (this.parser.ctx.symb != 63) {
            this.parser.erreur("String expected after #pragma PREFIX ");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject.idlPrefix = this.parser.ctx.value.equals("") ? null : new String(this.parser.ctx.value);
    }

    public String fullname(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                if (obj2.kind() == 15) {
                    v.addElement(obj2.name() + "Package");
                } else {
                    v.addElement(obj2.name());
                }
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (!(IdlCompiler.packageName == null || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("corba_pkg") && !IdlCompiler.use_package)) {
            name = IdlCompiler.packageName;
        }
        if (obj.getPrefix() != null && IdlCompiler.usePrefix) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + this.inversedPrefix(obj.getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public int hexaToDec(char hexa) {
        switch (hexa) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public void idl_definition(IdlObject obj) {
        block0 : switch (this.parser.ctx.symb) {
            case 37: {
                this.interface_type(obj);
                break;
            }
            case 39: {
                this.module_dcl(obj);
                break;
            }
            case 27: {
                this.const_dcl(obj);
                break;
            }
            case 32: {
                this.except_dcl(obj);
                break;
            }
            case 49: {
                this.struct_dcl(obj);
                break;
            }
            case 54: {
                this.union_dcl(obj);
                break;
            }
            case 31: {
                this.enum_dcl(obj);
                break;
            }
            case 52: {
                this.type_dcl(obj);
                break;
            }
            case 68: {
                this.pragma_dcl(obj);
                break;
            }
            case 76: {
                this.native_dcl(obj);
                break;
            }
            case 98: {
                this.parser.symbole();
                if (this.parser.ctx.symb != 37) {
                    this.parser.erreur("'interface' key work expected after 'local'");
                    break;
                }
                this.parser.ctx.one = this.parser.ctx.symb;
                this.parser.ctx.symb = 98;
                this.interface_type(obj);
                break;
            }
            case 87: {
                this.parser.symbole();
                switch (this.parser.ctx.symb) {
                    case 89: {
                        this.parser.ctx.one = this.parser.ctx.symb;
                        this.parser.ctx.symb = 87;
                        this.full_value_dcl(obj);
                        break block0;
                    }
                    case 37: {
                        this.parser.ctx.one = this.parser.ctx.symb;
                        this.parser.ctx.symb = 87;
                        this.interface_type(obj);
                        break block0;
                    }
                }
                this.parser.erreur("Bad definition after 'abstract'");
                break;
            }
            case 89: 
            case 91: {
                this.full_value_dcl(obj);
                break;
            }
            case 99: {
                this.type_id_dcl(obj);
                break;
            }
            case 100: {
                this.type_prefix_dcl(obj);
                break;
            }
            case 254: {
                return;
            }
            default: {
                this.parser.erreur("Definition expected");
                break;
            }
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 13) {
            this.parser.erreur("';' expected");
        }
        this.parser.symbole();
    }

    public void fixed_dcl(IdlObject obj) {
        if (this.parser.ctx.symb != 86) {
            this.parser.erreur("'fixed' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 15) {
            this.parser.erreur("'<' expected after 'fixed'");
        }
        this.parser.symbole();
        int digits = this.positive_int_const(obj);
        if (this.parser.ctx.symb != 11) {
            this.parser.erreur("',' expected");
        }
        this.parser.symbole();
        int scale = this.positive_int_const(obj);
        if (this.parser.ctx.symb != 16) {
            this.parser.erreur("'>' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.StopList.addElement(new Integer(16));
            this.parser.stopAt(this.parser.StopList);
        }
        this.parser.symbole();
        obj.addIdlObject(new IdlFixed(digits, scale, obj));
    }

    public void wstring_dcl(IdlObject obj) {
        int size = 0;
        if (this.parser.ctx.symb != 72) {
            this.parser.erreur("'wstring' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            size = this.positive_int_const(obj);
            if (this.parser.ctx.symb != 16) {
                this.parser.erreur("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.StopList.addElement(new Integer(16));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
        obj.addIdlObject(new IdlWString(size, obj));
    }

    public void sequence_dcl(IdlObject obj) {
        int size = 0;
        IdlSequence seq_obj = new IdlSequence(obj);
        seq_obj.attach_comment();
        if (this.parser.ctx.symb != 46) {
            this.parser.erreur("'sequence' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb == 15) {
            this.parser.symbole();
            this.simple_type_spec(seq_obj);
            if (this.parser.ctx.symb == 11) {
                this.parser.symbole();
                size = this.positive_int_const(obj);
            }
            seq_obj.setSize(size);
            if (this.parser.ctx.symb != 16) {
                this.parser.erreur("'>' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            obj.addIdlObject(seq_obj);
        }
        obj.addIdlObject(new IdlString(size, obj));
    }

    public void type_dcl(IdlObject obj) {
        int count = 0;
        IdlTypeDef first_type_obj = new IdlTypeDef(obj);
        first_type_obj.attach_comment();
        if (this.parser.ctx.symb != 52) {
            this.parser.erreur("'typedef' expected");
        }
        this.parser.symbole();
        this.type_spec(first_type_obj);
        while (true) {
            IdlTypeDef type_obj = new IdlTypeDef(obj);
            type_obj.type(first_type_obj.type());
            type_obj.attach_comment(first_type_obj.getComment());
            type_obj.setOrder(count++);
            this.declarators(type_obj);
            obj.addIdlObject(type_obj);
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        this.parser.ctx.one = this.parser.ctx.symb;
    }

    public void switch_body(IdlObject obj) {
        int idx = 0;
        boolean found = false;
        BooleanContainer asNext = new BooleanContainer();
        while (true) {
            if (this.switch_case(obj, asNext) != -1) {
                ((IdlUnion)obj).index(idx);
            }
            ++idx;
            if (asNext.value) continue;
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.block_symbole(obj);
            if (this.parser.ctx.symb == 5) break;
        }
        int pos = obj.pos();
        obj.reset();
        while (!obj.end()) {
            if (((IdlUnionMember)obj.current()).isAsNext()) {
                int back = obj.pos();
                boolean stop = false;
                found = false;
                while (!stop) {
                    if (!((IdlUnionMember)obj.current()).isAsNext()) {
                        found = true;
                        int limit = obj.pos();
                        obj.current().reset();
                        IdlObject type = obj.current().current();
                        String name = obj.current().name();
                        obj.pos(back);
                        int i = back;
                        while (i < limit) {
                            ((IdlUnionMember)obj.current()).memberTypeAndNameIs(type, name);
                            obj.next();
                            ++i;
                        }
                        obj.pos(limit - 1);
                        stop = true;
                    }
                    obj.next();
                    if (!obj.end()) continue;
                    stop = true;
                }
                if (!found) {
                    this.parser.erreur("A type declaration is expected for union members");
                }
            }
            obj.next();
        }
        obj.pos(pos);
    }

    public void interface_body(IdlInterface obj) {
        while (this.parser.ctx.symb != 5) {
            this.export_dcl(obj);
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
    }

    public void convertToDecimal() {
        String significatif = this.parser.ctx.value.substring(this.parser.ctx.value.indexOf(120) + 1);
        int value = 0;
        int i = 0;
        while (i < significatif.length()) {
            value *= 16;
            value += this.hexaToDec(significatif.charAt(i));
            ++i;
        }
        this.parser.ctx.value = new Integer(value).toString();
    }

    public void value_abs_dcl(IdlObject obj, String name) {
        IdlValue value = new IdlValue(obj);
        value.attach_comment();
        if (obj.isVisible(name, false)) {
            IdlObject target = obj.returnVisibleObject(name, false);
            if (target.kind() == 28) {
                this.parser.erreur("This valuetype is already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (target.kind() != 33) {
                this.parser.erreur("This identifier is not a forward valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (!((IdlValue)target).abstract_value()) {
                this.parser.erreur("The previous definition of this identifier was not for an abstract valuetype : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else if (((IdlValue)target).definedValue() != null) {
                this.parser.erreur("Abstract valuetype already defined : " + this.parser.ctx.value);
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            } else {
                ((IdlValue)target).definedValue(value);
            }
        }
        value.name(name);
        value.abstract_value(true);
        this.value_inheritance_spec(value, false, false);
        obj.addIdlObject(value);
        this.parser.symbole();
        while (this.parser.ctx.symb != 5) {
            this.export_dcl(value);
            if (this.parser.ctx.symb != 13) {
                this.parser.erreur("';' expected");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(5));
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
            }
            this.parser.symbole();
        }
    }

    public IdlGrammar(IdlParser p) {
        this.parser = p;
        this.irImport = new IdlFromIR(p);
    }

    public void full_value_dcl(IdlObject obj) {
        boolean abstract_value = false;
        boolean custom = false;
        if (this.parser.ctx.symb == 87) {
            abstract_value = true;
            this.parser.symbole();
        }
        if (this.parser.ctx.symb == 91) {
            if (abstract_value) {
                this.parser.erreur("A 'abstract' value cannot be 'custom'");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            custom = true;
            this.parser.symbole();
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 21) {
            this.parser.erreur("Identifier expected after 'valuetype'");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        String value_name = this.parser.ctx.value;
        this.parser.symbole();
        switch (this.parser.ctx.symb) {
            case 13: {
                this.value_forward_dcl(obj, value_name, abstract_value);
                return;
            }
            case 4: 
            case 14: 
            case 90: {
                if (abstract_value) {
                    this.value_abs_dcl(obj, value_name);
                } else {
                    this.value_dcl(obj, value_name, custom);
                }
                return;
            }
        }
        this.value_box_dcl(obj, value_name);
    }

    public void context_expr(IdlOp obj) {
        IdlContext context_obj = new IdlContext(obj);
        if (this.parser.ctx.symb != 28) {
            this.parser.erreur("'context' expected");
        }
        this.parser.symbole();
        if (this.parser.ctx.symb != 8) {
            this.parser.erreur("'(' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
        while (true) {
            if (this.parser.ctx.symb != 63) {
                this.parser.erreur("String expected after 'context'");
                this.parser.StopList.removeAllElements();
                this.parser.StopList.addElement(new Integer(13));
                this.parser.stopAt(this.parser.StopList);
                return;
            }
            context_obj.addValue(this.parser.ctx.value);
            this.parser.symbole();
            if (this.parser.ctx.symb != 11) break;
            this.parser.symbole();
        }
        obj.addIdlObject(context_obj);
        if (this.parser.ctx.symb != 9) {
            this.parser.erreur("')' expected");
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(28));
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        this.parser.symbole();
    }

    public void type_prefix_dcl(IdlObject obj) {
        IdlInterface itf;
        this.parser.symbole();
        String ident = this.scoped_name();
        if (!obj.isVisible(ident, false)) {
            this.parser.erreur("Unknown identifier : " + ident);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(13));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        IdlObject target = obj.returnVisibleObject(ident, false);
        if (this.parser.ctx.symb != 63) {
            this.parser.erreur("ID definition expected after typeId " + ident);
            this.parser.StopList.removeAllElements();
            this.parser.StopList.addElement(new Integer(255));
            this.parser.stopAt(this.parser.StopList);
            return;
        }
        if (target.kind() == 18 && (itf = (IdlInterface)target).isForward() && (itf = itf.getInterface()) != null) {
            target = itf;
        }
        if (target.equals(obj)) {
            IdlObject.idlPrefix = this.parser.ctx.value;
        }
        target.applyPrefix(this.parser.ctx.value);
    }

    public void switch_type_spec(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 47: {
                obj.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                obj.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                obj.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                obj.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                obj.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                obj.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                obj.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                obj.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 21: 
            case 56: {
                String name = this.scoped_name();
                if (!obj.isVisible(name, false)) {
                    this.parser.erreur("Undefined identifier : " + name);
                } else {
                    obj.addIdlObject(new IdlIdent(name, obj, obj.returnVisibleObject(name, false)));
                }
                return;
            }
            case 24: {
                obj.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 31: {
                this.enum_dcl(obj);
                break;
            }
            default: {
                this.parser.erreur("Bad type for union discriminant");
                break;
            }
        }
        this.parser.symbole();
    }

    public void param_type_spec(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 34: {
                obj.addIdlObject(IdlSimple.float_type);
                break;
            }
            case 30: {
                obj.addIdlObject(IdlSimple.double_type);
                break;
            }
            case 75: {
                obj.addIdlObject(IdlSimple.longdouble_type);
                break;
            }
            case 47: {
                obj.addIdlObject(IdlSimple.short_type);
                break;
            }
            case 66: {
                obj.addIdlObject(IdlSimple.ushort_type);
                break;
            }
            case 38: {
                obj.addIdlObject(IdlSimple.long_type);
                break;
            }
            case 65: {
                obj.addIdlObject(IdlSimple.ulong_type);
                break;
            }
            case 73: {
                obj.addIdlObject(IdlSimple.longlong_type);
                break;
            }
            case 74: {
                obj.addIdlObject(IdlSimple.ulonglong_type);
                break;
            }
            case 26: {
                obj.addIdlObject(IdlSimple.char_type);
                break;
            }
            case 71: {
                obj.addIdlObject(IdlSimple.wchar_type);
                break;
            }
            case 86: {
                this.fixed_dcl(obj);
                return;
            }
            case 72: {
                this.wstring_dcl(obj);
                return;
            }
            case 48: {
                this.string_dcl(obj);
                return;
            }
            case 21: 
            case 56: {
                String name = this.scoped_name();
                if (!obj.isVisible(name, false)) {
                    this.parser.erreur("Undefined identifier " + name);
                } else {
                    obj.addIdlObject(new IdlIdent(name, obj, obj.returnVisibleObject(name, false)));
                }
                return;
            }
            case 24: {
                obj.addIdlObject(IdlSimple.boolean_type);
                break;
            }
            case 41: {
                obj.addIdlObject(IdlSimple.octet_type);
                break;
            }
            case 22: {
                obj.addIdlObject(IdlSimple.any_type);
                break;
            }
            case 40: {
                obj.addIdlObject(IdlSimple.object_type);
                break;
            }
            case 88: {
                obj.addIdlObject(IdlSimple.valuebase_type);
                break;
            }
        }
        this.parser.symbole();
    }

    public void op_type_spec(IdlOp obj) {
        switch (this.parser.ctx.symb) {
            case 55: {
                obj.addIdlObject(IdlSimple.void_type);
                this.parser.symbole();
                break;
            }
            default: {
                this.param_type_spec(obj);
                break;
            }
        }
    }

    public void value_inheritance_spec(IdlObject obj, boolean custom, boolean statefull) {
        Vector<IdlObject> support_list = new Vector<IdlObject>();
        if (this.parser.ctx.symb == 14) {
            this.value_inheritance(obj, custom, statefull);
        }
        if (this.parser.ctx.symb == 90) {
            do {
                this.parser.symbole();
                if (this.parser.ctx.symb != 21) {
                    this.parser.erreur("Identifier expected after 'supports'");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
                if (obj.isVisible(this.parser.ctx.value, false)) {
                    IdlObject target = obj.returnVisibleObject(this.parser.ctx.value, false);
                    if (target.kind() == 18) {
                        if (((IdlInterface)target).getInterface() == null) {
                            this.parser.erreur("Unable to inherit from an interface which has not been yet defined : " + this.parser.ctx.value);
                            this.parser.StopList.removeAllElements();
                            this.parser.StopList.addElement(new Integer(5));
                            this.parser.StopList.addElement(new Integer(13));
                            this.parser.stopAt(this.parser.StopList);
                            return;
                        }
                        target = ((IdlInterface)target).getInterface();
                    }
                    if (target.kind() != 15) {
                        this.parser.erreur("This identifier is not an interface : " + this.parser.ctx.value);
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(5));
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                        return;
                    }
                    support_list.addElement(target);
                } else {
                    this.parser.erreur("Undefined interface : " + this.parser.ctx.value);
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                }
                this.parser.symbole();
            } while (this.parser.ctx.symb == 11);
            if (statefull) {
                int nb_non_abstract = 0;
                int i = 0;
                while (i < support_list.size()) {
                    if (!((IdlInterface)support_list.elementAt(i)).abstract_interface()) {
                        ++nb_non_abstract;
                    }
                    ++i;
                }
                if (nb_non_abstract > 1) {
                    this.parser.erreur("A statefull value can only support one non abstract interface");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(5));
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    return;
                }
            }
            ((IdlValue)obj).supports(support_list);
        }
    }

    public void constr_type_spec(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 49: {
                this.struct_dcl(obj);
                break;
            }
            case 54: {
                this.union_dcl(obj);
                break;
            }
            case 31: {
                this.enum_dcl(obj);
                break;
            }
        }
        this.parser.symbole();
    }

    public void type_spec(IdlObject obj) {
        switch (this.parser.ctx.symb) {
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 56: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 86: 
            case 88: {
                this.simple_type_spec(obj);
                break;
            }
            case 31: 
            case 49: 
            case 54: {
                this.constr_type_spec(obj);
                break;
            }
        }
    }

    private String removePrefix(String name) {
        if (name.charAt(0) == '_') {
            return name.substring(1);
        }
        return name;
    }

    public long const_exp(StringContainer str, IdlObject obj, DoubleContainer fv) {
        long size = 0L;
        boolean flag = true;
        DoubleContainer fv2 = new DoubleContainer();
        while (flag) {
            switch (this.parser.ctx.symb) {
                case 1: {
                    size -= this.unary_exp(str, obj, fv2);
                    fv.value -= fv2.value;
                    break;
                }
                case 0: {
                    size += this.unary_exp(str, obj, fv2);
                    fv.value += fv2.value;
                    break;
                }
                case 3: {
                    size /= this.unary_exp(str, obj, fv2);
                    fv.value /= fv2.value;
                    break;
                }
                case 60: {
                    size %= this.unary_exp(str, obj, fv2);
                    break;
                }
                case 2: {
                    size *= this.unary_exp(str, obj, fv2);
                    fv.value *= fv2.value;
                    break;
                }
                case 58: {
                    size = this.unary_exp(str, obj, fv);
                    break;
                }
                case 19: {
                    size &= this.unary_exp(str, obj, fv2);
                    break;
                }
                case 85: {
                    size |= this.unary_exp(str, obj, fv2);
                    break;
                }
                case 21: 
                case 56: {
                    String name = this.scoped_name();
                    if (!obj.isVisible(name, false)) {
                        this.parser.erreur("Undefined identifier : " + name);
                        this.parser.StopList.removeAllElements();
                        this.parser.StopList.addElement(new Integer(13));
                        this.parser.stopAt(this.parser.StopList);
                        break;
                    }
                    IdlObject found = obj.returnVisibleObject(name, false);
                    if (found.kind() == 7) {
                        size = ((IdlConst)found).intValue();
                        fv.value = ((IdlConst)found).floatValue();
                        str.value = str.value + this.fullname(found) + " ";
                        break;
                    }
                    if (found.kind() == 22) {
                        size = ((IdlEnumMember)found).getValue();
                        fv.value = size;
                        str.value = str.value + this.fullname(found) + "@ ";
                        break;
                    }
                    this.parser.erreur("This identifier " + name + " doesn't correspond to a constant value");
                    this.parser.StopList.removeAllElements();
                    this.parser.StopList.addElement(new Integer(13));
                    this.parser.stopAt(this.parser.StopList);
                    break;
                }
                case 8: {
                    size = this.primary_exp(str, obj, fv);
                    break;
                }
                case 63: {
                    str.value = str.value + "\"" + this.parser.ctx.value + "\" ";
                    this.parser.symbole();
                    break;
                }
                case 64: {
                    str.value = str.value + "'" + this.parser.ctx.value + "' ";
                    this.parser.symbole();
                    break;
                }
                case 61: {
                    str.value = str.value + this.parser.ctx.value + " ";
                    if (this.parser.ctx.base == 1) {
                        this.convertToDecimal();
                    }
                    size = Integer.valueOf(this.parser.ctx.value).intValue();
                    fv.value = size;
                    this.parser.symbole();
                    break;
                }
                case 62: {
                    str.value = str.value + this.parser.ctx.value + " ";
                    fv.value = Double.valueOf(this.parser.ctx.value);
                    this.parser.symbole();
                    break;
                }
                case 51: {
                    str.value = str.value + "true ";
                    size = 1L;
                    this.parser.symbole();
                    break;
                }
                case 33: {
                    str.value = str.value + "false ";
                    size = 0L;
                    this.parser.symbole();
                    break;
                }
                default: {
                    flag = false;
                    break;
                }
            }
        }
        return size;
    }
}

