/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.compiler.parser;

import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.object.IdlComment;
import JavaORB.compiler.object.IdlCommentField;
import JavaORB.compiler.object.IdlCommentSection;
import JavaORB.compiler.object.IdlInclude;
import JavaORB.compiler.object.IdlModule;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.object.IdlRoot;
import JavaORB.compiler.object.IdlSimple;
import JavaORB.compiler.parser.CompilationContext;
import JavaORB.compiler.parser.IdlGrammar;
import JavaORB.compiler.parser.Symbole;
import JavaORB.compiler.parser.SymboleDef;
import JavaORB.compiler.parser.SymboleJava;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class IdlParser {
    public IdlObject root = new IdlRoot();
    public String[] file_extension = new String[]{".idl"};
    public static int totalError = 0;
    public CompilationContext ctx;
    public Vector StopList = new Vector();
    public static int include_level = 0;
    public static IdlComment idl_comment = null;
    public Vector compilationList = new Vector();
    public Vector idlIncluded = new Vector();
    public int pass = 0;
    public int stop_else = 0;

    public void internal_erreur() {
        System.out.println("Unexpected error : ");
        System.out.println("\t" + this.ctx.name + ", Ligne " + this.ctx.ligne);
        System.exit(0);
    }

    public void erreur(String msg) {
        ++this.ctx.nberreur;
        ++totalError;
        System.out.println(this.ctx.name + ", Line " + this.ctx.ligne + " : " + msg);
        if (this.ctx.nberreur > 10) {
            System.out.println("Compilation stopped : too much errors");
            System.exit(0);
        }
    }

    public static void fatal_erreur(String message) {
        System.out.println("Fatal error : ");
        System.out.println("\t" + message);
        System.exit(0);
    }

    public boolean is_java_reserved_word() {
        int i = 0;
        while (i < SymboleJava.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)SymboleJava.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CompilationContext new_compilation_context() {
        CompilationContext context = new CompilationContext();
        context.nberreur = 0;
        context.nbwarning = 0;
        context.back = false;
        context.ligne = 1;
        context.symb = 59;
        return context;
    }

    public void define_symbole() {
        this.symbole();
        if (this.ctx.symb != 21) {
            this.erreur("Identifier expected after #define");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            int found = 0;
            int i = 0;
            while (i < IdlCompiler.symboleDefined.size()) {
                if (((Object)IdlCompiler.symboleDefined).equals(this.ctx.value)) {
                    found = i;
                    break;
                }
                ++i;
            }
            if (found == 0) {
                IdlCompiler.symboleDefined.addElement(this.ctx.value);
            }
            this.symbole();
        }
    }

    public void ifndef_symbole() {
        this.symbole();
        if (this.ctx.symb != 21) {
            this.erreur("Identifier expected after #undef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            boolean found = false;
            int i = 0;
            while (i < IdlCompiler.symboleDefined.size()) {
                String s = (String)IdlCompiler.symboleDefined.elementAt(i);
                if (s.equals(this.ctx.value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                int state = 1;
                int count = 1;
                this.pass = 2;
                while (state != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 2;
                                    --count;
                                    break;
                                }
                                case 3: {
                                    state = 2;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 3;
                                    --count;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 1;
                                    ++count;
                                    break;
                                }
                                case 3: {
                                    state = 1;
                                    count += 2;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                    }
                    if (count != 0) continue;
                    state = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public void ifdef_symbole() {
        this.symbole();
        if (this.ctx.symb != 21) {
            this.erreur("Identifier expected after #undef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            boolean found = false;
            int i = 0;
            while (i < IdlCompiler.symboleDefined.size()) {
                String s = (String)IdlCompiler.symboleDefined.elementAt(i);
                if (s.equals(this.ctx.value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                int state = 1;
                int count = 1;
                this.pass = 2;
                while (state != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 2;
                                    --count;
                                    break;
                                }
                                case 3: {
                                    state = 2;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 3;
                                    --count;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 1;
                                    ++count;
                                    break;
                                }
                                case 3: {
                                    state = 1;
                                    count += 2;
                                    break;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                    }
                    if (count != 0) continue;
                    state = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public void read_number() {
        int base = 0;
        boolean type = false;
        boolean stop = true;
        int index = 0;
        char[] tmp = new char[255];
        while (stop) {
            tmp[index++] = this.ctx.car;
            this.scan();
            if (this.ctx.car == '.') {
                if (!type) {
                    type = true;
                    continue;
                }
                this.erreur("Bad number value");
                continue;
            }
            if (this.ctx.car == 'x') {
                if (base == 0) {
                    base = 1;
                    continue;
                }
                this.erreur("Bad number value");
                continue;
            }
            if (this.ctx.car == '-') {
                this.erreur("Token '-' misplaced");
                stop = false;
                continue;
            }
            if (Character.isLetter(this.ctx.car)) {
                if (this.ctx.car == ' ' || this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                    stop = false;
                    this.ctx.back = true;
                    continue;
                }
                if (base == 1) continue;
                System.out.println("[" + this.ctx.car + "]");
                this.ctx.back = true;
                this.erreur("Bad hexadecimal value");
                stop = false;
                continue;
            }
            if (Character.isDigit(this.ctx.car)) continue;
            this.ctx.back = true;
            stop = false;
        }
        tmp[index] = '\u0000';
        this.ctx.symb = !type ? 61 : 62;
        this.ctx.value = new String(tmp, 0, index);
        this.ctx.base = base;
    }

    public void scan_comment() {
        boolean not_end = false;
        boolean end = false;
        boolean begin = false;
        Vector<Character> comment = new Vector<Character>();
        IdlCommentSection new_section = null;
        idl_comment = new IdlComment();
        do {
            this.scan();
        } while (this.ctx.car != '*');
        this.ctx.back = true;
        block5: while (!not_end) {
            switch (this.ctx.car) {
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        not_end = true;
                    }
                    while (this.ctx.car == ' ') {
                        this.scan();
                    }
                    continue block5;
                }
                case '@': {
                    this.scan();
                    this.read_word();
                    begin = true;
                    if (this.ctx.value.equals("exception")) {
                        new_section = new IdlCommentSection(IdlCommentField.exception_field);
                    } else if (this.ctx.value.equals("author")) {
                        new_section = new IdlCommentSection(IdlCommentField.author_field);
                    } else if (this.ctx.value.equals("version")) {
                        new_section = new IdlCommentSection(IdlCommentField.version_field);
                    } else if (this.ctx.value.equals("param")) {
                        new_section = new IdlCommentSection(IdlCommentField.param_field);
                    } else if (this.ctx.value.equals("return")) {
                        new_section = new IdlCommentSection(IdlCommentField.return_field);
                    } else if (this.ctx.value.equals("deprecated")) {
                        new_section = new IdlCommentSection(IdlCommentField.deprecated_field);
                    } else if (this.ctx.value.equals("see")) {
                        new_section = new IdlCommentSection(IdlCommentField.see_field);
                    } else {
                        new_section = new IdlCommentSection(IdlCommentField.unknown_field);
                        new_section.set_title(this.ctx.value);
                    }
                    end = this.read_description();
                    new_section.add_description(this.ctx.value);
                    idl_comment.add_section(new_section);
                    if (!end) continue block5;
                    not_end = true;
                    break;
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                        } while (this.ctx.car != '*');
                        this.ctx.back = true;
                        if (!begin) {
                            comment.addElement(new Character('\n'));
                        }
                    } else if (!begin) {
                        comment.addElement(new Character(this.ctx.car));
                    }
                    this.scan();
                    break;
                }
            }
        }
        if (comment.size() != 0) {
            char[] text = new char[comment.size()];
            int i = 0;
            while (i < comment.size()) {
                text[i] = ((Character)comment.elementAt(i)).charValue();
                ++i;
            }
            idl_comment.add_description(new String(text));
        } else {
            idl_comment = null;
        }
    }

    public void parse() {
        char[] tab = new char[255];
        this.pre_parse();
        if (this.ctx.symb == 59) {
            switch (this.ctx.car) {
                case '&': {
                    this.ctx.symb = 19;
                    break;
                }
                case '|': {
                    this.ctx.symb = 85;
                    break;
                }
                case '+': {
                    this.ctx.symb = 0;
                    break;
                }
                case '-': {
                    this.ctx.symb = 1;
                    break;
                }
                case '=': {
                    this.ctx.symb = 10;
                    break;
                }
                case '*': {
                    this.ctx.symb = 2;
                    break;
                }
                case '{': {
                    this.ctx.symb = 4;
                    break;
                }
                case '}': {
                    this.ctx.symb = 5;
                    break;
                }
                case '[': {
                    this.ctx.symb = 6;
                    break;
                }
                case ']': {
                    this.ctx.symb = 7;
                    break;
                }
                case '.': {
                    this.ctx.symb = 12;
                    break;
                }
                case '~': {
                    this.ctx.symb = 58;
                    break;
                }
                case '<': {
                    this.ctx.symb = 15;
                    break;
                }
                case '>': {
                    this.ctx.symb = 16;
                    break;
                }
                case '%': {
                    this.ctx.symb = 60;
                    break;
                }
                case '(': {
                    this.ctx.symb = 8;
                    break;
                }
                case ')': {
                    this.ctx.symb = 9;
                    break;
                }
                case ';': {
                    this.ctx.symb = 13;
                    break;
                }
                case ',': {
                    this.ctx.symb = 11;
                    break;
                }
                case ':': {
                    this.scan();
                    if (this.ctx.car == ':') {
                        this.ctx.symb = 56;
                        break;
                    }
                    this.ctx.symb = 14;
                    this.ctx.back = true;
                    break;
                }
                case '\"': {
                    boolean stop = true;
                    int index = 0;
                    boolean prev = false;
                    this.scan();
                    while (stop) {
                        tab[index++] = this.ctx.car;
                        if (this.ctx.car == '\u00fe') {
                            this.erreur("Incorrect string");
                        }
                        if (this.ctx.car == '\"' && !prev) {
                            stop = false;
                            continue;
                        }
                        prev = this.ctx.car == '\\';
                        this.scan();
                    }
                    tab[index] = '\u0000';
                    this.ctx.value = new String(tab, 0, index - 1);
                    this.ctx.symb = 63;
                    break;
                }
                case '\'': {
                    boolean stop = true;
                    int index = 0;
                    boolean prev = false;
                    this.scan();
                    while (stop) {
                        tab[index++] = this.ctx.car;
                        if (this.ctx.car == '\u00fe') {
                            this.erreur("Incorrect character");
                        }
                        if (this.ctx.car == '\'' && !prev) {
                            stop = false;
                            continue;
                        }
                        prev = this.ctx.car == '\\';
                        this.scan();
                    }
                    tab[index] = '\u0000';
                    this.ctx.value = new String(tab, 0, index - 1);
                    this.ctx.symb = 64;
                    break;
                }
                default: {
                    if (Character.isDigit(this.ctx.car)) {
                        this.read_number();
                        break;
                    }
                    if (Character.isLetter(this.ctx.car) || this.ctx.car == '_') {
                        this.read_word();
                        if (this.is_reserved_word()) {
                            this.to_reserved_word();
                            break;
                        }
                        this.ctx.symb = 21;
                        if (!this.is_java_reserved_word()) break;
                        this.ctx.value = "__" + this.ctx.value;
                        break;
                    }
                    this.erreur("Undefined character : " + this.ctx.car);
                    break;
                }
            }
        }
    }

    public void symbole() {
        if (this.ctx.one != 59) {
            this.ctx.symb = this.ctx.one;
            this.ctx.one = 59;
            return;
        }
        this.parse();
        block0 : switch (this.ctx.symb) {
            case 1: {
                this.parse();
                if (this.ctx.symb == 61 || this.ctx.symb == 62) {
                    this.ctx.value = "-" + this.ctx.value;
                    break;
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 1;
                break;
            }
            case 38: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.ctx.symb = 73;
                        break block0;
                    }
                    case 30: {
                        this.ctx.symb = 75;
                        break block0;
                    }
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 38;
                break;
            }
            case 53: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.parse();
                        if (this.ctx.symb == 38) {
                            this.ctx.symb = 74;
                            break block0;
                        }
                        this.ctx.one = this.ctx.symb;
                        this.ctx.symb = 65;
                        break block0;
                    }
                    case 47: {
                        this.ctx.symb = 66;
                        break block0;
                    }
                }
                this.erreur("Unexpected combinaison type with unsigned");
                break;
            }
        }
    }

    public void warning(String msg) {
        System.out.println("Warning ! " + this.ctx.name + ", Ligne " + this.ctx.ligne + " : " + msg);
    }

    public IdlParser() {
        IdlModule module = new IdlModule(this.root);
        module.name("CORBA");
        module._prefix = "omg.org";
        this.root.addIdlObject(module);
        module.addIdlObject(IdlSimple.typecode_type);
        IdlSimple.typecode_type.name("TypeCode");
        IdlSimple.typecode_type._upper = module;
        module._map = true;
        IdlSimple.typecode_type._map = true;
    }

    public void scan() {
        if (this.ctx.back) {
            this.ctx.back = false;
            return;
        }
        try {
            char c = (char)this.ctx.file.readByte();
            if (c == '\r') {
                this.scan();
            } else if (c == '\n') {
                ++this.ctx.ligne;
                this.ctx.car = (char)255;
            } else {
                this.ctx.car = c;
            }
        }
        catch (EOFException ex) {
            this.ctx.car = (char)254;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void include_idl() {
        String tmp;
        this.symbole();
        switch (this.ctx.symb) {
            case 15: {
                tmp = "";
                this.scan();
                while (this.ctx.car != '>') {
                    tmp = tmp + this.ctx.car;
                    if (this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                        this.erreur("IDL file name expected");
                        this.StopList.removeAllElements();
                        this.StopList.addElement(new Integer(39));
                        this.StopList.addElement(new Integer(37));
                        this.StopList.addElement(new Integer(52));
                        this.StopList.addElement(new Integer(54));
                        this.StopList.addElement(new Integer(49));
                        this.StopList.addElement(new Integer(31));
                        this.StopList.addElement(new Integer(32));
                        this.StopList.addElement(new Integer(27));
                        this.stopAt(this.StopList);
                        return;
                    }
                    this.scan();
                }
                break;
            }
            case 63: {
                tmp = this.ctx.value;
                break;
            }
            default: {
                this.erreur("IDL file name to include expected");
                this.StopList.removeAllElements();
                this.StopList.addElement(new Integer(39));
                this.StopList.addElement(new Integer(37));
                this.StopList.addElement(new Integer(52));
                this.StopList.addElement(new Integer(54));
                this.StopList.addElement(new Integer(49));
                this.StopList.addElement(new Integer(31));
                this.StopList.addElement(new Integer(32));
                this.StopList.addElement(new Integer(27));
                this.stopAt(this.StopList);
                return;
            }
        }
        this.ctx.prefix = IdlObject.idlPrefix;
        this.compilationList.addElement(this.ctx);
        boolean included = false;
        if (!this.isAlsoToCompile(tmp) && !IdlCompiler.map_all) {
            included = true;
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include : " + tmp);
        }
        this.compile_idl(tmp);
        this.root.addIdlObject(new IdlInclude(this.root, tmp));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (included) {
            include_level += -1;
        }
        int err = this.ctx.nberreur;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberreur += err;
        IdlObject.idlPrefix = this.ctx.prefix;
        this.symbole();
    }

    private boolean isAlsoToCompile(String name) {
        boolean found = false;
        int i = 0;
        while (i < this.file_extension.length) {
            if (name.endsWith(this.file_extension[i])) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            name = name + this.file_extension[0];
        }
        i = 0;
        while (i < IdlCompiler.idl_file_name.length) {
            if (name.equals(IdlCompiler.idl_file_name[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void to_reserved_word() {
        int i = 0;
        while (i < Symbole.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)Symbole.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                this.ctx.symb = s.symbole_token;
                return;
            }
            ++i;
        }
    }

    public void pre_parse() {
        boolean symb = true;
        int two = 1;
        this.scan();
        this.ctx.symb = 59;
        block0 : switch (this.ctx.car) {
            case '\u00fe': {
                this.ctx.symb = 254;
                this.scan();
                break;
            }
            case '\t': 
            case ' ': 
            case '\u00ff': {
                this.pre_parse();
                break;
            }
            case '#': {
                this.scan();
                this.read_word();
                this.to_reserved_word();
                switch (this.ctx.symb) {
                    case 77: {
                        if (this.pass != 0) break block0;
                        this.define_symbole();
                        break;
                    }
                    case 96: {
                        if (this.pass != 0) break block0;
                        this.ifdef_symbole();
                        break;
                    }
                    case 81: {
                        if (this.pass != 0) break block0;
                        this.undefine_symbole();
                        break;
                    }
                    case 78: {
                        if (this.pass != 0) break block0;
                        this.ifndef_symbole();
                        break;
                    }
                    case 68: {
                        break;
                    }
                    case 69: {
                        if (this.pass != 0) break block0;
                        this.include_idl();
                        break;
                    }
                    case 79: {
                        if (this.stop_else == 1 && this.pass == 0) {
                            int state = 1;
                            int count = 1;
                            this.stop_else = -1;
                            this.pass = 2;
                            while (state != 0) {
                                this.symbole();
                                block16 : switch (this.ctx.symb) {
                                    case 78: {
                                        switch (state) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                state = 3;
                                                ++count;
                                                break block16;
                                            }
                                        }
                                        break;
                                    }
                                    case 80: {
                                        switch (state) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                state = 2;
                                                --count;
                                                break block16;
                                            }
                                        }
                                        break;
                                    }
                                    case 79: {
                                        switch (state) {
                                            case 2: 
                                            case 3: {
                                                state = 1;
                                                break block16;
                                            }
                                        }
                                        break;
                                    }
                                }
                                if (count != 0) continue;
                                state = 0;
                            }
                            this.stop_else = 0;
                            this.pass = 0;
                        }
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break;
                    }
                    case 80: {
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break;
                    }
                    default: {
                        this.warning("Compilation flag unknown : " + this.ctx.value);
                        break;
                    }
                }
                break;
            }
            case '/': {
                this.scan();
                if (this.ctx.car == '/') {
                    while (this.ctx.car != '\u00ff') {
                        this.scan();
                    }
                    this.pre_parse();
                    break;
                }
                if (this.ctx.car == '*') {
                    boolean stop = true;
                    while (stop) {
                        this.scan();
                        if (this.ctx.car == '\u00fe') {
                            this.erreur("Comment end missing '*/'");
                            this.StopList.removeAllElements();
                            this.StopList.addElement(new Integer(255));
                            this.stopAt(this.StopList);
                        }
                        if (this.ctx.car == '*') {
                            ++two;
                            this.scan();
                            if (this.ctx.car == '/') {
                                stop = false;
                            } else {
                                this.ctx.back = true;
                            }
                        }
                        if (two != 2 || this.ctx.car != '\u00ff') continue;
                        this.ctx.back = false;
                        this.scan_comment();
                        break;
                    }
                    this.pre_parse();
                    break;
                }
                this.ctx.symb = 3;
                break;
            }
        }
    }

    public void stopAt(Vector list) {
        while (this.ctx.symb != 254) {
            int i = 0;
            while (i < list.size()) {
                Integer val = (Integer)list.elementAt(i);
                if (val == this.ctx.symb) {
                    return;
                }
                ++i;
            }
            this.symbole();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void open_idl_file(String file_name) {
        block11: {
            source_name = null;
            source_name = file_name;
            ready = false;
            i = 0;
            while (i < this.file_extension.length) {
                if (file_name.endsWith(this.file_extension[i])) {
                    ready = true;
                    break;
                }
                ++i;
            }
            if (!ready) {
                source_name = source_name + this.file_extension[0];
            }
            this.ctx = this.new_compilation_context();
            this.ctx.name = source_name;
            this.ctx.prefix = null;
            IdlObject.idlPrefix = null;
            try {
                this.ctx.file = new DataInputStream(new BufferedInputStream(new FileInputStream(source_name)));
                break block11;
            }
            catch (IOException e) {
                sep = System.getProperty("file.separator");
                if (IdlCompiler.includeList.size() == 0) {
                    System.out.println("Unable to open this file : " + source_name);
                    System.exit(0);
                }
                i = 0;
                ** while (i < IdlCompiler.includeList.size())
            }
lbl-1000:
            // 1 sources

            {
                path = new String((String)IdlCompiler.includeList.elementAt(i));
                if (path.charAt(path.length() - 1) != sep.charAt(0)) {
                    path = path + sep;
                }
                path = path + source_name;
                try {
                    this.ctx.file = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
                    break;
                }
                catch (IOException ex) {
                    ++i;
                }
                continue;
            }
lbl37:
            // 2 sources

            if (this.ctx.file == null) {
                System.out.println("File not found : " + file_name);
                System.exit(0);
            }
        }
    }

    public void undefine_symbole() {
        this.symbole();
        if (this.ctx.symb != 21) {
            this.erreur("Identifier expected after #undef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            int found = -1;
            int i = 0;
            while (i < IdlCompiler.symboleDefined.size()) {
                String s = (String)IdlCompiler.symboleDefined.elementAt(i);
                if (s.equals(this.ctx.value)) {
                    found = i;
                    break;
                }
                ++i;
            }
            if (found == -1) {
                this.warning("Undefined symbole : " + this.ctx.value);
            } else {
                IdlCompiler.symboleDefined.removeElementAt(i);
            }
            this.symbole();
        }
    }

    public void read_word() {
        char[] tmp = new char[512];
        int index = 0;
        while (Character.isLetterOrDigit(this.ctx.car) || this.ctx.car == '_') {
            if (index < 512) {
                tmp[index++] = this.ctx.car;
            } else {
                this.warning("Identifier too long");
            }
            this.scan();
            if (this.ctx.car == '\u00fe' || this.ctx.car == '\u00ff') break;
        }
        tmp[index] = '\u0000';
        this.ctx.value = new String(tmp, 0, index);
        this.ctx.back = true;
    }

    public boolean read_description() {
        boolean not_end = false;
        boolean end = false;
        Vector<Character> description = new Vector<Character>();
        while (!not_end) {
            this.scan();
            block0 : switch (this.ctx.car) {
                case '@': {
                    not_end = true;
                    break;
                }
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        not_end = true;
                        end = true;
                        break;
                    }
                    while (true) {
                        if (this.ctx.car != ' ') {
                            this.ctx.back = true;
                            break block0;
                        }
                        this.scan();
                    }
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                            if (this.ctx.car != '\u00fe') continue;
                            this.erreur("IDL comment incorrect.");
                            System.exit(0);
                        } while (this.ctx.car != '*');
                        this.ctx.back = true;
                        description.addElement(new Character('\n'));
                        break;
                    }
                    description.addElement(new Character(this.ctx.car));
                    break;
                }
            }
        }
        if (description.size() != 0) {
            char[] text = new char[description.size()];
            int i = 0;
            while (i < description.size()) {
                text[i] = ((Character)description.elementAt(i)).charValue();
                ++i;
            }
            this.ctx.value = new String(text);
        }
        return end;
    }

    public IdlObject compile_idl(String file_name) {
        IdlGrammar grammar = new IdlGrammar(this);
        this.open_idl_file(file_name);
        grammar.idl_specification(this.root);
        return this.root;
    }

    public void include_idl_file(String file_name) {
        this.ctx.prefix = IdlObject.idlPrefix;
        this.compilationList.addElement(this.ctx);
        if (!IdlCompiler.map_all) {
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include : " + file_name);
        }
        this.compile_idl(file_name);
        this.root.addIdlObject(new IdlInclude(this.root, file_name));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (!IdlCompiler.map_all) {
            include_level += -1;
        }
        int err = this.ctx.nberreur;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberreur += err;
        IdlObject.idlPrefix = this.ctx.prefix;
    }

    public boolean is_reserved_word() {
        int i = 0;
        while (i < Symbole.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)Symbole.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

