/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.Any;
import JavaORB.CORBA.NaturalEndian;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.portable.Delegate;
import JavaORB.ObjectAdapter;
import JavaORB.Trace;
import JavaORB.iiop.BiDirectionalClientConnectionIIOP;
import JavaORB.iiop.CloseConnectionEx;
import JavaORB.iiop.ConnectionManager;
import JavaORB.iiop.ProtocolPlugIIOP;
import JavaORB.iiop.ReplyBag;
import JavaORB.iiop.RequestBag;
import JavaORB.iiop.RequestContainer;
import JavaORB.protocol.ClientConnection;
import JavaORB.protocol.ClientStack;
import JavaORB.protocol.ExtendedInputStream;
import JavaORB.protocol.ExtendedOutputStream;
import JavaORB.protocol.ProtocolPlug;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ByteArrayHolder;
import org.omg.CORBA.ByteHolder;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.FREE_MEM;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_FLAG;
import org.omg.CORBA.INV_IDENT;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.FragmentHeader_1_2;
import org.omg.GIOP.FragmentHeader_1_2Helper;
import org.omg.GIOP.LocateReplyHeader_1_0;
import org.omg.GIOP.LocateReplyHeader_1_0Helper;
import org.omg.GIOP.LocateReplyHeader_1_2;
import org.omg.GIOP.LocateReplyHeader_1_2Helper;
import org.omg.GIOP.LocateRequestHeader_1_0;
import org.omg.GIOP.LocateRequestHeader_1_0Helper;
import org.omg.GIOP.LocateRequestHeader_1_2;
import org.omg.GIOP.LocateRequestHeader_1_2Helper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MessageHeader_1_0;
import org.omg.GIOP.MessageHeader_1_0Helper;
import org.omg.GIOP.MessageHeader_1_1;
import org.omg.GIOP.MessageHeader_1_1Helper;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.GIOP.ReplyHeader_1_2Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.RequestHeader_1_2;
import org.omg.GIOP.RequestHeader_1_2Helper;
import org.omg.GIOP.TargetAddress;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

public class ClientConnectionIIOP
extends Thread
implements ClientConnection {
    public final int FRAGMENT_SIZE = 32000;
    protected static Vector connectionList = new Vector();
    protected ClientStack connection;
    protected OutputStream previousIOR;
    protected static ConnectionManager manager = new ConnectionManager();
    protected boolean connected;
    private boolean endianMode;
    private String typeId;
    protected org.omg.GIOP.Version version;
    private String host;
    private int port;
    private byte[] object_key;
    private TaggedComponent[] tagged_list;
    private TaggedComponent[] component_list;
    private TargetAddress target_key;
    private static int requestCount = 0;
    private static int max_retry;
    private static Vector replyQueue;
    private ProtocolPlug plug;
    private static Vector waitedReply;
    private static Vector waitedRequest;
    private Object _target;
    protected ServiceContext[] _sc_list_supplied;
    protected ServiceContext[] _sc_list_consumed;
    protected static ServiceContext _bi_dir_tag;
    protected static boolean use_bi_dir;
    protected static byte[] _user_;
    protected static boolean _init;
    private RequestContainer currentRequest = null;
    private int _tmp_rqId;
    private static /* synthetic */ Class class$JavaORB$iiop$ClientConnectionIIOP;

    public ServiceContext[] _get_sending_service_context_list() {
        return this._sc_list_supplied;
    }

    protected synchronized void parseRequestMessage(byte[] buffer, boolean endian, IntHolder RqId, BooleanHolder Response, ByteArrayHolder ObjectKey, StringHolder Operation, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        this._sc_list_supplied = new ServiceContext[0];
        switch (this.version.minor) {
            case 0: {
                this._sc_list_consumed = ServiceContextListHelper.read(is);
                RqId.value = is.read_ulong();
                Response.value = is.read_boolean();
                int size = is.read_ulong();
                ObjectKey.value = new byte[size];
                is.read_octet_array(ObjectKey.value, 0, size);
                Operation.value = is.read_string();
                size = is.read_ulong();
                byte[] tmp = new byte[size];
                is.read_octet_array(tmp, 0, size);
                break;
            }
            case 1: {
                this._sc_list_consumed = ServiceContextListHelper.read(is);
                RqId.value = is.read_ulong();
                Response.value = is.read_boolean();
                is.read_octet();
                is.read_octet();
                is.read_octet();
                int sz = is.read_ulong();
                ObjectKey.value = new byte[sz];
                is.read_octet_array(ObjectKey.value, 0, sz);
                Operation.value = is.read_string();
                int size = is.read_ulong();
                byte[] tmp = new byte[size];
                is.read_octet_array(tmp, 0, size);
                break;
            }
            case 2: {
                RequestHeader_1_2 header_2 = RequestHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                this._sc_list_consumed = header_2.service_context;
                Response.value = header_2.response_flags != 0;
                switch (header_2.target.discriminator()) {
                    case 0: {
                        ObjectKey.value = header_2.target.object_key();
                        break;
                    }
                    case 1: {
                        throw new NO_IMPLEMENT();
                    }
                    case 2: {
                        throw new NO_IMPLEMENT();
                    }
                }
                Operation.value = header_2.operation;
                break;
            }
        }
        if (Trace.level != 0) {
            Trace.Step("Is oneway invocation : " + !Response.value);
        }
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Operation called : " + Operation.value);
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
    }

    protected boolean isBiDirChannel(String host, int port) {
        if (!use_bi_dir) {
            return false;
        }
        return ORBSingleton._orb.isListenPointFor(host, port);
    }

    protected static synchronized boolean isAnyReplyToRead(short rqid) {
        if (ClientConnectionIIOP.isAvailableReply(rqid, false)) {
            ClientConnectionIIOP.removeWaitedReply(rqid);
            return true;
        }
        int i = 0;
        while (i < waitedReply.size()) {
            if (Trace.level != 0) {
                Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Waited response : " + (Short)waitedReply.elementAt(i));
            }
            if (ClientConnectionIIOP.isAvailableReply((Short)waitedReply.elementAt(i), false)) {
                if (Trace.level != 0) {
                    Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Response received is waited ! ");
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public OutputStream createMessageHeader(MsgType_1_1 type, int size, byte fragment_flag) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::createMessageHeader");
        }
        OutputStream output = this.plug.newOutputStream(this.version.minor);
        char[] magic = new char[]{'G', 'I', 'O', 'P'};
        switch (this.version.minor) {
            case 0: {
                MessageHeader_1_0 header = new MessageHeader_1_0(magic, this.version, NaturalEndian.value, (byte)type.value(), size);
                MessageHeader_1_0Helper.write(output, header);
                break;
            }
            case 1: 
            case 2: {
                byte flag = 0;
                if (NaturalEndian.value) {
                    flag = 1;
                }
                flag = (byte)(flag + fragment_flag * 2);
                if (Trace.level != 0) {
                    Trace.Step("Flag value : " + flag);
                }
                MessageHeader_1_1 header1 = new MessageHeader_1_1(magic, this.version, flag, (byte)type.value(), size);
                MessageHeader_1_1Helper.write(output, header1);
                break;
            }
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::createMessageHeader");
        }
        return output;
    }

    public synchronized int sendRequest(String Operation, boolean response, OutputStream output) {
        int rqid = 0;
        Class clazz = class$JavaORB$iiop$ClientConnectionIIOP != null ? class$JavaORB$iiop$ClientConnectionIIOP : (class$JavaORB$iiop$ClientConnectionIIOP = ClientConnectionIIOP.class$("JavaORB.iiop.ClientConnectionIIOP"));
        synchronized (clazz) {
            if (Trace.level != 0) {
                Trace.InFunction("ClientConnectionIIOP::sendRequest");
            }
            OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
            this.checkBiDirIIOP();
            switch (this.version.minor) {
                case 0: {
                    ServiceContextListHelper.write(requestBody, this._sc_list_supplied);
                    requestBody.write_ulong(requestCount);
                    requestBody.write_boolean(response);
                    requestBody.write_ulong(this.object_key.length);
                    requestBody.write_octet_array(this.object_key, 0, this.object_key.length);
                    requestBody.write_string(Operation);
                    requestBody.write_ulong(0);
                    break;
                }
                case 1: {
                    byte[] reserved = new byte[]{0, 0, 0};
                    ServiceContextListHelper.write(requestBody, this._sc_list_supplied);
                    requestBody.write_ulong(requestCount);
                    requestBody.write_boolean(response);
                    requestBody.write_octet_array(reserved, 0, 3);
                    requestBody.write_ulong(this.object_key.length);
                    requestBody.write_octet_array(this.object_key, 0, this.object_key.length);
                    requestBody.write_string(Operation);
                    requestBody.write_ulong(0);
                    break;
                }
                case 2: {
                    byte[] reserved2 = new byte[]{0, 0, 0};
                    byte resp = 0;
                    if (response) {
                        resp = 1;
                    }
                    RequestHeader_1_2 header2 = new RequestHeader_1_2(requestCount, resp, reserved2, this._get_target_key(), Operation, this._sc_list_supplied);
                    RequestHeader_1_2Helper.write(requestBody, header2);
                    break;
                }
            }
            if (this.version.minor == 2) {
                ((ExtendedOutputStream)((java.lang.Object)requestBody)).alignment(8);
            }
            requestBody.write_octet_array(((ExtendedOutputStream)((java.lang.Object)output)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)output)).count());
            if (((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer().length > 32008 && this.version.minor > 0) {
                int n = this.sendRequestByFragment(requestBody);
                java.lang.Object var11_15 = null;
                return n;
            }
            if (this.version.minor == 2) {
                int chunck = (((ExtendedOutputStream)((java.lang.Object)requestBody)).count() + 12) % 8;
                int i = 0;
                while (i < chunck) {
                    requestBody.write_octet((byte)0);
                    ++i;
                }
            }
            OutputStream request = this.createMessageHeader(MsgType_1_1.Request, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), (byte)0);
            request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
            rqid = requestCount++;
            this.sendMessage(request);
            if (Trace.level != 0) {
                Trace.OutFunction("ClientConnectionIIOP::sendRequest");
            }
            int n = rqid;
            java.lang.Object var11_16 = null;
            return n;
        }
    }

    public void extractUserException(InputStream input, ExceptionList exceptList, Environment env) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::extractUserException");
        }
        boolean found = false;
        String exceptId = input.read_string();
        if (Trace.level != 0) {
            Trace.Step("Exception ID : " + exceptId);
        }
        ((ExtendedInputStream)((java.lang.Object)input)).resetCount();
        if (exceptList == null) {
            env.exception(new ApplicationException(exceptId, input));
            return;
        }
        try {
            int i = 0;
            while (i < exceptList.count()) {
                if (exceptId.equals(exceptList.item(i).id())) {
                    found = true;
                    Any any = new Any();
                    ((org.omg.CORBA.Any)any).read_value(input, exceptList.item(i));
                    UnknownUserException excep = new UnknownUserException(any);
                    env.exception(excep);
                    break;
                }
                ++i;
            }
        }
        catch (BadKind ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Exception BadKind anormalement generee");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.INTERNAL");
            }
            throw new INTERNAL("Unexcepted BadKind exception", 2, CompletionStatus.COMPLETED_MAYBE);
        }
        if (!found) {
            if (Trace.level != 0) {
                Trace.Step("Exception utilisateur inconnue");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.UNKNOWN");
            }
            env.exception(new UNKNOWN("Unable to read a user exception", 1, CompletionStatus.COMPLETED_MAYBE));
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::extractUserException");
        }
    }

    public synchronized void parseFragmentMessage(byte[] buffer, boolean endian, IntHolder RqId, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                throw new INTERNAL();
            }
            case 2: {
                FragmentHeader_1_2 header_2 = FragmentHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
    }

    public synchronized void parseReplyMessage(byte[] buffer, boolean endian, IntHolder RqId, ReplyStatusType_1_2Holder ReplyStatus, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        this._sc_list_supplied = new ServiceContext[0];
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 header1 = ReplyHeader_1_0Helper.read(is);
                RqId.value = header1.request_id;
                ReplyStatus.value = ReplyStatusType_1_2.from_int(header1.reply_status.value());
                this._sc_list_consumed = header1.service_context;
                break;
            }
            case 2: {
                ReplyHeader_1_2 header2 = ReplyHeader_1_2Helper.read(is);
                RqId.value = header2.request_id;
                ReplyStatus.value = header2.reply_status;
                this._sc_list_consumed = header2.service_context;
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
    }

    public synchronized void sendMessage(OutputStream msg) throws COMM_FAILURE {
        try {
            this.connection.updateSender(this);
            this.connection.write(((ExtendedOutputStream)((java.lang.Object)msg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)msg)).count());
        }
        catch (Throwable ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible d'envoyer un message au serveur");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to send a request to the server", 5, CompletionStatus.COMPLETED_NO);
        }
    }

    protected static synchronized RequestBag getAvailableRequest() {
        if (waitedRequest.size() == 0) {
            return null;
        }
        RequestBag rq = (RequestBag)waitedRequest.elementAt(0);
        waitedRequest.removeElementAt(0);
        return rq;
    }

    protected void receiveRequestByFragment(byte[] buffer, boolean endian, IntHolder RqId, BooleanHolder Response, ByteArrayHolder ObjectKey, StringHolder Operation, InputStream body) throws CloseConnectionEx {
        boolean last_frag = false;
        byte[] msg = new byte[]{};
        BooleanHolder fragment = new BooleanHolder();
        BooleanHolder endianType = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        int fragNum = 1;
        if (Trace.level != 0) {
            Trace.Step("Receive request by fragment");
        }
        if (Trace.level != 0) {
            Trace.Step("New fragment  : 1");
        }
        msg = buffer;
        while (!last_frag) {
            ++fragNum;
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endianType, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            if (!fragment.value) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            InputStream tempBody = this.plug.newInputStream(this.version.minor);
            byte[] tmp = null;
            if (this.version.minor == 2) {
                this.parseFragmentMessage(buffer, endian, RqId, tempBody);
                tmp = ((ExtendedInputStream)((java.lang.Object)tempBody)).getBuffer();
            } else {
                tmp = buffer;
            }
            if (Trace.level != 0) {
                Trace.Step("Fragment size = " + tmp.length);
            }
            byte[] old = msg;
            msg = new byte[msg.length + tmp.length];
            System.arraycopy(old, 0, msg, 0, old.length);
            System.arraycopy(tmp, 0, msg, old.length, tmp.length);
        }
        if (Trace.level != 0) {
            Trace.Step("Message size : " + msg.length);
        }
        this.parseRequestMessage(msg, endian, RqId, Response, ObjectKey, Operation, body);
    }

    private boolean isConnectionInto(Vector list) {
        ClientStack stk = null;
        int i = 0;
        while (i < list.size()) {
            stk = (ClientStack)list.elementAt(i);
            if (stk == this.connection) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static synchronized void removeWaitedReply(short RqId) {
        int i = 0;
        while (i < waitedReply.size()) {
            if ((Short)waitedReply.elementAt(i) == RqId) {
                waitedReply.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void connectToServer() throws COMM_FAILURE {
        block22: {
            tentative = 0;
            stop = false;
            exist = false;
            if (Trace.level != 0) {
                Trace.InFunction("ClientConnectionIIOP::connectToServer");
            }
            if (Trace.level != 0) {
                Trace.Step("Check if there is an available connection to the server");
            }
            i = 0;
            while (i < ClientConnectionIIOP.connectionList.size()) {
                cl = (ClientConnectionIIOP)ClientConnectionIIOP.connectionList.elementAt(i);
                if (cl._get_host().toUpperCase().equals(this.host.toUpperCase()) && cl._get_port() == this.port) {
                    if (Trace.level != 0) {
                        Trace.Step("A connection is already available for : " + this.host + " / " + this.port);
                    }
                    this.connected = true;
                    this.connection = cl.connection;
                    exist = true;
                    ClientConnectionIIOP.manager.updateDeadline(this.connection.object());
                    break;
                }
                ++i;
            }
            if (exist) break block22;
            if (Trace.level != 0) {
                Trace.Step("No asymetrical connection available.");
            }
            if (!this.isBiDirChannel(this.host, this.port)) ** GOTO lbl62
            if (Trace.level != 0) {
                Trace.Step("A BiDirectional connection is selected...");
            }
            this.connection = this.getBiDirChannel(this.host, this.port);
            this.connected = true;
            return;
lbl-1000:
            // 1 sources

            {
                if (Trace.level != 0) {
                    Trace.Step("Try to connect " + this.host + " on port " + this.port);
                }
                try {
                    ++tentative;
                    this.connection.open(this.host, this.port);
                    stop = true;
                    this.connected = true;
                    this.setTimeOut(ORBSingleton._timeout);
                    ClientConnectionIIOP.manager.addConnection(this.connection.object(), this.host, this.port);
                    this.launchBiDirIIOP(this.connection);
                    continue;
                }
                catch (UnknownHostException e) {
                    if (Trace.level != 0) {
                        Trace.CoreError("Unknown host " + this.host);
                    }
                    if (Trace.level != 0) {
                        Trace.ThrowException("org.omg.CORBA.COMM_FAILURE = " + e);
                    }
                    throw new COMM_FAILURE("Unknown server host name", 6, CompletionStatus.COMPLETED_NO);
                }
                catch (IOException e) {
                    if (tentative == ClientConnectionIIOP.max_retry) {
                        if (Trace.level != 0) {
                            Trace.CoreError("Unable to connect to = " + e);
                        }
                        if (Trace.level != 0) {
                            Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                        }
                        throw new COMM_FAILURE("Unable to connect to server", 5, CompletionStatus.COMPLETED_NO);
                    }
                    if (Trace.level != 0) {
                        Trace.Step("Attente de 1 seconde...");
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        if (Trace.level == 0) continue;
                        Trace.CoreError("Interruption d'attente");
                    }
                }
lbl62:
                // 5 sources

                ** while (!stop)
            }
        }
        ClientConnectionIIOP.connectionList.addElement(this);
        if (Trace.level != 0) {
            Trace.Step("Connexion success !");
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::connectToServer");
        }
    }

    public void disconnectAllFromServer() {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::disconnectAllFromServer");
        }
        int i = 0;
        while (i < connectionList.size()) {
            ClientConnectionIIOP cl = (ClientConnectionIIOP)connectionList.elementAt(i);
            if (cl._get_host().equals(this.host) && cl._get_port() == this.port) {
                cl.connected = false;
                connectionList.removeElementAt(i);
            }
            ++i;
        }
        try {
            manager.remove(this.connection.object());
            if (Trace.level != 0) {
                Trace.Step("Effectue la deconnexion");
            }
            this.connection.close();
            this.connected = false;
        }
        catch (IOException excep) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de fermer la connexion vers le serveur");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to close client connection", 7, CompletionStatus.COMPLETED_NO);
        }
    }

    public void _set_key(byte[] key) {
        this.object_key = key;
    }

    public byte[] _get_key() {
        return this.object_key;
    }

    public void _set_target_key(TargetAddress target) {
        this.target_key = target;
    }

    public TargetAddress _get_target_key() {
        if (this.target_key == null) {
            this.target_key = new TargetAddress();
            this.target_key.object_key(this._get_key());
        }
        return this.target_key;
    }

    public void disconnectFromServer() {
        boolean found = false;
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::disconnectFromServer");
        }
        if (!this.connected) {
            return;
        }
        if (Trace.level != 0) {
            Trace.Step("Supprime la connexion dans la liste des connexions ouvertes");
        }
        int i = 0;
        while (i < connectionList.size()) {
            if ((ClientConnectionIIOP)connectionList.elementAt(i) == this) {
                connectionList.removeElementAt(i);
                found = true;
                break;
            }
            ++i;
        }
        Vector vector = connectionList;
        synchronized (vector) {
            if (Trace.level != 0) {
                Trace.Step("Verifie si la connexion est partagee");
            }
            i = 0;
            while (i < connectionList.size()) {
                ClientConnectionIIOP cl = (ClientConnectionIIOP)connectionList.elementAt(i);
                if (cl._get_host().equalsIgnoreCase(this.host) && cl._get_port() == this.port) {
                    if (Trace.level != 0) {
                        Trace.Step("La connexion est partagee ");
                    }
                    connectionList.removeElementAt(i);
                    cl.connected = false;
                    i = -1;
                }
                ++i;
            }
            try {
                manager.remove(this.connection.object());
                if (Trace.level != 0) {
                    Trace.Step("Effectue la deconnexion");
                }
                this.connection.close();
                this.connected = false;
            }
            catch (IOException excep) {
                if (Trace.level != 0) {
                    Trace.CoreError("Impossible de fermer la connexion vers le serveur");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                }
                throw new COMM_FAILURE("Unable to close client connection", 7, CompletionStatus.COMPLETED_NO);
            }
            java.lang.Object var5_6 = null;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::disconnectFromServer");
        }
    }

    protected byte[] readBuffer(int size) throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::readBuffer()");
        }
        byte[] buffer = new byte[size];
        try {
            this.connection.read(buffer, 0, size);
        }
        catch (InterruptedIOException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de lire sur une connexion cliente");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Time out on client connection", 2, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (IOException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de lire sur une connexion cliente");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to read on client connection", 2, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::readBuffer()");
        }
        return buffer;
    }

    public void invoke(String Operation, OutputStream output, InputStream input, ExceptionList exceptList, Environment env, java.lang.Object[] extra) throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::invoke");
        }
        boolean redo = true;
        if (!this.connected) {
            this.connectToServer();
        }
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Try to invoke");
        }
        manager.changeState(this.connection.object(), true);
        int RequestId = this.sendRequest(Operation, true, output);
        RequestContainer requestContainer = this.currentRequest;
        synchronized (requestContainer) {
            this.currentRequest.operation = Operation;
            this.currentRequest.response = true;
            this.currentRequest.output = output;
            this.currentRequest.rqId = RequestId;
            java.lang.Object var11_10 = null;
        }
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Invoke success [ " + RequestId + " ] : " + Operation);
        }
        try {
            while (redo) {
                if (ClientConnectionIIOP.isAvailableReply((short)RequestId, false)) {
                    this.getAvailableReply((short)RequestId, input, exceptList, env);
                    break;
                }
                redo = this.receiveReply(RequestId, input, exceptList, env);
            }
        }
        catch (CloseConnectionEx ex) {
            // empty catch block
        }
        manager.changeState(this.connection.object(), false);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::invoke");
        }
    }

    public void _set_host(String host) {
        this.host = host;
    }

    public String _get_host() {
        return this.host;
    }

    public synchronized void reInvoke() {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::reInvoke");
        }
        OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
        this.checkBiDirIIOP();
        switch (this.version.minor) {
            case 0: {
                ServiceContextListHelper.write(requestBody, this._sc_list_supplied);
                requestBody.write_ulong(this.currentRequest.rqId);
                requestBody.write_boolean(this.currentRequest.response);
                requestBody.write_ulong(this.object_key.length);
                requestBody.write_octet_array(this.object_key, 0, this.object_key.length);
                requestBody.write_string(this.currentRequest.operation);
                requestBody.write_ulong(0);
                break;
            }
            case 1: {
                byte[] reserved = new byte[]{0, 0, 0};
                ServiceContextListHelper.write(requestBody, this._sc_list_supplied);
                requestBody.write_ulong(this.currentRequest.rqId);
                requestBody.write_boolean(this.currentRequest.response);
                requestBody.write_octet_array(reserved, 0, 3);
                requestBody.write_ulong(this.object_key.length);
                requestBody.write_octet_array(this.object_key, 0, this.object_key.length);
                requestBody.write_string(this.currentRequest.operation);
                requestBody.write_ulong(0);
                break;
            }
            case 2: {
                byte[] reserved2 = new byte[]{0, 0, 0};
                byte resp = 0;
                if (this.currentRequest.response) {
                    resp = 1;
                }
                RequestHeader_1_2 header2 = new RequestHeader_1_2(this.currentRequest.rqId, resp, reserved2, this._get_target_key(), this.currentRequest.operation, this._sc_list_supplied);
                RequestHeader_1_2Helper.write(requestBody, header2);
                break;
            }
        }
        requestBody.write_octet_array(((ExtendedOutputStream)((java.lang.Object)this.currentRequest.output)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)this.currentRequest.output)).count());
        if (((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer().length > 32008 && this.version.minor > 0) {
            this.reInvokeByFragment(requestBody, this.currentRequest.rqId);
            return;
        }
        if (this.version.minor == 2) {
            int chunck = (((ExtendedOutputStream)((java.lang.Object)requestBody)).count() + 12) % 8;
            int i = 0;
            while (i < chunck) {
                requestBody.write_octet((byte)0);
                ++i;
            }
        }
        OutputStream request = this.createMessageHeader(MsgType_1_1.Request, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), (byte)0);
        request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
        this.sendMessage(request);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::reInvoke");
        }
    }

    public ServiceContext[] _get_service_context_list() {
        return this._sc_list_consumed;
    }

    public void _set_receiving_service_context_list(ServiceContext[] sc) {
        this._sc_list_consumed = sc;
    }

    public void _set_service_context_list(ServiceContext[] sc) {
        this._sc_list_supplied = sc;
    }

    protected synchronized void parseLocateMessage(byte[] buffer, boolean endian, IntHolder RqId, ByteArrayHolder ObjectKey) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                LocateRequestHeader_1_0 header = LocateRequestHeader_1_0Helper.read(is);
                RqId.value = header.request_id;
                ObjectKey.value = header.object_key;
                break;
            }
            case 2: {
                LocateRequestHeader_1_2 header_2 = LocateRequestHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                ObjectKey.value = header_2.target.object_key();
                break;
            }
        }
    }

    private synchronized void addWaitedReply(short RqId) {
        int i = 0;
        while (i < waitedReply.size()) {
            if (RqId == (Short)waitedReply.elementAt(i)) {
                return;
            }
            ++i;
        }
        waitedReply.addElement(new Short(RqId));
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public Version adaptVersionToIIOP(org.omg.GIOP.Version ver) {
        Version version = new Version();
        version.major = ver.major;
        version.minor = ver.minor;
        return version;
    }

    public synchronized void parseMessageHeader(byte[] buffer, BooleanHolder endian, ByteHolder msgType, IntHolder msgSize, BooleanHolder fragment) {
        InputStream is = this.plug.newInputStream(buffer, NaturalEndian.value, this.version.minor);
        char[] magic = new char[4];
        is.read_char_array(magic, 0, 4);
        if (magic[0] != 'G' || magic[1] != 'I' || magic[2] != 'O' || magic[3] != 'P') {
            if (Trace.level != 0) {
                Trace.CoreError("Bad GIOP Header : " + magic);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Bad GIOP Header", 3, CompletionStatus.COMPLETED_NO);
        }
        org.omg.GIOP.Version ver = org.omg.GIOP.VersionHelper.read(is);
        this.version.minor = ver.minor;
        this.version.major = ver.major;
        if (this.version.minor == 2) {
            byte flag = is.read_octet();
            endian.value = false;
            if ((flag & 1) != 0) {
                endian.value = true;
            }
        } else {
            endian.value = is.read_boolean();
        }
        is = this.plug.newInputStream(buffer, endian.value, this.version.minor);
        switch (this.version.minor) {
            case 0: {
                MessageHeader_1_0 header = MessageHeader_1_0Helper.read(is);
                msgType.value = header.message_type;
                msgSize.value = header.message_size;
                fragment.value = false;
                break;
            }
            case 1: 
            case 2: {
                MessageHeader_1_1 header1 = MessageHeader_1_1Helper.read(is);
                fragment.value = false;
                if ((header1.flags & 2) != 0) {
                    fragment.value = true;
                }
                msgType.value = header1.message_type;
                msgSize.value = header1.message_size;
                break;
            }
        }
    }

    public void sendLocateRequestByFragment(OutputStream output) {
        Class clazz = class$JavaORB$iiop$ClientConnectionIIOP != null ? class$JavaORB$iiop$ClientConnectionIIOP : (class$JavaORB$iiop$ClientConnectionIIOP = ClientConnectionIIOP.class$("JavaORB.iiop.ClientConnectionIIOP"));
        synchronized (clazz) {
            block13: {
                if (Trace.level != 0) {
                    Trace.InFunction("ClientConnectionIIOP::sendLocateRequestByFragment");
                }
                byte[] buffer = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
                boolean last_frag = false;
                int last_size = buffer.length;
                int buffer_index = 0;
                int frag_size = 31988;
                if (Trace.level != 0) {
                    Trace.Step("Send by fragments, initiale size : " + last_size);
                }
                int fragNum = 0;
                while (!last_frag) {
                    OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
                    if (++fragNum > 1 && this.version.minor == 2) {
                        FragmentHeader_1_2 fragmentHeader = new FragmentHeader_1_2(requestCount);
                        FragmentHeader_1_2Helper.write(requestBody, fragmentHeader);
                    }
                    byte[] toSend = new byte[frag_size];
                    System.arraycopy(buffer, buffer_index, toSend, 0, frag_size);
                    requestBody.write_octet_array(toSend, 0, frag_size);
                    buffer_index += frag_size;
                    if ((last_size -= frag_size) < 32000) {
                        frag_size = last_size;
                    }
                    if (frag_size == 0) {
                        last_frag = true;
                        if (Trace.level != 0) {
                            Trace.Step("Last fragment : " + fragNum);
                        }
                    } else if (Trace.level != 0) {
                        Trace.Step("New fragment : " + fragNum);
                    }
                    byte notLast = 0;
                    if (!last_frag) {
                        notLast = 1;
                    }
                    OutputStream request = fragNum > 1 ? this.createMessageHeader(MsgType_1_1.Fragment, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast) : this.createMessageHeader(MsgType_1_1.LocateRequest, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast);
                    request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
                    this.sendMessage(request);
                }
                if (Trace.level == 0) break block13;
                Trace.OutFunction("ClientConnectionIIOP::sendLocateRequestByFragment");
            }
            java.lang.Object var13_13 = null;
        }
    }

    public void send(String Operation, OutputStream output, boolean responseExpected, IntHolder RqId, java.lang.Object[] extra) throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::send");
        }
        if (!this.connected) {
            this.connectToServer();
        }
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Try to invoke");
        }
        manager.changeState(this.connection.object(), true);
        RqId.value = this.sendRequest(Operation, responseExpected, output);
        this.currentRequest.operation = Operation;
        this.currentRequest.response = responseExpected;
        this.currentRequest.output = output;
        this.currentRequest.rqId = RqId.value;
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Invoke success [ " + RqId.value + " ]");
        }
        manager.changeState(this.connection.object(), false);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::send");
        }
    }

    public synchronized void receiveReplyByFragment(byte[] buffer, boolean endian, IntHolder RqId, ReplyStatusType_1_2Holder ReplyStatus, InputStream body) {
        boolean last_frag = false;
        byte[] msg = new byte[]{};
        int fragNum = 0;
        BooleanHolder fragment = new BooleanHolder();
        BooleanHolder endianType = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        if (Trace.level != 0) {
            Trace.Step("Receive reply by fragment");
        }
        if (Trace.level != 0) {
            Trace.Step("New fragment  : 1");
        }
        msg = buffer;
        while (!last_frag) {
            ++fragNum;
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endianType, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            if (!fragment.value) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            InputStream tempBody = this.plug.newInputStream(this.version.minor);
            byte[] tmp = null;
            if (this.version.minor == 2) {
                this.parseFragmentMessage(buffer, endian, RqId, tempBody);
                tmp = ((ExtendedInputStream)((java.lang.Object)tempBody)).getBuffer();
            } else {
                tmp = buffer;
            }
            if (Trace.level != 0) {
                Trace.Step("Fragment size = " + tmp.length);
            }
            byte[] old = msg;
            msg = new byte[msg.length + tmp.length];
            System.arraycopy(old, 0, msg, 0, old.length);
            System.arraycopy(tmp, 0, msg, old.length, tmp.length);
        }
        if (Trace.level != 0) {
            Trace.Step("Message size : " + msg.length);
        }
        this.parseReplyMessage(msg, endian, RqId, ReplyStatus, body);
    }

    protected static void appendRequestToQueue(byte[] buffer, boolean endian, byte msgType, boolean fragment) {
        RequestBag rq = new RequestBag();
        rq.buffer = buffer;
        rq.endian = endian;
        rq.msgType = msgType;
        rq.fragment = fragment;
        waitedRequest.addElement(rq);
    }

    public void run() {
        throw new NO_IMPLEMENT("Unable to launch a ClientConnectionIIOP thread...");
    }

    public void sendMessageError() {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::sendMessageError");
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.MessageError, 0, (byte)0);
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::sendMessageError");
        }
    }

    public org.omg.GIOP.Version _get_version() {
        return this.version;
    }

    public org.omg.GIOP.Version adaptVersion(Version ver) {
        org.omg.GIOP.Version version = new org.omg.GIOP.Version();
        version.major = ver.major;
        version.minor = ver.minor;
        return version;
    }

    public void _set_version(org.omg.GIOP.Version version) {
        this.version = version;
    }

    public void reInvokeByFragment(OutputStream output, int rqId) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::reInvokeByFragment");
        }
        byte[] buffer = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
        boolean last_frag = false;
        int last_size = buffer.length;
        int buffer_index = 0;
        this.checkBiDirIIOP();
        int frag_size = 31988;
        if (Trace.level != 0) {
            Trace.Step("Send by fragments, initiale size : " + last_size);
        }
        int fragNum = 0;
        while (!last_frag) {
            OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
            if (++fragNum > 1 && this.version.minor == 2) {
                FragmentHeader_1_2 fragmentHeader = new FragmentHeader_1_2(rqId);
                FragmentHeader_1_2Helper.write(requestBody, fragmentHeader);
            }
            byte[] toSend = new byte[frag_size];
            System.arraycopy(buffer, buffer_index, toSend, 0, frag_size);
            requestBody.write_octet_array(toSend, 0, frag_size);
            buffer_index += frag_size;
            if ((last_size -= frag_size) < 32000) {
                frag_size = last_size;
            }
            if (frag_size == 0) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            byte notLast = 0;
            if (!last_frag) {
                notLast = 1;
            }
            OutputStream request = fragNum > 1 ? this.createMessageHeader(MsgType_1_1.Fragment, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast) : this.createMessageHeader(MsgType_1_1.Request, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast);
            request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
            this.sendMessage(request);
            ++rqId;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::reInvokeByFragment");
        }
    }

    protected Vector postBiDirLaunch(ObjectAdapter oa, Vector list) {
        if (use_bi_dir && !this.isConnectionInto(list)) {
            BiDirectionalClientConnectionIIOP bi = new BiDirectionalClientConnectionIIOP(oa, this.connection);
            bi.setDaemon(true);
            bi.start();
            list.addElement(this.connection);
        }
        return list;
    }

    public LocateStatusType_1_2 locate(ObjectImpl ref) throws COMM_FAILURE {
        Object tmp = this._target;
        this._target = ref;
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::locate");
        }
        if (!this.connected) {
            this.connectToServer();
        }
        manager.changeState(this.connection.object(), true);
        if (Trace.level != 0) {
            Trace.Step("Tentative de demande de localisation");
        }
        LocateStatusType_1_2 status = this.locateRemoteObject(ref);
        if (Trace.level != 0) {
            Trace.Step("Resultat de la recherche : " + status.value());
        }
        manager.changeState(this.connection.object(), false);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::locate");
        }
        this._target = tmp;
        return status;
    }

    public byte[] fillProfile(int ver_minor) {
        OutputStream output = this.plug.newOutputStream(this.version.minor);
        output.write_boolean(this.endianMode);
        switch (ver_minor) {
            case 0: {
                ProfileBody_1_0 profile = new ProfileBody_1_0();
                profile.host = this.host;
                profile.iiop_version = new Version();
                profile.iiop_version.major = 1;
                profile.iiop_version.minor = 0;
                profile.port = (short)this.port;
                profile.object_key = this.object_key;
                ProfileBody_1_0Helper.write(output, profile);
                break;
            }
            case 1: 
            case 2: {
                ProfileBody_1_1 profile_1 = new ProfileBody_1_1();
                profile_1.host = this.host;
                profile_1.iiop_version = new Version();
                profile_1.iiop_version.major = 1;
                profile_1.iiop_version.minor = (byte)ver_minor;
                profile_1.port = (short)this.port;
                profile_1.object_key = this.object_key;
                profile_1.components = this.tagged_list;
                ProfileBody_1_1Helper.write(output, profile_1);
                break;
            }
        }
        byte[] ProfileBody = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
        return ProfileBody;
    }

    public synchronized void parseLocateReplyMessage(byte[] buffer, boolean endian, IntHolder RqId, LocateStatusType_1_2Holder ReplyStatus) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                LocateReplyHeader_1_0 header = LocateReplyHeader_1_0Helper.read(is);
                RqId.value = header.request_id;
                ReplyStatus.value = LocateStatusType_1_2.from_int(header.locate_status.value());
                break;
            }
            case 2: {
                LocateReplyHeader_1_2 header2 = LocateReplyHeader_1_2Helper.read(is);
                RqId.value = header2.request_id;
                ReplyStatus.value = header2.locate_status;
                break;
            }
        }
    }

    public void changePeer(InputStream input) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::changePeer");
        }
        this.disconnectFromServer();
        if (this.previousIOR == null) {
            this.previousIOR = this.plug.newOutputStream(this.version.minor);
            this.writeObjectRef(this.previousIOR);
        }
        this.readObjectRef(input);
        this.connectToServer();
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::changePeer");
        }
    }

    public synchronized void getAvailableReply(short RqId, InputStream input, ExceptionList exceptList, Environment env) throws COMM_FAILURE {
        ReplyBag rb = null;
        IntHolder rqid = new IntHolder();
        ReplyStatusType_1_2Holder ReplyStatus = new ReplyStatusType_1_2Holder();
        int i = 0;
        while (i < replyQueue.size()) {
            rb = (ReplyBag)replyQueue.elementAt(i);
            if (rb.RqId == RqId) {
                if (Trace.level != 0) {
                    Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Get old received response : " + RqId);
                }
                replyQueue.removeElementAt(i);
                ClientConnectionIIOP.removeWaitedReply(RqId);
                this.parseReplyMessage(rb.buffer, rb.endian, rqid, ReplyStatus, input);
                switch (ReplyStatus.value.value()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.extractUserException(input, exceptList, env);
                        break;
                    }
                    case 2: {
                        this.extractSystemException(input, env);
                        break;
                    }
                    case 3: {
                        this.changePeer(input);
                        break;
                    }
                }
                return;
            }
            ++i;
        }
    }

    protected ClientStack getBiDirChannel(String host, int port) {
        return ORBSingleton._orb.getListenPointStackFor(host, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive(short RqId, InputStream input, ExceptionList exceptList, Environment env, java.lang.Object[] extra) throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::receive");
        }
        boolean redo = true;
        manager.changeState(this.connection.object(), true);
        try {
            if (ClientConnectionIIOP.isAvailableReply(RqId, false)) {
                this.getAvailableReply(RqId, input, exceptList, env);
            } else {
                while (redo) {
                    redo = this.receiveReply(RqId, input, exceptList, env);
                }
            }
        }
        catch (CloseConnectionEx ex) {
            // empty catch block
        }
        manager.changeState(this.connection.object(), false);
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::receive");
        }
    }

    public boolean isDataAvailable() throws COMM_FAILURE {
        boolean available;
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::isDataAvailable");
        }
        try {
            available = this.connection.available();
        }
        catch (IOException e) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de verifier les donnees disponibles = " + e);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to check available data", 7, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::isDataAvailable");
        }
        return available;
    }

    public LocateStatusType_1_2 locateRemoteObject(ObjectImpl ref) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::locateRemoteObject");
        }
        BooleanHolder endian = new BooleanHolder();
        BooleanHolder fragment = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        IntHolder RqId = new IntHolder();
        LocateStatusType_1_2Holder ReplyStatus = new LocateStatusType_1_2Holder();
        OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                byte[] objectKey = ((Delegate)ref._get_delegate())._get_key();
                LocateRequestHeader_1_0 header0 = new LocateRequestHeader_1_0(requestCount, objectKey);
                LocateRequestHeader_1_0Helper.write(requestBody, header0);
                break;
            }
            case 2: {
                TargetAddress targetKey = ((Delegate)ref._get_delegate())._get_target_key();
                LocateRequestHeader_1_2 header2 = new LocateRequestHeader_1_2(requestCount, targetKey);
                LocateRequestHeader_1_2Helper.write(requestBody, header2);
                break;
            }
        }
        boolean sent = false;
        if (((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer().length > 32008 && this.version.minor > 0) {
            this.sendLocateRequestByFragment(requestBody);
            sent = true;
        }
        if (!sent) {
            OutputStream request = this.createMessageHeader(MsgType_1_1.LocateRequest, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), (byte)0);
            request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
            this.sendMessage(request);
        }
        byte[] buffer = this.readBuffer(12);
        this.parseMessageHeader(buffer, endian, msgType, msgSize, fragment);
        buffer = this.readBuffer(msgSize.value);
        switch (msgType.value) {
            case 1: {
                this.sendMessageError();
                if (Trace.level == 0) break;
                Trace.CoreError("Le serveur nous renvoi Reply ce qui est impossible");
                break;
            }
            case 4: {
                if (fragment.value) {
                    this.receiveLocateReplyByFragment(buffer, endian.value, RqId, ReplyStatus);
                    break;
                }
                this.parseLocateReplyMessage(buffer, endian.value, RqId, ReplyStatus);
                break;
            }
            case 6: {
                this.disconnectFromServer();
                if (this.previousIOR != null) {
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous informe qu'il a recu un message errone, nous retournons au precedent serveur");
                    }
                    this.changePeer(this.previousIOR.create_input_stream());
                    this.previousIOR = null;
                    return this.locateRemoteObject(ref);
                }
                if (Trace.level != 0) {
                    Trace.CoreError("Le serveur nous informe qu'il a recu un message errone");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                }
                throw new COMM_FAILURE("Message error received from server", 6, CompletionStatus.COMPLETED_MAYBE);
            }
            case 5: {
                this.disconnectFromServer();
                if (this.previousIOR != null) {
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous informe qu'il a recu un message errone, nous retournons au precedent serveur");
                    }
                    this.changePeer(this.previousIOR.create_input_stream());
                    this.previousIOR = null;
                    return this.locateRemoteObject(ref);
                }
                if (Trace.level != 0) {
                    Trace.CoreError("Connexion fermee a la demande du serveur");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                }
                throw new COMM_FAILURE("Connection closed by peer", 6, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                this.disconnectFromServer();
                if (this.previousIOR != null) {
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous informe qu'il a recu un message errone, nous retournons au precedent serveur");
                    }
                    this.changePeer(this.previousIOR.create_input_stream());
                    this.previousIOR = null;
                    return this.locateRemoteObject(ref);
                }
                if (Trace.level != 0) {
                    Trace.CoreError("Type de message inattendu");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                }
                throw new COMM_FAILURE("Unexpected message sent by server", 6, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::locateRemoteObject");
        }
        return ReplyStatus.value;
    }

    public void extractSystemException(InputStream input, Environment env) {
        if (Trace.level != 0) {
            Trace.InOutFunction("ClientConnectionIIOP::extractSystemException");
        }
        String exceptId = input.read_string();
        int exceptMinor = input.read_ulong();
        int exceptStatusCode = input.read_ulong();
        CompletionStatus exceptStatus = CompletionStatus.from_int(exceptStatusCode);
        if (Trace.level != 0) {
            Trace.Step("Exception ID :" + exceptId);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_PARAM:1.0")) {
            throw new BAD_PARAM(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/NO_MEMORY:1.0")) {
            throw new NO_MEMORY(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/IMP_LIMIT:1.0")) {
            throw new IMP_LIMIT(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/COMM_FAILURE:1.0")) {
            throw new COMM_FAILURE(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INV_OBJREF:1.0")) {
            throw new INV_OBJREF(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/NO_PERMISSION:1.0")) {
            throw new NO_PERMISSION(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INTERNAL:1.0")) {
            throw new INTERNAL(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/MARSHAL:1.0")) {
            throw new MARSHAL(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INITIALIZE:1.0")) {
            throw new INITIALIZE(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0")) {
            throw new NO_IMPLEMENT(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_TYPECODE:1.0")) {
            throw new BAD_TYPECODE(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_OPERATION:1.0")) {
            throw new BAD_OPERATION(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/NO_RESOURCES:1.0")) {
            throw new NO_RESOURCES(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/NO_RESPONSE:1.0")) {
            throw new NO_RESPONSE(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/PERSIST_STORE:1.0")) {
            throw new PERSIST_STORE(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0")) {
            throw new BAD_INV_ORDER(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/TRANSIENT:1.0")) {
            throw new TRANSIENT(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/FREE_MEM:1.0")) {
            throw new FREE_MEM(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INV_IDENT:1.0")) {
            throw new INV_IDENT(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INV_FLAG:1.0")) {
            throw new INV_FLAG(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INTF_REPOS:1.0")) {
            throw new INTF_REPOS(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_CONTEXT:1.0")) {
            throw new BAD_CONTEXT(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0")) {
            throw new OBJ_ADAPTER(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/DATA_CONVERSION:1.0")) {
            throw new DATA_CONVERSION(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0")) {
            throw new OBJECT_NOT_EXIST(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0")) {
            throw new TRANSACTION_REQUIRED(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0")) {
            throw new TRANSACTION_ROLLEDBACK(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0")) {
            throw new INVALID_TRANSACTION(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/BAD_QOS:1.0")) {
            throw new BAD_QOS(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/INV_POLICY:1.0")) {
            throw new INV_POLICY(exceptMinor, exceptStatus);
        }
        if (exceptId.equals("IDL:omg.org/CORBA/CODESET_INCOMPATIBLE:1.0")) {
            throw new CODESET_INCOMPATIBLE(exceptMinor, exceptStatus);
        }
        if (Trace.level != 0) {
            Trace.Step("Unknown exception intercepted...");
        }
        UNKNOWN uex = new UNKNOWN(exceptMinor, exceptStatus);
        this.plug.setUnknown(uex, this._sc_list_consumed, this.version.minor);
        throw uex;
    }

    public void _set_target(Object target) {
        if (target == null) {
            return;
        }
        this._target = target;
    }

    public Object _get_target() {
        return this._target;
    }

    public static synchronized void appendReplyToQueue(InputStream input, byte[] buffer, boolean endian, short rqid) {
        ReplyBag rb = new ReplyBag();
        rb.buffer = buffer;
        rb.endian = endian;
        rb.RqId = rqid;
        ((ExtendedInputStream)((java.lang.Object)input)).setBuffer(new byte[100], endian);
        replyQueue.addElement(rb);
    }

    protected static synchronized boolean isAnyRequestToRead() {
        return waitedRequest.size() != 0;
    }

    public ClientConnectionIIOP() {
        if (Trace.level != 0) {
            Trace.NewInstance("ClientConnectionIIOP");
        }
        this.endianMode = NaturalEndian.value;
        this.connected = false;
        this.version = new org.omg.GIOP.Version(1, ProtocolPlugIIOP.minor);
        this.tagged_list = new TaggedComponent[0];
        this.component_list = new TaggedComponent[0];
        this._sc_list_supplied = new ServiceContext[0];
        this._sc_list_consumed = new ServiceContext[0];
        this.plug = ORBSingleton.plug;
        this.connection = this.plug.newClientStack(this);
        this.previousIOR = null;
        this.currentRequest = new RequestContainer();
        if (!_init) {
            _init = true;
            String s = ORBSingleton.getORBProperty("ORB.RetryCount");
            max_retry = s != null ? (int)new Short(s).shortValue() : 5;
            s = System.getProperty("user.name");
            _user_ = s == null ? new byte[0] : s.getBytes();
            s = ORBSingleton.getORBProperty("ORB.BiDirIIOP");
            if (s != null && s.equalsIgnoreCase("true")) {
                use_bi_dir = true;
            }
        }
    }

    public int sendRequestByFragment(OutputStream output) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::sendRequestByFragment");
        }
        byte[] buffer = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
        boolean last_frag = false;
        int last_size = buffer.length;
        int buffer_index = 0;
        int rqid = 0;
        this.checkBiDirIIOP();
        int frag_size = 31988;
        if (Trace.level != 0) {
            Trace.Step("Send by fragments, initiale size : " + last_size);
        }
        int fragNum = 0;
        while (!last_frag) {
            OutputStream requestBody = this.plug.newOutputStream(this.version.minor);
            if (++fragNum > 1 && this.version.minor == 2) {
                FragmentHeader_1_2 fragmentHeader = new FragmentHeader_1_2(requestCount);
                FragmentHeader_1_2Helper.write(requestBody, fragmentHeader);
            }
            byte[] toSend = new byte[frag_size];
            System.arraycopy(buffer, buffer_index, toSend, 0, frag_size);
            if (this.version.minor == 2) {
                ((ExtendedOutputStream)((java.lang.Object)requestBody)).alignment(8);
            }
            requestBody.write_octet_array(toSend, 0, frag_size);
            buffer_index += frag_size;
            if ((last_size -= frag_size) < 32000) {
                frag_size = last_size;
            }
            if (frag_size == 0) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            byte notLast = 0;
            if (!last_frag) {
                notLast = 1;
            }
            OutputStream request = fragNum > 1 ? this.createMessageHeader(MsgType_1_1.Fragment, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast) : this.createMessageHeader(MsgType_1_1.Request, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count(), notLast);
            request.write_octet_array(((ExtendedOutputStream)((java.lang.Object)requestBody)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)requestBody)).count());
            ++requestCount;
            this.sendMessage(request);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::sendRequestByFragment");
        }
        return rqid;
    }

    public void receiveLocateReplyByFragment(byte[] buffer, boolean endian, IntHolder RqId, LocateStatusType_1_2Holder ReplyStatus) {
        boolean last_frag = false;
        byte[] msg = new byte[]{};
        int fragNum = 0;
        BooleanHolder fragment = new BooleanHolder();
        BooleanHolder endianType = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        if (Trace.level != 0) {
            Trace.Step("Receive reply by fragment");
        }
        if (Trace.level != 0) {
            Trace.Step("New fragment  : 1");
        }
        msg = buffer;
        while (!last_frag) {
            ++fragNum;
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endianType, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            if (!fragment.value) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            InputStream tempBody = this.plug.newInputStream(this.version.minor);
            byte[] tmp = null;
            if (this.version.minor == 2) {
                this.parseFragmentMessage(buffer, endian, RqId, tempBody);
                tmp = ((ExtendedInputStream)((java.lang.Object)tempBody)).getBuffer();
            } else {
                tmp = buffer;
            }
            if (Trace.level != 0) {
                Trace.Step("Fragment size = " + tmp.length);
            }
            byte[] old = msg;
            msg = new byte[msg.length + tmp.length];
            System.arraycopy(old, 0, msg, 0, old.length);
            System.arraycopy(tmp, 0, msg, old.length, tmp.length);
        }
        if (Trace.level != 0) {
            Trace.Step("Message size : " + msg.length);
        }
        this.parseLocateReplyMessage(msg, endian, RqId, ReplyStatus);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean receiveReply(int RequestId, InputStream input, ExceptionList exceptList, Environment env) throws CloseConnectionEx {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::receiveReply");
        }
        endian = new BooleanHolder();
        msgType = new ByteHolder();
        msgSize = new IntHolder();
        RqId = new IntHolder();
        fragment = new BooleanHolder();
        ReplyStatus = new ReplyStatusType_1_2Holder();
        this.addWaitedReply((short)RequestId);
        var12_11 = this.connection.locker();
        synchronized (var12_11) {
            if (ClientConnectionIIOP.isAnyReplyToRead((short)RequestId)) {
                return true;
            }
            if (ClientConnectionIIOP.isAnyRequestToRead()) {
                return true;
            }
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endian, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            switch (msgType.value) {
                case 0: {
                    if (Trace.level != 0) {
                        Trace.Step("( Thread " + Thread.currentThread().toString() + " ) A request has been received... save it");
                    }
                    ClientConnectionIIOP.appendRequestToQueue(buffer, endian.value, msgType.value, fragment.value);
                    return true;
                }
                case 1: {
                    if (fragment.value) {
                        if (Trace.level != 0) {
                            Trace.Step("Response received by fragment");
                        }
                        this.receiveReplyByFragment(buffer, endian.value, RqId, ReplyStatus, input);
                    } else {
                        this.parseReplyMessage(buffer, endian.value, RqId, ReplyStatus, input);
                    }
                    if (Trace.level != 0) {
                        Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Received response : " + RqId.value + " / Waited : " + RequestId);
                    }
                    if (RequestId == RqId.value) {
                        ClientConnectionIIOP.removeWaitedReply((short)RequestId);
                        if (Trace.level != 0) {
                            Trace.Step("Response received.");
                        }
                        switch (ReplyStatus.value.value()) {
                            case 0: {
                                ** break;
                            }
                            case 1: {
                                this.extractUserException(input, exceptList, env);
                                ** break;
                            }
                            case 2: {
                                this.extractSystemException(input, env);
                                ** break;
                            }
                            case 3: {
                                if (Trace.level != 0) {
                                    Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Ask for a location forward...");
                                }
                                this.changePeer(input);
                                this.reInvoke();
                                return true;
                            }
                        }
                        ** break;
                    }
                    if (Trace.level != 0) {
                        Trace.Step("This is not the waited response, save it");
                    }
                    ClientConnectionIIOP.appendReplyToQueue(input, buffer, endian.value, (short)RqId.value);
                    return true;
                }
                case 4: {
                    this.sendMessageError();
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous renvoi LocateReply ce qui est impossible");
                        ** break;
                    }
                    break;
                }
                case 6: {
                    this.disconnectFromServer();
                    if (this.previousIOR != null) {
                        if (Trace.level != 0) {
                            Trace.CoreError("Le serveur nous informe qu'il a recu un message errone, nous retournons au precedent serveur");
                        }
                        this.changePeer(this.previousIOR.create_input_stream());
                        this.previousIOR = null;
                        return true;
                    }
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous informe qu'il a recu un message errone");
                    }
                    if (Trace.level == 0) throw new COMM_FAILURE("Message error received from server", 6, CompletionStatus.COMPLETED_MAYBE);
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                    throw new COMM_FAILURE("Message error received from server", 6, CompletionStatus.COMPLETED_MAYBE);
                }
                case 5: {
                    this.disconnectAllFromServer();
                    if (this.previousIOR == null) throw new CloseConnectionEx();
                    if (Trace.level != 0) {
                        Trace.CoreError("Le serveur nous informe qu'il a recu un message errone, nous retournons au precedent serveur");
                    }
                    this.changePeer(this.previousIOR.create_input_stream());
                    this.previousIOR = null;
                    return true;
                }
                case 7: {
                    if (Trace.level != 0) {
                        Trace.CoreError("Type de message inattendu");
                    }
                    this.sendMessageError();
                    ** break;
                }
                default: {
                    if (Trace.level != 0) {
                        Trace.CoreError("Type de message inattendu");
                    }
                    this.sendMessageError();
                    return true;
                }
            }
lbl98:
            // 6 sources

            var13_28 = null;
        }
        if (Trace.level == 0) return false;
        Trace.OutFunction("ClientConnectionIIOP::receiveReply");
        return false;
    }

    public static synchronized boolean isAvailableReply(short rqid, boolean mark) {
        ReplyBag rb = null;
        int i = 0;
        while (i < replyQueue.size()) {
            rb = (ReplyBag)replyQueue.elementAt(i);
            if (rb.RqId == rqid) {
                if (rb.mark && mark) {
                    return false;
                }
                rb.mark = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void _set_port(int port) {
        this.port = port;
    }

    public int _get_port() {
        return this.port;
    }

    protected void launchBiDirIIOP(ClientStack c) {
        if (use_bi_dir && ORBSingleton.oa != null) {
            BiDirectionalClientConnectionIIOP bi = new BiDirectionalClientConnectionIIOP(ORBSingleton.oa, c);
            bi.setDaemon(true);
            bi.start();
        }
    }

    protected void checkBiDirIIOP() {
        if (use_bi_dir && _bi_dir_tag != null) {
            if (Trace.level != 0) {
                Trace.Step("Add BiDir IIOP Context");
            }
            ServiceContext[] list = new ServiceContext[this._sc_list_supplied.length + 1];
            System.arraycopy(this._sc_list_supplied, 0, list, 0, this._sc_list_supplied.length);
            list[this._sc_list_supplied.length] = _bi_dir_tag;
            this._sc_list_supplied = list;
        }
    }

    public void setTimeOut(int limit) {
        this.connection.setTimeOut(limit);
    }

    public java.lang.Object _get_extra(String name) {
        if (name.equals("TaggedProfile")) {
            return this.tagged_list;
        }
        if (name.equals("TaggedComponent")) {
            return this.component_list;
        }
        if (name.equals("RequestId")) {
            return new Integer(this._tmp_rqId);
        }
        return null;
    }

    public void _set_id(String id) {
        this.typeId = id;
    }

    public String _get_id() {
        return this.typeId;
    }

    public void _set_extra(String name, java.lang.Object value) {
        if (name.equals("TaggedProfile")) {
            this.tagged_list = (TaggedComponent[])value;
        } else if (name.equals("TaggedComponent")) {
            this.component_list = (TaggedComponent[])value;
        } else if (name.equals("RequestId")) {
            this._tmp_rqId = (Integer)value;
        }
    }

    static {
        replyQueue = new Vector();
        waitedReply = new Vector();
        waitedRequest = new Vector();
        _bi_dir_tag = null;
        use_bi_dir = false;
        _user_ = null;
        _init = false;
    }

    public void readObjectRef(InputStream is) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::readObjectRef");
        }
        boolean find_profile = false;
        IOR ior = null;
        org.omg.GIOP.Version ver = null;
        ior = IORHelper.read(is);
        this.typeId = ior.type_id;
        if (this.typeId.equals("")) {
            this.typeId = null;
        }
        if (Trace.level != 0) {
            Trace.Step("Type Id : " + this.typeId);
        }
        int i = 0;
        while (i < ior.profiles.length) {
            block33: {
                boolean endian;
                InputStream input;
                block32: {
                    if (ior.profiles[i].tag != 0) break block32;
                    if (Trace.level != 0) {
                        Trace.Step("Profile IIOP");
                    }
                    if (find_profile) break block33;
                    find_profile = true;
                    input = this.plug.newInputStream(ior.profiles[i].profile_data, false, this.version.minor);
                    endian = input.read_boolean();
                    ((ExtendedInputStream)((java.lang.Object)input)).setEndian(endian);
                    ver = this.adaptVersion(VersionHelper.read(input));
                    ((ExtendedInputStream)((java.lang.Object)input)).resetCount();
                    input.read_boolean();
                    switch (ver.minor) {
                        case 0: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.0");
                            }
                            ProfileBody_1_0 profile = ProfileBody_1_0Helper.read(input);
                            this.host = profile.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile.iiop_version);
                            this.object_key = profile.object_key;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                            }
                            this.tagged_list = new TaggedComponent[0];
                            break;
                        }
                        case 1: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.1");
                            }
                            ProfileBody_1_1 profile_1 = ProfileBody_1_1Helper.read(input);
                            this.host = profile_1.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile_1.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile_1.iiop_version);
                            this.object_key = profile_1.object_key;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                            }
                            this.tagged_list = profile_1.components;
                            break;
                        }
                        case 2: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.2");
                            }
                            ProfileBody_1_1 profile_2 = ProfileBody_1_1Helper.read(input);
                            this.host = profile_2.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile_2.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile_2.iiop_version);
                            this.object_key = profile_2.object_key;
                            this.target_key = new TargetAddress();
                            this.target_key.object_key(this.object_key);
                            this.tagged_list = profile_2.components;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                                break;
                            }
                            break block33;
                        }
                    }
                    break block33;
                }
                if (ior.profiles[i].tag == 1) {
                    if (Trace.level != 0) {
                        Trace.Step("Profile MULTIPLE COMPONENTS");
                    }
                    input = this.plug.newInputStream(ior.profiles[i].profile_data, false, this.version.minor);
                    endian = input.read_boolean();
                    ((ExtendedInputStream)((java.lang.Object)input)).setEndian(endian);
                    int nb_components = input.read_ulong();
                    this.component_list = new TaggedComponent[nb_components];
                    int j = 0;
                    while (j < nb_components) {
                        this.component_list[j] = TaggedComponentHelper.read(input);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!find_profile && this.typeId != null) {
            if (Trace.level != 0) {
                Trace.CoreError("Reference d'objet invalide");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.INV_OBJREF");
            }
            throw new INV_OBJREF("Invalid IIOP reference", 1, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::readObjectRef");
        }
    }

    public void writeObjectRef(OutputStream os) {
        int delta = 0;
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::writeObjectRef");
        }
        if (this.component_list.length != 0) {
            ++delta;
        }
        IOR ior = new IOR();
        ior.type_id = this.typeId;
        switch (this.version.minor) {
            case 0: {
                ior.profiles = new TaggedProfile[delta + 1];
                ior.profiles[0] = new TaggedProfile();
                ior.profiles[0].tag = 0;
                ior.profiles[0].profile_data = this.fillProfile(this.version.minor);
                if (delta == 0) break;
                ior.profiles[1] = new TaggedProfile();
                ior.profiles[1].tag = 1;
                OutputStream output = this.plug.newOutputStream(this.version.minor);
                output.write_boolean(this.endianMode);
                output.write_ulong(this.component_list.length);
                int i = 0;
                while (i < this.component_list.length) {
                    TaggedComponentHelper.write(output, this.component_list[i]);
                    ++i;
                }
                ior.profiles[1].profile_data = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
                break;
            }
            case 1: 
            case 2: {
                ior.profiles = new TaggedProfile[2 + delta];
                ior.profiles[0] = new TaggedProfile();
                ior.profiles[0].tag = 0;
                ior.profiles[0].profile_data = this.fillProfile(this.version.minor);
                ior.profiles[1] = new TaggedProfile();
                ior.profiles[1].tag = 0;
                ior.profiles[1].profile_data = this.fillProfile(0);
                if (delta == 0) break;
                ior.profiles[2] = new TaggedProfile();
                ior.profiles[2].tag = 1;
                OutputStream output = this.plug.newOutputStream(this.version.minor);
                output.write_boolean(this.endianMode);
                output.write_ulong(this.component_list.length);
                int i = 0;
                while (i < this.component_list.length) {
                    TaggedComponentHelper.write(output, this.component_list[i]);
                    ++i;
                }
                ior.profiles[2].profile_data = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
                break;
            }
        }
        IORHelper.write(os, ior);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::writeObjectRef");
        }
    }

    protected void finalize() {
        if (this.connected) {
            this.disconnectFromServer();
        }
    }
}

