/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.handler.ConnectionInfo;
import JavaORB.CORBA.handler.ListenerManager;
import JavaORB.Trace;
import JavaORB.iiop.ClientConnectionIIOP;
import JavaORB.iiop.ConnectionTable;
import java.io.IOException;
import java.net.Socket;
import org.omg.CORBA.INTERNAL;

public class ConnectionManager
extends Thread {
    private boolean echo;
    private long sleepTime = 20000L;
    private long deadlineTime;
    private boolean stop = false;
    private ConnectionTable[] table;
    private ListenerManager listener;

    public void remove(Object c) {
        int find = -1;
        int i = 0;
        while (i < this.table.length) {
            if (this.table[i].connection == c) {
                find = i;
                break;
            }
            ++i;
        }
        if (find != -1) {
            this.removeConnection(find);
        }
    }

    public synchronized void addConnection(Object connection, String host, int port) {
        ConnectionTable[] tmp = new ConnectionTable[this.table.length + 1];
        ConnectionTable entry = new ConnectionTable();
        System.arraycopy(this.table, 0, tmp, 0, this.table.length);
        tmp[this.table.length] = entry;
        this.table = tmp;
        if (this.echo) {
            System.out.println("[ Open a connection to ( " + host + " ) on port ( " + port + " ) ]");
        }
        entry.connection = connection;
        entry.inUsage = 0L;
        entry.host = host;
        entry.port = port;
        entry.hasBeenUsed = false;
        entry.deadline = System.currentTimeMillis() + this.deadlineTime;
    }

    public synchronized void changeState(Object connection, boolean used) {
        ConnectionTable entry = this.lookfor(connection);
        if (entry != null) {
            entry.inUsage = used ? ++entry.inUsage : --entry.inUsage;
            if (used) {
                entry.hasBeenUsed = true;
            }
        }
    }

    public ConnectionManager() {
        String s = ORBSingleton.getORBProperty("ORB.ServerTimeOut");
        this.deadlineTime = s != null ? new Long(s) : 15000L;
        s = ORBSingleton.getORBProperty("ORB.ConnectionVerbose");
        this.echo = false;
        if (s != null && s.toLowerCase().equals("true")) {
            this.echo = true;
        }
        this.listener = ORBSingleton._orb.get_listener_manager();
        this.table = new ConnectionTable[0];
        this.setDaemon(true);
        this.start();
    }

    public void updateDeadline(Object connection) {
        ConnectionTable entry = this.lookfor(connection);
        if (entry != null) {
            entry.deadline = System.currentTimeMillis() + this.deadlineTime;
        }
    }

    public void closeConnection(int index) {
        if (Trace.level != 0) {
            Trace.Step("Ferme une connexion qui a atteint sa deadline");
        }
        ConnectionTable entry = this.table[index];
        if (this.echo) {
            System.out.println("[ Close connection to ( " + entry.host + " ) on port ( " + entry.port + " ) ]");
        }
        if (Trace.level != 0) {
            Trace.Step("Ferme toutes les connexions partagees");
        }
        int i = 0;
        while (i < ClientConnectionIIOP.connectionList.size()) {
            ClientConnectionIIOP cl = (ClientConnectionIIOP)ClientConnectionIIOP.connectionList.elementAt(i);
            if (Trace.level != 0) {
                Trace.Step("Recherche parmi les connexions ouvertes : " + cl._get_host() + " / " + cl._get_port());
            }
            if (cl._get_host().equalsIgnoreCase(entry.host) && cl._get_port() == entry.port) {
                if (Trace.level != 0) {
                    Trace.Step("Ferme une connexion partagee");
                }
                cl.connected = false;
                ClientConnectionIIOP.connectionList.removeElementAt(i);
                i = -1;
            }
            ++i;
        }
        this.report_connection_close(entry.host, entry.port);
        try {
            ((Socket)entry.connection).close();
        }
        catch (IOException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de fermer la connection");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.INTERNAL");
            }
            throw new INTERNAL();
        }
        entry.connection = null;
        this.removeConnection(index);
    }

    private void report_connection_close(String host, int port) {
        ConnectionInfo ci = new ConnectionInfo();
        ci.host = host;
        ci.port = port;
        ci.clientSide = true;
        this.listener.dispatchCloseConnectionEvent(ci);
    }

    public ConnectionTable lookfor(Object connection) {
        int i = 0;
        while (i < this.table.length) {
            if (this.table[i].connection == connection) {
                return this.table[i];
            }
            ++i;
        }
        return null;
    }

    public void stopManager() {
        this.stop = true;
    }

    public void run() {
        try {
            while (!this.stop) {
                Thread.sleep(this.sleepTime);
                this.checkConnectionTable();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkConnectionTable() {
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < this.table.length) {
            if (!this.table[i].hasBeenUsed) {
                if (this.table[i].inUsage == 0L && time > this.table[i].deadline) {
                    this.closeConnection(i--);
                }
            } else {
                this.table[i].hasBeenUsed = false;
                this.table[i].deadline = System.currentTimeMillis() + this.deadlineTime;
            }
            ++i;
        }
    }

    public synchronized void removeConnection(int index) {
        ConnectionTable[] tmp = new ConnectionTable[this.table.length - 1];
        System.arraycopy(this.table, 0, tmp, 0, index);
        if (index != this.table.length - 1) {
            System.arraycopy(this.table, index + 1, tmp, index, this.table.length - (index + 1));
        }
        this.table = tmp;
    }
}

