/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.AbstractInterface;
import JavaORB.CORBA.AbstractInterfaceHelper;
import JavaORB.CORBA.Any;
import JavaORB.CORBA.Context;
import JavaORB.CORBA.DataInputStream;
import JavaORB.CORBA.NaturalEndian;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.TypeCode;
import JavaORB.CORBA.handler.ObjectFactory;
import JavaORB.Trace;
import JavaORB.protocol.ExtendedInputStream;
import JavaORB.util.URLLoader;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;

public class InputCDRStream
extends InputStream
implements ExtendedInputStream {
    protected static final int OPEN_ENCAPS = -1;
    protected byte[] buffer;
    protected int count;
    private boolean swap;
    protected ORBSingleton orb;
    protected ObjectFactory _factory;
    private boolean _endian;
    private Stack _encap_stack = new Stack();
    protected int encap_remain = -1;
    protected Hashtable _value_list;
    protected int _indirection;
    protected int _version;

    protected Serializable getValueFromList(int index) {
        Enumeration enumeration = this._value_list.keys();
        Integer val = null;
        while (enumeration.hasMoreElements()) {
            val = (Integer)enumeration.nextElement();
            if (val != index) continue;
            return (Serializable)this._value_list.get(val);
        }
        return null;
    }

    public int read() throws IOException {
        if (this.count + 1 >= this.buffer.length) {
            return -1;
        }
        return this.read_octet();
    }

    public int read(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        int len = Math.min(buf.length, this.buffer.length - this.count);
        this.read_octet_array(buf, 0, len);
        return len;
    }

    public int read(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        len = Math.min(len, this.buffer.length - this.count);
        this.read_octet_array(buf, off, len);
        return len;
    }

    public int read_long() {
        this.alignment(4);
        int l = this.buffer[this.count++] << 24 | this.buffer[this.count++] << 16 & 0xFF0000 | this.buffer[this.count++] << 8 & 0xFF00 | this.buffer[this.count++] & 0xFF;
        if (this.swap) {
            int tmp;
            l = tmp = l >>> 24 | (l & 0xFF0000) >>> 8 | (l & 0xFF00) << 8 | (l & 0xFF) << 24;
        }
        this.check_encaps_end(4);
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + l);
        }
        return l;
    }

    public int read_ulong() {
        return this.read_long();
    }

    public void begin_encapsulation() {
        int len = this.read_ulong();
        if (len == -1) {
            throw new IndexOutOfBoundsException();
        }
        if (this.encap_remain >= 0) {
            this.encap_remain -= len;
        }
        this._encap_stack.push(new Boolean(this.swap));
        this._encap_stack.push(new Integer(this.encap_remain));
        this.encap_remain = len;
        this.swap = this.read_boolean();
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public Object read_Object() {
        ObjectImpl obj;
        JavaORB.CORBA.portable.ObjectImpl objimpl = new JavaORB.CORBA.portable.ObjectImpl();
        objimpl._set_delegate(new JavaORB.CORBA.portable.Delegate());
        ((JavaORB.CORBA.portable.Delegate)objimpl._get_delegate())._read_Object(this);
        this._factory.unmarshalObject(objimpl);
        if (objimpl.is_nil()) {
            return null;
        }
        if (ORBSingleton.oa != null && (obj = ORBSingleton.oa.implExists(objimpl)) != null) {
            return obj;
        }
        return objimpl;
    }

    public Object read_Object(Class clz) {
        return null;
    }

    public void alignment(int size) {
        if (this.count != 0 && this.count % size != 0) {
            int skip = size - this.count % size;
            this.count += skip;
            this.check_encaps_end(skip);
        }
        if (Trace.level != 0) {
            Trace.Step("Taille du buffer : " + this.buffer.length + " acces : " + this.count);
        }
    }

    private void check_encaps_end(int len) {
        if (this.encap_remain >= 0) {
            this.encap_remain -= len;
            if (this.encap_remain <= 0) {
                this.encap_remain = (Integer)this._encap_stack.pop();
                this.swap = (Boolean)this._encap_stack.pop();
            }
        }
    }

    public boolean equals(org.omg.CORBA.portable.InputStream is) {
        if (Trace.level != 0) {
            Trace.InOutFunction("InputStream::equals");
        }
        return this.getBuffer() == ((ExtendedInputStream)((java.lang.Object)is)).getBuffer();
    }

    public char read_char() {
        char c = (char)this.buffer[this.count++];
        this.check_encaps_end(1);
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + c);
        }
        return c;
    }

    public void read_boolean_array(boolean[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.buffer[this.count++] == 1;
            ++i;
        }
        this.check_encaps_end(length);
    }

    public void read_short_array(short[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_short();
            ++i;
        }
    }

    public void read_ushort_array(short[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_ushort();
            ++i;
        }
    }

    public void fromHexaString(String str) {
        if (Trace.level != 0) {
            Trace.InFunction("InputStream::fromHexaString");
        }
        String ascii = "0123456789abcdef";
        str = str.toLowerCase();
        this.buffer = new byte[str.length() / 2];
        this.resetCount();
        int i = 0;
        int j = 0;
        while (i < str.length() / 2) {
            int high = ascii.indexOf(str.charAt(j++));
            int low = ascii.indexOf(str.charAt(j++));
            this.buffer[i] = (byte)(16 * high + low);
            ++i;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("InputStream::fromHexaString");
        }
    }

    public String read_wstring() {
        char[] tab = null;
        switch (this._version) {
            case 0: 
            case 1: {
                int taille = this.read_ulong() / 2 - 1;
                tab = new char[taille];
                if (taille == 0) {
                    this.read_wchar();
                    return null;
                }
                this.read_wchar_array(tab, 0, taille);
                this.read_wchar();
                return new String(tab);
            }
            case 2: {
                int taille = this.read_ulong() / 2;
                tab = new char[taille];
                this.read_wchar_array(tab, 0, taille);
                return new String(tab);
            }
        }
        return null;
    }

    public java.lang.Object read_abstract_interface() {
        Object ior = null;
        AbstractInterface abs = AbstractInterfaceHelper.read(this);
        if (!abs.discriminator()) {
            return abs.value();
        }
        ior = abs.ior();
        Delegate deleg = ((ObjectImpl)ior)._get_delegate();
        ObjectImpl stub = this.loadStubWithID(((JavaORB.CORBA.portable.Delegate)deleg)._get_id());
        stub._set_delegate(deleg);
        return stub;
    }

    public void read_char_array(char[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = (char)this.buffer[this.count++];
            ++i;
        }
        this.check_encaps_end(length);
    }

    public void read_double_array(double[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_double();
            ++i;
        }
    }

    public java.lang.Object read_abstract_interface(Class clz) {
        boolean discriminator = this.read_boolean();
        if (!discriminator) {
            return this.read_value(clz);
        }
        Object ior = this.read_Object();
        Delegate deleg = ((ObjectImpl)ior)._get_delegate();
        java.lang.Object object = this.createObject(clz);
        ObjectImpl stub = null;
        try {
            stub = (ObjectImpl)object;
        }
        catch (ClassCastException ex) {
            throw new BAD_PARAM();
        }
        stub._set_delegate(deleg);
        return stub;
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public Serializable read_value() {
        String[] id = null;
        byte[] buf = null;
        String CodeBase2 = null;
        Serializable ser = null;
        int size = 0;
        this.alignment(4);
        this._indirection = this.count;
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            ser = this.getValueFromList(index);
            if (ser == null) {
                int temp = this.count;
                int temp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                ser = this.read_value();
                this.count = temp;
                this.encap_remain = temp_remain;
                if (ser == null) {
                    throw new MARSHAL("Invalid indirection");
                }
            }
            return ser;
        }
        if (tag == 0) {
            return null;
        }
        if (tag <= 0x7FFFFF00 || tag >= Integer.MAX_VALUE) {
            throw new MARSHAL("Invalid value tag");
        }
        if ((tag & 1) == 1) {
            if (this.read_long() == -1) {
                int index = this.read_ulong();
                int tmp = this.count;
                int tmp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                CodeBase2 = this.read_string();
                this.count = tmp;
                this.encap_remain = tmp_remain;
            } else {
                CodeBase2 = this.read_string();
            }
        }
        if ((tag & 6) == 2) {
            id = new String[]{this.read_string()};
        }
        if ((tag & 6) == 6) {
            id = new String[this.read_long()];
            int i = 0;
            while (i < id.length) {
                id[i] = this.read_string();
                ++i;
            }
        }
        size = 0;
        if ((tag & 8) == 8) {
            size = this.read_long();
            buf = new byte[size];
            if (Trace.level != 0) {
                Trace.Step("Read value chunk = " + size);
            }
            this.read_octet_array(buf, 0, size);
        }
        ValueFactory factory = null;
        int i = 0;
        try {
            while ((factory = this.orb.lookup_value_factory(id[i])) == null) {
                try {
                    factory = this.loadFactoryWithID(id[i], CodeBase2);
                }
                catch (MARSHAL ex) {
                    // empty catch block
                }
                if (++i != id.length) continue;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MARSHAL();
        }
        if (factory == null) {
            throw new MARSHAL();
        }
        if (size == 0) {
            ser = factory.read_value(this);
        } else {
            InputCDRStream input = new InputCDRStream(buf, this.getEndian());
            ser = factory.read_value(input);
        }
        if ((tag & 8) == 8) {
            this.read_long();
        }
        return ser;
    }

    public Serializable read_value(String rep_id) {
        String[] id = null;
        byte[] buf = null;
        String CodeBase2 = null;
        Serializable ser = null;
        int size = 0;
        this.alignment(4);
        this._indirection = this.count;
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            ser = this.getValueFromList(index);
            if (ser == null) {
                int temp = this.count;
                int temp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                ser = this.read_value();
                this.count = temp;
                this.encap_remain = temp_remain;
                if (ser == null) {
                    throw new MARSHAL("Invalid indirection");
                }
            }
            return ser;
        }
        if (tag == 0) {
            return null;
        }
        if (tag <= 0x7FFFFF00 || tag >= Integer.MAX_VALUE) {
            throw new MARSHAL("Invalid value tag");
        }
        if ((tag & 1) == 1) {
            if (this.read_long() == -1) {
                int index = this.read_ulong();
                int tmp = this.count;
                int tmp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                CodeBase2 = this.read_string();
                this.count = tmp;
                this.encap_remain = tmp_remain;
            } else {
                CodeBase2 = this.read_string();
            }
        }
        if ((tag & 6) == 2) {
            id = new String[]{this.read_string()};
        }
        if ((tag & 6) == 6) {
            id = new String[this.read_long()];
            int i = 0;
            while (i < id.length) {
                id[i] = this.read_string();
                ++i;
            }
        }
        boolean found = false;
        int i = 0;
        while (i < id.length) {
            if (id.equals(rep_id)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            throw new BAD_PARAM();
        }
        size = 0;
        if ((tag & 8) == 8) {
            size = this.read_long();
            buf = new byte[size];
            if (Trace.level != 0) {
                Trace.Step("Read value chunk = " + size);
            }
            this.read_octet_array(buf, 0, size);
        }
        ValueFactory factory = null;
        factory = this.orb.lookup_value_factory(rep_id);
        if (factory == null) {
            factory = this.loadFactoryWithID(rep_id, CodeBase2);
        }
        if (factory == null) {
            throw new MARSHAL();
        }
        if (size == 0) {
            ser = factory.read_value(this);
        } else {
            InputCDRStream input = new InputCDRStream(buf, this.getEndian());
            ser = factory.read_value(input);
        }
        if ((tag & 8) == 8) {
            this.read_long();
        }
        return ser;
    }

    public Serializable read_value(Serializable value) {
        this._value_list.put(new Integer(this._indirection), value);
        if (value instanceof CustomValue) {
            CustomValue customValue = (CustomValue)value;
            DataInputStream inputStream = new DataInputStream(this);
            customValue.unmarshal(inputStream);
            return value;
        }
        if (value instanceof StreamableValue) {
            ((StreamableValue)value)._read(this);
            return value;
        }
        throw new BAD_PARAM();
    }

    public Serializable read_value(Class clz) {
        java.lang.Object value = null;
        value = this.createObject(clz);
        if (value instanceof Serializable) {
            return this.read_value((Serializable)value);
        }
        throw new BAD_PARAM();
    }

    public Serializable read_value(BoxedValueHelper factory) {
        String[] id;
        String CodeBase2 = null;
        this.alignment(4);
        this._indirection = this.count;
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            Serializable ser = this.getValueFromList(index);
            if (ser == null) {
                int temp = this.count;
                int temp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                ser = this.read_value();
                this.count = temp;
                this.encap_remain = temp_remain;
                if (ser == null) {
                    throw new MARSHAL("Invalid indirection");
                }
            }
            return ser;
        }
        if (tag == 0) {
            return null;
        }
        if (tag <= 0x7FFFFF00 || tag >= Integer.MAX_VALUE) {
            throw new MARSHAL("Invalid value tag");
        }
        if ((tag & 1) == 1) {
            if (this.read_long() == -1) {
                int index = this.read_ulong();
                int tmp = this.count;
                int tmp_remain = this.encap_remain;
                this.count = index;
                this.encap_remain = -1;
                CodeBase2 = this.read_string();
                this.count = tmp;
                this.encap_remain = tmp_remain;
            } else {
                CodeBase2 = this.read_string();
            }
        }
        if ((tag & 6) == 2 && !(id = new String[]{this.read_string()})[0].equals(factory.get_id())) {
            throw new MARSHAL();
        }
        return factory.read_value(this);
    }

    public void setEndian(boolean bigEndian) {
        if (Trace.level != 0) {
            Trace.InFunction("InputStream::setEndian");
        }
        this.swap = bigEndian != NaturalEndian.value;
        if (Trace.level != 0) {
            Trace.OutFunction("InputStream::setEndian");
        }
    }

    public boolean getEndian() {
        if (Trace.level != 0) {
            Trace.InOutFunction("InputStream::getEndian");
        }
        if (this.swap) {
            return !NaturalEndian.value;
        }
        return NaturalEndian.value;
    }

    public boolean read_boolean() {
        boolean b = this.buffer[this.count++] == 1;
        this.check_encaps_end(1);
        if (Trace.level != 0) {
            Trace.FullStep("Valeur lue : " + b);
        }
        return b;
    }

    public void skip_encapsulation() {
        int skip = this.read_ulong();
        if (skip == -1) {
            throw new IndexOutOfBoundsException();
        }
        this.skip(skip);
        if (this.encap_remain >= 0) {
            this.encap_remain -= skip;
        }
    }

    private void stream_close() {
        this.swap = this._endian;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long n) {
        if (n < 0L) {
            throw new IndexOutOfBoundsException();
        }
        ret = 0L;
        if (n != 0L) ** GOTO lbl10
        return ret;
lbl-1000:
        // 1 sources

        {
            n -= (long)this.encap_remain;
            ret += (long)this.encap_remain;
            this.count += this.encap_remain;
            this.check_encaps_end(this.encap_remain);
lbl10:
            // 2 sources

            ** while (this.encap_remain >= 0 && n > (long)this.encap_remain)
        }
lbl11:
        // 1 sources

        if (n == 0L) {
            return ret;
        }
        if (n > (long)(this.buffer.length - this.count)) {
            ret += (long)(this.buffer.length - this.count);
            this.count = this.buffer.length;
        } else {
            ret += n;
            this.count += (int)n;
        }
        return ret;
    }

    public void resetCount() {
        if (Trace.level != 0) {
            Trace.InFunction("InputStream::resetCount");
        }
        if (Trace.level != 0) {
            Trace.FullStep("Index avant initialisation : " + this.count);
        }
        this.count = 0;
        while (!this._encap_stack.empty()) {
            this.swap = (Boolean)this._encap_stack.firstElement();
            this._encap_stack.removeAllElements();
        }
        if (Trace.level != 0) {
            Trace.OutFunction("InputStream::resetCount");
        }
    }

    public int count() {
        if (Trace.level != 0) {
            Trace.InOutFunction("InputStream::count");
        }
        return this.count;
    }

    public void count(int ct) {
        if (ct > this.buffer.length) {
            throw new BAD_OPERATION();
        }
        if (this.count < ct) {
            this.skip(ct - this.count);
        } else if (this.count > ct) {
            this.resetCount();
            this.skip(ct);
        }
    }

    public Principal read_Principal() {
        Principal p = new Principal();
        byte[] b = new byte[this.read_ulong()];
        this.read_octet_array(b, 0, b.length);
        p.name = b;
        return p;
    }

    public char read_wchar() {
        this.alignment(2);
        char c = (char)(this.buffer[this.count++] << 8 | this.buffer[this.count++] & 0xFF);
        if (this.swap) {
            char tmp;
            c = tmp = (char)(this.buffer[this.count - 2] & 0xFF | this.buffer[this.count - 1] << 8);
        }
        this.check_encaps_end(2);
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + c);
        }
        return c;
    }

    public short read_short() {
        return (short)this.read_wchar();
    }

    public short read_ushort() {
        return this.read_short();
    }

    public org.omg.CORBA.Context read_Context() {
        NVList nv = ORBSingleton.init().create_list(0);
        int max = this.read_ulong() / 2;
        int i = 0;
        while (i < max) {
            org.omg.CORBA.Any a = ORBSingleton.init().create_any();
            String name = this.read_string();
            a.insert_string(this.read_string());
            nv.add_value(name, a, 0);
            ++i;
        }
        Context context = new Context("", null);
        ((org.omg.CORBA.Context)context).set_values(nv);
        return context;
    }

    private Class loadClassFromURL(String className, String url) {
        URLLoader loader2 = new URLLoader();
        StringTokenizer token = new StringTokenizer(url, " ");
        while (token.hasMoreTokens()) {
            loader2.addURL(token.nextToken());
        }
        Class<?> clz = null;
        try {
            clz = loader2.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to find class from an URL : " + className);
            }
            return null;
        }
        return clz;
    }

    public void read_wchar_array(char[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_wchar();
            ++i;
        }
    }

    public void read_longlong_array(long[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_longlong();
            ++i;
        }
    }

    public void read_ulonglong_array(long[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_ulonglong();
            ++i;
        }
    }

    public void read_float_array(float[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_float();
            ++i;
        }
    }

    public BigDecimal read_fixed() {
        return null;
    }

    private void stream_open() {
        this.read_ulong();
        this._endian = this.swap;
        this.swap = this.read_boolean();
    }

    protected java.lang.Object createObject(Class clz) {
        java.lang.Object object = null;
        if (clz != null) {
            try {
                object = clz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new BAD_PARAM("Unable to create an instance of " + clz.getName());
            }
            catch (IllegalAccessException ex) {
                throw new BAD_PARAM("Unable to access to " + clz.getName());
            }
        }
        return object;
    }

    public long read_longlong() {
        this.alignment(8);
        long l = (long)this.buffer[this.count++] << 56 | (long)this.buffer[this.count++] << 48 & 0xFF000000000000L | (long)this.buffer[this.count++] << 40 & 0xFF0000000000L | (long)this.buffer[this.count++] << 32 & 0xFF00000000L | (long)this.buffer[this.count++] << 24 & 0xFF000000L | (long)this.buffer[this.count++] << 16 & 0xFF0000L | (long)this.buffer[this.count++] << 8 & 0xFF00L | (long)this.buffer[this.count++] & 0xFFL;
        if (this.swap) {
            long tmp;
            l = tmp = (long)this.buffer[this.count - 8] & 0xFFL | (long)this.buffer[this.count - 7] << 8 & 0xFF00L | (long)this.buffer[this.count - 6] << 16 & 0xFF0000L | (long)this.buffer[this.count - 5] << 24 & 0xFF000000L | (long)this.buffer[this.count - 4] << 32 & 0xFF00000000L | (long)this.buffer[this.count - 3] << 40 & 0xFF0000000000L | (long)this.buffer[this.count - 2] << 48 & 0xFF000000000000L | (long)this.buffer[this.count - 1] << 56;
        }
        this.check_encaps_end(8);
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + l);
        }
        return l;
    }

    public InputCDRStream() {
        if (Trace.level != 0) {
            Trace.NewLowInstance("InputCDRStream");
        }
        this.buffer = new byte[100];
        this.count = 0;
        this.swap = false;
        this.orb = ORBSingleton._orb;
        this._factory = this.orb.get_object_factory();
        this._value_list = new Hashtable();
        this._version = 2;
    }

    public InputCDRStream(byte[] buf, boolean bigEndian) {
        if (Trace.level != 0) {
            Trace.NewLowInstance("InputCDRStream");
        }
        this.orb = ORBSingleton._orb;
        this.count = 0;
        this.buffer = buf;
        if (bigEndian != NaturalEndian.value) {
            this.swap = true;
        }
        this._factory = this.orb.get_object_factory();
        this._value_list = new Hashtable();
    }

    public byte read_octet() {
        byte b = this.buffer[this.count++];
        this.check_encaps_end(1);
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + b);
        }
        return b;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public int available() {
        return this.buffer.length - this.count;
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public void setBuffer(byte[] buf, boolean bigEndian) {
        if (Trace.level != 0) {
            Trace.InFunction("InputStream::setBuffer");
        }
        this.buffer = buf;
        this.count = 0;
        if (bigEndian != NaturalEndian.value) {
            this.swap = true;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("InputStream::setBuffer");
        }
    }

    public byte[] getBuffer() {
        if (Trace.level != 0) {
            Trace.InOutFunction("InputStream::getBuffer");
        }
        return this.buffer;
    }

    public org.omg.CORBA.Any read_any() {
        org.omg.CORBA.TypeCode typeco = this.read_TypeCode();
        Any any = new Any();
        any.read_value(this, typeco);
        return any;
    }

    public String read_string() {
        int taille = this.read_ulong() - 1;
        if (taille == 0) {
            this.read_octet();
            return "";
        }
        String ret = new String(this.buffer, this.count, taille);
        this.count += taille;
        this.check_encaps_end(taille);
        this.read_octet();
        if (Trace.level != 0) {
            Trace.FullStep("Value lue : " + ret);
        }
        return ret;
    }

    public org.omg.CORBA.TypeCode read_TypeCode() {
        org.omg.CORBA.TypeCode typeco = null;
        int kind = this.read_ulong();
        if (Trace.level != 0) {
            Trace.FullStep("Type du TypeCode = " + kind);
        }
        switch (kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 26: {
                return this.orb.get_primitive_tc(TCKind.from_int(kind));
            }
            case 14: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                this.stream_close();
                return this.orb.create_interface_tc(id, name);
            }
            case 31: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                this.stream_close();
                return this.orb.create_native_tc(id, name);
            }
            case 32: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                this.stream_close();
                return this.orb.create_abstract_interface_tc(id, name);
            }
            case 30: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                typeco = this.read_TypeCode();
                this.stream_close();
                return this.orb.create_value_box_tc(id, name, typeco);
            }
            case 29: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                short modifier = this.read_short();
                typeco = this.read_TypeCode();
                int counter = this.read_ulong();
                ValueMember[] vm = new ValueMember[counter];
                int i = 0;
                while (i < counter) {
                    vm[i] = new ValueMember();
                    vm[i].name = this.read_string();
                    vm[i].type = this.read_TypeCode();
                    vm[i].access = this.read_short();
                    ++i;
                }
                this.stream_close();
                return this.orb.create_value_tc(id, name, modifier, typeco, vm);
            }
            case 15: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                int counter = this.read_ulong();
                StructMember[] sm = new StructMember[counter];
                int i = 0;
                while (i < counter) {
                    sm[i] = new StructMember();
                    sm[i].name = this.read_string();
                    sm[i].type = this.read_TypeCode();
                    ++i;
                }
                this.stream_close();
                return this.orb.create_struct_tc(id, name, sm);
            }
            case 16: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                typeco = this.read_TypeCode();
                int defaultused = this.read_long();
                int counter = this.read_ulong();
                UnionMember[] um = new UnionMember[counter];
                int i = 0;
                while (i < counter) {
                    um[i] = new UnionMember();
                    um[i].label = this.orb.create_any();
                    if (i != defaultused) {
                        ((Any)um[i].label).read_value(this, typeco);
                    } else {
                        switch (((TypeCode)typeco).final_type().kind().value()) {
                            case 2: {
                                this.read_short();
                                break;
                            }
                            case 4: {
                                this.read_ushort();
                                break;
                            }
                            case 3: {
                                this.read_long();
                                break;
                            }
                            case 5: {
                                this.read_ulong();
                                break;
                            }
                            case 8: {
                                this.read_boolean();
                                break;
                            }
                            case 9: {
                                this.read_char();
                                break;
                            }
                            case 17: {
                                this.read_ulong();
                                break;
                            }
                            default: {
                                throw new MARSHAL();
                            }
                        }
                        um[i].label.insert_octet((byte)0);
                    }
                    um[i].name = this.read_string();
                    um[i].type = this.read_TypeCode();
                    ++i;
                }
                this.stream_close();
                return this.orb.create_union_tc(id, name, typeco, um);
            }
            case 17: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                int counter = this.read_ulong();
                String[] members = new String[counter];
                int i = 0;
                while (i < counter) {
                    members[i] = this.read_string();
                    ++i;
                }
                this.stream_close();
                return this.orb.create_enum_tc(id, name, members);
            }
            case 18: {
                int counter = this.read_ulong();
                return this.orb.create_string_tc(counter);
            }
            case 27: {
                int counter = this.read_ulong();
                return this.orb.create_wstring_tc(counter);
            }
            case -1: {
                int offset = this.read_long();
                int counter = this.count;
                int oldencap_remain = this.encap_remain;
                this.count = this.count + offset - 4;
                this.encap_remain = -1;
                this.stream_open();
                String id = this.read_string();
                this.count = counter;
                this.encap_remain = oldencap_remain;
                return this.orb.create_recursive_tc(id);
            }
            case 19: {
                this.stream_open();
                typeco = this.read_TypeCode();
                int length = this.read_ulong();
                this.stream_close();
                return this.orb.create_sequence_tc(length, typeco);
            }
            case 20: {
                this.stream_open();
                typeco = this.read_TypeCode();
                int length = this.read_ulong();
                this.stream_close();
                return this.orb.create_array_tc(length, typeco);
            }
            case 21: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                typeco = this.read_TypeCode();
                this.stream_close();
                return this.orb.create_alias_tc(id, name, typeco);
            }
            case 22: {
                this.stream_open();
                String id = this.read_string();
                String name = this.read_string();
                int counter = this.read_ulong();
                StructMember[] sm = new StructMember[counter];
                int i = 0;
                while (i < counter) {
                    sm[i] = new StructMember();
                    sm[i].name = this.read_string();
                    sm[i].type = this.read_TypeCode();
                    ++i;
                }
                this.stream_close();
                return this.orb.create_exception_tc(id, name, sm);
            }
        }
        typeco = this.orb.get_primitive_tc(TCKind.tk_null);
        return typeco;
    }

    protected ObjectImpl loadStubWithID(String id) {
        int index = 0;
        Class stub = null;
        String base_name = id.substring(4, id.lastIndexOf(":"));
        base_name = base_name.replace('/', '.');
        String stubName = null;
        if (base_name.lastIndexOf(".") != -1) {
            stubName = base_name.substring(0, base_name.lastIndexOf(".") + 1);
            base_name = base_name.substring(base_name.lastIndexOf(".") + 1, base_name.length());
        } else {
            stubName = "";
        }
        stubName = stubName + "_" + base_name + "Stub";
        while (true) {
            if (Trace.level != 0) {
                Trace.Step("Now, look for : " + stubName);
            }
            if ((stub = this.loadClass(stubName)) != null) {
                return (ObjectImpl)this.createObject(stub);
            }
            index = stubName.indexOf(".");
            if (index == -1) break;
            stubName = stubName.substring(index + 1, stubName.length());
        }
        if (stub == null) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to load stub from id : " + id);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.MARSHAL");
            }
            throw new MARSHAL();
        }
        return (ObjectImpl)this.createObject(stub);
    }

    public void read_octet_array(byte[] value, int offset, int length) {
        System.arraycopy(this.buffer, this.count, value, offset, length);
        this.count += length;
        this.check_encaps_end(length);
    }

    public void read_long_array(int[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_long();
            ++i;
        }
    }

    public void read_ulong_array(int[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            value[i] = this.read_ulong();
            ++i;
        }
    }

    protected ValueFactory loadFactoryWithID(String id, String url) {
        int index = 0;
        Class clzHelper = null;
        String base_name = id.substring(4, id.lastIndexOf(":"));
        base_name = base_name.replace('/', '.');
        String factoryName = base_name + "DefaultFactory";
        while (true) {
            if (Trace.level != 0) {
                Trace.Step("Now, look for : " + factoryName);
            }
            if ((clzHelper = url != null ? this.loadClassFromURL(factoryName, url) : this.loadClass(factoryName)) != null) {
                return (ValueFactory)this.createObject(clzHelper);
            }
            index = factoryName.indexOf(".");
            if (index == -1) break;
            factoryName = factoryName.substring(index + 1, factoryName.length());
        }
        if (clzHelper == null) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to load factory  id : " + id);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.MARSHAL");
            }
            throw new MARSHAL();
        }
        return (ValueFactory)this.createObject(clzHelper);
    }

    private Class loadClass(String className) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to find class : " + className);
            }
            return null;
        }
        return clz;
    }
}

