/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.ThreadPoolingPolicyImpl;
import JavaORB.ObjectAdapter;
import JavaORB.Trace;
import JavaORB.iiop.ProtocolPlugIIOP;
import JavaORB.protocol.Listener;
import JavaORB.protocol.ProtocolPlug;
import JavaORB.protocol.ServerConnection;
import JavaORB.util.JavaORBThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class ListenerIIOP
extends JavaORBThread
implements Listener {
    private boolean usePool;
    private int maxPool;
    private int nbThread;
    private int _port;
    private ObjectAdapter Adapter;
    private ServerConnection[] Pool;
    private int listenerPort;
    private String hostName;
    private String hostAddr;
    private boolean WaitEnable;
    private ServerSocket connection;
    private ProtocolPlug plug;
    private Vector threadList;

    public String _get_host() {
        return this.hostName;
    }

    public void begin() {
        this.setDaemon(true);
        this.start();
    }

    public void end() {
        this.WaitEnable = false;
    }

    public void deactivate() throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ListenerIIOP::desactivate()");
        }
        ServerConnection last = null;
        if (Trace.level != 0) {
            Trace.Step("Close the listenning connection");
        }
        try {
            this.WaitEnable = false;
            this.connection.close();
        }
        catch (Throwable excep) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to close the listener");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FALURE");
            }
            throw new COMM_FAILURE("Unable to close the listener", 1, CompletionStatus.COMPLETED_NO);
        }
        try {
            if (Trace.level != 0) {
                Trace.Step("Desactive chaque thread de traitement");
            }
            if (this.usePool) {
                int i = 0;
                while (i < this.Pool.length) {
                    if (!Thread.currentThread().equals(this.Pool[i])) {
                        this.Pool[i].deactivate();
                        this.Pool[i].end();
                    } else {
                        last = this.Pool[i];
                    }
                    ++i;
                }
            } else {
                ServerConnection t = null;
                while (this.threadList.size() != 0) {
                    t = (ServerConnection)this.threadList.elementAt(0);
                    if (!Thread.currentThread().equals(t)) {
                        t.deactivate();
                        t.end();
                        continue;
                    }
                    last = t;
                }
            }
        }
        catch (Throwable ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to close the listener");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FALURE");
            }
            throw new COMM_FAILURE("Unable to close the listener", 1, CompletionStatus.COMPLETED_NO);
        }
        try {
            last.deactivate();
            last.end();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::desactivate()");
        }
    }

    public void attend() {
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ListenerIIOP() {
        if (Trace.level != 0) {
            Trace.NewInstance("ListenerIIOP");
        }
        this.plug = ORBSingleton.plug;
        if (ORBSingleton._thread_pooling_policy.value().value() == 1) {
            this.usePool = true;
            this.maxPool = ((ThreadPoolingPolicyImpl)ORBSingleton._thread_pooling_policy).arg();
        } else {
            this.usePool = false;
            this.maxPool = ((ThreadPoolingPolicyImpl)ORBSingleton._thread_pooling_policy).arg();
        }
        this.nbThread = 0;
        this.threadList = new Vector();
    }

    public int _get_port() {
        return this.listenerPort;
    }

    /*
     * Unable to fully structure code
     */
    public void waitIncomingRequest() {
        channel = null;
        if (Trace.level != 0) {
            Trace.InFunction("ListenerIIOP::waitIncomingRequest()");
        }
        if (Trace.level != 0) {
            Trace.Step("Attente d'une nouvelle connexion");
        }
        this.WaitEnable = true;
        while (this.WaitEnable) {
            block26: {
                try {
                    channel = this.connection.accept();
                }
                catch (IOException excep) {
                    if (this.WaitEnable) {
                        if (Trace.level != 0) {
                            Trace.CoreError("Impossible d'accepter une nouvelle connexion");
                        }
                        if (Trace.level != 0) {
                            Trace.ThrowException("org.omg.CORBA.COMM_FALURE");
                        }
                        throw new COMM_FAILURE("Unable to make an accept on connection", 1, CompletionStatus.COMPLETED_NO);
                    }
                    return;
                }
                try {
                    channel.setTcpNoDelay(true);
                }
                catch (SocketException ex) {
                    if (Trace.level == 0) break block26;
                    Trace.CoreError("Unable to set socket options");
                }
            }
            if (!this.usePool) ** GOTO lbl57
            if (Trace.level != 0) {
                Trace.Step("Selectionne un thread pour gerer le connexion");
            }
            NoThreadAvailable = true;
            while (NoThreadAvailable) {
                i = 0;
                while (i < this.Pool.length) {
                    if (!this.Pool[i].busy()) break;
                    ++i;
                }
                if (i != this.Pool.length) {
                    this.Pool[i].setChannel(channel);
                    this.Pool[i].reactivation();
                    NoThreadAvailable = false;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (Trace.level == 0) continue;
                Trace.Step("Retry to find a thread for the incoming connection");
            }
            continue;
lbl-1000:
            // 1 sources

            {
                if (Trace.level != 0) {
                    Trace.Step("Attente d'une liberation de thread");
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
lbl57:
                // 3 sources

                ** while (this.nbThread == this.maxPool)
            }
lbl58:
            // 1 sources

            ++this.nbThread;
            if (Trace.level != 0) {
                Trace.Step("Creation d'un nouveau thread pour traiter la demande");
            }
            thread = this.plug.newServerConnection();
            thread.begin();
            this.threadList.addElement(thread);
            thread.setListener(this);
            thread._set_port(this._port);
            thread.setObjectAdapter(this.Adapter);
            thread.noPool();
            thread.setChannel(channel);
            suspended = false;
            while (!suspended) {
                if (((JavaORBThread)thread).isSuspended()) {
                    suspended = true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            thread.reactivation();
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::waitIncomingRequest()");
        }
    }

    public void activate(ObjectAdapter OA, int port) throws COMM_FAILURE {
        block18: {
            if (Trace.level != 0) {
                Trace.InFunction("ListenerIIOP::activate()");
            }
            this.Adapter = OA;
            if (this.usePool) {
                this.Pool = this.plug.newServerConnectionArray(this.maxPool);
            }
            try {
                if (((ProtocolPlugIIOP)this.plug).useIP()) {
                    this.hostName = InetAddress.getLocalHost().getHostAddress();
                    this.hostAddr = InetAddress.getLocalHost().getHostAddress();
                    break block18;
                }
                try {
                    this.hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Throwable ex) {
                    this.hostName = InetAddress.getLocalHost().getHostAddress();
                }
                this.hostAddr = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                if (Trace.level != 0) {
                    Trace.CoreError("Impossible de recuperer le nom du host");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.INTERNAL");
                }
                throw new INTERNAL("Unable to get host name", 1, CompletionStatus.COMPLETED_NO);
            }
        }
        if (this.usePool) {
            int i = 0;
            while (i < this.Pool.length) {
                this.Pool[i] = this.plug.newServerConnection();
                this.Pool[i].setListener(this);
                this.Pool[i]._set_port(port);
                this.Pool[i].setObjectAdapter(this.Adapter);
                this.Pool[i].begin();
                ++this.nbThread;
                ++i;
            }
        }
        this._port = port;
        if (Trace.level != 0) {
            Trace.Step("Creation de la socket d'ecoute");
        }
        try {
            this.connection = new ServerSocket(port);
        }
        catch (IOException excep) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de creer le socket d'ecoute");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to open listener socket", 0, CompletionStatus.COMPLETED_NO);
        }
        this.listenerPort = this.connection.getLocalPort();
        if (Trace.level != 0) {
            Trace.Step("Le serveur est active sur la machine " + this.hostName + " et sur le port " + this.listenerPort);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::activate()");
        }
    }

    public void complete_and_deactivate() throws COMM_FAILURE {
        if (Trace.level != 0) {
            Trace.InFunction("ListenerIIOP::complete_and_desactivate()");
        }
        ServerConnection last = null;
        if (Trace.level != 0) {
            Trace.Step("Ferme le connexion d'ecoute");
        }
        try {
            this.WaitEnable = false;
            this.connection.close();
        }
        catch (Throwable excep) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to close the listener");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FALURE");
            }
            throw new COMM_FAILURE("Unable to close the listener", 1, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.Step("Desactive chaque thread de traitement");
        }
        int i = 0;
        while (i < this.Pool.length) {
            if (!Thread.currentThread().equals(this.Pool[i])) {
                this.Pool[i].complete();
                this.Pool[i].deactivate();
                this.Pool[i].end();
            } else {
                last = this.Pool[i];
            }
            ++i;
        }
        last.deactivate();
        last.end();
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::complete_and_desactivate()");
        }
    }

    public boolean isCompleted() {
        boolean result = true;
        if (Trace.level != 0) {
            Trace.InFunction("ListenerIIOP::isCompleted");
        }
        int i = 0;
        while (i < this.Pool.length) {
            if (this.Pool[i].busy()) {
                result = false;
                break;
            }
            ++i;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::isCompleted");
        }
        return result;
    }

    public void complete() {
        if (Trace.level != 0) {
            Trace.InFunction("ListenerIIOP::complete");
        }
        if (Trace.level != 0) {
            Trace.Step("Termine chaque traitement");
        }
        int i = 0;
        while (i < this.Pool.length) {
            this.Pool[i].complete();
            ++i;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ListenerIIOP::complete");
        }
    }

    public synchronized void ServerConnectionDown(ServerConnection sc) {
        this.nbThread += -1;
        if (!this.usePool) {
            ServerConnection t = null;
            int i = 0;
            while (i < this.threadList.size()) {
                t = (ServerConnection)this.threadList.elementAt(0);
                if (sc.equals(t)) {
                    this.threadList.removeElementAt(i);
                    return;
                }
                ++i;
            }
        }
    }

    public String _get_addr() {
        return this.hostAddr;
    }

    public void run() {
        this.waitIncomingRequest();
    }
}

