/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.AbstractInterface;
import JavaORB.CORBA.AbstractInterfaceHelper;
import JavaORB.CORBA.Any;
import JavaORB.CORBA.DataOutputStream;
import JavaORB.CORBA.NaturalEndian;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.RequestInterceptorManager;
import JavaORB.CORBA.TypeCode;
import JavaORB.CORBA.handler.ObjectFactory;
import JavaORB.CORBA.portable.Delegate;
import JavaORB.Trace;
import JavaORB.protocol.ExtendedOutputStream;
import JavaORB.protocol.ProtocolPlug;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class OutputCDRStream
extends OutputStream
implements ExtendedOutputStream {
    protected static final int VALUE_NO_CODEBASE = 0;
    protected static final int VALUE_CODEBASE = 1;
    protected static final int VALUE_NO_TYPE_INFORMATION = 0;
    protected static final int SINGLE_TYPE_INFORMATION = 2;
    protected static final int MULTIPLE_TYPE_INFORMATION = 6;
    protected static final int CHUNK = 8;
    protected static final int NO_CHUNK = 0;
    protected static final int OPEN_ENCAPS = -1;
    protected byte[] buffer;
    private Vector data;
    private int count;
    protected int level = 0;
    private boolean useTk = false;
    private ProtocolPlug plug;
    private Vector tkList;
    private ObjectFactory _factory;
    private Hashtable _value_list;
    private int _url_index;
    private Stack _encap_stack = new Stack();
    private int _version;

    public void write_long(int value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur long : " + value);
        }
        this.alignment(4);
        this.buffer[this.count++] = (byte)(value >>> 24);
        this.buffer[this.count++] = (byte)(value >>> 16);
        this.buffer[this.count++] = (byte)(value >>> 8);
        this.buffer[this.count++] = (byte)value;
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_long);
        }
    }

    public void write_ulong(int value) {
        this.write_long(value);
    }

    public void begin_encapsulation() {
        int idx = this.stream_begin();
        this._encap_stack.push(new Integer(idx));
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void write_Object(Object value) {
        this._factory.marshalObject(value);
        if (value == null) {
            IOR ior = new IOR();
            ior.type_id = "";
            ior.profiles = new TaggedProfile[0];
            IORHelper.write(this, ior);
        } else {
            ((Delegate)((ObjectImpl)value)._get_delegate())._write_Object(this);
        }
    }

    public void alignment(int size) {
        if (this.count != 0 && this.count % size != 0) {
            this.count = this.count + size - this.count % size;
        }
        this.adjustSize(size + 1);
        if (Trace.level != 0) {
            Trace.OutFunction("OutputStream::alignment");
        }
    }

    public void increaseDeepth() {
        ++this.level;
    }

    public void write_char(char value) throws DATA_CONVERSION {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute le caractere : " + value);
        }
        if (value > '\u00ff') {
            if (Trace.level != 0) {
                Trace.CoreError("Char attendu et non pas WChar");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("omg.org.CORBA.DATA_CONVERSION");
            }
            throw new DATA_CONVERSION("Bad char type", 0, CompletionStatus.COMPLETED_NO);
        }
        this.alignment(1);
        this.buffer[this.count++] = (byte)value;
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_char);
        }
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_boolean(value[i]);
            ++i;
        }
    }

    public void write_short_array(short[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_short(value[i]);
            ++i;
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_ushort(value[i]);
            ++i;
        }
    }

    public void write_wstring(String value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur wstring : " + value);
        }
        switch (this._version) {
            case 0: 
            case 1: {
                if (value == null) {
                    this.write_ulong(1);
                    this.write_wchar('\u0000');
                    return;
                }
                this.write_ulong(value.length() * 2 + 2);
                int i = 0;
                while (i < value.length()) {
                    this.write_wchar(value.charAt(i));
                    ++i;
                }
                this.write_wchar('\u0000');
            }
            case 2: {
                if (value == null) {
                    this.write_ulong(0);
                    return;
                }
                this.write_ulong(value.length() * 2);
                int i = 0;
                while (i < value.length()) {
                    this.write_wchar(value.charAt(i));
                    ++i;
                }
                break;
            }
        }
    }

    public void write_abstract_interface(java.lang.Object obj) {
        AbstractInterface abs = new AbstractInterface();
        boolean found = false;
        if (obj instanceof Object && ((ObjectImpl)obj)._get_delegate() != null) {
            abs.ior((Object)obj);
            found = true;
        }
        if (obj instanceof ValueBase) {
            abs.value((Serializable)obj);
            found = true;
        }
        if (!found) {
            throw new BAD_PARAM();
        }
        AbstractInterfaceHelper.write(this, abs);
    }

    public void write_char_array(char[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_char(value[i]);
            ++i;
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_double(value[i]);
            ++i;
        }
    }

    public void write_float(float value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur float : " + value);
        }
        this.write_long(Float.floatToIntBits(value));
    }

    public void write_value(Serializable value) {
        String url = null;
        if (value != null) {
            Integer offset = (Integer)this._value_list.get(value);
            if (offset != null) {
                this.write_long(-1);
                this.write_long(offset);
                return;
            }
            this.alignment(4);
            this._value_list.put(value, new Integer(this.count));
        }
        if (value == null) {
            this.write_long(0);
            return;
        }
        if (value instanceof CustomValue) {
            if (Trace.level != 0) {
                Trace.Step("Custom marshal value type");
            }
            CustomValue customValue = (CustomValue)value;
            String[] id = customValue._truncatable_ids();
            int tag = 0;
            url = this.getURLCodeBase();
            tag = id.length > 1 ? 2147483406 : 2147483402;
            if (url != null) {
                ++tag;
            }
            this.write_long(tag);
            if (url != null) {
                if (this._url_index != -1) {
                    this.write_ulong(-1);
                    this.write_ulong(this._url_index);
                } else {
                    this.alignment(4);
                    this._url_index = this.count;
                    this.write_string(url);
                }
            }
            ++this.level;
            if (id.length > 1) {
                this.write_long(id.length);
            }
            int i = 0;
            while (i < id.length) {
                this.write_string(id[i]);
                ++i;
            }
            if (Trace.level != 0) {
                Trace.Step("Apply chunk to this value");
            }
            OutputCDRStream output = new OutputCDRStream();
            DataOutputStream outputStream = new DataOutputStream(output);
            customValue.marshal(outputStream);
            if (Trace.level != 0) {
                Trace.Step("Chunk size : " + output.count());
            }
            this.write_long(output.count());
            byte[] buffer = output.getBuffer();
            this.write_octet_array(buffer, 0, output.count());
            this.write_long(-this.level);
            this.level += -1;
            return;
        }
        if (value instanceof StreamableValue) {
            StreamableValue streamValue = (StreamableValue)value;
            String[] id = streamValue._truncatable_ids();
            int tag = 0;
            url = this.getURLCodeBase();
            tag = id.length > 1 ? 2147483406 : 2147483394;
            if (url != null) {
                ++tag;
            }
            this.write_long(tag);
            if (url != null) {
                this.write_string(url);
            }
            if (id.length > 1) {
                this.write_long(id.length);
            }
            int i = 0;
            while (i < id.length) {
                this.write_string(id[i]);
                ++i;
            }
            if (id.length > 1) {
                if (Trace.level != 0) {
                    Trace.Step("Apply chunk to this value");
                }
                ++this.level;
                OutputCDRStream output = new OutputCDRStream();
                streamValue._write(output);
                if (Trace.level != 0) {
                    Trace.Step("Chunk size : " + output.count());
                }
                this.write_long(output.count());
                byte[] buffer = output.getBuffer();
                this.write_octet_array(buffer, 0, output.count());
                this.write_long(-this.level);
                this.level += -1;
            } else {
                streamValue._write(this);
            }
        }
        if (!(value instanceof StreamableValue)) {
            if (value instanceof ValueBase) {
                String id = ((ValueBase)value)._truncatable_ids()[0];
                this.write_value(value, id);
                return;
            }
            throw new BAD_PARAM();
        }
    }

    public void write_value(Serializable value, String rep_id) {
        if (value != null) {
            Integer offset = (Integer)this._value_list.get(value);
            if (offset != null) {
                this.write_long(-1);
                this.write_long(offset);
                return;
            }
            this.alignment(4);
            this._value_list.put(value, new Integer(this.count));
        }
        if (!(value instanceof StreamableValue)) {
            if (Trace.level != 0) {
                Trace.Step("The value is a value box");
            }
            Class helperClass = this.loadBoxHelper(rep_id);
            BoxedValueHelper helper = null;
            try {
                helper = (BoxedValueHelper)helperClass.newInstance();
            }
            catch (InstantiationException e) {
                if (Trace.level != 0) {
                    Trace.CoreError("Unable to instantiate a class from id : " + rep_id);
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.MARSHAL");
                }
                throw new MARSHAL();
            }
            catch (IllegalAccessException e) {
                if (Trace.level != 0) {
                    Trace.CoreError("Unable to access a class fom id : " + rep_id);
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.MARSHAL");
                }
                throw new MARSHAL();
            }
            this.write_value(value, helper);
        } else {
            this.write_value(value);
        }
    }

    public void write_value(Serializable value, Class clz) {
        this.write_value(value);
    }

    public String toHexaString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (Trace.level != 0) {
            Trace.InFunction("OutputStream::toHexaString");
        }
        StringBuffer str = new StringBuffer(2 * this.count);
        int i = 0;
        while (i < this.count) {
            str.append(hex[(byte)((this.buffer[i] & 0xF0) >>> 4)]);
            str.append(hex[(byte)(this.buffer[i] & 0xF)]);
            ++i;
        }
        if (Trace.level != 0) {
            Trace.OutFunction("OutputStream::toHexaString");
        }
        return str.toString();
    }

    public void write_value(Serializable value, BoxedValueHelper factory) {
        int tag = 0;
        if (value != null) {
            Integer offset = (Integer)this._value_list.get(value);
            if (offset != null) {
                this.write_long(-1);
                this.write_long(offset);
                return;
            }
            this.alignment(4);
            this._value_list.put(value, new Integer(this.count));
        }
        if (value == null) {
            this.write_long(0);
            return;
        }
        String url = this.getURLCodeBase();
        tag = url == null ? 2147483394 : 2147483395;
        this.write_long(tag);
        if (url != null) {
            if (this._url_index != -1) {
                this.write_ulong(-1);
                this.write_ulong(this._url_index);
            } else {
                this.alignment(4);
                this._url_index = this.count;
                this.write_string(url);
            }
        }
        this.write_string(factory.get_id());
        factory.write_value(this, value);
    }

    public void setTkList(java.lang.Object[] list) {
        this.tkList.removeAllElements();
        int i = 0;
        while (i < list.length) {
            this.tkList.addElement(list[i]);
            ++i;
        }
    }

    public java.lang.Object[] getTkList() {
        java.lang.Object[] list = new java.lang.Object[this.tkList.size()];
        int i = 0;
        while (i < this.tkList.size()) {
            list[i] = this.tkList.elementAt(i);
            ++i;
        }
        return list;
    }

    public void write_boolean(boolean value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur booleenne : " + value);
        }
        if (value) {
            this.write_octet((byte)1);
        } else {
            this.write_octet((byte)0);
        }
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_boolean);
        }
    }

    public void end_encapsulation() {
        int idx = (Integer)this._encap_stack.pop();
        this.stream_end(idx);
    }

    public int count() {
        if (Trace.level != 0) {
            Trace.InOutFunction("OutputStream::count");
        }
        return this.count;
    }

    public void count(int ct) {
        if (ct > this.buffer.length) {
            throw new BAD_OPERATION();
        }
        if (ct < this.count && !this._encap_stack.empty() && ct < (Integer)this._encap_stack.peek() + 5) {
            throw new BAD_OPERATION();
        }
        this.count = ct;
    }

    private void stream_end(int index) {
        if (Trace.level != 0) {
            Trace.FullStep("Correct sub stream");
        }
        int c = this.count;
        this.count = index;
        this.write_long(c - (this.count + 4));
        this.count = c;
    }

    public void decreaseDeepth() {
        this.level += -1;
    }

    public void write_Principal(Principal value) {
        byte[] b = value.name;
        this.write_ulong(b.length);
        this.write_octet_array(b, 0, b.length);
    }

    public byte[] getFullBuffer() {
        if (Trace.level != 0) {
            Trace.InOutFunction("OutputStream::getBuffer");
        }
        byte[] rbuf = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, rbuf, 0, this.buffer.length);
        return rbuf;
    }

    public void write_wchar(char value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur wchar : " + value);
        }
        this.alignment(2);
        this.buffer[this.count++] = (byte)(value >>> 8);
        this.buffer[this.count++] = (byte)value;
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_wchar);
        }
    }

    public void copyInto(org.omg.CORBA.portable.OutputStream ostream) {
        int size = 0;
        byte[] tab = null;
        int pos = this.count();
        InputStream istream = this.create_input_stream();
        if (this.tkList.size() == 0) {
            if (this.count() != 0) {
                throw new INTERNAL("Try to copy a marshal buffer without a tk list...");
            }
        } else {
            int i = 0;
            while (i < this.tkList.size()) {
                TCKind tk = (TCKind)this.tkList.elementAt(i);
                switch (tk.value()) {
                    case 8: {
                        ostream.write_boolean(istream.read_boolean());
                        break;
                    }
                    case 9: {
                        ostream.write_char(istream.read_char());
                        break;
                    }
                    case 26: {
                        ostream.write_wchar(istream.read_wchar());
                        break;
                    }
                    case 10: {
                        ostream.write_octet(istream.read_octet());
                        break;
                    }
                    case 2: {
                        ostream.write_short(istream.read_short());
                        break;
                    }
                    case 3: {
                        ostream.write_long(istream.read_long());
                        break;
                    }
                    case 23: {
                        ostream.write_longlong(istream.read_longlong());
                        break;
                    }
                    case 20: {
                        size = (Integer)this.tkList.elementAt(++i);
                        tab = new byte[size];
                        istream.read_octet_array(tab, 0, tab.length);
                        ostream.write_octet_array(tab, 0, tab.length);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public InputStream create_input_stream() {
        if (Trace.level != 0) {
            Trace.InFunction("OutputStream::create_input_stream");
        }
        int c = this.count;
        Enumeration e = this._encap_stack.elements();
        while (e.hasMoreElements()) {
            this.count = (Integer)e.nextElement();
            this.write_ulong(c - (this.count + 4));
        }
        this.count = c;
        InputStream is = this.plug.newInputStream(this.getBuffer(), NaturalEndian.value, this._version);
        c = this.count;
        Enumeration e2 = this._encap_stack.elements();
        while (e2.hasMoreElements()) {
            this.count = (Integer)e2.nextElement();
            this.write_ulong(-1);
        }
        this.count = c;
        if (Trace.level != 0) {
            Trace.OutFunction("OutputStream::create_input_stream");
        }
        return is;
    }

    public void write_short(short value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur short : " + value);
        }
        this.alignment(2);
        this.buffer[this.count++] = (byte)((value & 0xFF00) >>> 8);
        this.buffer[this.count++] = (byte)(value & 0xFF);
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_short);
        }
    }

    public void write_ushort(short value) {
        this.write_short(value);
    }

    public void write_Context(Context ctx, ContextList contexts) {
        Vector<String> allCtx = new Vector<String>();
        int i = 0;
        while (i < contexts.count()) {
            try {
                NVList list = ctx.get_values("", 0, contexts.item(i));
                int j = 0;
                while (j < list.count()) {
                    allCtx.addElement(list.item(j).name());
                    allCtx.addElement(list.item(j).value().extract_string());
                    ++j;
                }
            }
            catch (Bounds ex) {
                // empty catch block
            }
            ++i;
        }
        if (allCtx.size() != 0) {
            this.write_ulong(allCtx.size());
            int j = 0;
            while (j < allCtx.size()) {
                this.write_string((String)allCtx.elementAt(j));
                ++j;
            }
        } else if (contexts.count() != 0) {
            this.write_ulong(0);
        }
    }

    private String getURLCodeBase() {
        String url = ORBSingleton.getORBProperty("OBV.URLCodeBase");
        if (Trace.level != 0) {
            Trace.Step("URL to use : " + url);
        }
        return url;
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_wchar(value[i]);
            ++i;
        }
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_longlong(value[i]);
            ++i;
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_ulonglong(value[i]);
            ++i;
        }
    }

    public void write_float_array(float[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_float(value[i]);
            ++i;
        }
    }

    public void write(int value) {
        this.write_octet((byte)value);
    }

    public void write(byte[] buf) {
        this.write_octet_array(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) {
        this.write_octet_array(buf, off, len);
    }

    public void write_fixed(BigDecimal value) {
    }

    private int stream_begin() {
        if (Trace.level != 0) {
            Trace.FullStep("Add sub stream header");
        }
        this.write_long(-1);
        int c = this.count - 4;
        this.write_boolean(NaturalEndian.value);
        return c;
    }

    public void reset() {
        this.count = 0;
        this._value_list = new Hashtable();
        this._encap_stack.removeAllElements();
    }

    public void write_longlong(long value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur longlong : " + value);
        }
        this.alignment(8);
        this.buffer[this.count++] = (byte)(value >>> 56);
        this.buffer[this.count++] = (byte)(value >>> 48);
        this.buffer[this.count++] = (byte)(value >>> 40);
        this.buffer[this.count++] = (byte)(value >>> 32);
        this.buffer[this.count++] = (byte)(value >>> 24);
        this.buffer[this.count++] = (byte)(value >>> 16);
        this.buffer[this.count++] = (byte)(value >>> 8);
        this.buffer[this.count++] = (byte)value;
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_longlong);
        }
    }

    public OutputCDRStream() {
        if (Trace.level != 0) {
            Trace.NewLowInstance("OutputStream");
        }
        this.buffer = new byte[100];
        this.data = new Vector();
        this.count = 0;
        this.plug = ORBSingleton.plug;
        this.tkList = new Vector();
        this._factory = ORBSingleton._orb.get_object_factory();
        this.useTk = RequestInterceptorManager.useTkInOutputStream;
        this._value_list = new Hashtable();
        this._url_index = -1;
        this._version = 2;
    }

    public OutputCDRStream(byte[] buf) {
        if (Trace.level != 0) {
            Trace.NewLowInstance("OutputStream");
        }
        this.plug = ORBSingleton.plug;
        if (this.buffer != null) {
            this.count = buf.length;
            this.buffer = buf;
        } else {
            this.buffer = new byte[1024];
            this.count = 0;
        }
        this.data = new Vector();
        this._factory = ORBSingleton._orb.get_object_factory();
        this._value_list = new Hashtable();
        this._version = 2;
    }

    public void write_octet(byte value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur octet : " + value);
        }
        this.alignment(1);
        this.buffer[this.count++] = value;
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_octet);
        }
    }

    public void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public void write_double(double value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur double : " + value);
        }
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public byte[] getBuffer() {
        if (Trace.level != 0) {
            Trace.InOutFunction("OutputStream::getBuffer");
        }
        byte[] rbuf = new byte[this.count];
        System.arraycopy(this.buffer, 0, rbuf, 0, this.count);
        return rbuf;
    }

    public void setBuffer(byte[] buf) {
        this.buffer = buf;
        this.count = 0;
        this._encap_stack.removeAllElements();
    }

    public void adjustSize(int length) {
        if (this.count + length > this.buffer.length) {
            int newLen = this.count + length > 2 * this.buffer.length ? this.count + length : 2 * this.buffer.length;
            byte[] buffer2 = new byte[newLen];
            System.arraycopy(this.buffer, 0, buffer2, 0, this.buffer.length);
            this.buffer = buffer2;
        }
    }

    public void write_any(org.omg.CORBA.Any value) {
        this.write_TypeCode(value.type());
        value.write_value(this);
    }

    public void write_string(String value) {
        if (Trace.level != 0) {
            Trace.FullStep("Ajoute la valeur string : " + value);
        }
        if (value == null) {
            this.write_ulong(1);
            this.write_char('\u0000');
            return;
        }
        this.write_ulong(value.length() + 1);
        this.adjustSize(value.length() + 1);
        int i = 0;
        while (i < value.length()) {
            this.write_char(value.charAt(i));
            ++i;
        }
        this.write_octet((byte)0);
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode value) {
        Hashtable tc_list = new Hashtable();
        TypeCode cfr_ignored_0 = (TypeCode)value;
        TypeCode._no_recursive = false;
        this.write_TypeCodeValue(value, tc_list);
        TypeCode cfr_ignored_1 = (TypeCode)value;
        TypeCode._no_recursive = true;
    }

    public void print_buffer() {
        if (Trace.level != 0) {
            Trace.InOutFunction("OutputStream::print_buffer");
        }
        if (Trace.level != 0) {
            Trace.Buffer(this.buffer);
        }
    }

    private Class loadBoxHelper(String id) {
        int index = 0;
        Class clzHelper = null;
        String base_name = id.substring(4, id.lastIndexOf(":"));
        base_name = base_name.replace('/', '.');
        String BoxedValueHelperName = base_name + "Helper";
        while (true) {
            if (Trace.level != 0) {
                Trace.Step("Now, look for : " + BoxedValueHelperName);
            }
            if ((clzHelper = this.loadClass(BoxedValueHelperName)) != null) {
                return clzHelper;
            }
            index = BoxedValueHelperName.indexOf(".");
            if (index == -1) break;
            BoxedValueHelperName = BoxedValueHelperName.substring(index + 1, BoxedValueHelperName.length());
        }
        if (clzHelper == null) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to load helper class from id : " + id);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.MARSHAL");
            }
            throw new MARSHAL();
        }
        return clzHelper;
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        this.adjustSize(length + 1);
        System.arraycopy(value, offset, this.buffer, this.count, length);
        if (this.useTk) {
            this.tkList.addElement(TCKind.tk_array);
            this.tkList.addElement(new Integer(length));
        }
        this.count += length;
    }

    public void write_long_array(int[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_long(value[i]);
            ++i;
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            this.write_ulong(value[i]);
            ++i;
        }
    }

    public void write_TypeCodeValue(org.omg.CORBA.TypeCode value, Hashtable tc_list) {
        if (((TypeCode)value).recursive()) {
            try {
                if (Trace.level != 0) {
                    Trace.FullStep("Recursive TypeCode  : " + value.id());
                }
                this.write_long(-1);
                Integer pos = (Integer)tc_list.get(value.id());
                this.write_long(pos - this.count);
                return;
            }
            catch (BadKind ex) {
                // empty catch block
            }
        }
        int kind = value.kind().value();
        if (Trace.level != 0) {
            Trace.FullStep("Type de TypeCode : " + kind);
        }
        this.write_long(kind);
        try {
            switch (kind) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 26: {
                    break;
                }
                case 14: 
                case 31: 
                case 32: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.stream_end(begin);
                    break;
                }
                case 30: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_TypeCodeValue(value.content_type(), tc_list);
                    this.stream_end(begin);
                    break;
                }
                case 29: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_short(value.type_modifier());
                    this.write_TypeCodeValue(value.concrete_base_type(), tc_list);
                    this.write_ulong(value.member_count());
                    int i = 0;
                    while (i < value.member_count()) {
                        this.write_string(value.member_name(i));
                        this.write_TypeCodeValue(value.member_type(i), tc_list);
                        this.write_short(value.member_visibility(i));
                        ++i;
                    }
                    this.stream_end(begin);
                    break;
                }
                case 15: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    try {
                        this.write_string(value.id());
                        this.write_string(value.name());
                    }
                    catch (BadKind except) {
                        // empty catch block
                    }
                    this.write_ulong(value.member_count());
                    int i = 0;
                    while (i < value.member_count()) {
                        this.write_string(value.member_name(i));
                        this.write_TypeCodeValue(value.member_type(i), tc_list);
                        ++i;
                    }
                    this.stream_end(begin);
                    break;
                }
                case 16: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_TypeCodeValue(value.discriminator_type(), tc_list);
                    this.write_long(value.default_index());
                    this.write_ulong(value.member_count());
                    int i = 0;
                    while (i < value.member_count()) {
                        if (i != value.default_index()) {
                            ((Any)value.member_label(i)).write_value(this);
                        } else {
                            switch (((TypeCode)value.discriminator_type()).final_type().kind().value()) {
                                case 2: {
                                    this.write_short((short)0);
                                    break;
                                }
                                case 4: {
                                    this.write_ushort((short)0);
                                    break;
                                }
                                case 3: {
                                    this.write_long(0);
                                    break;
                                }
                                case 5: {
                                    this.write_ulong(0);
                                    break;
                                }
                                case 8: {
                                    this.write_boolean(false);
                                    break;
                                }
                                case 9: {
                                    this.write_char('\u0000');
                                    break;
                                }
                                case 17: {
                                    this.write_ulong(0);
                                    break;
                                }
                                default: {
                                    throw new MARSHAL();
                                }
                            }
                        }
                        this.write_string(value.member_name(i));
                        this.write_TypeCodeValue(value.member_type(i), tc_list);
                        ++i;
                    }
                    this.stream_end(begin);
                    break;
                }
                case 17: {
                    int begin = this.stream_begin();
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_ulong(value.member_count());
                    int i = 0;
                    while (i < value.member_count()) {
                        this.write_string(value.member_name(i));
                        ++i;
                    }
                    this.stream_end(begin);
                    break;
                }
                case 18: 
                case 27: {
                    this.write_ulong(value.length());
                    break;
                }
                case 19: {
                    int begin = this.stream_begin();
                    this.write_TypeCodeValue(value.content_type(), tc_list);
                    this.write_ulong(value.length());
                    this.stream_end(begin);
                    break;
                }
                case 20: {
                    int begin = this.stream_begin();
                    this.write_TypeCodeValue(value.content_type(), tc_list);
                    this.write_ulong(value.length());
                    this.stream_end(begin);
                    break;
                }
                case 21: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_TypeCodeValue(value.content_type(), tc_list);
                    this.stream_end(begin);
                    break;
                }
                case 22: {
                    int begin = this.stream_begin();
                    tc_list.put(value.id(), new Integer(begin));
                    this.write_string(value.id());
                    this.write_string(value.name());
                    this.write_ulong(value.member_count());
                    int i = 0;
                    while (i < value.member_count()) {
                        this.write_string(value.member_name(i));
                        this.write_TypeCodeValue(value.member_type(i), tc_list);
                        ++i;
                    }
                    this.stream_end(begin);
                    break;
                }
            }
        }
        catch (BadKind except) {
        }
        catch (org.omg.CORBA.TypeCodePackage.Bounds except) {
            // empty catch block
        }
    }

    private Class loadClass(String className) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to find class : " + className);
            }
            return null;
        }
        return clz;
    }
}

