/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.ContextType;
import JavaORB.CORBA.NaturalEndian;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.CORBA.handler.ConnectionInfo;
import JavaORB.CORBA.portable.Delegate;
import JavaORB.ObjectAdapter;
import JavaORB.Trace;
import JavaORB.iiop.ClientConnectionIIOP;
import JavaORB.iiop.CloseConnectionEx;
import JavaORB.iiop.ProtocolPlugIIOP;
import JavaORB.iiop.RequestBag;
import JavaORB.protocol.ExtendedInputStream;
import JavaORB.protocol.ExtendedOutputStream;
import JavaORB.protocol.Listener;
import JavaORB.protocol.ProtocolPlug;
import JavaORB.protocol.ServerConnection;
import JavaORB.protocol.ServerStack;
import JavaORB.util.JavaORBThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ByteArrayHolder;
import org.omg.CORBA.ByteHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.FragmentHeader_1_2;
import org.omg.GIOP.FragmentHeader_1_2Helper;
import org.omg.GIOP.LocateReplyHeader_1_0;
import org.omg.GIOP.LocateReplyHeader_1_0Helper;
import org.omg.GIOP.LocateReplyHeader_1_2;
import org.omg.GIOP.LocateReplyHeader_1_2Helper;
import org.omg.GIOP.LocateRequestHeader_1_0;
import org.omg.GIOP.LocateRequestHeader_1_0Helper;
import org.omg.GIOP.LocateRequestHeader_1_2;
import org.omg.GIOP.LocateRequestHeader_1_2Helper;
import org.omg.GIOP.LocateStatusType_1_0;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.MessageHeader_1_0;
import org.omg.GIOP.MessageHeader_1_0Helper;
import org.omg.GIOP.MessageHeader_1_1;
import org.omg.GIOP.MessageHeader_1_1Helper;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.GIOP.ReplyHeader_1_2Helper;
import org.omg.GIOP.ReplyStatusType_1_0;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.RequestHeader_1_2;
import org.omg.GIOP.RequestHeader_1_2Helper;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.Version;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

public class ServerConnectionIIOP
extends JavaORBThread
implements ServerConnection {
    private ConnectionInfo _peer_info;
    public final int FRAGMENT_SIZE = 32000;
    private boolean wait_for_end;
    private JavaORBThread waiter;
    private Listener myListener;
    public boolean busy;
    public String host;
    public int port;
    private boolean endianMode;
    private String typeId;
    private Version version;
    private byte[] object_key;
    private TaggedComponent[] tagged_list;
    private TaggedComponent[] component_list;
    private TargetAddress target_key;
    private ServerStack connection;
    private ObjectAdapter Adapter;
    private boolean ConnectionAvailable;
    private ProtocolPlug plug;
    private ContextType myConnectionContext;
    private boolean pooled;
    private ServiceContext[] _sc_list_supplied;
    private ServiceContext[] _sc_list_consumed;
    protected static boolean use_bi_dir = false;
    protected static boolean _init = false;

    public ServiceContext[] _get_sending_service_context_list() {
        return this._sc_list_supplied;
    }

    public synchronized void parseRequestMessage(byte[] buffer, boolean endian, IntHolder RqId, BooleanHolder Response, ByteArrayHolder ObjectKey, StringHolder Operation, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        this._sc_list_supplied = new ServiceContext[0];
        switch (this.version.minor) {
            case 0: {
                this._sc_list_consumed = ServiceContextListHelper.read(is);
                RqId.value = is.read_ulong();
                Response.value = is.read_boolean();
                int size = is.read_ulong();
                ObjectKey.value = new byte[size];
                is.read_octet_array(ObjectKey.value, 0, size);
                Operation.value = is.read_string();
                size = is.read_ulong();
                byte[] tmp = new byte[size];
                is.read_octet_array(tmp, 0, size);
                break;
            }
            case 1: {
                this._sc_list_consumed = ServiceContextListHelper.read(is);
                RqId.value = is.read_ulong();
                Response.value = is.read_boolean();
                is.read_octet();
                is.read_octet();
                is.read_octet();
                int sz = is.read_ulong();
                ObjectKey.value = new byte[sz];
                is.read_octet_array(ObjectKey.value, 0, sz);
                Operation.value = is.read_string();
                sz = is.read_ulong();
                byte[] tmp = new byte[sz];
                is.read_octet_array(tmp, 0, sz);
                break;
            }
            case 2: {
                RequestHeader_1_2 header_2 = RequestHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                this._sc_list_consumed = header_2.service_context;
                Response.value = header_2.response_flags != 0;
                switch (header_2.target.discriminator()) {
                    case 0: {
                        ObjectKey.value = header_2.target.object_key();
                        break;
                    }
                    case 1: {
                        throw new NO_IMPLEMENT();
                    }
                    case 2: {
                        throw new NO_IMPLEMENT();
                    }
                }
                Operation.value = header_2.operation;
                break;
            }
        }
        if (Trace.level != 0) {
            Trace.Step("Reponse attendue : " + Response.value);
        }
        if (Trace.level != 0) {
            Trace.Step("( Thread " + Thread.currentThread().toString() + " ) Operation demandee : " + Operation.value);
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
        this.checkBiDirIIOP();
    }

    protected synchronized boolean isAnyReplyToRead(short rqid) {
        return ClientConnectionIIOP.isAnyReplyToRead(rqid);
    }

    public boolean busy() {
        return this.busy;
    }

    public OutputStream createMessageHeader(MsgType_1_1 type, int size, byte fragment_flag) {
        if (Trace.level != 0) {
            Trace.InFunction("ClientConnectionIIOP::createMessageHeader");
        }
        OutputStream output = this.plug.newOutputStream(this.version.minor);
        char[] magic = new char[]{'G', 'I', 'O', 'P'};
        switch (this.version.minor) {
            case 0: {
                MessageHeader_1_0 header = new MessageHeader_1_0(magic, this.version, NaturalEndian.value, (byte)type.value(), size);
                MessageHeader_1_0Helper.write(output, header);
                break;
            }
            case 1: 
            case 2: {
                byte flag = 0;
                if (NaturalEndian.value) {
                    flag = 1;
                }
                flag = (byte)(flag + fragment_flag * 2);
                MessageHeader_1_1 header1 = new MessageHeader_1_1(magic, this.version, flag, (byte)type.value(), size);
                MessageHeader_1_1Helper.write(output, header1);
                break;
            }
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ClientConnectionIIOP::createMessageHeader");
        }
        return output;
    }

    public void replySystemException(int RqId, OutputStream body) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::replySystemException");
        }
        OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 reply = new ReplyHeader_1_0();
                reply.service_context = this._sc_list_supplied;
                reply.request_id = RqId;
                reply.reply_status = ReplyStatusType_1_0.SYSTEM_EXCEPTION;
                ReplyHeader_1_0Helper.write(ReplyMsg, reply);
                break;
            }
            case 2: {
                ReplyHeader_1_2 reply_2 = new ReplyHeader_1_2();
                reply_2.service_context = this._sc_list_supplied;
                reply_2.request_id = RqId;
                reply_2.reply_status = ReplyStatusType_1_2.SYSTEM_EXCEPTION;
                ReplyHeader_1_2Helper.write(ReplyMsg, reply_2);
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).alignment(8);
        }
        ReplyMsg.write_octet_array(((ExtendedOutputStream)((java.lang.Object)body)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)body)).count());
        OutputStream output = this.createMessageHeader(MsgType_1_1.Reply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), (byte)0);
        output.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::replySystemException");
        }
    }

    public void setInfoToObject(Object obj) {
        if (obj == null) {
            return;
        }
        Delegate deleg = (Delegate)((ObjectImpl)obj)._get_delegate();
        deleg._set_receiving_service_context_list(this._sc_list_consumed);
    }

    public synchronized void parseFragmentMessage(byte[] buffer, boolean endian, IntHolder RqId, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                throw new INTERNAL();
            }
            case 2: {
                FragmentHeader_1_2 header_2 = FragmentHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
    }

    public void sendCloseConnection() {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::sendCloseConnection");
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.CloseConnection, 0, (byte)0);
        try {
            this.sendMessage(output);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            // empty catch block
        }
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::sendCloseConnection");
        }
    }

    public void sendMessage(OutputStream msg) {
        try {
            this.connection.write(((ExtendedOutputStream)((java.lang.Object)msg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)msg)).count());
        }
        catch (Throwable ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Impossible d'envoyer un message au client");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to reply to client", 5, CompletionStatus.COMPLETED_NO);
        }
    }

    private synchronized void parseReplyMessage(byte[] buffer, boolean endian, IntHolder RqId, ReplyStatusType_1_2Holder ReplyStatus, InputStream body) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        this._sc_list_supplied = new ServiceContext[0];
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 header1 = ReplyHeader_1_0Helper.read(is);
                RqId.value = header1.request_id;
                ReplyStatus.value = ReplyStatusType_1_2.from_int(header1.reply_status.value());
                this._sc_list_consumed = header1.service_context;
                break;
            }
            case 2: {
                ReplyHeader_1_2 header2 = ReplyHeader_1_2Helper.read(is);
                RqId.value = header2.request_id;
                ReplyStatus.value = header2.reply_status;
                this._sc_list_consumed = header2.service_context;
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedInputStream)((java.lang.Object)is)).alignment(8);
        }
        byte[] msgBody = new byte[buffer.length - ((ExtendedInputStream)((java.lang.Object)is)).count()];
        is.read_octet_array(msgBody, 0, msgBody.length);
        ((ExtendedInputStream)((java.lang.Object)body)).setBuffer(msgBody, endian);
    }

    public void receiveRequestByFragment(byte[] buffer, boolean endian, IntHolder RqId, BooleanHolder Response, ByteArrayHolder ObjectKey, StringHolder Operation, InputStream body) throws CloseConnectionEx {
        boolean last_frag = false;
        byte[] msg = new byte[]{};
        BooleanHolder fragment = new BooleanHolder();
        BooleanHolder endianType = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        int fragNum = 1;
        if (Trace.level != 0) {
            Trace.Step("Receive request by fragment");
        }
        if (Trace.level != 0) {
            Trace.Step("New fragment  : 1");
        }
        msg = buffer;
        while (!last_frag) {
            ++fragNum;
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endianType, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            if (!fragment.value) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            InputStream tempBody = this.plug.newInputStream(this.version.minor);
            byte[] tmp = null;
            if (this.version.minor == 2) {
                this.parseFragmentMessage(buffer, endian, RqId, tempBody);
                tmp = ((ExtendedInputStream)((java.lang.Object)tempBody)).getBuffer();
            } else {
                tmp = buffer;
            }
            if (Trace.level != 0) {
                Trace.Step("Fragment size = " + tmp.length);
            }
            byte[] old = msg;
            msg = new byte[msg.length + tmp.length];
            System.arraycopy(old, 0, msg, 0, old.length);
            System.arraycopy(tmp, 0, msg, old.length, tmp.length);
        }
        if (Trace.level != 0) {
            Trace.Step("Message size : " + msg.length);
        }
        this.parseRequestMessage(msg, endian, RqId, Response, ObjectKey, Operation, body);
    }

    protected RequestBag getAvailableRequest() {
        return ClientConnectionIIOP.getAvailableRequest();
    }

    public void pause() {
        this.suspendThread();
    }

    public void _set_key(byte[] key) {
        this.object_key = key;
    }

    public byte[] _get_key() {
        return this.object_key;
    }

    public void _set_target_key(TargetAddress target) {
        this.target_key = target;
    }

    public TargetAddress _get_target_key() {
        if (this.target_key == null) {
            this.target_key = new TargetAddress();
            this.target_key.object_key(this._get_key());
        }
        return this.target_key;
    }

    protected synchronized byte[] readBuffer(int size) throws COMM_FAILURE, CloseConnectionEx {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::readBuffer()");
        }
        byte[] buffer = new byte[size];
        try {
            this.connection.read(buffer, 0, size);
        }
        catch (InterruptedIOException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("TimeOut atteint du cote serveur, ferme la connexion");
            }
            throw new CloseConnectionEx();
        }
        catch (IOException ex) {
            if (Trace.level != 0) {
                Trace.TraceException(ex);
            }
            if (Trace.level != 0) {
                Trace.CoreError("Impossible de lire sur une connexion serveur");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to read on server connection", 2, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::readBuffer()");
        }
        return buffer;
    }

    public void _set_host(String host) {
        this.host = host;
    }

    public String _get_host() {
        return this.host;
    }

    public void noPool() {
        this.pooled = false;
    }

    public synchronized void deactivate() {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::desactivate()");
        }
        if (this.busy) {
            if (Trace.level != 0) {
                Trace.Step("Ferme le connexion d'ecoute du thread");
            }
            try {
                this.sendCloseConnection();
                this.connection.close();
            }
            catch (Throwable excep) {
                if (Trace.level != 0) {
                    Trace.CoreError("Impossible de fermer la connexion d'ecoute du thread");
                }
                if (Trace.level != 0) {
                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                }
                throw new COMM_FAILURE("Unable to close server connection", 8, CompletionStatus.COMPLETED_NO);
            }
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::desactivate()");
        }
    }

    public synchronized void setObjectAdapter(ObjectAdapter OA) {
        this.Adapter = OA;
    }

    public ServiceContext[] _get_service_context_list() {
        return this._sc_list_consumed;
    }

    public void _set_receiving_service_context_list(ServiceContext[] sc) {
        this._sc_list_consumed = sc;
    }

    public void _set_service_context_list(ServiceContext[] sc) {
        this._sc_list_supplied = sc;
    }

    public synchronized void setChannel(Socket channel) {
        if (Trace.level != 0) {
            Trace.InOutFunction("ServerConnectionIIOP::setChannel()");
        }
        this.connection.setChannel(channel);
        this.connection.setTimeOut(ORBSingleton._timeout);
        this._peer_info = new ConnectionInfo();
        InetAddress addr = channel.getInetAddress();
        this._peer_info.host = addr.getHostName();
        if (this._peer_info.host == null) {
            this._peer_info.host = addr.getHostAddress();
        }
        this._peer_info.port = channel.getPort();
        ORBSingleton._orb.get_listener_manager().dispatchNewConnectionEvent(this._peer_info);
    }

    public synchronized void parseLocateMessage(byte[] buffer, boolean endian, IntHolder RqId, ByteArrayHolder ObjectKey) {
        InputStream is = this.plug.newInputStream(buffer, endian, this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                LocateRequestHeader_1_0 header = LocateRequestHeader_1_0Helper.read(is);
                RqId.value = header.request_id;
                ObjectKey.value = header.object_key;
                break;
            }
            case 2: {
                LocateRequestHeader_1_2 header_2 = LocateRequestHeader_1_2Helper.read(is);
                RqId.value = header_2.request_id;
                switch (header_2.target.discriminator()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                ObjectKey.value = header_2.target.object_key();
                break;
            }
        }
    }

    public synchronized void setListener(Listener listen) {
        this.myListener = listen;
    }

    public org.omg.IIOP.Version adaptVersionToIIOP(Version ver) {
        org.omg.IIOP.Version version = new org.omg.IIOP.Version();
        version.major = ver.major;
        version.minor = ver.minor;
        return version;
    }

    public void replyUserException(int RqId, OutputStream body) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::replyUserException");
        }
        OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 reply = new ReplyHeader_1_0();
                reply.service_context = this._sc_list_supplied;
                reply.request_id = RqId;
                reply.reply_status = ReplyStatusType_1_0.USER_EXCEPTION;
                ReplyHeader_1_0Helper.write(ReplyMsg, reply);
                break;
            }
            case 2: {
                ReplyHeader_1_2 reply_2 = new ReplyHeader_1_2();
                reply_2.service_context = this._sc_list_supplied;
                reply_2.request_id = RqId;
                reply_2.reply_status = ReplyStatusType_1_2.USER_EXCEPTION;
                ReplyHeader_1_2Helper.write(ReplyMsg, reply_2);
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).alignment(8);
        }
        ReplyMsg.write_octet_array(((ExtendedOutputStream)((java.lang.Object)body)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)body)).count());
        OutputStream output = this.createMessageHeader(MsgType_1_1.Reply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), (byte)0);
        output.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::replyUserException");
        }
    }

    private void removeListenPoints() {
        if (Trace.level != 0) {
            Trace.Step("Remove listen points");
        }
        ORBSingleton._orb.removeListenPoint(this.connection);
    }

    public synchronized void parseMessageHeader(byte[] buffer, BooleanHolder endian, ByteHolder msgType, IntHolder msgSize, BooleanHolder fragment) {
        InputStream is = this.plug.newInputStream(buffer, NaturalEndian.value, this.version.minor);
        char[] magic = new char[4];
        is.read_char_array(magic, 0, 4);
        if (magic[0] != 'G' || magic[1] != 'I' || magic[2] != 'O' || magic[3] != 'P') {
            if (Trace.level != 0) {
                Trace.CoreError("Bad GIOP Header : " + magic);
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Bad GIOP Header", 3, CompletionStatus.COMPLETED_NO);
        }
        Version ver = org.omg.GIOP.VersionHelper.read(is);
        this.version.minor = ver.minor;
        this.version.major = ver.major;
        if (this.version.minor == 2) {
            byte flag = is.read_octet();
            endian.value = false;
            if ((flag & 1) != 0) {
                endian.value = true;
            }
        } else {
            endian.value = is.read_boolean();
        }
        is = this.plug.newInputStream(buffer, endian.value, this.version.minor);
        switch (this.version.minor) {
            case 0: {
                MessageHeader_1_0 header = MessageHeader_1_0Helper.read(is);
                msgType.value = header.message_type;
                msgSize.value = header.message_size;
                fragment.value = false;
                break;
            }
            case 1: 
            case 2: {
                MessageHeader_1_1 header1 = MessageHeader_1_1Helper.read(is);
                fragment.value = false;
                if ((header1.flags & 2) != 0) {
                    fragment.value = true;
                }
                msgType.value = header1.message_type;
                msgSize.value = header1.message_size;
                break;
            }
        }
    }

    public void run() {
        do {
            if (Trace.level != 0) {
                Trace.Step("Arrete le thread ServerConnection");
            }
            this.suspendThread();
            this.busy = true;
            if (Trace.level != 0) {
                Trace.Step("Apres reveil de ServerConnection");
            }
            try {
                this.proceed();
            }
            catch (COMM_FAILURE ex) {
                if (Trace.level != 0) {
                    Trace.CoreError("Rattrapage d'une exception COMM_FAILURE");
                }
            }
            catch (INTERNAL ex_internal) {
                if (Trace.level != 0) {
                    Trace.TraceException(ex_internal);
                }
                this.deactivate();
            }
            catch (Exception ex_strange) {
                if (Trace.level != 0) {
                    Trace.CoreError("Rattrapage d'une exception inattendue " + ex_strange.toString());
                }
                if (Trace.level != 0) {
                    Trace.TraceException(ex_strange);
                }
                this.deactivate();
            }
            this.busy = false;
            ORBSingleton._orb.get_listener_manager().dispatchCloseConnectionEvent(this._peer_info);
            if (this.wait_for_end) {
                this.waiter.resumeThread();
            }
            this.removeListenPoints();
        } while (this.pooled);
        this.myListener.ServerConnectionDown(this);
    }

    public void replyByFragment(int RqId, OutputStream body) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::replyByFragment");
        }
        byte[] buffer = ((ExtendedOutputStream)((java.lang.Object)body)).getBuffer();
        boolean last_frag = false;
        int last_size = buffer.length;
        int buffer_index = 0;
        int frag_size = 31988;
        int fragNum = 0;
        while (!last_frag) {
            OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
            if (++fragNum > 1 && this.version.minor == 2) {
                FragmentHeader_1_2 fragmentHeader = new FragmentHeader_1_2(RqId);
                FragmentHeader_1_2Helper.write(ReplyMsg, fragmentHeader);
            }
            byte[] toSend = new byte[frag_size];
            System.arraycopy(buffer, buffer_index, toSend, 0, frag_size);
            if (this.version.minor == 2) {
                ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).alignment(8);
            }
            ReplyMsg.write_octet_array(toSend, 0, frag_size);
            buffer_index += frag_size;
            if ((last_size -= frag_size) < 32000) {
                frag_size = last_size;
            }
            if (frag_size == 0) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            byte notLast = 0;
            if (!last_frag) {
                notLast = 1;
            }
            OutputStream reply = fragNum > 1 ? this.createMessageHeader(MsgType_1_1.Fragment, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), notLast) : this.createMessageHeader(MsgType_1_1.Reply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), notLast);
            reply.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
            if (Trace.level != 0) {
                Trace.Step("Send reply number : " + RqId);
            }
            this.sendMessage(reply);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::replyByFragment");
        }
    }

    private synchronized void receiveReplyByFragment(byte[] buffer, boolean endian, IntHolder RqId, ReplyStatusType_1_2Holder ReplyStatus, InputStream body) throws CloseConnectionEx {
        boolean last_frag = false;
        byte[] msg = new byte[]{};
        int fragNum = 0;
        BooleanHolder fragment = new BooleanHolder();
        BooleanHolder endianType = new BooleanHolder();
        ByteHolder msgType = new ByteHolder();
        IntHolder msgSize = new IntHolder();
        if (Trace.level != 0) {
            Trace.Step("Receive reply by fragment");
        }
        if (Trace.level != 0) {
            Trace.Step("New fragment  : 1");
        }
        msg = buffer;
        while (!last_frag) {
            ++fragNum;
            buffer = this.readBuffer(12);
            this.parseMessageHeader(buffer, endianType, msgType, msgSize, fragment);
            buffer = this.readBuffer(msgSize.value);
            if (!fragment.value) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            InputStream tempBody = this.plug.newInputStream(this.version.minor);
            byte[] tmp = null;
            if (this.version.minor == 2) {
                this.parseFragmentMessage(buffer, endian, RqId, tempBody);
                tmp = ((ExtendedInputStream)((java.lang.Object)tempBody)).getBuffer();
            } else {
                tmp = buffer;
            }
            if (Trace.level != 0) {
                Trace.Step("Fragment size = " + tmp.length);
            }
            byte[] old = msg;
            msg = new byte[msg.length + tmp.length];
            System.arraycopy(old, 0, msg, 0, old.length);
            System.arraycopy(tmp, 0, msg, old.length, tmp.length);
        }
        if (Trace.level != 0) {
            Trace.Step("Message size : " + msg.length);
        }
        this.parseReplyMessage(msg, endian, RqId, ReplyStatus, body);
    }

    public void sendMessageError() {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::sendMessageError");
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.MessageError, 0, (byte)0);
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::sendMessageError");
        }
    }

    public void _set_version(Version version) {
        this.version = version;
    }

    public Version _get_version() {
        return this.version;
    }

    public Version adaptVersion(org.omg.IIOP.Version ver) {
        Version version = new Version();
        version.major = ver.major;
        version.minor = ver.minor;
        return version;
    }

    public void reactivation() {
        this.resumeThread();
    }

    public void locateReplyByFragment(int RqId, OutputStream body) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::locateReplyByFragment");
        }
        byte[] buffer = ((ExtendedOutputStream)((java.lang.Object)body)).getBuffer();
        boolean last_frag = false;
        int last_size = buffer.length;
        int buffer_index = 0;
        int frag_size = 31988;
        int fragNum = 0;
        while (!last_frag) {
            OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
            if (++fragNum > 1 && this.version.minor == 2) {
                FragmentHeader_1_2 fragmentHeader = new FragmentHeader_1_2(RqId);
                FragmentHeader_1_2Helper.write(ReplyMsg, fragmentHeader);
            }
            byte[] toSend = new byte[frag_size];
            System.arraycopy(buffer, buffer_index, toSend, 0, frag_size);
            ReplyMsg.write_octet_array(toSend, 0, frag_size);
            buffer_index += frag_size;
            if ((last_size -= frag_size) < 32000) {
                frag_size = last_size;
            }
            if (frag_size == 0) {
                last_frag = true;
                if (Trace.level != 0) {
                    Trace.Step("Last fragment : " + fragNum);
                }
            } else if (Trace.level != 0) {
                Trace.Step("New fragment : " + fragNum);
            }
            byte notLast = 0;
            if (!last_frag) {
                notLast = 1;
            }
            OutputStream reply = fragNum > 1 ? this.createMessageHeader(MsgType_1_1.Fragment, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), notLast) : this.createMessageHeader(MsgType_1_1.LocateReply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), notLast);
            reply.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
            if (Trace.level != 0) {
                Trace.Step("Send reply number : " + RqId);
            }
            this.sendMessage(reply);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::locateReplyByFragment");
        }
    }

    public void end() {
        this.myListener.ServerConnectionDown(this);
        this.pooled = false;
    }

    public synchronized void complete() {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::complete");
        }
        try {
            if (this.busy) {
                if (Trace.level != 0) {
                    Trace.Step("On attend la fin du traitement");
                }
                this.waiter = (JavaORBThread)Thread.currentThread();
                this.wait_for_end = true;
                this.waiter.suspendThread();
                if (Trace.level != 0) {
                    Trace.Step("Traitement acheve");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::complete_and_desactivate()");
        }
    }

    public byte[] fillProfile(int ver_minor) {
        OutputStream output = this.plug.newOutputStream(this.version.minor);
        output.write_boolean(this.endianMode);
        switch (ver_minor) {
            case 0: {
                ProfileBody_1_0 profile = new ProfileBody_1_0();
                profile.host = this.host;
                profile.iiop_version = new org.omg.IIOP.Version();
                profile.iiop_version.major = 1;
                profile.iiop_version.minor = 0;
                profile.port = (short)this.port;
                profile.object_key = this.object_key;
                ProfileBody_1_0Helper.write(output, profile);
                break;
            }
            case 1: 
            case 2: {
                ProfileBody_1_1 profile_1 = new ProfileBody_1_1();
                profile_1.host = this.host;
                profile_1.iiop_version = new org.omg.IIOP.Version();
                profile_1.iiop_version.major = 1;
                profile_1.iiop_version.minor = (byte)ver_minor;
                profile_1.port = (short)this.port;
                profile_1.object_key = this.object_key;
                profile_1.components = this.tagged_list;
                ProfileBody_1_1Helper.write(output, profile_1);
                break;
            }
        }
        byte[] ProfileBody = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
        return ProfileBody;
    }

    private void addListenPoints(ListenPoint[] lp) {
        ORBSingleton._orb.addListenPoint(lp, this.connection);
    }

    public void replyLocationReply(int RqId, LocateStatusType_1_2 status, OutputStream ref) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::replyLocationReply");
        }
        OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                LocateReplyHeader_1_0 reply = new LocateReplyHeader_1_0();
                reply.request_id = RqId;
                reply.locate_status = LocateStatusType_1_0.from_int(status.value());
                LocateReplyHeader_1_0Helper.write(ReplyMsg, reply);
                break;
            }
            case 2: {
                LocateReplyHeader_1_2 reply_2 = new LocateReplyHeader_1_2();
                reply_2.request_id = RqId;
                reply_2.locate_status = status;
                LocateReplyHeader_1_2Helper.write(ReplyMsg, reply_2);
                break;
            }
        }
        if (status.value() == LocateStatusType_1_2.OBJECT_FORWARD.value()) {
            ReplyMsg.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ref)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ref)).count());
        }
        if (((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer().length > 32008 && this.version.minor > 0) {
            this.locateReplyByFragment(RqId, ReplyMsg);
            return;
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.LocateReply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), (byte)0);
        output.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
        if (Trace.level != 0) {
            Trace.Step("Send reply number : " + RqId);
        }
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::replyLocationReply");
        }
    }

    public void copyInfoFromObject(Object obj) {
        if (obj == null) {
            return;
        }
        Delegate deleg = (Delegate)((ObjectImpl)obj)._get_delegate();
        this._sc_list_supplied = deleg._get_sending_service_context_list();
    }

    public void begin() {
        this.setDaemon(true);
        this.start();
    }

    protected synchronized boolean isAnyRequestToRead() {
        return ClientConnectionIIOP.isAnyRequestToRead();
    }

    public synchronized void appendReplyToQueue(InputStream input, byte[] buffer, boolean endian, short rqid) {
        ClientConnectionIIOP.appendReplyToQueue(input, buffer, endian, rqid);
    }

    public ServerConnectionIIOP() {
        if (Trace.level != 0) {
            Trace.NewInstance("ServerConnectionIIOP");
        }
        this.busy = false;
        this.endianMode = NaturalEndian.value;
        this.wait_for_end = false;
        this.plug = ORBSingleton.plug;
        this.myConnectionContext = new ContextType();
        this.version = new Version(1, ProtocolPlugIIOP.minor);
        this.pooled = true;
        this.tagged_list = new TaggedComponent[0];
        this.component_list = new TaggedComponent[0];
        this._sc_list_supplied = new ServiceContext[0];
        this._sc_list_consumed = new ServiceContext[0];
        this.connection = this.plug.newServerStack();
        if (!_init) {
            _init = true;
            String s = ORBSingleton.getORBProperty("ORB.BiDirIIOP");
            if (s != null && s.equalsIgnoreCase("true")) {
                use_bi_dir = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void proceed() throws COMM_FAILURE {
        endian = new BooleanHolder();
        fragment = new BooleanHolder();
        msgType = new ByteHolder();
        msgSize = new IntHolder();
        Response = new BooleanHolder();
        RqId = null;
        ObjectKey = new ByteArrayHolder();
        Operation = new StringHolder();
        body = null;
        ReplyStatus = new ReplyStatusType_1_2Holder();
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::proceed()");
        }
        this.ConnectionAvailable = true;
        if (Trace.level != 0) {
            Trace.Step("Traite les requetes en entrees");
        }
        try {
            while (this.ConnectionAvailable) {
                var13_14 = this.connection.locker();
                synchronized (var13_14) {
                    block34: {
                        body = this.plug.newInputStream(this.version.minor);
                        RqId = new IntHolder();
                        if (this.isAnyRequestToRead()) {
                            if (Trace.level != 0) {
                                Trace.Step("A request is available...");
                            }
                            rq = this.getAvailableRequest();
                            buffer = rq.buffer;
                            endian.value = rq.endian;
                            msgType.value = rq.msgType;
                            fragment.value = rq.fragment;
                        } else {
                            if (this.isAnyReplyToRead((short)-1)) break block34;
                            if (Trace.level != 0) {
                                Trace.Step("Try to get a request...");
                            }
                            buffer = this.readBuffer(12);
                            this.parseMessageHeader(buffer, endian, msgType, msgSize, fragment);
                            buffer = this.readBuffer(msgSize.value);
                        }
                        switch (msgType.value) {
                            case 0: {
                                if (Trace.level != 0) {
                                    Trace.Step("A new request is available...");
                                }
                                if (fragment.value) {
                                    this.receiveRequestByFragment(buffer, endian.value, RqId, Response, ObjectKey, Operation, body);
                                } else {
                                    this.parseRequestMessage(buffer, endian.value, RqId, Response, ObjectKey, Operation, body);
                                }
                                if (Trace.level != 0) {
                                    Trace.Step("Dispatch request number : " + RqId.value);
                                }
                                this.Adapter.dispatch(this, RqId.value, Response.value, ObjectKey.value, Operation.value, body);
                                ** break;
                            }
                            case 1: {
                                if (ServerConnectionIIOP.use_bi_dir) {
                                    if (fragment.value) {
                                        if (Trace.level != 0) {
                                            Trace.Step("A response is received by fragment");
                                        }
                                        this.receiveReplyByFragment(buffer, endian.value, RqId, ReplyStatus, body);
                                    } else {
                                        this.parseReplyMessage(buffer, endian.value, RqId, ReplyStatus, body);
                                    }
                                    this.appendReplyToQueue(body, buffer, endian.value, (short)RqId.value);
                                    ** break;
                                }
                                if (Trace.level != 0) {
                                    Trace.CoreError("Unexpected message type : " + msgType.value);
                                }
                                this.sendMessageError();
                                ** break;
                            }
                            case 2: {
                                ** break;
                            }
                            case 3: {
                                this.parseLocateMessage(buffer, endian.value, RqId, ObjectKey);
                                this.Adapter.locate(this, RqId.value, ObjectKey.value);
                                ** break;
                            }
                            case 6: {
                                this.deactivate();
                                if (Trace.level != 0) {
                                    Trace.CoreError("Message MessageError recu ");
                                }
                                if (Trace.level != 0) {
                                    Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
                                }
                                throw new COMM_FAILURE("Unknown message type", 4, CompletionStatus.COMPLETED_MAYBE);
                            }
                            case 7: {
                                if (Trace.level != 0) {
                                    Trace.CoreError("Message inattendu : " + msgType.value);
                                }
                                this.sendMessageError();
                                ** break;
                            }
                            default: {
                                if (Trace.level != 0) {
                                    Trace.CoreError("Message inconnu : " + msgType.value);
                                }
                                this.sendMessageError();
                            }
                        }
lbl88:
                        // 7 sources

                    }
                    var14_15 = null;
                }
            }
        }
        catch (CloseConnectionEx ex) {
            this.sendCloseConnection();
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::proceed()");
        }
    }

    public void reply(int RqId, OutputStream body) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::reply");
        }
        OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 reply = new ReplyHeader_1_0();
                reply.service_context = this._sc_list_supplied;
                reply.request_id = RqId;
                reply.reply_status = ReplyStatusType_1_0.NO_EXCEPTION;
                ReplyHeader_1_0Helper.write(ReplyMsg, reply);
                break;
            }
            case 2: {
                ReplyHeader_1_2 reply_2 = new ReplyHeader_1_2();
                reply_2.service_context = this._sc_list_supplied;
                reply_2.request_id = RqId;
                reply_2.reply_status = ReplyStatusType_1_2.NO_EXCEPTION;
                ReplyHeader_1_2Helper.write(ReplyMsg, reply_2);
                break;
            }
        }
        if (this.version.minor == 2) {
            ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).alignment(8);
        }
        ReplyMsg.write_octet_array(((ExtendedOutputStream)((java.lang.Object)body)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)body)).count());
        if (((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer().length > 32008 && this.version.minor > 0) {
            this.replyByFragment(RqId, ReplyMsg);
            return;
        }
        if (this.version.minor == 2) {
            int chunck = (((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count() + 12) % 8;
            int i = 0;
            while (i < chunck) {
                ReplyMsg.write_octet((byte)0);
                ++i;
            }
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.Reply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), (byte)0);
        output.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
        if (Trace.level != 0) {
            Trace.Step("Send reply number : " + RqId);
        }
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::reply");
        }
    }

    public void _set_port(int port) {
        this.port = port;
    }

    public int _get_port() {
        return this.port;
    }

    private void checkBiDirIIOP() {
        int i = 0;
        while (i < this._sc_list_consumed.length) {
            if (this._sc_list_consumed[i].context_id == 5) {
                InputStream in = this.plug.newInputStream(this._sc_list_consumed[i].context_data, true, this.version.minor);
                ((ExtendedInputStream)((java.lang.Object)in)).setEndian(in.read_boolean());
                BiDirIIOPServiceContext sc = BiDirIIOPServiceContextHelper.read(in);
                this.addListenPoints(sc.listen_points);
                return;
            }
            ++i;
        }
    }

    public java.lang.Object _get_extra(String name) {
        if (name.equals("TaggedProfile")) {
            return this.tagged_list;
        }
        if (name.equals("TaggedComponent")) {
            return this.component_list;
        }
        return null;
    }

    public void _set_id(String id) {
        this.typeId = id;
    }

    public String _get_id() {
        return this.typeId;
    }

    public void _set_extra(String name, java.lang.Object value) {
        if (name.equals("TaggedProfile")) {
            this.tagged_list = (TaggedComponent[])value;
        } else if (name.equals("TaggedComponent")) {
            this.component_list = (TaggedComponent[])value;
        }
    }

    public void readObjectRef(InputStream is) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::readObjectRef");
        }
        boolean find_profile = false;
        IOR ior = null;
        ior = IORHelper.read(is);
        this.typeId = ior.type_id;
        if (this.typeId.equals("")) {
            this.typeId = null;
        }
        if (Trace.level != 0) {
            Trace.Step("Type Id : " + this.typeId);
        }
        int i = 0;
        while (i < ior.profiles.length) {
            boolean endian;
            InputStream input;
            if (ior.profiles[i].tag == 0) {
                if (!find_profile) {
                    if (Trace.level != 0) {
                        Trace.Step("Profile IIOP");
                    }
                    find_profile = true;
                    input = this.plug.newInputStream(ior.profiles[i].profile_data, false, this.version.minor);
                    endian = input.read_boolean();
                    ((ExtendedInputStream)((java.lang.Object)input)).setEndian(endian);
                    this.version = this.adaptVersion(VersionHelper.read(input));
                    ((ExtendedInputStream)((java.lang.Object)input)).resetCount();
                    input.read_boolean();
                    switch (this.version.minor) {
                        case 0: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.0");
                            }
                            ProfileBody_1_0 profile = ProfileBody_1_0Helper.read(input);
                            this.host = profile.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile.iiop_version);
                            this.object_key = profile.object_key;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                            }
                            this.tagged_list = new TaggedComponent[0];
                            break;
                        }
                        case 1: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.1");
                            }
                            ProfileBody_1_1 profile_1 = ProfileBody_1_1Helper.read(input);
                            this.host = profile_1.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile_1.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile_1.iiop_version);
                            this.object_key = profile_1.object_key;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                            }
                            this.tagged_list = profile_1.components;
                            break;
                        }
                        case 2: {
                            if (Trace.level != 0) {
                                Trace.Step("IIOP version 1.2");
                            }
                            ProfileBody_1_1 profile_2 = ProfileBody_1_1Helper.read(input);
                            this.host = profile_2.host;
                            if (Trace.level != 0) {
                                Trace.Step("Hote : " + this.host);
                            }
                            this.port = profile_2.port;
                            if (this.port < 0) {
                                this.port = 65536 + this.port;
                            }
                            if (Trace.level != 0) {
                                Trace.Step("Port : " + this.port);
                            }
                            this.version = this.adaptVersion(profile_2.iiop_version);
                            this.object_key = profile_2.object_key;
                            if (Trace.level != 0) {
                                Trace.Step("Object Key :" + new String(this.object_key));
                            }
                            this.tagged_list = profile_2.components;
                            break;
                        }
                    }
                }
            } else if (ior.profiles[i].tag == 1) {
                if (Trace.level != 0) {
                    Trace.Step("Profile MULTIPLE COMPONENTS");
                }
                input = this.plug.newInputStream(ior.profiles[i].profile_data, false, this.version.minor);
                endian = input.read_boolean();
                ((ExtendedInputStream)((java.lang.Object)input)).setEndian(endian);
                int nb_components = input.read_ulong();
                this.component_list = new TaggedComponent[nb_components];
                int j = 0;
                while (j < this.component_list.length) {
                    this.component_list[j] = TaggedComponentHelper.read(input);
                    ++j;
                }
            }
            ++i;
        }
        if (!find_profile && this.typeId != null) {
            if (Trace.level != 0) {
                Trace.CoreError("Reference d'objet invalide");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.INV_OBJREF");
            }
            throw new INV_OBJREF("Invalid IIOP reference", 1, CompletionStatus.COMPLETED_NO);
        }
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::readObjectRef");
        }
    }

    public void writeObjectRef(OutputStream os) {
        int delta = 0;
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::writeObjectRef");
        }
        if (this.component_list.length != 0) {
            ++delta;
        }
        IOR ior = new IOR();
        ior.type_id = this.typeId;
        switch (this.version.minor) {
            case 0: {
                ior.profiles = new TaggedProfile[1];
                ior.profiles[0] = new TaggedProfile();
                ior.profiles[0].tag = 0;
                ior.profiles[0].profile_data = this.fillProfile(this.version.minor);
                if (delta == 0) break;
                ior.profiles[1] = new TaggedProfile();
                ior.profiles[1].tag = 1;
                OutputStream output = this.plug.newOutputStream(this.version.minor);
                output.write_boolean(this.endianMode);
                output.write_ulong(this.component_list.length);
                int i = 0;
                while (i < this.component_list.length) {
                    TaggedComponentHelper.write(output, this.component_list[i]);
                    ++i;
                }
                ior.profiles[1].profile_data = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
                break;
            }
            case 1: 
            case 2: {
                ior.profiles = new TaggedProfile[2];
                ior.profiles[0] = new TaggedProfile();
                ior.profiles[0].tag = 0;
                ior.profiles[0].profile_data = this.fillProfile(this.version.minor);
                ior.profiles[1] = new TaggedProfile();
                ior.profiles[1].tag = 0;
                ior.profiles[1].profile_data = this.fillProfile(0);
                if (delta == 0) break;
                ior.profiles[2] = new TaggedProfile();
                ior.profiles[2].tag = 1;
                OutputStream output = this.plug.newOutputStream(this.version.minor);
                output.write_boolean(this.endianMode);
                output.write_ulong(this.component_list.length);
                int i = 0;
                while (i < this.component_list.length) {
                    TaggedComponentHelper.write(output, this.component_list[i]);
                    ++i;
                }
                ior.profiles[2].profile_data = ((ExtendedOutputStream)((java.lang.Object)output)).getBuffer();
                break;
            }
        }
        IORHelper.write(os, ior);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::writeObjectRef");
        }
    }

    public ContextType getContext() {
        return this.myConnectionContext;
    }

    public void replyLocationForward(int RqId, OutputStream ref) {
        if (Trace.level != 0) {
            Trace.InFunction("ServerConnectionIIOP::replyLocationForward");
        }
        OutputStream ReplyMsg = this.plug.newOutputStream(this.version.minor);
        switch (this.version.minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 reply = new ReplyHeader_1_0();
                reply.service_context = this._sc_list_supplied;
                reply.request_id = RqId;
                reply.reply_status = ReplyStatusType_1_0.LOCATION_FORWARD;
                ReplyHeader_1_0Helper.write(ReplyMsg, reply);
                break;
            }
            case 2: {
                ReplyHeader_1_2 reply_2 = new ReplyHeader_1_2();
                reply_2.service_context = this._sc_list_supplied;
                reply_2.request_id = RqId;
                reply_2.reply_status = ReplyStatusType_1_2.LOCATION_FORWARD;
                ReplyHeader_1_2Helper.write(ReplyMsg, reply_2);
                break;
            }
        }
        ReplyMsg.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ref)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ref)).count());
        if (((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer().length > 32008 && this.version.minor > 0) {
            this.replyByFragment(RqId, ReplyMsg);
            return;
        }
        if (this.version.minor == 2) {
            int chunck = (((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count() + 12) % 8;
            int i = 0;
            while (i < chunck) {
                ReplyMsg.write_octet((byte)0);
                ++i;
            }
        }
        OutputStream output = this.createMessageHeader(MsgType_1_1.Reply, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count(), (byte)0);
        output.write_octet_array(((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).getBuffer(), 0, ((ExtendedOutputStream)((java.lang.Object)ReplyMsg)).count());
        if (Trace.level != 0) {
            Trace.Step("Send reply number : " + RqId);
        }
        this.sendMessage(output);
        if (Trace.level != 0) {
            Trace.OutFunction("ServerConnectionIIOP::replyLocationForward");
        }
    }
}

