/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.iiop;

import JavaORB.CORBA.MessageInterceptorManager;
import JavaORB.CORBA.ORBSingleton;
import JavaORB.Interceptor.MessageManagerImpl;
import JavaORB.Trace;
import JavaORB.protocol.ClientConnection;
import JavaORB.protocol.ServerStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;

public class ServerStackIIOP
implements ServerStack {
    private Socket connection;
    private Object mutex;
    private byte[] remaining;
    private MessageInterceptorManager _manager = ORBSingleton.initSingleton().getMessageInterceptorManager();

    public void updateSender(ClientConnection sender) {
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public void open(String host, int port) throws IOException, UnknownHostException {
    }

    public ServerStackIIOP() {
        this.remaining = new byte[0];
        this.mutex = new Object();
    }

    public int read(byte[] buffer, int begin, int size) throws InterruptedIOException, IOException {
        boolean stop = false;
        boolean doIt = true;
        int r = 0;
        int _size = 0;
        byte[] tmp_buffer = new byte[size];
        do {
            doIt = true;
            if (this.remaining.length != 0) {
                if (this.remaining.length >= size) {
                    doIt = false;
                    tmp_buffer = this.remaining;
                    _size = size;
                } else {
                    _size = size - this.remaining.length;
                    doIt = true;
                }
            } else {
                _size = size;
            }
            if (doIt) {
                r = this.receive(tmp_buffer, 0, _size);
            }
            if (_size == size) continue;
            byte[] tmp = new byte[size];
            System.arraycopy(this.remaining, 0, tmp, 0, this.remaining.length);
            System.arraycopy(tmp_buffer, 0, tmp, this.remaining.length, tmp_buffer.length);
            tmp_buffer = tmp;
        } while (stop = this.receive_message_interceptor(tmp_buffer, buffer, begin, size));
        return r;
    }

    public boolean available() throws IOException {
        InputStream input = this.connection.getInputStream();
        int available = input.available();
        return available != 0;
    }

    public void write(byte[] buffer, int begin, int size) throws IOException {
        IntHolder new_size = new IntHolder(size);
        byte[] new_buffer = this.send_message_interceptor(buffer, begin, new_size);
        this.send(new_buffer, 0, new_size.value);
    }

    public void setTimeOut(int time) {
        try {
            this.connection.setSoTimeout(time);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void setChannel(Socket channel) {
        this.connection = channel;
    }

    public byte[] send_message_interceptor(byte[] buffer, int begin, IntHolder size) {
        MessageManagerImpl manager = new MessageManagerImpl(this);
        manager.setMessageIn(buffer, begin, size.value);
        int i = 0;
        while (i < this._manager.getList().length) {
            this._manager.getList()[i].send_message(null, manager);
            ++i;
        }
        return manager.getMessageIn(size);
    }

    public boolean receive_message_interceptor(byte[] tmp, byte[] buffer, int begin, int size) {
        MessageManagerImpl manager = new MessageManagerImpl(this);
        manager.setMessageOut(tmp, 0, size);
        int i = 0;
        while (i < this._manager.getList().length) {
            if (this._manager.getList()[this._manager.getList().length - (i + 1)].receive_message(null, manager)) {
                return true;
            }
            ++i;
        }
        manager.getMessageOut(buffer, 0, begin, size);
        this.remaining = manager.remain();
        return false;
    }

    public Object locker() {
        return this.mutex;
    }

    public void send(byte[] buffer, int begin, int size) throws IOException {
        OutputStream output = this.connection.getOutputStream();
        output.write(buffer, begin, size);
    }

    public int receive(byte[] buffer, int begin, int size) throws InterruptedIOException, IOException {
        InputStream input;
        try {
            input = this.connection.getInputStream();
        }
        catch (IOException ex) {
            if (Trace.level != 0) {
                Trace.CoreError("Unable to get InputStream");
            }
            if (Trace.level != 0) {
                Trace.ThrowException("org.omg.CORBA.COMM_FAILURE");
            }
            throw new COMM_FAILURE("Unable to get inputstream", 5, CompletionStatus.COMPLETED_NO);
        }
        byte[] copy_buffer = new byte[size];
        int old_size = begin;
        while (size != 0) {
            int read = input.read(copy_buffer, 0, size);
            size -= read;
            System.arraycopy(copy_buffer, 0, buffer, old_size, read);
            old_size = read + old_size;
        }
        return size;
    }

    public Object object() {
        return this.connection;
    }
}

