/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.ir;

import JavaORB.compiler.IdlCompiler;
import JavaORB.compiler.object.IdlObject;
import JavaORB.compiler.parser.IdlParser;
import JavaORB.ir.idlToIR;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;

public class irTool {
    public static String idl_file_name;
    public static boolean remove;

    public static void main(String[] args) {
        IdlCompiler.packageName = new String("corba_pkg");
        IdlParser Parser = new IdlParser();
        idlToIR toIR = new idlToIR();
        IdlCompiler.displayBadFlag = false;
        IdlCompiler.analyse_arguments(args);
        System.out.println("JavaORB / irTool utility");
        System.out.println("version 1.0");
        System.out.println("Jerome Daniel");
        System.out.println("");
        if (args.length != 0) {
            irTool.analyse_arguments(args);
        } else {
            irTool.affiche_aide();
        }
        Repository root = irTool.connectToIR(args);
        IdlCompiler.verbose = true;
        IdlObject.adaptName = false;
        IdlObject CompilationGraph = Parser.compile_idl(idl_file_name);
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors in IDL file...");
            System.out.println("No IDL definitions added !");
            System.exit(0);
        }
        if (!remove) {
            toIR.addIDLData(CompilationGraph, root);
        }
    }

    static {
        remove = false;
    }

    public static void analyse_arguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') {
                idl_file_name = args[i];
            } else if (args[i].equals("-remove")) {
                remove = true;
            } else if (args[i].equals("-verbose")) {
                idlToIR.verbose = true;
            }
            ++i;
        }
    }

    public static Repository connectToIR(String[] args) {
        ORB orb = ORB.init(args, null);
        Repository root = null;
        try {
            Object obj = orb.resolve_initial_references("InterfaceRepository");
            root = RepositoryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            System.out.println("Unable to connect to IR");
            System.out.println("Check these elements : ");
            System.out.println("\t- The IR is running");
            System.out.println("\t- The ORB.ref is updated and can be found");
            System.exit(0);
        }
        if (root == null) {
            System.out.println("Unable to connect to IR");
            System.out.println("Check these elements : ");
            System.out.println("\t- The IR is running");
            System.out.println("\t- The ORB.ref is updated and can be found");
            System.exit(0);
        }
        return root;
    }

    public static void affiche_aide() {
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################");
        System.out.println("#                     JavaORB                   #");
        System.out.println("#                -----------------              #");
        System.out.println("#                 (c) 1997, 1998                #");
        System.out.println("#################################################");
        System.out.println("# Interface Repository Tool, Release 1.0        #");
        System.out.println("#################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Usage");
        System.out.println("-----");
        System.out.println("");
        System.out.println("\tirTool idl_file_name [ options ]");
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("\t-remove");
        System.out.println("\t\tRemove an IDL definition from the Interface Repository");
        System.out.println("\t-I");
        System.out.println("\t\tProvide a way to define some include directories.");
        System.out.println("\t\tcommande.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  idl demo.idl -I/home/moi/idl -I../autre");
        System.out.println("\t-D");
        System.out.println("\t\tWith this option, you can define some symboles. This");
        System.out.println("\t\toption is equivalent to #define");
        System.out.println("");
        System.out.println("");
        System.exit(0);
    }
}

