/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.util;

import JavaORB.ORBObjectLoaderHelper;
import JavaORB.ObjectAlreadyRegistered;
import JavaORB.ObjectData;
import JavaORB.ObjectDataHolder;
import JavaORB.ObjectIdHolder;
import JavaORB.ObjectNotFound;
import JavaORB.Trace;
import JavaORB._loaderImplBase;
import JavaORB.launchPolicy;
import JavaORB.loader;
import JavaORB.loaderHelper;
import JavaORB.util.IORBag;
import JavaORB.util.IORManager;
import JavaORB.util.LoaderActiveEntry;
import JavaORB.util.LoaderEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.GIOP.Version;

public class LoaderImpl
extends _loaderImplBase {
    Vector table = new Vector();
    Vector active = new Vector();
    int activeCount;

    public void stopObject(int id) throws ObjectNotFound {
        LoaderActiveEntry act = this.findActiveEntryById(id);
        if (act == null) {
            throw new ObjectNotFound();
        }
        boolean external = false;
        if (act.entry.serverHost != null && !act.entry.serverHost.equals("")) {
            external = true;
        }
        if (external) {
            IORManager manager = new IORManager();
            IORBag ior = manager.extract(this);
            ior.host = act.entry.serverHost;
            Object remoteLoader = manager.bag_to_ior(ior);
            loader rloader = loaderHelper.narrow(remoteLoader);
            rloader.stopObject(id);
            return;
        }
        if (act.entry.policy == launchPolicy.NOT_SHARED) {
            act.process.destroy();
            act.process = null;
            int index = this.findActiveEntryIndexById(id);
            this.active.removeElementAt(index);
        } else {
            act.launchCount += -1;
            int index = this.findActiveEntryIndexById(id);
            this.active.removeElementAt(index);
            if (act.launchCount == 0) {
                if (act.entry.policy == launchPolicy.ALL_OBJECTS_SHARED) {
                    boolean isAnyMoreActivity = this.isAnyActivity(act.entry.serverName);
                    if (!isAnyMoreActivity) {
                        act.process.destroy();
                        act.process = null;
                    }
                } else {
                    act.process.destroy();
                    act.process = null;
                }
            }
        }
    }

    public int findActiveEntryIndexById(int id) {
        int i = 0;
        while (i < this.active.size()) {
            LoaderActiveEntry entry = (LoaderActiveEntry)this.active.elementAt(i);
            if (entry.id == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeObject(String name) throws ObjectNotFound {
        int index = this.findEntryIndexByName(name);
        if (index == -1) {
            throw new ObjectNotFound();
        }
        this.table.removeElementAt(index);
    }

    public void getObjectData(String name, ObjectDataHolder data) throws ObjectNotFound {
        int index = this.findEntryIndexByName(name);
        if (index == -1) {
            throw new ObjectNotFound();
        }
        LoaderEntry entry = (LoaderEntry)this.table.elementAt(index);
        data.value = new ObjectData();
        data.value.id = -1;
        data.value.name = name;
        data.value.host = entry.serverHost;
        data.value.server = entry.serverName;
        data.value.classpath = entry.classpath;
        data.value.arguments = entry.args;
        data.value.policy = entry.policy;
    }

    public LoaderImpl() {
        this.loadPersistentData();
    }

    public void addObject(String name, String host, String serverName, String serverClasspath, String arguments, launchPolicy policy) throws ObjectAlreadyRegistered {
        if (this.findEntryIndexByName(name) != -1) {
            throw new ObjectAlreadyRegistered();
        }
        LoaderEntry entry = new LoaderEntry();
        entry.name = name;
        entry.serverHost = host;
        entry.serverName = serverName;
        entry.classpath = serverClasspath;
        entry.args = arguments;
        entry.orbLoader = null;
        entry.policy = policy;
        this.table.addElement(entry);
    }

    public int findEntryIndexByName(String name) {
        int i = 0;
        while (i < this.table.size()) {
            LoaderEntry entry = (LoaderEntry)this.table.elementAt(i);
            if (entry.name.compareTo(name) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findEntryIndexByServerName(String name) {
        int i = 0;
        while (i < this.table.size()) {
            LoaderEntry entry = (LoaderEntry)this.table.elementAt(i);
            if (entry.serverName.compareTo(name) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isAnyActivity(String name) {
        int i = 0;
        while (i < this.active.size()) {
            LoaderActiveEntry act = (LoaderActiveEntry)this.active.elementAt(i);
            if (act.entry.serverName.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String deleteSpace(String src) {
        int begin_idx = 0;
        int end_idx = 0;
        String word = null;
        try {
            begin_idx = 0;
            while (src.charAt(begin_idx) == ' ') {
                ++begin_idx;
            }
            end_idx = src.length() - 1;
            while (src.charAt(end_idx) == ' ') {
                --end_idx;
            }
            word = new String(src.substring(begin_idx, end_idx + 1));
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return word;
    }

    private void loadPersistentData() {
        Properties p = new Properties();
        Vector v = new Vector();
        FileInputStream input = null;
        launchPolicy policy = null;
        try {
            input = new FileInputStream("loader.data");
            p.load(input);
        }
        catch (IOException ex) {
            return;
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        int i = 0;
        while (i < v.size()) {
            String name = (String)v.elementAt(i);
            String stRef = p.getProperty(name);
            String serverName = null;
            String classpath = null;
            String host = null;
            String args = null;
            int index = 0;
            int previous_index = 0;
            boolean end = false;
            try {
                while (!end) {
                    String word;
                    String word2;
                    index = stRef.indexOf(44, previous_index);
                    if (index == -1) {
                        end = true;
                        index = stRef.length();
                    }
                    if ((word2 = (word = this.deleteSpace(stRef.substring(previous_index, index))).toUpperCase()).startsWith("SERVERNAME")) {
                        serverName = this.extractWordWithSep(word, '(');
                    } else if (word2.startsWith("HOST")) {
                        host = this.extractWordWithSep(word, '(');
                    } else if (word2.startsWith("CLASSPATH")) {
                        classpath = this.extractWordWithSep(word, '(');
                    } else if (word2.startsWith("ARGUMENTS")) {
                        args = this.extractWordWithSep(word, '(');
                    } else if (word2.startsWith("POLICY")) {
                        String policyWord = this.extractWordWithSep(word, '(').toUpperCase();
                        policy = policyWord.equals("NOT_SHARED") ? launchPolicy.NOT_SHARED : (policyWord.equals("ALL_OBJECTS_SHARED") ? launchPolicy.ALL_OBJECTS_SHARED : (policyWord.equals("SAME_OBJECT_SHARED") ? launchPolicy.SAME_OBJECT_SHARED : launchPolicy.NOT_SHARED));
                    }
                    previous_index = index + 1;
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                // empty catch block
            }
            try {
                if (policy == null) {
                    policy = launchPolicy.NOT_SHARED;
                }
                this.addObject(name, host, serverName, classpath, args, policy);
            }
            catch (ObjectAlreadyRegistered ex_reg) {
                // empty catch block
            }
            ++i;
        }
    }

    private String extractWordWithSep(String src, char sep) {
        int begin_idx = 0;
        int end_idx = 0;
        String word = null;
        try {
            begin_idx = src.indexOf(sep, 0);
            end_idx = src.indexOf(sep, begin_idx + 1);
            if (end_idx == -1) {
                end_idx = src.length();
            }
            word = new String(src.substring(begin_idx + 1, end_idx - 1));
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return this.deleteSpace(word);
    }

    private int launchServer(LoaderEntry entry) {
        LoaderActiveEntry activeEntry = new LoaderActiveEntry();
        activeEntry.entry = entry;
        ServerSocket connection = null;
        short portNumber = 0;
        try {
            connection = new ServerSocket(0);
            portNumber = (short)connection.getLocalPort();
            connection.close();
            String fullClasspath = System.getProperty("java.class.path");
            if (entry.classpath != null) {
                fullClasspath = fullClasspath + System.getProperty("path.separator") + entry.classpath;
            }
            String command = "java -Dorg.omg.CORBA.ORBClass=JavaORB.CORBA.ORBSingleton -Dorg.omg.CORBA.ORBSingletonClass=JavaORB.CORBA.ORBSingleton";
            command = command + " -classpath " + fullClasspath + " " + entry.serverName + " -OAPort=" + portNumber + " -loader";
            if (Trace.level != 0) {
                Trace.Step(" Command = " + command);
            }
            if (entry.args != null) {
                command = command + " " + entry.args;
            }
            Runtime runtime = Runtime.getRuntime();
            activeEntry.process = runtime.exec(command);
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        IORBag ior = new IORBag();
        IORManager manager = new IORManager();
        ior.version = new Version();
        ior.version.major = 1;
        ior.version.minor = 0;
        try {
            ior.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex_unk) {
            ex_unk.printStackTrace();
        }
        ior.port = portNumber;
        ior.id = "IDL:JavaORB/ORBObjectLoader:1.0";
        String keyAsString = "ORBObjectLoader";
        ior.key = new byte[keyAsString.length()];
        int i = 0;
        while (i < keyAsString.length()) {
            ior.key[i] = (byte)keyAsString.charAt(i);
            ++i;
        }
        Object obj = manager.bag_to_ior(ior);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex_int) {
            // empty catch block
        }
        try {
            entry.orbLoader = ORBObjectLoaderHelper.narrow(obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        activeEntry.launchCount = 0;
        activeEntry.id = this.activeCount++;
        this.active.addElement(activeEntry);
        return activeEntry.id;
    }

    public String[] getAllObjects() {
        Vector<String> list = new Vector<String>();
        int i = 0;
        while (i < this.table.size()) {
            LoaderEntry entry = (LoaderEntry)this.table.elementAt(i);
            list.addElement(entry.name);
            ++i;
        }
        String[] result = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            result[i2] = (String)list.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public void addActiveObject(String name, Object reference, Object loaderReference) throws ObjectAlreadyRegistered {
        if (this.findEntryIndexByName(name) != -1) {
            throw new ObjectAlreadyRegistered();
        }
        LoaderEntry entry = new LoaderEntry();
        entry.name = name;
        entry.serverName = null;
        entry.classpath = null;
        entry.args = null;
        entry.orbLoader = ORBObjectLoaderHelper.narrow(loaderReference);
        this.table.addElement(entry);
    }

    public Object remoteGetObject(String name, ObjectIdHolder id, LoaderEntry entry) throws ObjectNotFound {
        IORManager manager = new IORManager();
        IORBag ior = manager.extract(this);
        ior.host = entry.serverHost;
        Object remoteLoader = manager.bag_to_ior(ior);
        loader rloader = loaderHelper.narrow(remoteLoader);
        Object obj = rloader.getObject(name, id);
        LoaderActiveEntry activeEntry = new LoaderActiveEntry();
        activeEntry.launchCount = 0;
        activeEntry.id = id.value;
        activeEntry.entry = entry;
        this.active.addElement(activeEntry);
        return obj;
    }

    public LoaderActiveEntry findActiveEntryById(int id) {
        int i = 0;
        while (i < this.active.size()) {
            LoaderActiveEntry entry = (LoaderActiveEntry)this.active.elementAt(i);
            if (entry.id == id) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public int findActiveEntryIndexByName(String name) {
        int i = 0;
        while (i < this.active.size()) {
            LoaderActiveEntry act = (LoaderActiveEntry)this.active.elementAt(i);
            if (act.entry.name.compareTo(name) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ObjectData[] getAllActiveObjects() {
        Vector<ObjectData> list = new Vector<ObjectData>();
        int i = 0;
        while (i < this.active.size()) {
            LoaderActiveEntry entry = (LoaderActiveEntry)this.active.elementAt(i);
            ObjectData data = new ObjectData();
            data.id = entry.id;
            data.name = entry.entry.name;
            data.server = entry.entry.name;
            data.host = entry.entry.serverHost;
            data.classpath = entry.entry.classpath;
            data.arguments = entry.entry.args;
            data.policy = entry.entry.policy;
            list.addElement(data);
            ++i;
        }
        ObjectData[] result = new ObjectData[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            result[i2] = (ObjectData)list.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public Object getObject(String name, ObjectIdHolder id) throws ObjectNotFound {
        boolean live;
        LoaderActiveEntry activeEntry = null;
        int index = this.findEntryIndexByName(name);
        if (index == -1) {
            throw new ObjectNotFound();
        }
        LoaderEntry entry = (LoaderEntry)this.table.elementAt(index);
        boolean external = false;
        if (entry.serverHost != null && !entry.serverHost.equals("")) {
            external = true;
        }
        if (external) {
            return this.remoteGetObject(name, id, entry);
        }
        if (entry.policy == launchPolicy.NOT_SHARED) {
            id.value = this.launchServer(entry);
            activeEntry = this.findActiveEntryById(id.value);
            try {
                activeEntry.ref = activeEntry.entry.orbLoader.getObject(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return activeEntry.ref;
        }
        int idx = this.findActiveEntryIndexByName(name);
        if (idx == -1) {
            if (activeEntry.entry.policy == launchPolicy.ALL_OBJECTS_SHARED) {
                index = this.findEntryIndexByServerName(entry.serverName);
                if (index == -1) {
                    id.value = this.launchServer(entry);
                    activeEntry = this.findActiveEntryById(id.value);
                } else {
                    activeEntry = new LoaderActiveEntry();
                    activeEntry.entry = entry;
                    activeEntry.id = this.activeCount++;
                    activeEntry.process = ((LoaderActiveEntry)this.active.elementAt((int)index)).process;
                    id.value = activeEntry.id;
                }
                try {
                    activeEntry.ref = activeEntry.entry.orbLoader.getObject(name);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
                return activeEntry.ref;
            }
            id.value = this.launchServer(entry);
            activeEntry = this.findActiveEntryById(id.value);
            try {
                activeEntry.ref = activeEntry.entry.orbLoader.getObject(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return activeEntry.ref;
        }
        activeEntry = (LoaderActiveEntry)this.active.elementAt(idx);
        ++activeEntry.launchCount;
        try {
            live = activeEntry.entry.orbLoader.ping(name);
        }
        catch (COMM_FAILURE ex_comm) {
            this.active.removeElementAt(idx);
            return this.getObject(name, id);
        }
        if (live) {
            return activeEntry.ref;
        }
        return null;
    }
}

