/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.util;

import JavaORB.CORBA.ORBSingleton;
import JavaORB.protocol.Listener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Utility {
    public static String getSystemProperty(String property) {
        return System.getProperty(property);
    }

    public static String getORBProperty(String property) {
        Properties props = new Properties();
        try {
            String javaHome = System.getProperty("java.home");
            File propFile = new File(javaHome + File.separator + "lib" + File.separator + "orb.properties");
            if (!propFile.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(propFile);
            props.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            return null;
        }
        return props.getProperty(property);
    }

    public static Class loadClass(String classNameKey, String defaultClass) {
        String className = Utility.getSystemProperty(classNameKey);
        if (className == null) {
            className = Utility.getORBProperty(classNameKey);
        }
        if (className == null) {
            className = defaultClass;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getServerPort() {
        if (ORBSingleton.oa == null) {
            return -1;
        }
        Listener listener = ORBSingleton.oa.get_listener();
        return listener._get_port();
    }

    public static String getServerHostName() {
        if (ORBSingleton.oa == null) {
            return null;
        }
        Listener listener = ORBSingleton.oa.get_listener();
        return listener._get_host();
    }
}

