/*
 * Decompiled with CFR 0.152.
 */
package JavaORB.util;

import JavaORB.ObjectDataHolder;
import JavaORB.ObjectNotFound;
import JavaORB.launchPolicy;
import JavaORB.loader;
import JavaORB.loaderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class objectData {
    public static void main(String[] args) {
        System.out.println("JavaORB Object Loader / objectData Utility");
        System.out.println("version 1.1");
        System.out.println("Jerome DANIEL");
        System.out.println("");
        ORB orb = ORB.init(args, null);
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("ObjectLoader");
        }
        catch (InvalidName ex) {
            System.out.println("The ObjectLoader reference is unavailable");
            System.exit(-1);
        }
        if (obj == null) {
            System.out.println("Bad loader reference");
            System.exit(-1);
        }
        loader load = loaderHelper.narrow(obj);
        InputStreamReader inread = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(inread);
        String name = null;
        try {
            System.out.print("Object name : ");
            name = reader.readLine();
        }
        catch (IOException ioex) {
            System.out.println("Internal error...");
            System.exit(-1);
        }
        ObjectDataHolder data = new ObjectDataHolder();
        try {
            load.getObjectData(name, data);
        }
        catch (ObjectNotFound ex_ntf) {
            System.out.println("The object " + name + " is unknowned");
            System.exit(-1);
        }
        catch (COMM_FAILURE ex) {
            System.out.println("The loader is not running...");
            System.exit(-1);
        }
        System.out.println("Object " + name + " data :");
        System.out.println("\tServer host           : " + data.value.host);
        System.out.println("\tServer name           : " + data.value.server);
        System.out.println("\tAdditionnal classpath : " + data.value.classpath);
        System.out.println("\tArguments             : " + data.value.arguments);
        if (data.value.policy == launchPolicy.NOT_SHARED) {
            System.out.println("\tLaunch policy         : not shared");
        } else if (data.value.policy == launchPolicy.ALL_OBJECTS_SHARED) {
            System.out.println("\tLaunch policy         : all objects shared");
        } else if (data.value.policy == launchPolicy.SAME_OBJECT_SHARED) {
            System.out.println("\tLaunch policy         : same object shared");
        }
    }
}

