/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLflex;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectix.AspectixException;
import org.aspectix.IDLflex.Debug;
import org.aspectix.IDLflex.IDLObjectVector;
import org.aspectix.IDLflex.IDLOutputList;
import org.aspectix.IDLflex.IDLStringWriter;
import org.aspectix.IDLflex.IDLWriter;
import org.aspectix.IDLflex.IDLflexEntityResolver;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.IRObj.IDLIterationPseudo;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.aspectix.IDLflex.LocateFile;
import org.aspectix.IDLflex.Plugin;
import org.aspectix.IDLflex.Utility;
import org.aspectix.xmlparser.IBMXMLparser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDLDefCompiler {
    private Hashtable pluginClasses;
    private Vector pluginVector;
    private IDLOutputList writerlist;
    String writepath;
    Document mainDoc;
    Element docElement;
    Utility util;
    Class writerclass;
    private IDLObjectVector generatePath;
    private IDLObject currentIDL;
    Vector x = new Vector();
    Hashtable config;

    public IDLIterationPseudo getIterationPseudo() {
        int n = this.generatePath.count_objects();
        int n2 = n - 1;
        while (n2 >= 0) {
            IDLObject iDLObject = this.generatePath.objectAt(n2);
            if (iDLObject.is_a("IDLIterationPseudo")) {
                return (IDLIterationPseudo)iDLObject;
            }
            --n2;
        }
        return null;
    }

    public IDLOutputList generateCode(String string, IDLObject iDLObject, int n) throws IDLflexException {
        this.writerlist = new IDLOutputList(this.writerclass, this.writepath, n);
        if (string == null) {
            string = this.getRootCompiler();
        }
        this.push_currentIDL(iDLObject);
        this.generateCode(string, (IDLWriter)null);
        return this.writerlist;
    }

    public void generateCode(String string, IDLObject iDLObject, IDLWriter iDLWriter) throws IDLflexException {
        this.writerlist = null;
        this.push_currentIDL(iDLObject);
        this.generateCode(string, iDLWriter);
    }

    private Document parseFile(String string) throws AspectixException {
        IBMXMLparser iBMXMLparser = new IBMXMLparser(new IDLflexEntityResolver());
        this.x.addElement(iBMXMLparser);
        String string2 = LocateFile.getXMLSearchPath();
        String string3 = LocateFile.findFile(string, string2);
        if (string3 == null) {
            System.err.println("file not found: " + string);
            System.exit(1);
        }
        return iBMXMLparser.parse(string3);
    }

    private void insertIncludedFiles(Document document) throws AspectixException {
        Object object;
        Object object2;
        Object object3;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object3 = nodeList.item(n2);
            if (object3.getNodeName().equals("IMPORT")) {
                object2 = (Element)object3;
                object = object2.getAttribute("NAME");
                vector.add((String)object);
                vector2.add(object3);
            }
            ++n2;
        }
        object3 = vector2.elements();
        while (object3.hasMoreElements()) {
            object2 = (Node)object3.nextElement();
            element.removeChild((Node)object2);
        }
        object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = this.parseFile((String)object2);
            this.insertIncludedFiles((Document)object);
            Element element2 = object.getDocumentElement();
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            int n4 = 0;
            while (n4 < n3) {
                Node node = document.importNode(nodeList2.item(n4), true);
                element.appendChild(node);
                ++n4;
            }
        }
    }

    public IDLDefCompiler(Hashtable hashtable) throws IDLflexException {
        Element element;
        this.generatePath = new IDLObjectVector();
        this.pluginVector = new Vector();
        this.pluginClasses = new Hashtable();
        this.config = hashtable;
        this.writepath = (String)this.config.get("DEF:WRITEPATH");
        if (this.writepath == null) {
            this.writepath = ".";
        }
        try {
            this.mainDoc = this.parseFile((String)this.config.get("IDLflexMapping"));
            this.insertIncludedFiles(this.mainDoc);
        }
        catch (AspectixException aspectixException) {
            throw new IDLflexException("Error while parsing mapping: " + aspectixException.getMessage());
        }
        this.docElement = this.mainDoc.getDocumentElement();
        String string = "";
        try {
            element = this.docElement;
            if (element == null) {
                throw new IDLflexException("*** empty XML document\n");
            }
            string = element.getAttribute("UTILITY");
            this.util = (Utility)Class.forName(string).newInstance();
            this.util.init(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IDLflexException("*** Cannot create instance ofspecified UTILITY class '" + string + "'\n" + exception.toString());
        }
        try {
            element = this.docElement;
            String string2 = element.getAttribute("WRITER");
            this.writerclass = Class.forName(string2);
        }
        catch (Exception exception) {
            throw new IDLflexException("*** Cannot load WRITER class:\n" + exception.toString());
        }
    }

    public void registerPlugin(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            this.pluginClasses.put(string.toLowerCase(), clazz);
        }
        catch (Exception exception) {
            System.err.println("registerPlugin: class " + string2 + " not found.");
        }
    }

    public String getRootCompiler() {
        Element element = this.docElement;
        if (element == null) {
            return null;
        }
        return element.getAttribute("ROOT");
    }

    private IDLObject remove_alias(IDLObject iDLObject) {
        while (iDLObject.is_a("AliasObj")) {
            try {
                iDLObject = iDLObject.getContent("RESOLVE");
            }
            catch (IDLflexException iDLflexException) {
                // empty catch block
            }
        }
        return iDLObject;
    }

    private Vector splitIfCondition(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        while ((n = string.indexOf("|")) >= 0) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + 1);
        }
        vector.addElement(string);
        return vector;
    }

    private boolean checkType(IDLObject iDLObject, String string) {
        Vector vector = this.splitIfCondition(string);
        int n = 0;
        while (n < vector.size()) {
            boolean bl;
            String string2 = (String)vector.elementAt(n);
            if (string2.startsWith("!")) {
                bl = true;
                string2 = string2.substring(1);
            } else {
                bl = false;
            }
            if (string2.toLowerCase().startsWith("resolve.")) {
                iDLObject = this.remove_alias(iDLObject);
                string2 = string2.substring(8);
            }
            boolean bl2 = string2.equalsIgnoreCase("TypedefObj") ? iDLObject.is_a("UnionObj") || iDLObject.is_a("StructObj") || iDLObject.is_a("AliasObj") || iDLObject.is_a("EnumObj") : iDLObject.is_a(string2);
            if (bl) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkAttr(IDLObject iDLObject, String string) throws IDLflexException {
        Vector vector = this.splitIfCondition(string);
        int n = 0;
        while (n < vector.size()) {
            boolean bl;
            String string2 = (String)vector.elementAt(n);
            if (string2.startsWith("!")) {
                bl = true;
                string2 = string2.substring(1);
            } else {
                bl = false;
            }
            if (string2.toLowerCase().startsWith("resolve.")) {
                iDLObject = this.remove_alias(iDLObject);
                string2 = string2.substring(8);
            }
            boolean bl2 = this.util.getAttribute(string2, iDLObject);
            if (bl) {
                boolean bl3 = bl2 = !bl2;
            }
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int checkIf(Element element) throws IDLflexException {
        String string = element.getAttribute("TYPE");
        if (!string.equals("")) {
            if (this.checkType(this.currentIDL, string)) {
                return 1;
            }
            return 0;
        }
        String string2 = element.getAttribute("COND");
        if (!string2.equals("")) {
            if (this.checkAttr(this.currentIDL, string2)) {
                return 1;
            }
            return 0;
        }
        throw new IDLflexException("condition with neither TYPE nor COND");
    }

    Element getComponentElement(String string) throws IDLflexException {
        Element element = this.docElement;
        if (element != null) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals("COMPONENT") && (element = (Element)node).getAttribute("NAME").equals(string)) {
                    return element;
                }
                node = node.getNextSibling();
            }
        }
        throw new IDLflexException("Component " + string + " does not exist!");
    }

    Element getBasicElement(String string, String string2) {
        Element element = this.docElement;
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals(string)) {
                element = (Element)node;
                if (string2 == null || string2.equals("")) {
                    return element;
                }
                if (element.getAttribute("NAME").equals(string2)) {
                    return element;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public final String[] getTable(String string) {
        Element element = this.getBasicElement("TABLE", string);
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        String string2 = element.getAttribute("SEPARATOR");
        String string3 = node.getNodeValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public final Hashtable getMapTable(String string) {
        Element element = this.getBasicElement("MAPTABLE", string);
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (node != null) {
            if (node.getNodeName().equals("MAP")) {
                Element element2 = (Element)node;
                String string2 = element2.getAttribute("TAG");
                String string3 = element2.getAttribute("MAP");
                hashtable.put(string2, string3);
            }
            node = node.getNextSibling();
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileTagHandler(Node node, String string) throws IDLflexException {
        IDLWriter iDLWriter;
        String string2 = this.util.getName(string, this.currentIDL);
        Debug.print(3, 1, "Creating " + string2);
        try {
            iDLWriter = this.writerlist.open(string2, this.currentIDL.getName("id"), "");
        }
        catch (IDLflexException iDLflexException) {
            throw new IDLflexException("*** Cannot create file writer for file '" + string2 + "'\n" + iDLflexException.toString());
        }
        IDLObject iDLObject = this.util.getReferenceObject();
        this.util.setReferenceObject(this.currentIDL);
        try {
            this.generateCode(node, iDLWriter);
            try {
                iDLWriter.close();
            }
            catch (Exception exception) {
                throw new IDLflexException("*** Cannot close file writerfor file '" + string2 + "'\n" + exception.toString());
            }
            Object var8_8 = null;
            this.util.setReferenceObject(iDLObject);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.util.setReferenceObject(iDLObject);
            throw throwable;
        }
    }

    public Plugin getPlugin(String string) throws IDLflexException {
        int n = this.pluginVector.size() - 1;
        while (n >= 0) {
            Plugin plugin = (Plugin)this.pluginVector.elementAt(n);
            if (plugin.name.equalsIgnoreCase(string)) {
                return plugin;
            }
            --n;
        }
        throw new IDLflexException("plugin object with name " + string + " does not exist!");
    }

    private void pluginTagHandler(Node node, IDLObject iDLObject) throws IDLflexException {
        String string = ((Element)node).getAttribute("ID").toLowerCase();
        String string2 = ((Element)node).getAttribute("OP").toLowerCase();
        if (string2.equalsIgnoreCase("NEW")) {
            string2 = "NEW:Counter";
        }
        if (string2.toUpperCase().startsWith("NEW:")) {
            Plugin plugin;
            String string3 = string2.substring(4).toLowerCase();
            Class clazz = (Class)this.pluginClasses.get(string3);
            try {
                plugin = (Plugin)clazz.newInstance();
                plugin.name = string;
            }
            catch (Exception exception) {
                throw new IDLflexException("creating plugin object " + string + " (" + string2 + ") failed.");
            }
            this.pluginVector.addElement(plugin);
        } else {
            Plugin plugin = this.getPlugin(string);
            if (string2 != null) {
                if (string2.equalsIgnoreCase("DEL")) {
                    this.pluginVector.removeElement(plugin);
                } else {
                    plugin.execCmd(string2);
                }
            }
        }
    }

    private void generateCode(String string, IDLWriter iDLWriter) throws IDLflexException {
        Debug.print(3, 1, "generateCode called for " + string);
        Element element = this.getComponentElement(string);
        Node node = element.getFirstChild();
        this.generateCode(node, iDLWriter);
    }

    private static IDLObject resolveObject(IDLObject iDLObject, String string) throws IDLflexException {
        while (true) {
            int n;
            IDLObject iDLObject2;
            if ((iDLObject2 = (n = string.indexOf(".")) >= 0 ? iDLObject.getContent(string.substring(0, n)) : iDLObject.getContent(string)) == null) {
                throw new IDLflexException("resolveObject: reached null Object while resolving prefix " + string + " on " + iDLObject.getName("id") + "/" + iDLObject);
            }
            iDLObject = iDLObject2;
            if (n < 0) break;
            string = string.substring(n + 1);
        }
        return iDLObject;
    }

    private IDLObject resolveOBJattr(Element element, IDLObject iDLObject) throws IDLflexException {
        String string = element.getAttribute("OBJ");
        if (string == null || string.equals("")) {
            return iDLObject;
        }
        if (string.equals("UPPER")) {
            return this.generatePath.getUpperObject(1);
        }
        return IDLDefCompiler.resolveObject(iDLObject, string);
    }

    private boolean checkIncludeExclude(IDLObject iDLObject) throws IDLflexException {
        String string = iDLObject.getName("fullname");
        if (string != null && !string.equals("")) {
            Vector vector;
            if (!string.startsWith("::")) {
                string = "::" + string;
            }
            if ((vector = (Vector)this.config.get("IDLflexIncludeID")) == null) {
                vector = new Vector();
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.startsWith((String)vector.elementAt(n2)) || ((String)vector.elementAt(n2)).startsWith(string) && iDLObject.is_a("ModuleObj")) break;
                ++n2;
            }
            if (n > 0 && n2 >= n) {
                Debug.print(3, 1, "not including " + string);
                return false;
            }
            Vector vector2 = (Vector)this.config.get("IDLflexExcludeID");
            n = vector2.size();
            n2 = 0;
            while (n2 < n) {
                if (string.startsWith((String)vector2.elementAt(n2))) {
                    Debug.print(3, 1, "rejecting " + string);
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return true;
    }

    private IDLObject[] reverselist(IDLObject[] iDLObjectArray) {
        int n = iDLObjectArray.length;
        IDLObject[] iDLObjectArray2 = new IDLObject[n];
        int n2 = 0;
        while (n2 < n) {
            iDLObjectArray2[n2] = iDLObjectArray[n - n2 - 1];
            ++n2;
        }
        return iDLObjectArray2;
    }

    private IDLObject[] getIterateContentList(IDLObject iDLObject, String string) throws IDLflexException {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (!iDLObject.is_a("ContainerObj", false) && !iDLObject.is_a("ModuleObj") || !string.equals("MEMBER")) {
            IDLObject[] iDLObjectArray = iDLObject.getContentList(string);
            if (string2.equalsIgnoreCase("reverse")) {
                iDLObjectArray = this.reverselist(iDLObjectArray);
            }
            return iDLObjectArray;
        }
        IDLObject[] iDLObjectArray = iDLObject.getContentList(string);
        Vector<IDLObject> vector = new Vector<IDLObject>(iDLObjectArray.length);
        int n2 = 0;
        while (n2 < iDLObjectArray.length) {
            if (this.checkIncludeExclude(iDLObjectArray[n2])) {
                vector.addElement(iDLObjectArray[n2]);
            }
            ++n2;
        }
        iDLObjectArray = new IDLObject[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            iDLObjectArray[n3] = (IDLObject)vector.elementAt(n3);
            ++n3;
        }
        if (string2.equalsIgnoreCase("reverse")) {
            iDLObjectArray = this.reverselist(iDLObjectArray);
        }
        return iDLObjectArray;
    }

    private IDLObject resolveOBJ(Element element) throws IDLflexException {
        return this.resolveOBJattr(element, this.currentIDL);
    }

    private void push_currentIDL(IDLObject iDLObject) {
        this.generatePath.addObject(iDLObject);
        this.currentIDL = iDLObject;
    }

    private void pull_currentIDL() {
        this.generatePath.removeLastObject();
        this.currentIDL = this.generatePath.getLastObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFILE(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = element.getAttribute("SPEC");
            this.fileTagHandler(element.getFirstChild(), string);
            Object var5_4 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateIF(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            if (this.checkIf(element) == 1) {
                this.generateCode(element.getFirstChild(), iDLWriter);
            }
            Object var4_3 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSWITCH(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            Node node = element.getFirstChild();
            while (node != null) {
                String string = node.getNodeName();
                if (string.equals("CASE")) {
                    Object var8_5;
                    this.generatePath.addNode(node);
                    this.push_currentIDL(this.resolveOBJ((Element)node));
                    try {
                        if (this.checkIf((Element)node) == 1) {
                            Node node2;
                            try {
                                node2 = ((Element)node).getFirstChild();
                            }
                            catch (Exception exception) {
                                System.err.println(node);
                                exception.printStackTrace();
                                throw new IDLflexException("getFirstChild");
                            }
                            this.generateCode(node2, iDLWriter);
                            var8_5 = null;
                            this.pull_currentIDL();
                            this.generatePath.removeLastNode();
                            break;
                        }
                        var8_5 = null;
                        this.pull_currentIDL();
                        this.generatePath.removeLastNode();
                    }
                    catch (Throwable throwable) {
                        var8_5 = null;
                        this.pull_currentIDL();
                        this.generatePath.removeLastNode();
                        throw throwable;
                    }
                }
                if (string.equals("DEFAULT")) {
                    this.generatePath.addNode(node);
                    this.push_currentIDL(this.resolveOBJ((Element)node));
                    try {
                        Node node3 = node.getFirstChild();
                        this.generateCode(node3, iDLWriter);
                        Object var10_10 = null;
                        this.pull_currentIDL();
                        this.generatePath.removeLastNode();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        this.pull_currentIDL();
                        this.generatePath.removeLastNode();
                        throw throwable;
                    }
                }
                node = node.getNextSibling();
            }
            Object var12_13 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCALL(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = element.getAttribute("NAME");
            this.generateCode(string, iDLWriter);
            Object var5_4 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateITERATE(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = element.getAttribute("NAME");
            if (string.equals("")) {
                throw new IDLflexException("ITERATE: missing NAME");
            }
            Node node = element.getFirstChild();
            IDLObject[] iDLObjectArray = this.getIterateContentList(this.currentIDL, string);
            if (iDLObjectArray == null) {
                throw new IDLflexException("ITERATE: no such spec " + string + " in Object " + this.currentIDL);
            }
            IDLIterationPseudo iDLIterationPseudo = new IDLIterationPseudo();
            iDLIterationPseudo.count = iDLObjectArray.length;
            this.push_currentIDL(iDLIterationPseudo);
            try {
                int n = 0;
                while (n < iDLObjectArray.length) {
                    Object var9_8;
                    iDLIterationPseudo.index = n;
                    this.push_currentIDL(iDLObjectArray[n]);
                    try {
                        this.generateCode(node, iDLWriter);
                        var9_8 = null;
                        this.pull_currentIDL();
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        this.pull_currentIDL();
                        throw throwable;
                    }
                    ++n;
                }
                Object var11_10 = null;
                this.pull_currentIDL();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.pull_currentIDL();
                throw throwable;
            }
            Object var13_13 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    private void generateERROR(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = "";
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals("#text")) {
                    string = string + node.getNodeValue();
                }
                node = node.getNextSibling();
            }
            if (string.equals("")) {
                string = "ERROR-Tag in xml-File without Text";
            }
            System.err.println(this.currentIDL);
            System.err.println(this.currentIDL.getClass());
            throw new IDLflexException(string);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateGET(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = element.getAttribute("T");
            String string2 = this.util.getName(string, this.currentIDL);
            try {
                if (iDLWriter != null) {
                    iDLWriter.write(string2);
                }
            }
            catch (Exception exception) {
                System.err.println("GET(" + string + "): " + exception);
                exception.printStackTrace();
            }
            Object var7_6 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSBOX(Element element, IDLWriter iDLWriter) throws IDLflexException {
        this.push_currentIDL(this.resolveOBJ(element));
        try {
            String string = element.getAttribute("NAME");
            IDLStringWriter iDLStringWriter = new IDLStringWriter();
            this.generateCode(element.getFirstChild(), (IDLWriter)iDLStringWriter);
            try {
                iDLStringWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.util.savebox.put(string, iDLStringWriter.toString());
            Object var7_6 = null;
            this.pull_currentIDL();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.pull_currentIDL();
            throw throwable;
        }
    }

    public void generateCode(Node node, IDLWriter iDLWriter) throws IDLflexException {
        Debug.print(3, 1, "generateCode called:");
        try {
            try {
                while (node != null) {
                    String string;
                    Debug.print(3, 1, "looping: \ncurrent Node name is " + node.getNodeName() + "\nnode value is " + node.getNodeValue() + "\nIDLObject is " + this.currentIDL + "\n");
                    this.generatePath.addNode(node);
                    String string2 = node.getNodeName();
                    if (string2.equals("FILE")) {
                        this.generateFILE((Element)node, iDLWriter);
                    } else if (string2.equals("IF")) {
                        this.generateIF((Element)node, iDLWriter);
                    } else if (string2.equals("SWITCH")) {
                        this.generateSWITCH((Element)node, iDLWriter);
                    } else if (string2.equals("CALL")) {
                        this.generateCALL((Element)node, iDLWriter);
                    } else if (string2.equals("ITERATE")) {
                        this.generateITERATE((Element)node, iDLWriter);
                    } else if (string2.equals("ERROR")) {
                        this.generateERROR((Element)node, iDLWriter);
                    } else if (string2.equals("#text")) {
                        string = node.getNodeValue();
                        if (!string.equals("")) {
                            try {
                                if (iDLWriter != null) {
                                    iDLWriter.write(string);
                                }
                            }
                            catch (Exception exception) {
                                System.err.println("#text: " + exception.toString());
                            }
                        }
                    } else if (string2.equals("GET")) {
                        this.generateGET((Element)node, iDLWriter);
                    } else if (string2.equals("P")) {
                        try {
                            if (iDLWriter != null) {
                                iDLWriter.write("\r");
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("P: " + exception.toString());
                        }
                    } else if (string2.equals("SBOX")) {
                        this.generateSBOX((Element)node, iDLWriter);
                    } else if (string2.equals("SBOXDEL")) {
                        string = ((Element)node).getAttribute("NAME");
                        this.util.savebox.del(string);
                    } else if (string2.equals("PLUGIN")) {
                        this.pluginTagHandler(node, this.currentIDL);
                    }
                    this.generatePath.removeLastNode();
                    node = node.getNextSibling();
                }
            }
            catch (IDLflexException iDLflexException) {
                if (iDLflexException.hasContext()) {
                    throw iDLflexException;
                }
                throw new IDLflexException(this.generatePath, iDLflexException.getMessage());
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
    }
}

