/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLflex.mapping;

import java.io.File;
import org.aspectix.IDLflex.IDLDefCompiler;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.IRObj.AttributeObj;
import org.aspectix.IDLflex.IRObj.ConstantObj;
import org.aspectix.IDLflex.IRObj.EnumObj;
import org.aspectix.IDLflex.IRObj.ExceptionObj;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.aspectix.IDLflex.IRObj.InterfaceObj;
import org.aspectix.IDLflex.IRObj.OperationObj;
import org.aspectix.IDLflex.IRObj.PrimitiveObj;
import org.aspectix.IDLflex.IRObj.StringObj;
import org.aspectix.IDLflex.IRObj.StructObj;
import org.aspectix.IDLflex.IRObj.UnionObj;
import org.aspectix.IDLflex.NameCollisionResolver;
import org.aspectix.IDLflex.Utility;

public class JavaUtility
extends Utility {
    NameCollisionResolver suffixCollisionResolver;
    NameCollisionResolver keywordCollisionResolver;
    NameCollisionResolver fullCollisionResolver;
    static String currentPackagePrefix = "";

    public void setReferenceObject(IDLObject iDLObject) {
        super.setReferenceObject(iDLObject);
        try {
            currentPackagePrefix = iDLObject != null ? this.getPackageName(iDLObject) : "";
        }
        catch (Exception exception) {
            System.err.println(" JavaUtility: setReferenceObject failed: ");
            exception.printStackTrace();
            currentPackagePrefix = "";
        }
    }

    public void init(IDLDefCompiler iDLDefCompiler) {
        super.init(iDLDefCompiler);
        this.fullCollisionResolver = new NameCollisionResolver(iDLDefCompiler.getTable("ReservedSuffix"), iDLDefCompiler.getTable("ReservedWords"));
        this.suffixCollisionResolver = new NameCollisionResolver(iDLDefCompiler.getTable("ReservedSuffix"), null);
        this.keywordCollisionResolver = new NameCollisionResolver(null, iDLDefCompiler.getTable("ReservedWords"));
    }

    protected String constructName(IDLObject iDLObject, String string) {
        return this.constructName(iDLObject, string, "");
    }

    /*
     * Unable to fully structure code
     */
    protected String constructName(IDLObject var1_1, String var2_2, String var3_3) {
        try {
            if (var1_1 instanceof PrimitiveObj && var1_1.getName("name").equals("tk_value") && var2_2.equals("")) {
                return "java.io.Serializable";
            }
            var4_4 = Utility.get_basic_mapping(var1_1);
            if (var2_2.equals("")) {
                return var4_4;
            }
            if (var4_4.startsWith("org.omg")) {
                return var4_4 + var2_2;
            }
            var5_8 = var4_4.lastIndexOf(".");
            if (var5_8 >= 0) {
                var4_4 = var4_4.substring(var5_8 + 1);
            }
            var4_4 = var4_4.substring(0, 1).toUpperCase() + var4_4.substring(1);
            return "org.omg.CORBA." + var4_4 + "Holder";
        }
        catch (Exception var4_5) {
            if (var1_1.is_a("NativeObj")) {
                try {
                    System.err.println("Access to native type " + var1_1.getName("fullname"));
                }
                catch (IDLflexException var4_6) {
                    // empty catch block
                }
                System.err.println("Mapping to java.lang.Object!");
                if (var2_2.equals("")) {
                    return "java.lang.Object";
                }
                System.err.println("Access to suffix " + var2_2 + " not adequately supported.");
            }
            if ((var4_7 = this.resolve(var1_1)).length() == 0) {
                System.err.println("constructName: empty Path! obj=" + var1_1);
                return "";
            }
            var6_10 = "";
            var5_9 = 0;
            ** while (var5_9 < var4_7.length() - 1)
        }
lbl-1000:
        // 1 sources

        {
            var7_11 = var4_7.obj(var5_9);
            if (var7_11 instanceof InterfaceObj) {
                if (!(var7_11 instanceof AttributeObj || var7_11 instanceof OperationObj || var7_11 instanceof ConstantObj)) {
                    var6_10 = var6_10 + this.fullCollisionResolver.resolve(var4_7.name(var5_9)) + "Package.";
                }
            } else {
                var6_10 = var7_11 instanceof StructObj != false || var7_11 instanceof ExceptionObj != false || var7_11 instanceof UnionObj != false ? var6_10 + this.fullCollisionResolver.resolve(var4_7.name(var5_9)) + "Package." : var6_10 + this.fullCollisionResolver.resolve(var4_7.name(var5_9)) + ".";
            }
            ++var5_9;
            continue;
        }
lbl39:
        // 1 sources

        var6_10 = var4_7.obj(var5_9) instanceof AttributeObj != false || var4_7.obj(var5_9) instanceof OperationObj != false ? var6_10 + var3_3 + this.keywordCollisionResolver.resolve(var4_7.name(var5_9)) + var2_2 : var6_10 + var3_3 + this.fullCollisionResolver.resolve(var4_7.name(var5_9)) + var2_2;
        return var6_10;
    }

    protected String getJavaFullName(IDLObject iDLObject, String string) throws IDLflexException {
        if (string.equals("")) {
            return this.constructName(iDLObject, "");
        }
        if (string.equals("holder")) {
            IDLObject iDLObject2 = iDLObject;
            while (iDLObject.is_a("AliasObj")) {
                IDLObject iDLObject3 = iDLObject.getContent("RESOLVE");
                if (iDLObject3.is_a("SequenceObj") || iDLObject3.is_a("ArrayObj")) {
                    iDLObject = iDLObject2;
                    break;
                }
                iDLObject = iDLObject3;
            }
            return this.constructName(iDLObject, "Holder");
        }
        if (string.equals("helper")) {
            return this.constructName(iDLObject, "Helper");
        }
        if (string.equals("operationif")) {
            boolean bl = iDLObject.getAttribute("abstractif");
            return this.constructName(iDLObject, bl ? "" : "Operations");
        }
        if (string.equals("skeleton")) {
            if (this.getAttribute("DEF:POA", iDLObject)) {
                return this.constructName(iDLObject, "POA");
            }
            return this.constructName(iDLObject, "ImplBase", "_");
        }
        if (string.equals("tie")) {
            if (this.getAttribute("DEF:POA", iDLObject)) {
                return this.constructName(iDLObject, "POATie");
            }
            return this.constructName(iDLObject, "Tie");
        }
        if (string.equals("signatureif")) {
            return this.constructName(iDLObject, "");
        }
        if (string.equals("stub")) {
            return this.constructName(iDLObject, "Stub", "_");
        }
        if (string.equals("newarray")) {
            int n = 0;
            while (true) {
                if (iDLObject.is_a("AliasObj")) {
                    iDLObject = iDLObject.getContent("RESOLVE");
                    continue;
                }
                if (!iDLObject.is_a("SequenceObj") && !iDLObject.is_a("ArrayObj")) break;
                iDLObject = iDLObject.getContent("BASE");
                ++n;
            }
            String string2 = this.getJavaFullName(iDLObject, "decl") + "[len" + this.getName("PLUGIN:INDEX", iDLObject) + "]";
            int n2 = 1;
            while (n2 < n) {
                string2 = string2 + "[]";
                ++n2;
            }
            return string2;
        }
        if (string.equals("basicidl")) {
            return Utility.get_primitive_name(iDLObject);
        }
        if (string.equals("decl")) {
            while (iDLObject.is_a("AliasObj")) {
                iDLObject = iDLObject.getContent("RESOLVE");
            }
            if (iDLObject.is_a("SequenceObj") || iDLObject.is_a("ArrayObj")) {
                String string3 = this.getJavaFullName(iDLObject.getContent("BASE"), "decl");
                return string3 + "[]";
            }
            return this.constructName(iDLObject, "");
        }
        throw new IDLflexException("getJavaFullName (type=" + string + ") failed");
    }

    protected String getJavaPath(IDLObject iDLObject, String string) throws IDLflexException {
        String string2 = this.getJavaFullName(iDLObject, string);
        string2 = string2.replace('.', File.separatorChar);
        return string2 + ".java";
    }

    protected String getJavaName(IDLObject iDLObject, String string) throws IDLflexException {
        String string2 = this.getJavaFullName(iDLObject, string);
        int n = string2.lastIndexOf(46);
        return string2.substring(n + 1);
    }

    protected String getPackageName(IDLObject iDLObject) throws IDLflexException {
        String string = this.constructName(iDLObject, "");
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public String getName(String string, IDLObject iDLObject) throws IDLflexException {
        String string2;
        String string3;
        String string4;
        if (!string.startsWith("JAVA:")) {
            return super.getName(string, iDLObject);
        }
        int n = (string = string.substring(5)).indexOf(":");
        if (n >= 0) {
            string4 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string4 = string;
            string3 = "";
        }
        if (string4.equals("PkgDecl")) {
            String string5 = this.getPackageName(iDLObject);
            if (string5.equals("")) {
                return "";
            }
            return "package " + string5 + ";";
        }
        if (string4.equals("PkgName")) {
            return this.getPackageName(iDLObject);
        }
        if (string4.equals("ConstVal")) {
            Object object = iDLObject.getValue("value");
            if (object == null) {
                System.err.println("constval is null for " + iDLObject);
            }
            IDLObject iDLObject2 = iDLObject.getContent("base");
            String string6 = "";
            if (iDLObject2 instanceof PrimitiveObj) {
                string6 = iDLObject2.getName("name");
            }
            if (iDLObject2 instanceof StringObj) {
                string6 = "tk_string";
            }
            if (iDLObject2 instanceof EnumObj) {
                string6 = "tk_enum";
            }
            if (string6.equals("tk_enum")) {
                return object.toString();
            }
            if (string6.equals("tk_boolean")) {
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    return "true";
                }
                return "false";
            }
            if (string6.equals("tk_string") || string6.equals("tk_wstring")) {
                return "\"" + (String)object + "\"";
            }
            if (string6.equals("tk_char") || string6.equals("tk_wchar")) {
                return "'" + (String)object + "'";
            }
            return object.toString();
        }
        if (string4.equals("DiscrVal")) {
            string2 = iDLObject.is_a("UnionObj") ? "defdiscr" : "discr";
            long l = (Long)iDLObject.getValue(string2);
            if (string3.equals("num")) {
                return String.valueOf(l);
            }
            IDLObject iDLObject3 = iDLObject.is_a("UnionMemberObj") ? iDLObject.getContent("SUPER").getContent("RDISCR") : iDLObject.getContent("RDISCR");
            if (iDLObject3.is_a("PrimitiveObj")) {
                if (iDLObject3.getAttribute("tk_boolean")) {
                    return l == 0L ? "false" : "true";
                }
                if (iDLObject3.getAttribute("tk_char") || iDLObject3.getAttribute("tk_wchar")) {
                    return "'" + (char)l + "'";
                }
                return String.valueOf(l);
            }
            System.err.println("JavaUtility: DISCRVAL: unsupported discriminator type!");
        } else {
            if (string4.equals("FILE")) {
                return this.getJavaPath(iDLObject, string3);
            }
            if (string4.equals("TYPE")) {
                if (string3.equals("name")) {
                    String string7 = iDLObject.getName("name");
                    String string8 = this.keywordCollisionResolver.resolve(string7);
                    if (string8.equals("")) {
                        System.err.println("JAVA:TYPE:name: empty name for " + iDLObject);
                    }
                    return string8;
                }
                String string9 = this.getJavaFullName(iDLObject, string3);
                if (string9 == null) {
                    System.err.println("DEBUG: JavaFullName is null for " + iDLObject);
                    System.err.println("DEBUG: Request is TYPE:" + string3);
                    System.err.println("DEBUG: obj name is " + iDLObject.getName("name"));
                }
                if (currentPackagePrefix.equals("")) {
                    return string9;
                }
                if (string9.startsWith(currentPackagePrefix)) {
                    if (string9.lastIndexOf(".") > currentPackagePrefix.length()) {
                        return string9;
                    }
                    return string9.substring(currentPackagePrefix.length() + 1);
                }
                return string9;
            }
        }
        if (iDLObject.is_a("UnionObj") && string4.equals("DiscrAddUnderscore")) {
            string2 = "discriminator";
            IDLObject[] iDLObjectArray = iDLObject.getContentList("UNIQUE");
            block0: while (true) {
                int n2 = 0;
                while (n2 < iDLObjectArray.length) {
                    if (iDLObjectArray[n2].getName("name").equals(string2)) {
                        string2 = "_" + string2;
                        continue block0;
                    }
                    ++n2;
                }
                break;
            }
            int n3 = string2.lastIndexOf("_");
            if (n3 < 0) {
                return "";
            }
            return string2.substring(0, n3 + 1);
        }
        return super.getName(string, iDLObject);
    }

    public boolean getAttribute(String string, IDLObject iDLObject) throws IDLflexException {
        if (string.equals("JAVA:AbstractBase")) {
            if (!iDLObject.is_a("InterfaceObj")) {
                throw new IDLflexException("attribute 'abstractbase' only available for InterfaceObj");
            }
            if (iDLObject.getAttribute("abstractif")) {
                return true;
            }
            IDLObject[] iDLObjectArray = iDLObject.getContentList("ALLBASE");
            int n = 0;
            while (n < iDLObjectArray.length) {
                if (iDLObjectArray[n].getAttribute("abstractif")) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return super.getAttribute(string, iDLObject);
    }
}

