/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import java.io.InputStream;
import org.aspectix.IDLparser.grammar.IDLLexer;
import org.aspectix.IDLparser.grammar.IDLNodeFactory;
import org.aspectix.IDLparser.grammar.IDLParser;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.LookupUtil;
import org.aspectix.IDLparser.tree.SpecNode;
import org.aspectix.IDLparser.util.IDLTreeVisitor;

public class ValidatingParser {
    private SpecNode ast = null;
    private boolean verbose = false;

    public void setVerbose() {
        this.verbose = true;
    }

    public void printParseInfo() throws IDLException {
        if (this.ast == null) {
            throw new IDLException("error(ValidatingParser): no AST generated yet - cannot print parse info");
        }
        System.out.println("\nPRINTING PARSE INFO...");
        this.ast.printParseInfo();
    }

    public void printTreeInfo() throws IDLException {
        System.out.println("\nPRINTING ANTLR TREE OUTPUT...");
        if (this.ast == null) {
            throw new IDLException("error(ValidatingParser): no AST generated yet - cannot print tree info");
        }
        IDLTreeVisitor iDLTreeVisitor = new IDLTreeVisitor();
        iDLTreeVisitor.visit((AST)this.ast);
    }

    public IDLNode parse(InputStream inputStream) throws IDLException {
        if (this.verbose) {
            System.out.println("\nParsing IDL file...");
        }
        this.ast = this.createAST(inputStream);
        if (this.verbose) {
            System.out.println("\nSetting scope...");
        }
        this.ast.setScope();
        if (this.verbose) {
            System.out.println("\nChecking syntax...");
        }
        LookupUtil.instance().setAST(this.ast);
        this.ast.setSequence();
        this.ast.checkClashes();
        this.ast.resolveReferences();
        this.ast.checkIdentifierUsage();
        return this.ast;
    }

    private SpecNode createAST(InputStream inputStream) throws IDLException {
        try {
            IDLParser iDLParser = new IDLParser(new IDLLexer(inputStream));
            iDLParser.setASTFactory(new IDLNodeFactory());
            iDLParser.setASTNodeType("org.aspectix.IDLparser.tree.IDLEntityNode");
            iDLParser.specification();
            return (SpecNode)iDLParser.getAST();
        }
        catch (RecognitionException recognitionException) {
            throw new IDLException("parse error at line " + LocationInfo.getLocationInfo(recognitionException.getLine()) + ":\n" + recognitionException.getMessage());
        }
        catch (TokenStreamRecognitionException tokenStreamRecognitionException) {
            throw new IDLException("parse error at line " + LocationInfo.getLocationInfo(tokenStreamRecognitionException.recog.getLine()) + ":\n" + tokenStreamRecognitionException.getMessage());
        }
        catch (TokenStreamException tokenStreamException) {
            throw new IDLException("error while parsing: " + tokenStreamException.getMessage());
        }
    }
}

