/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.IDLArray;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.LookupUtil;

public class ArrayNode
extends IDLEntityNode
implements IDLArray {
    private BigDecimal length = null;

    public ArrayNode() {
    }

    public ArrayNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    public String getText() {
        return "array";
    }

    public int getType() {
        return 25;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack("array", "::");
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING array in line " + this.getLine());
        }
        super.resolveReferences();
        this.length = ((IDLConst)this.getFirstChild()).numberValue();
        LookupUtil.assertPositiveIntValue(this.length, this.getLine());
    }

    public boolean defined() {
        return true;
    }

    public int getLength() throws IDLException {
        if (this.length == null) {
            this.throwNotResolvedException();
        }
        return this.length.intValue();
    }

    public IDLType getIDLType() {
        return (IDLType)((Object)this.getSecondChild());
    }

    public IDLType getEffectiveType() throws IDLException {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + ((IDLEntityNode)iDLNode).getText() + " cannot be assigned to array type ");
    }

    public int getTypeId() {
        return 18;
    }
}

