/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.aspectix.IDLparser.pub.IDLBaseType;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;

public class BaseTypeNode
extends IDLEntityNode
implements IDLBaseType {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigDecimal MAX_SHORT = new BigDecimal(32767.0);
    private static final BigDecimal MIN_SHORT = new BigDecimal(-32768.0);
    private static final BigDecimal MAX_USHORT = new BigDecimal(65535.0);
    private static final BigDecimal MIN_USHORT = new BigDecimal(0.0);
    private static final BigDecimal MAX_LONG = new BigDecimal(2.147483647E9);
    private static final BigDecimal MIN_LONG = new BigDecimal(-2.147483648E9);
    private static final BigDecimal MAX_ULONG = new BigDecimal(4.294967295E9);
    private static final BigDecimal MIN_ULONG = new BigDecimal(0.0);
    private static final BigDecimal MAX_LONGLONG = new BigDecimal(ONE.shiftLeft(63).subtract(ONE));
    private static final BigDecimal MIN_LONGLONG = new BigDecimal(ONE.shiftLeft(63).negate());
    private static final BigDecimal MAX_ULONGLONG = new BigDecimal(ONE.shiftLeft(64).subtract(ONE));
    private static final BigDecimal MIN_ULONGLONG = new BigDecimal(0.0);
    private static final BigDecimal MAX_FLOAT = new BigDecimal(ONE.shiftLeft(23).subtract(ONE).multiply(ONE.shiftLeft(127)));
    private static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();
    private static final BigDecimal MAX_DOUBLE = new BigDecimal(ONE.shiftLeft(52).subtract(ONE).multiply(ONE.shiftLeft(1023)));
    private static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();
    private static final BigDecimal MAX_LONGDOUBLE = new BigDecimal(ONE.shiftLeft(64).subtract(ONE).multiply(ONE.shiftLeft(16383)));
    private static final BigDecimal MIN_LONGDOUBLE = MAX_LONGDOUBLE.negate();

    public int getType() {
        return 21;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack(this.getText(), "::");
    }

    public boolean isVoid() {
        return this.getText().equals("void");
    }

    public String getName() {
        return this.getText();
    }

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        if (!(iDLNode instanceof IDLConst)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + ((IDLEntityNode)iDLNode).getText() + " cannot be assigned to type " + this.getText());
        }
        if (this.getTypeId() == 4 || this.getTypeId() == 5 || this.getTypeId() == 14) {
            BigDecimal bigDecimal = ((IDLConst)iDLNode).numberValue();
            if (this.getTypeId() == 4 && bigDecimal.scale() != 0) {
                throw new IDLException("error(line" + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + bigDecimal.toString() + " is not an integer type");
            }
            String string = this.getText();
            if (string.equals("fixed")) {
                return bigDecimal;
            }
            if (string.equals("short") ? bigDecimal.compareTo(MAX_SHORT) != 1 && bigDecimal.compareTo(MIN_SHORT) != -1 : (string.equals("unsigned_short") ? bigDecimal.compareTo(MAX_USHORT) != 1 && bigDecimal.compareTo(MIN_USHORT) != -1 : (string.equals("unsigned_long") ? bigDecimal.compareTo(MAX_ULONG) != 1 && bigDecimal.compareTo(MIN_ULONG) != -1 : (string.equals("long") ? bigDecimal.compareTo(MAX_LONG) != 1 && bigDecimal.compareTo(MIN_LONG) != -1 : (string.equals("unsigned_long_long") ? bigDecimal.compareTo(MAX_ULONGLONG) != 1 && bigDecimal.compareTo(MIN_ULONGLONG) != -1 : (string.equals("long_long") ? bigDecimal.compareTo(MAX_LONGLONG) != 1 && bigDecimal.compareTo(MIN_LONGLONG) != -1 : (string.equals("float") ? bigDecimal.compareTo(MAX_FLOAT) != 1 && bigDecimal.compareTo(MIN_FLOAT) != -1 : (string.equals("double") ? bigDecimal.compareTo(MAX_DOUBLE) != 1 && bigDecimal.compareTo(MIN_DOUBLE) != -1 : string.equals("long_double") && bigDecimal.compareTo(MAX_LONGDOUBLE) != 1 && bigDecimal.compareTo(MIN_LONGDOUBLE) != -1)))))))) {
                return bigDecimal;
            }
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + bigDecimal.toString() + " exceeds range of type " + string);
        }
        return ((IDLConst)iDLNode).stringValue(this.getTypeId());
    }

    public int getTypeId() {
        String string = this.getText();
        if (string.indexOf("float") != -1 || string.indexOf("double") != -1) {
            return 5;
        }
        if (string.indexOf("short") != -1 || string.indexOf("long") != -1) {
            return 4;
        }
        if (string.equals("char")) {
            return 1;
        }
        if (string.equals("wchar")) {
            return 2;
        }
        if (string.equals("fixed")) {
            return 14;
        }
        if (string.equals("boolean")) {
            return 3;
        }
        return 0;
    }
}

