/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import java.util.Iterator;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.util.IDLIterator;

public class ContextNode
extends IDLEntityNode {
    public ContextNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    public int getType() {
        return 18;
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING context expression in line " + this.getLine());
        }
        super.resolveReferences();
        IDLIterator iDLIterator = this.iterator();
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iDLIterator.next();
            this.checkContextLiteral(iDLEntityNode);
        }
    }

    public Iterator getLiterals() {
        return this.iterator();
    }

    private void checkContextLiteral(IDLEntityNode iDLEntityNode) throws IDLException {
        String string = iDLEntityNode.getText();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\"' && c != '_' && c != '.') {
                if (c == '*') {
                    if (n != string.length() - 2) {
                        throw new IDLException("error(line " + iDLEntityNode.getLine() + "): asterisk may only occur " + "at the end of a string in context expression");
                    }
                } else if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    throw new IDLException("error(line " + iDLEntityNode.getLine() + "): strings in context " + "expressions may only contain alphabetic, digit, period, " + "underscore and asterisk characters");
                }
            }
            ++n;
        }
    }
}

