/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import java.math.BigInteger;
import java.util.Iterator;
import org.aspectix.IDLparser.pub.IDLEnum;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLScopedName;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.ScopedNameNode;
import org.aspectix.IDLparser.util.IDLIterator;

public class EnumNode
extends IDLEntityNode
implements IDLEnum {
    private static final BigInteger MAX_ELEMENTS = BigInteger.valueOf(0xFFFFFFFFL);

    public EnumNode() {
    }

    public EnumNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING enumeration " + this.getScopedName() + " in line " + this.getLine());
        }
        super.resolveReferences();
        IDLIterator iDLIterator = this.iterator();
        BigInteger bigInteger = BigInteger.valueOf(0L);
        while (iDLIterator.hasNext()) {
            iDLIterator.next();
            bigInteger = bigInteger.add(BigInteger.valueOf(1L));
            if (bigInteger.compareTo(MAX_ELEMENTS) != 1) continue;
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + " enum " + this.getText() + " has more than " + MAX_ELEMENTS.toString() + " elements");
        }
    }

    public Iterator getNames() {
        return this.iterator();
    }

    public String getName() {
        return this.getText();
    }

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        if (iDLNode instanceof ScopedNameNode) {
            IDLIterator iDLIterator = this.iterator();
            BigInteger bigInteger = BigInteger.valueOf(0L);
            while (iDLIterator.hasNext()) {
                IDLScopedName iDLScopedName = (IDLScopedName)iDLIterator.next();
                IDLScopeStack iDLScopeStack = iDLScopedName.getScope();
                iDLScopeStack.push(iDLScopedName.getText());
                if (((IDLEntityNode)iDLNode).getScopedName().isShortReferenceTo(iDLScopeStack)) {
                    return bigInteger;
                }
                bigInteger = bigInteger.add(BigInteger.valueOf(1L));
            }
            throw new IDLException("error( line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): unknown enumeration value " + ((IDLEntityNode)iDLNode).getText());
        }
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + ((IDLEntityNode)iDLNode).getText() + " cannot be assigned to type enum " + this.getScopedName());
    }

    public int getTypeId() {
        return 7;
    }
}

