/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLFixed;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.LookupUtil;

public class FixedNode
extends IDLEntityNode
implements IDLFixed {
    private BigDecimal total = null;
    private BigDecimal fractional = null;

    public FixedNode() {
    }

    public FixedNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    public int getType() {
        return 15;
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING fixed node in line " + this.getLine());
        }
        super.resolveReferences();
        this.total = ((IDLConst)this.getFirstChild()).numberValue();
        this.fractional = ((IDLConst)((Object)this.getSecondChild())).numberValue();
        LookupUtil.assertPositiveIntValue(this.total, this.getLine());
    }

    public int getTotal() throws IDLException {
        if (this.total == null) {
            this.throwNotResolvedException();
        }
        return this.total.intValue();
    }

    public int getFractional() throws IDLException {
        if (this.fractional == null) {
            this.throwNotResolvedException();
        }
        return this.fractional.intValue();
    }

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        BigDecimal bigDecimal = ((IDLConst)iDLNode).numberValue();
        return bigDecimal;
    }

    public int getTypeId() {
        return 15;
    }
}

