/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspectix.IDLparser.grammar.IDLClassStrings;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLInterf;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.InheritNode;
import org.aspectix.IDLparser.tree.LookupUtil;
import org.aspectix.IDLparser.tree.ScopedNameNode;
import org.aspectix.IDLparser.util.IDLIterator;

public class InterfNode
extends IDLEntityNode
implements IDLInterf {
    private boolean inherit = false;
    private boolean forwardDecl = false;
    private boolean localif = false;
    private boolean abstractif = false;
    private boolean inherited = false;

    public InterfNode() {
    }

    public InterfNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    private void inherit() throws IDLException {
        if (this.forwardDecl) {
            return;
        }
        if (this.inherited) {
            return;
        }
        if (this.inherit) {
            IDLIterator iDLIterator = this.iterator();
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iDLIterator.next();
            if (!(iDLEntityNode instanceof InheritNode)) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + ") : interface " + this.getScopedName() + " expected inheritance specification - found " + iDLEntityNode.getClass().getName() + " " + iDLEntityNode.getScopedName());
            }
            IDLIterator iDLIterator2 = iDLEntityNode.iterator();
            ArrayList<IDLEntityNode> arrayList = new ArrayList<IDLEntityNode>();
            while (iDLIterator2.hasNext()) {
                IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iDLIterator2.next();
                IDLEntityNode iDLEntityNode3 = ((ScopedNameNode)iDLEntityNode2).getReference();
                if (iDLEntityNode3 == null || !(iDLEntityNode3 instanceof InterfNode)) {
                    throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()) + "): " + iDLEntityNode2.getScopedName() + " is not a valid interface to inherit from.");
                }
                if (((InterfNode)iDLEntityNode3).forwardDecl()) {
                    throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): " + iDLEntityNode3.getScopedName() + " is just a forward declaration (line " + iDLEntityNode3.getLine() + "), not a valid base interface");
                }
                if (iDLEntityNode3.getScopedName().equals(this.getScopedName())) {
                    throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): " + this.getScopedName() + " may not inherit from itself");
                }
                if (arrayList.contains(iDLEntityNode3)) {
                    throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + ") : " + this.getScopedName() + " can't inherit from " + iDLEntityNode2.getScopedName() + " twice");
                }
                arrayList.add(iDLEntityNode3);
                Iterator iterator = ((InterfNode)iDLEntityNode3).getVisibleMembers();
                while (iterator.hasNext()) {
                    this.inheritMember((IDLEntityNode)iterator.next());
                }
            }
            this.inherited = true;
        }
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING interface " + this.getScopedName() + " in line " + this.getLine());
        }
        IDLIterator iDLIterator = this.iterator();
        if (this.inherit) {
            ((IDLEntityNode)iDLIterator.next()).resolveReferences();
        }
        this.inherit();
        while (iDLIterator.hasNext()) {
            ((IDLEntityNode)iDLIterator.next()).resolveReferences();
        }
        if (this.forwardDecl) {
            InterfNode interfNode = LookupUtil.instance().lookupInterfaceDefinition(this.getScopedName());
            if (interfNode == null) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unsatisfied forward declaration " + this.getScopedName());
            }
            if (interfNode.sequence() < this.sequence()) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): forward declaration " + this.getScopedName() + " ocurred after interface definition - line " + interfNode.getLine());
            }
        }
    }

    IDLEntityNode resolveBaseReference(ScopedNameNode scopedNameNode) throws IDLException {
        IDLEntityNode iDLEntityNode = null;
        IDLScopeStack iDLScopeStack = scopedNameNode.getScopedName();
        String string = scopedNameNode.getLocalName();
        this.inherit();
        IDLIterator iDLIterator = this.iterator();
        if (!this.inherit) {
            return null;
        }
        iDLIterator.next();
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iDLIterator.next();
            if (iDLEntityNode2.visible() || !iDLEntityNode2.getLocalName().equals(string)) continue;
            if (iDLEntityNode != null) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(scopedNameNode.getLine()) + "): ambiguous reference to " + "inherited member " + iDLScopeStack + " - found in lines " + iDLEntityNode.getLine() + " and " + iDLEntityNode2.getLine());
            }
            iDLEntityNode = iDLEntityNode2;
        }
        return iDLEntityNode;
    }

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + ((IDLEntityNode)iDLNode).getText() + " cannot be assigned to type interface " + this.getScopedName());
    }

    public int getTypeId() {
        return 11;
    }

    public void setInherit() {
        this.inherit = true;
    }

    public boolean inherits() {
        return this.inherit;
    }

    public void setForwardDecl() {
        this.forwardDecl = true;
    }

    public boolean forwardDecl() {
        return this.forwardDecl;
    }

    public void setLocalIf() {
        this.localif = true;
    }

    public boolean localIf() {
        return this.localif;
    }

    public void setAbstractIf() {
        this.abstractif = true;
    }

    public boolean abstractIf() {
        return this.abstractif;
    }

    public String getName() {
        return this.getText();
    }

    public Iterator getDirectBaseInterfaces() throws IDLException {
        ArrayList<IDLEntityNode> arrayList = new ArrayList<IDLEntityNode>();
        if (!this.inherit) {
            return arrayList.iterator();
        }
        IDLIterator iDLIterator = ((IDLEntityNode)this.getFirstChild()).iterator();
        while (iDLIterator.hasNext()) {
            ScopedNameNode scopedNameNode = (ScopedNameNode)iDLIterator.next();
            arrayList.add(scopedNameNode.getReference());
        }
        return arrayList.iterator();
    }

    public Iterator getVisibleMembers() {
        ArrayList<IDLEntityNode> arrayList = new ArrayList<IDLEntityNode>();
        IDLIterator iDLIterator = this.iterator();
        if (this.inherits()) {
            iDLIterator.next();
        }
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iDLIterator.next();
            if (!iDLEntityNode.visible()) continue;
            arrayList.add(iDLEntityNode);
        }
        return arrayList.iterator();
    }

    public Iterator getVisibleInheritedMembers() {
        ArrayList<IDLEntityNode> arrayList = new ArrayList<IDLEntityNode>();
        IDLIterator iDLIterator = this.iterator();
        if (this.inherits()) {
            iDLIterator.next();
        }
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iDLIterator.next();
            if (iDLEntityNode.getDefinitionScope().equals(iDLEntityNode.getScope()) || !iDLEntityNode.visible()) continue;
            arrayList.add(iDLEntityNode);
        }
        return arrayList.iterator();
    }

    public Iterator getLocallyDefinedMembers() {
        ArrayList<IDLEntityNode> arrayList = new ArrayList<IDLEntityNode>();
        IDLIterator iDLIterator = this.iterator();
        if (this.inherits()) {
            iDLIterator.next();
        }
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iDLIterator.next();
            if (!iDLEntityNode.getDefinitionScope().equals(iDLEntityNode.getScope())) continue;
            arrayList.add(iDLEntityNode);
        }
        return arrayList.iterator();
    }

    private void inheritMember(IDLEntityNode iDLEntityNode) throws IDLException {
        boolean bl = false;
        IDLIterator iDLIterator = this.iterator();
        if (this.inherits()) {
            iDLIterator.next();
        }
        while (iDLIterator.hasNext()) {
            IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iDLIterator.next();
            String string = iDLEntityNode2.getLocalName();
            String string2 = iDLEntityNode.getLocalName();
            if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
            if (!string.equals(string2)) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()) + "): members " + IDLClassStrings.classes[iDLEntityNode.getType()] + " " + string2 + " " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + " and " + IDLClassStrings.classes[iDLEntityNode2.getType()] + " " + string + " in interface " + this.getText() + " - names differ in case");
            }
            if (iDLEntityNode.getType() != iDLEntityNode2.getType()) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + "): interface " + this.getScopedName() + " member " + string2 + " collides with member from line " + iDLEntityNode2.getLine() + " (have different types)");
            }
            if (iDLEntityNode.getDefinitionScope().equals(iDLEntityNode2.getDefinitionScope())) {
                return;
            }
            if (iDLEntityNode.getType() == 29 || iDLEntityNode.getType() == 12) {
                throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): colliding members " + string2 + " " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()) + " and " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()));
            }
            bl = true;
            if (iDLEntityNode2.getDefinitionScope().equals(iDLEntityNode2.getScope())) continue;
            iDLEntityNode2.setInvisible();
        }
        IDLEntityNode iDLEntityNode3 = null;
        try {
            iDLEntityNode3 = (IDLEntityNode)iDLEntityNode.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (bl) {
            iDLEntityNode3.setInvisible();
        }
        iDLEntityNode3.setNextSibling(null);
        iDLEntityNode3.setScope(this.getScopedName());
        this.addChild((AST)iDLEntityNode3);
    }
}

