/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLTypeUtil;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;

public class LiteralNode
extends IDLEntityNode
implements IDLConst {
    private static final int EXPONENT_RANGE = 9884;
    private int literalType;

    public int getType() {
        return 32;
    }

    public void setLiteralType(int n) {
        this.literalType = n;
    }

    public int getLiteralType() {
        return this.literalType;
    }

    public String stringValue(int n) throws IDLException {
        if (this.literalType == 1 && (n == 1 || n == 2)) {
            return this.charConvert(this.getText());
        }
        if (this.literalType == 12 && (n == 12 || n == 13)) {
            return this.stringConvert(this.getText());
        }
        if (this.literalType == n) {
            return this.getText();
        }
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): Can't assign constant expression " + this.getText() + " to type " + IDLTypeUtil.toString(n));
    }

    public BigDecimal numberValue() throws IDLException {
        try {
            String string = this.getText();
            int n = string.indexOf(".");
            int n2 = string.indexOf("e");
            if (n2 == -1) {
                n2 = string.indexOf("E");
            }
            if (string.endsWith("d") || string.endsWith("D")) {
                string = string.substring(0, string.length() - 1);
                while (string.startsWith("0")) {
                    string = string.substring(1);
                }
                while (string.endsWith("0")) {
                    string = string.substring(0, string.length() - 1);
                }
                return new BigDecimal(string);
            }
            if (string.startsWith("0x") || string.startsWith("0X")) {
                string = string.substring(2);
                return new BigDecimal(new BigInteger(string, 16), 0);
            }
            if (n != -1 || n2 != -1) {
                if (n2 != -1) {
                    BigDecimal bigDecimal = new BigDecimal(string.substring(0, n2));
                    int n3 = Integer.parseInt(string.substring(n2 + 1));
                    if (Math.abs(n3) > 9884) {
                        throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): literal " + this.getText() + " - exponent is too large");
                    }
                    return bigDecimal.movePointRight(n3);
                }
                return new BigDecimal(string);
            }
            if (string.startsWith("0")) {
                if (string.length() == 1) {
                    return new BigDecimal(0.0);
                }
                string = string.substring(1);
                return new BigDecimal(new BigInteger(string, 8), 0);
            }
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): Can't interpret literal " + this.getText() + " as number");
        }
    }

    private String charConvert(String string) throws IDLException {
        string = string.substring(1, string.length() - 1);
        return this.replaceEsc(string);
    }

    private String stringConvert(String string) throws IDLException {
        int n;
        if ((string = string.substring(1, string.length() - 1)).equals("\\0")) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): Null character is not allowed in string literal - " + "encountered " + this.getText());
        }
        string = this.replaceEsc(string);
        while ((n = string.indexOf("\"\"")) != -1) {
            string = string.substring(0, n).concat(string.substring(n + 2));
        }
        return string;
    }

    private String replaceEsc(String string) throws IDLException {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("\\", n2)) != -1) {
            String string2;
            switch (string.charAt(n + 1)) {
                case '\\': {
                    string2 = "\\";
                    break;
                }
                case 'n': {
                    string2 = "\n";
                    break;
                }
                case 't': {
                    string2 = "\t";
                    break;
                }
                case 'v': {
                    string2 = "\u000b";
                    break;
                }
                case 'b': {
                    string2 = "\b";
                    break;
                }
                case 'r': {
                    string2 = "\r";
                    break;
                }
                case 'f': {
                    string2 = "\f";
                    break;
                }
                case 'a': {
                    string2 = "\u0007";
                    break;
                }
                case '?': {
                    string2 = "?";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                string = string.substring(0, n) + string2 + string.substring(n + 2);
            }
            n2 = n + 1;
        }
        return string;
    }

    private String replaceCharValue(String string, int n) throws IDLException {
        int n2 = 0;
        String string2 = null;
        if (string.charAt(n + 1) == 'x') {
            if (string.length() > n + 2 && this.isHex(string.charAt(n + 2))) {
                ++n2;
                if (string.length() > n + 3 && this.isHex(string.charAt(n + 3))) {
                    ++n2;
                }
            }
            string2 = string.substring(n + 2, n + n2 + 2);
            return string.substring(0, n) + this.valueReplace(string2, 16) + string.substring(n + n2 + 2);
        }
        if (string.length() > n + 1 && this.isOctal(string.charAt(n + 1))) {
            ++n2;
            if (string.length() > n + 2 && this.isOctal(string.charAt(n + 2))) {
                ++n2;
                if (string.length() > n + 3 && this.isOctal(string.charAt(n + 3))) {
                    ++n2;
                }
            }
        }
        string2 = string.substring(n + 1, n + n2 + 1);
        return string.substring(0, n) + this.valueReplace(string2, 8) + string.substring(n + n2 + 1);
    }

    private boolean isHex(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if ('A' <= c && c <= 'F') {
            return true;
        }
        return 'a' <= c && c <= 'f';
    }

    private boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    private String valueReplace(String string, int n) throws IDLException {
        try {
            char[] cArray = new char[]{(char)Integer.parseInt(string, n)};
            return new String(cArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): Escaped value " + string + " (base " + n + ") in literal " + this.getText() + " cannot be converted to char - " + numberFormatException.getMessage());
        }
    }
}

