/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNamed;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.InterfNode;
import org.aspectix.IDLparser.tree.ModuleNode;
import org.aspectix.IDLparser.tree.OpDeclNode;
import org.aspectix.IDLparser.tree.ParamDeclNode;
import org.aspectix.IDLparser.tree.ScopedNameNode;
import org.aspectix.IDLparser.tree.ValueTypeNode;

public class LookupUtil {
    public static int currentSequence = 0;
    private static final TreeSet keywords = new TreeSet();
    private static LookupUtil instance;
    private IDLEntityNode ast = null;
    private boolean trace = false;

    private LookupUtil() {
    }

    public static LookupUtil instance() {
        if (instance == null) {
            instance = new LookupUtil();
        }
        return instance;
    }

    public void setAST(IDLEntityNode iDLEntityNode) {
        this.ast = iDLEntityNode;
    }

    public static void assertPositiveIntValue(BigDecimal bigDecimal, int n) throws IDLException {
        if (bigDecimal.signum() != 1) {
            throw new IDLException("error(line " + n + "): value must be positive (found " + bigDecimal.toString() + ")");
        }
        if (bigDecimal.scale() != 0) {
            throw new IDLException("error(line " + n + "): value must be integer (found " + bigDecimal.toString() + ")");
        }
    }

    public InterfNode lookupInterfaceDefinition(IDLScopeStack iDLScopeStack) {
        Iterator iterator = this.getDefinedNodesByAbsoluteName(iDLScopeStack);
        Object var4_3 = null;
        while (iterator.hasNext()) {
            IDLEntityNode iDLEntityNode = (IDLEntityNode)iterator.next();
            if (!(iDLEntityNode instanceof InterfNode) || ((InterfNode)iDLEntityNode).forwardDecl()) continue;
            return (InterfNode)iDLEntityNode;
        }
        return null;
    }

    void assertIdentNotUsed(IDLEntityNode iDLEntityNode) throws IDLException {
        Iterator iterator = iDLEntityNode.getSurroundingScopes();
        if (!iterator.hasNext()) {
            return;
        }
        IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iterator.next();
        Iterator iterator2 = iDLEntityNode2.getUsedDescendants();
        while (iterator2.hasNext()) {
            IDLEntityNode iDLEntityNode3 = (IDLEntityNode)iterator2.next();
            if (!(iDLEntityNode3 instanceof ScopedNameNode) || iDLEntityNode3.sequence() >= iDLEntityNode.sequence() || !((ScopedNameNode)iDLEntityNode3).usesUnqualified(iDLEntityNode.getLocalName())) continue;
            System.err.println("error (line " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + "): identifier " + iDLEntityNode.getLocalName() + " may not be redefined after having " + "been used in scope " + iDLEntityNode2.getScopedName() + " at line " + LocationInfo.getLocationInfo(iDLEntityNode3.getLine()));
        }
    }

    public void checkNameClash(IDLEntityNode iDLEntityNode) throws IDLException {
        Iterator iterator = this.getDefinedNodesByAbsoluteName(iDLEntityNode.getScopedName());
        while (iterator.hasNext()) {
            IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iterator.next();
            if (iDLEntityNode2.sequence() >= iDLEntityNode.sequence() || iDLEntityNode instanceof OpDeclNode && iDLEntityNode2 instanceof OpDeclNode || iDLEntityNode instanceof ParamDeclNode && iDLEntityNode2 instanceof ParamDeclNode) continue;
            System.err.println(iDLEntityNode.getClass().toString());
            if (iDLEntityNode instanceof ModuleNode && iDLEntityNode2 instanceof ModuleNode || iDLEntityNode instanceof InterfNode && iDLEntityNode2 instanceof InterfNode && ((InterfNode)iDLEntityNode2).forwardDecl() || iDLEntityNode instanceof ValueTypeNode && iDLEntityNode2 instanceof ValueTypeNode && ((ValueTypeNode)iDLEntityNode2).forwardDecl()) continue;
            throw new IDLException(LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + ": " + iDLEntityNode.getScopedName() + " previously defined in line " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()));
        }
    }

    public IDLEntityNode resolveRecursiveReference(IDLEntityNode iDLEntityNode) {
        Iterator iterator = iDLEntityNode.getSurroundingScopes();
        while (iterator.hasNext()) {
            IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iterator.next();
            if (!(iDLEntityNode2 instanceof IDLNamed) || !iDLEntityNode.getScopedName().isShortReferenceTo(iDLEntityNode2.getScopedName())) continue;
            return iDLEntityNode2;
        }
        return null;
    }

    IDLEntityNode resolveReference(ScopedNameNode scopedNameNode) throws IDLException {
        IDLEntityNode iDLEntityNode = null;
        IDLScopeStack iDLScopeStack = scopedNameNode.getScopedName();
        if (this.trace) {
            System.err.println("- resolveReference called with " + iDLScopeStack + " on node " + scopedNameNode.getScopedName());
        }
        if (iDLScopeStack.toString("::").startsWith("::")) {
            InterfNode interfNode;
            iDLEntityNode = this.handleAmbiguity(this.getDefinedNodesByAbsoluteName(scopedNameNode.getScopedName()), scopedNameNode);
            if (iDLEntityNode != null && this.trace) {
                System.err.println("- found " + iDLEntityNode.getScopedName());
            }
            if (iDLScopeStack.isSimpleSuperCall() && (interfNode = this.getSurroundingInterface(scopedNameNode)) != null) {
                IDLEntityNode iDLEntityNode2;
                if (this.trace) {
                    System.err.println("- interface context: " + interfNode.getScopedName());
                }
                if ((iDLEntityNode2 = interfNode.resolveBaseReference(scopedNameNode)) != null) {
                    if (iDLEntityNode != null) {
                        throw new IDLException("error (line " + LocationInfo.getLocationInfo(scopedNameNode.getLine()) + " ): ambiguous reference to " + iDLScopeStack + " - found in lines " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + " and " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()));
                    }
                    if (this.trace) {
                        System.err.println("- found " + iDLEntityNode2.getScopedName());
                    }
                    iDLEntityNode = iDLEntityNode2;
                }
            }
        } else {
            InterfNode interfNode;
            IDLEntityNode iDLEntityNode3;
            Iterator iterator = scopedNameNode.getSurroundingScopes();
            while (iterator.hasNext()) {
                iDLEntityNode3 = (IDLEntityNode)iterator.next();
                if (this.trace) {
                    System.err.println("- searching scope " + iDLEntityNode3.getScopedName());
                }
                if ((iDLEntityNode = this.resolveChildByRelativeName(iDLEntityNode3, scopedNameNode)) != null) break;
            }
            if (iDLEntityNode == null && (interfNode = this.getSurroundingInterface(scopedNameNode)) != null) {
                if (this.trace) {
                    System.err.println("- interface context: " + interfNode.getScopedName());
                }
                if ((iDLEntityNode3 = interfNode.resolveBaseReference(scopedNameNode)) != null) {
                    if (iDLEntityNode != null) {
                        throw new IDLException("error (line " + LocationInfo.getLocationInfo(scopedNameNode.getLine()) + " ): ambiguous reference to " + iDLScopeStack + " - found in lines " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + " and " + LocationInfo.getLocationInfo(iDLEntityNode3.getLine()));
                    }
                    if (this.trace) {
                        System.err.println("- found " + iDLEntityNode3.getScopedName());
                    }
                    iDLEntityNode = iDLEntityNode3;
                }
            }
        }
        if (this.trace) {
            if (iDLEntityNode != null) {
                System.err.println("- returning " + iDLEntityNode.getScopedName());
            } else {
                System.err.println("- returning null");
            }
        }
        return iDLEntityNode;
    }

    private IDLEntityNode resolveChildByRelativeName(IDLEntityNode iDLEntityNode, IDLEntityNode iDLEntityNode2) throws IDLException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = iDLEntityNode.iterator();
        while (iterator.hasNext()) {
            ((IDLEntityNode)iterator.next()).addDefinedChildrenWithInvertedName(arrayList, iDLEntityNode2.getScopedName().getInvertedStack());
        }
        iterator = arrayList.iterator();
        return this.handleAmbiguity(iterator, iDLEntityNode2);
    }

    private InterfNode getSurroundingInterface(IDLEntityNode iDLEntityNode) {
        Iterator iterator = iDLEntityNode.getSurroundingScopes();
        while (iterator.hasNext()) {
            IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iterator.next();
            if (!(iDLEntityNode2 instanceof InterfNode)) continue;
            return (InterfNode)iDLEntityNode2;
        }
        return null;
    }

    private Iterator getDefinedNodesByAbsoluteName(IDLScopeStack iDLScopeStack) {
        ArrayList arrayList = new ArrayList();
        this.ast.addDefinedChildrenWithInvertedName(arrayList, iDLScopeStack.getInvertedStack());
        return arrayList.iterator();
    }

    private IDLEntityNode handleAmbiguity(Iterator iterator, IDLEntityNode iDLEntityNode) throws IDLException {
        IDLEntityNode iDLEntityNode2 = null;
        while (iterator.hasNext()) {
            IDLEntityNode iDLEntityNode3 = (IDLEntityNode)iterator.next();
            if (iDLEntityNode3.sequence() >= iDLEntityNode.sequence()) continue;
            if (this.trace) {
                System.err.println("- next is " + iDLEntityNode3.getScopedName());
            }
            if (iDLEntityNode2 != null) {
                iDLEntityNode2 = this.chooseAmbiguous(iDLEntityNode2, iDLEntityNode3, iDLEntityNode);
                if (!this.trace) continue;
                System.err.println("- found " + iDLEntityNode2.getScopedName());
                continue;
            }
            iDLEntityNode2 = iDLEntityNode3;
        }
        return iDLEntityNode2;
    }

    private IDLEntityNode chooseAmbiguous(IDLEntityNode iDLEntityNode, IDLEntityNode iDLEntityNode2, IDLEntityNode iDLEntityNode3) throws IDLException {
        int n = iDLEntityNode3.sequence();
        int n2 = iDLEntityNode.sequence();
        int n3 = iDLEntityNode2.sequence();
        if (n2 < n && n3 < n) {
            if (iDLEntityNode instanceof InterfNode && iDLEntityNode2 instanceof InterfNode) {
                if (n2 < n3 && ((InterfNode)iDLEntityNode).forwardDecl()) {
                    return iDLEntityNode2;
                }
                if (n3 < n2 && ((InterfNode)iDLEntityNode2).forwardDecl()) {
                    return iDLEntityNode;
                }
            }
            throw new IDLException("error (line " + LocationInfo.getLocationInfo(iDLEntityNode3.getLine()) + " ): ambiguous reference to " + iDLEntityNode3.getScopedName() + " - found in lines " + LocationInfo.getLocationInfo(iDLEntityNode.getLine()) + " and " + LocationInfo.getLocationInfo(iDLEntityNode2.getLine()));
        }
        if (n2 >= n && n3 < n) {
            return iDLEntityNode2;
        }
        if (n3 >= n && n2 < n) {
            return iDLEntityNode;
        }
        return null;
    }

    static {
        keywords.addAll(Arrays.asList("any", "attribute", "boolean", "case", "char", "const", "context", "default", "double", "enum", "exception", "false", "fixed", "float", "in", "inout", "interface", "long", "module", "object", "octet", "oneway", "out", "raises", "readonly", "sequence", "short", "string", "struct", "switch", "true", "typedef", "unsigned", "union", "void", "wchar", "wstring"));
        instance = null;
    }
}

