/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import antlr.Token;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLString;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.LookupUtil;

public class StringNode
extends IDLEntityNode
implements IDLString {
    private boolean resolved = false;
    private BigDecimal length = null;

    public StringNode() {
    }

    public StringNode(Token token) {
        super(token);
        this.line = token.getLine();
    }

    public int getType() {
        return 14;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack("string", "::");
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING string in line " + this.getLine());
        }
        if (this.getFirstChild() != null) {
            this.length = ((IDLConst)this.getFirstChild()).numberValue();
            LookupUtil.assertPositiveIntValue(this.length, this.getLine());
        }
        this.resolved = true;
    }

    public int getLength() throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.length == null) {
            return 0;
        }
        return this.length.intValue();
    }

    public boolean isWide() {
        return this.getText().equals("wstring");
    }

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        String string = ((IDLConst)iDLNode).stringValue(this.getTypeId());
        if (this.length == null) {
            return string;
        }
        String string2 = string;
        if (this.length.compareTo(new BigDecimal((double)string2.length())) >= 0) {
            return string;
        }
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLNode.getLine()) + "): " + ((IDLEntityNode)iDLNode).getText() + " cannot be assigned to string type of length " + this.length);
    }

    public int getTypeId() {
        if (this.getText().equals("wstring")) {
            return 13;
        }
        return 12;
    }
}

